{***********************************************************************\ 
*									* 
*   File: scorpion/src/treepr/GetBoxSizes.p 
*				 					* 
*   Copyright (C) 1991 Nancy Butler, Joan Curry, Steven Konstant,
*	Dore Rosenblum, and Greg Bollella
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************} 

const
#include "globalconst.h"
type
#include "globaltypes.h"
#include "GetBoxSizes.h"

var

#include "globals.h"

procedure GetBoxSizes ;
(***************************************************************************)
(* procedure GetBoxSizes ( var T     : TreeNodeList ;                      *)
(*                         Condensed : boolean       )                     *)
(* Input parameter                                                         *)
(*   Condensed - true if tree is to be displayed in condensed mode.        *)
(* Update parameter                                                        *)
(*   T - a tree data structure, as returned by MakeTree.                   *)
(*       The fields set by GetBoxSizes are MaxBoxHt - in the HeaderNodes,  *)
(*       and BoxHt, BoxWidth, and PadPattribs (for nodes that have that    *)
(*       variant field) - in the TreeNodes.  The values to which these     *)
(*       fields are set are documented in the TreePrint internal documenta-*)
(*       tion manual and in the header and in-code comments following.     *)
(*                                                                         *)
(* Calls only subroutines declared internal to GetBoxSizes.                *)
(*                                                                         *)
(* Programmer : Joan Curry                                                 *)
(* Written    : 3/22/84                                                    *)
(***************************************************************************)
  var
    CurrentLevel : TreeNodeList ;
    CurrentNode  : TreeNodePtr  ;

  function FullModeBoxHt (N : TreeNodePtr) : integer ;
  (*************************************************************************)
  (* function FullModeBoxHt                                                *)
  (*                                                                       *)
  (* Input parameter                                                       *)
  (*   N - a tree node.  N^.tag must be RegularNode, SeqNode, or SetNode.  *)
  (* Returns the number of lines of text that will be displayed in the box *)
  (*   representing that node.  That's one line for the node type and node *)
  (*   label together, one line each for the non-pointer attributes, and   *)
  (*   one line for all of the pointer attributes if there are any.        *)
  (*                                                                       *)
  (* Programmer: Joan Curry                                                *)
  (* Written   : 3/22/84                                                   *)
  (*************************************************************************)
    var
      TempFtn : integer    ;
      npattr  : NPattrList ;
    begin
      TempFtn := 1 ;
      npattr := N^.NPattribs ;
      while npattr <> nil do
        begin
          TempFtn := TempFtn + 1 ;
          npattr := npattr^.Next 
        end ;
      if N^.Pattribs <> nil then
          TempFtn := TempFtn + 1 ;
      FullModeBoxHt := TempFtn
    end ;                               (* FullModeBoxHt *)

  function PlineWidth (N : TreeNodePtr) : integer ;
  (************************************************************************)
  (* function PlineWidth                                                  *)
  (*                                                                      *)
  (* Input parameter                                                      *)
  (*   N - a tree node.  N^.tag must be RegularNode, SeqNode, or SetNode. *)
  (*                                                                      *)
  (* Returns the length, in chars, that the box must be to accomodate the *)
  (*   pointer attributes. (Returns 1 if there are no pointer attributes) *)
  (*                                                                      *)
  (* Programmer: Joan Curry                                               *)
  (* Written   : 3/22/84                                                  *)
  (************************************************************************)
    var
      TempFtn : integer   ;
      pattr   : PattrList ;
    begin
      TempFtn := 1 ;
      pattr := N^.Pattribs ;
      while pattr <> nil do
        begin
          TempFtn := TempFtn + pattr^.Name.length
                             +3 ;    {1 blank before the name, 1 blank after,}
          pattr := pattr^.Next               {and 1 space for horizontal line}
        end ;
      PlineWidth := TempFtn
    end ;                                (* PlineWidth *)

  function MaxNPlineWidth (N : TreeNodePtr) : integer ;
  (*************************************************************************)
  (* function MaxNPlineWidth                                               *)
  (*                                                                       *)
  (* Input parameter                                                       *)
  (*   N - a tree node.  N^.tag must be RegularNode, SeqNode, or SetNode.  *)
  (*                                                                       *)
  (* Returns the length, in chars, that the box must be to accomodate all  *)
  (*   lines of text except the line for the pointer attributes.           *)
  (*                                                                       *)
  (* Programmer: Joan Curry                                                *)
  (* Written   : 3/22/84                                                   *)
  (*************************************************************************)
    var
      TempFtn  : integer    ;
      NextLine : integer    ;
      npattr   : NPattrList ;
    begin
      TempFtn := N^.Ntype.length + N^.Nlabel.length
                 + 7 ;  {2 vertical lines, 2 parens, 3 blanks}
      npattr := N^.NPattribs ;
      while npattr <> nil do
        begin
          NextLine := npattr^.Name.length + npattr^.StrRepVal.length
                      + 6 ;  {2 vertical lines, 1 colon, 3 blanks}
          if NextLine > TempFtn then
              TempFtn := NextLine ;
          npattr := npattr^.Next
        end ;
      MaxNPlineWidth := TempFtn
    end ;                                (* MaxNPlineWidth *)

  procedure GetOneBoxSize (var N     : TreeNodePtr ;
                           Condensed : boolean ) ;

  (*************************************************************************)
  (* procedure GetOneBoxSize                                               *)
  (*                                                                       *)
  (* Input parameter                                                       *)
  (*   Condensed - true if tree is to be displayed in condensed mode.      *)
  (* Update parameter                                                      *)
  (*   N - a tree node.  The fields BoxHt, BoxWidth, and (unless it's a    *)
  (*       sequence value or set value node) PadPattrLine are filled in.   *)
  (*                                                                       *)
  (* Calls FullModeBoxHt, PlineWidth, and MaxNPlineWidth                   *)
  (*                                                                       *)
  (* Programmer: Joan Curry                                                *)
  (* Written   : 3/21/84                                                   *)
  (*************************************************************************)

    var
      Pwidth  : integer ;  {width - in chars - that box would need to be to}
                                             {accomodate the pointer fields}
      NPwidth : integer ;  {same for the non-pointer fields}

    begin
      if (N^.tag = SeqValue) or (N^.tag = SetValue) then
        begin                     {print only the value for set or seq value}
          N^.BoxHt := 1 ;                       {TreeNode - truncate string-}
          if Condensed then                     {length if in condensed mode}
              if N^.StrRepVal.length > CondensedStrLen then
                  N^.StrRepVal.length := CondensedStrLen ;
          N^.BoxWidth := N^.StrRepVal.length
                         + 4  {2 vertical lines, 2 blanks}
        end

      else if N^.Duplicate then
        begin                       {print only the node label & carat, no box}
          N^.BoxHt := 1 ;
          N^.BoxWidth := N^.Nlabel.length 
                         + 5 ;    {1 carat, 2 blanks -  and 2 extra spaces}
          N^.PadPattrLine := false          {are needed by printing module}
        end

      else if Condensed then
        begin                       {print only the label in box}
          N^.BoxHt := 1 ;
          N^.BoxWidth := N^.Nlabel.length
                         + 4 ;  {2 vertical lines, 2 blanks}
          N^.PadPattrLine := false
        end

      else                   {full mode, N is RegularNode, SeqNode, or SetNode}
        begin
          N^.BoxHt := FullModeBoxHt (N) ;
          Pwidth := PlineWidth (N) ;
          NPwidth := MaxNPlineWidth (N) ;
          if NPwidth > Pwidth then
            begin
              N^.BoxWidth := NPwidth ;
              N^.PadPattrLine := N^.Pattribs <> nil
            end
          else
            begin
              N^.BoxWidth := Pwidth ;
              N^.PadPattrLine := false
            end
        end
    end ;                                (* GetOneBoxSize *)




  begin                                   (* body of GetBoxSizes *)
    CurrentLevel := T ;
    while CurrentLevel <> nil do
      begin
        CurrentLevel^.MaxBoxHt := 1 ;
        CurrentNode := CurrentLevel^.First ;
        while CurrentNode <> nil do
          begin
            GetOneBoxSize (CurrentNode, Condensed) ;
            if CurrentNode^.BoxHt > CurrentLevel^.MaxBoxHt then
                CurrentLevel^.MaxBoxHt := CurrentNode^.BoxHt ;
            CurrentNode := CurrentNode^.Next
          end ;
        CurrentLevel := CurrentLevel^.Next
      end
  end ;                                   (* body of GetBoxSizes *)

