/***********************************************************************\ 
*									* 
*   File: scorpion/src/showdep/main.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: main and supporting functions				*
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	main.c,v $
 * Revision 4.0  89/04/29  18:01:41  cheung
 * main.c  Ver 4.0
 * 
*									*
*   Edit Log:								*
*     Apr 24 1989 (shannon) Created.					*
*									*
\* ******************************************************************* */
 
#include "ShowDep.h"
#include <stdio.h>

#define GetStructureEntity(ref) ref->sem_entity.VStructureEntity
#define GetProcessEntity(ref) ref->sem_entity.VProcessEntity
#define TypeOfEntity(ref)	typeof(ref->sem_entity)


main(argc, argv)
int argc;
char *argv[];
{
	compilationUnit compUnit;
	extern Boolean ReaderOK;
	Boolean printflag=TRUE;		/* default */
	Boolean treeprflag=FALSE;	/* default */
	int i;
	char *mktemp();
        void exit();
        void revision_number();
        void usage();

	for (i=1; i<argc; i++) {
	    if (!strcmp(argv[i], "-p")) {
		printflag = TRUE;
		treeprflag = FALSE;
	    }
	    else if (!strcmp(argv[i], "-g")) {
		printflag = FALSE;
		treeprflag = TRUE;
	    }
            else if (!strcmp(argv[i],"-V")) {
		revision_number(argv[0]);
                exit(0);
            }
	    else {
		(void)fprintf(stderr,"%s: Invalid flag '%s' ignored\n",argv[0],argv[i]);
		usage(argv[0]);
	    }
	}
	if (isatty(0)) {
	    (void) fprintf(stderr, "%s: can't take input from keyboard\n", 
                 argv[0]);
	    exit(1);
	}
	compUnit = input(stdin);
	if (!ReaderOK) {
	    (void) fprintf(stderr, "%s: invalid input\n", argv[0]);
	    exit(1);
	}
	process(stdout, compUnit, printflag);
	if (treeprflag) {
	    output(stdout, compUnit, TWOPASS);
	}
	return 0;
}

process(fp, compUnit, printflag)
FILE *fp;
compilationUnit compUnit;
Boolean printflag;
{
	SEQDeclaration SDecl;
	Declaration ADecl;
	SEQDeclaration imports;
	int linenumber=1;

	/* collect and delete the imports */
	initializeSEQDeclaration(imports);
	foreachinSEQDeclaration(compUnit->syn_body, SDecl, ADecl) {
	    if (typeof(ADecl)==KImportDecl)
		appendfrontSEQDeclaration(imports, ADecl);
	}
	foreachinSEQDeclaration(imports, SDecl, ADecl) {
	    removeSEQDeclaration(compUnit->syn_body, ADecl);
	}

	/* process the  structures first */
	foreachinSEQDeclaration(compUnit->syn_body, SDecl, ADecl) {
	    if (typeof(ADecl)==KStructureEntity)
		PrintSt(fp, ADecl.VStructureEntity, 0, printflag, &linenumber, (char *)NULL);
	}
	/* process the processes next */
	foreachinSEQDeclaration(compUnit->syn_body, SDecl, ADecl) {
	    if (typeof(ADecl)==KProcessEntity)
		PrintPr(fp, ADecl.VProcessEntity, 0, printflag, &linenumber);
	}
}


PrintSt(fp, AStr, indent, printflag, linenumber, type)
FILE *fp;
StructureEntity AStr;
int indent;
Boolean printflag;
int *linenumber;
char *type;	/* Invariant, Port, or NULL */
{
	SEQStructureRef SStRef;
	StructureRef AStRef;
	StructureEntity st;

	if (printflag) {
	    (void) fprintf(fp, "%2d. ", *linenumber);
	    print_blanks(fp, indent);
	    if (type)
		(void) fprintf(fp, "%s ", type);
	    (void) fprintf(fp, "Structure %s", AStr->lex_name);
	}
	if (AStr->inv_firstref > 0) {
	    if (printflag) 
                (void) fprintf(fp, "^ (%d)\n", AStr->inv_firstref);
	    *linenumber += 1;
	    return; /* already done */
	}
	if (printflag) (void) fprintf(fp, "\n");

	AStr->inv_firstref = *linenumber;
	*linenumber += 1;
	foreachinSEQStructureRef(AStr->syn_from, SStRef, AStRef) {
	    if (TypeOfEntity(AStRef) == KStructureEntity) {
		st = GetStructureEntity(AStRef);
		appendrearSEQStructureEntity(AStr->sem_from, st);
		PrintSt(fp, st, indent+1, printflag, linenumber, (char *)NULL);
	    }
	}
	AStr->sem_refines.VVoid = NVoid;
	if (typeof(AStr->syn_refines)==KStructureRef) {
	    AStRef = AStr->syn_refines.VStructureRef;
	    if (TypeOfEntity(AStRef) == KStructureEntity) {
		st = GetStructureEntity(AStRef);
		AStr->sem_refines.VStructureEntity = st;
		PrintSt(fp, st, indent+1, printflag, linenumber, (char *)NULL);
	    }
	}
}

PrintPr(fp, APr, indent, printflag, linenumber)
FILE *fp;
ProcessEntity APr;
int indent;
Boolean printflag;
int *linenumber;
{
	ProcessRef APrRef;
	ProcessEntity pr;
	StructureRef AStRef;
	StructureEntity st;
	SETPort SPort;
	Port APort;

	if (printflag) {
	    (void) fprintf(fp, "%2d. ", *linenumber);
	    print_blanks(fp, indent);
	    (void) fprintf(fp, "Process %s", APr->lex_name);
	}
	if (APr->inv_firstref > 0) {
	    if (printflag) (void) fprintf(fp, "^ (%d)\n", APr->inv_firstref);
	    *linenumber += 1;
	    return; /* already done */
	}
	if (printflag) (void) fprintf(fp, "\n");
	APr->inv_firstref = *linenumber;
	*linenumber += 1;

	APr->sem_refines.VVoid = NVoid;
	if (typeof(APr->syn_refines)==KProcessRef) {
	    APrRef = APr->syn_refines.VProcessRef;
	    if (TypeOfEntity(APrRef) == KProcessEntity) {
		pr = GetProcessEntity(APrRef);
		APr->sem_refines.VProcessEntity = pr;
		PrintPr(fp, pr, indent+1, printflag, linenumber);
	    }
	}
	if (typeof(APr->syn_invariant) == KStructureRef) {
	    AStRef = APr->syn_invariant.VStructureRef;
	    if (TypeOfEntity(AStRef) == KStructureEntity) {
		st = GetStructureEntity(AStRef);
		APr->sem_invariant = st;
		PrintSt(fp, st, indent+1, printflag, linenumber, "Invariant");
	    }
	}
	foreachinSETPort(APr->sem_ports, SPort, APort) {
	    if (TypeOfEntity(APort->syn_data) == KStructureEntity) {
		st = GetStructureEntity(APort->syn_data);
		appendrearSEQStructureEntity(APr->sem_portsts, st);
		PrintSt(fp, st, indent+1, printflag, linenumber, "Port");
	    }
	}
}


print_blanks(fp, indent)
FILE *fp;
int indent;
{
	while (indent--) (void) fprintf(fp, "    ");
}

void usage(name)
char *name;
{
 (void)fprintf(stderr,"usage: %s [-p] [-g] < inputfile > outputfile\n",name);
}


void revision_number(name)
char *name;
{
 char revision_str[20];

 (void)sscanf("$Revision: 5.0 $","%*s %s",revision_str);
 (void)printf("%s: Display derivation & refinement dependencies of IDL structures and processes Version %s\n",name,revision_str);
 usage(name);
}
