/***********************************************************************\ 
*									* 
*   File: scorpion/src/lister/process.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include <string.h>
#include "lister.h"
#include "macros.h"
#include "globals.h"


/* some macros */
#define LengthcppLine(buf) ((buf[1] == ' ') ? (strlen(buf)-4) : (strlen(buf)-3))
#define PrintNextErrorLineMsg(fp, linecount) \
	    {char s[LINESIZE]; \
	     (void) sprintf(s,"*** Next error is on line %d\n", linecount); \
	     PrintString(fp, s); }

#define PrintFirstErrorLineMsg(fp, linecount) \
	    {char s[LINESIZE]; \
	     (void) sprintf(s,"*** First error is on line %d\n", linecount); \
	     PrintString(fp, s); }
	

#define BuildPreviousErrorLineMsg(prev_errmsg, prevErrline) \
	(void) sprintf(prev_errmsg, "*** Previous error was on line %d\n", \
		prevErrline);

#define BuildSourceLine(line, buf, linecount) \
	    (void) sprintf(line, "%4d| %s", linecount, buf);
char emptyline[] = "\0";
#define FreeLine(l) {/*FreeHeap(l);*/ l = emptyline;}



ProcessErrorInstances(current_wfp, current_rfp, Asourcefile)
FILE *current_wfp;
FILE *current_rfp;
sourcefile Asourcefile;
{
	SEQErrorInstance SErrorInstance;
	ErrorInstance AnErrorInstance;
	filetransition AFile;
	char pointerline[LINESIZE];
	String savenextline;
	String delaypointerline;
	String previous_line;
	String this_line; 
	char buf[LINESIZE];
	char prev_errmsg[LINESIZE];
	int charoffset;			/* offset of error instance in file*/
	int charcount;			/* current char count in file */
	int lastcharcount;		/* last count from while loop */
	int tempcount;			/* temporary for errorcount */
	Boolean printnextline;
	Boolean firstErr;		/* indicator of first error */
	Boolean EndposErr;		/* indicator of endposition errors */
	int previousErrline;
	int lasterrorline;
	SEQString sourcelines;
	SEQString errormsgs;
	SEQString endposErrors;
	String errmsg;
	String strptr;

	String GetError();
	int GetErrLevel();

	TRACE("ProcessErrorInstances");
#ifdef DEBUG
	PrintErrorInstances(Asourcefile);
#endif

	/* initialize */
	numwarnings = 0;
	numfatalerrors = 0;
	numsevere_errors = 0;
	numrecoverable_errors = 0;
	numextensions = 0;
	numcomments = 0;
	charcount = 0;
	lastcharcount = 0;
	lasterrorline = 0;
	linecount = 0;
	errorcount = 0;
	fileerrorcount = 0;
	lineoffset = SRCLINEOFFSET;
	printnextline = FALSE;
	firstErr = TRUE;
	EndposErr = FALSE;
	previousErrline = -1;
	prev_errmsg[0] = '\0';
	buf[0] = '\0';
	previous_line = emptyline;
	this_line = emptyline;
	ClearBuf(pointerline, LINESIZE);
	pointerline[0] = '\0';
	delaypointerline = emptyline;
	initializeSEQString(errormsgs);
	initializeSEQString(sourcelines);
	initializeSEQString(endposErrors);

	/* process each error instance */
	foreachinSEQErrorInstance(Asourcefile->errors, SErrorInstance,
				  AnErrorInstance) {

	    IncrementErrCount(AnErrorInstance);
	    ++fileerrorcount;
	    ++totalerrorcount;
	    if (GetErrLevel(AnErrorInstance) <= suppresslevel)
		continue;

	    if (typeof(AnErrorInstance->information->position)
						== Kendposition) {
		EndposErr = TRUE;
		tempcount = errorcount;
		errorcount = 0;
		errmsg = GetError(AnErrorInstance);
		CopyName(strptr,errmsg);
		appendrearSEQString(endposErrors,strptr);
		errorcount = tempcount;
		continue;
	    }


	    AFile = AnErrorInstance->filetransition;
	    charoffset = AnErrorInstance->source_position 
		     - AFile->charoffset + lastcharcount + 1;
	    while (AFile->filelinenumber > linecount+1) {
		(void) fgets(buf, LINESIZE, current_rfp);
		previous_line = this_line;
		++linecount;
		this_line = (String)GetHeap(SRCLINEOFFSET+strlen(buf)+1);
		BuildSourceLine(this_line, buf, linecount);
		appendrearSEQString(sourcelines, this_line);
		if (buf[0] == '#') /* preprocessor line */
		    lastcharcount += LengthcppLine(buf);
		else lastcharcount += strlen(buf);
		charoffset = AnErrorInstance->source_position 
			     - AFile->charoffset + lastcharcount + 1;
		charcount = lastcharcount;
	    }

	    while ((charcount < charoffset) && 
		   (fgets(buf, LINESIZE, current_rfp) != NULL)) {
		previous_line = this_line;
		errorcount = 0;
		++linecount;
		this_line = (String)GetHeap(SRCLINEOFFSET+strlen(buf)+1);
		BuildSourceLine(this_line, buf, linecount);
		if (printnextline) {
		    CopyName(savenextline, this_line);
		    printnextline = FALSE;
		}
		appendrearSEQString(sourcelines, this_line);
		if (buf[0] == '#') /* preprocessor line */
		    charcount += LengthcppLine(buf);
		else charcount += strlen(buf);
	    }

	    /* if error is on different line than last print the
	       last errors and the source between               */
	    if (linecount > lasterrorline) {

		/* if delay flag is set, add last two source lines 
		   to error list */
		if (delay_messages) {
		    if ((linecount-lasterrorline) > 2) {
			appendrearSEQString(errormsgs, horiz_line);
			CopyName(strptr, previous_line);
			appendrearSEQString(errormsgs, strptr);
		    }
		    if ((linecount-lasterrorline) > 1) {
			CopyName(strptr, this_line);
			appendrearSEQString(errormsgs, strptr);
			delaypointerline = (String)GetHeap(LINESIZE+1);
			ClearBuf(pointerline, LINESIZE);
			pointerline[0] = '\0';
			appendrearSEQString(errormsgs, delaypointerline);
		    }
		}

		/* else print last error message */
		else if (!emptySEQString(errormsgs)) {

		    if (!suppresslisting) {
			PrintPointerLine(current_wfp, pointerline);
			PrintString(current_wfp, prev_errmsg);
			PrintSEQString(current_wfp, errormsgs);
			PrintNextErrorLineMsg(current_wfp, linecount);
		    }
		    if (!suppress_stderr) {
			PrintPointerLine(stderr, pointerline);
			PrintSEQString(stderr, errormsgs);
			PrintString(stderr, savenextline);
			FreeLine(savenextline);
		    }
		    FreeSEQString(&errormsgs); 
		    ClearBuf(pointerline, LINESIZE);
		    pointerline[0] = '\0';

		}

		if (!suppress_stderr) {
		    if (firstErr && !firstFile)
			PrintStderrNewFile();
		    if ((linecount-lasterrorline) > 2) {
		        if (!firstErr)
			    PrintString(stderr, horiz_line);
			if (previous_line != emptyline)
			    PrintString(stderr, previous_line);
		    }
		    if ((linecount-lasterrorline) > 1) {
			PrintString(stderr, this_line);
		    }
		    printnextline = TRUE;
		}

		/* print out source inbetween error messages */
		if ((!suppresslisting) && (!emptySEQString(sourcelines))){
		    if (firstErr) {
			PrintFirstErrorLineMsg(current_wfp, linecount);
		    }
		    PrintSEQString(current_wfp, sourcelines);
		    FreeSEQString(&sourcelines);
		}

		/* build previous error message for next */
		if ((!delay_messages) && (previousErrline>0)) {
		    BuildPreviousErrorLineMsg(prev_errmsg, 
						previousErrline);
		}
		previousErrline = linecount;
		lasterrorline = linecount;
	    }

	    /* add new error to error message list */
	    lineoffset = strlen(this_line) - (charcount-charoffset);
	    if (typeof(AnErrorInstance->information->position)
						== Kcharposition)
		BuildPointerLine(this_line, pointerline, lineoffset, ++errorcount);
	    else ++errorcount;
	    if (delay_messages)
		(void) strcpy(delaypointerline, pointerline);

	    errmsg = GetError(AnErrorInstance);
	    CopyName(strptr, errmsg);
	    appendrearSEQString(errormsgs, strptr);


	    firstErr = FALSE;
	} /* end foreachinSEQErrorInstance */

	/* no more errors so print out last error */
	if ((!delay_messages) && (!emptySEQString(errormsgs))) {
	    if (!suppresslisting) {
		PrintPointerLine(current_wfp, pointerline);
		PrintString(current_wfp, prev_errmsg);
		PrintSEQString(current_wfp, errormsgs);
	    }
	    if (!suppress_stderr) {
		PrintPointerLine(stderr, pointerline);
		PrintSEQString(stderr, errormsgs);
	    }
	    FreeSEQString(&errormsgs); 
	}

	/* print out rest of source */
	this_line = (String)GetHeap(SRCLINEOFFSET+LINESIZE+1);
	while (fgets(buf, LINESIZE, current_rfp) != NULL) {
	    ++linecount;
	    BuildSourceLine(this_line, buf, linecount);
	    if (!suppresslisting)
		PrintString(current_wfp, this_line);
	    if ((!suppress_stderr) && (printnextline)) {
		PrintString(stderr, this_line);
		printnextline = FALSE;
	    }
	    if (suppresslisting)
		break;
	}
	FreeLine(this_line);

	/* if messages are delayed print now */
	if (delay_messages) {
	    if (!suppresslisting) {
		PrintSEQString(current_wfp, errormsgs);
		PrintString(current_wfp, horiz_line);
	    }
	    if (!suppress_stderr) {
		PrintSEQString(stderr, errormsgs);
	    }
	    FreeSEQString(&errormsgs); 
	}

	/* Print endposition messages */
	if (EndposErr) {
	if (!suppresslisting) {
		PrintString(current_wfp, horiz_line);
		PrintSEQString(current_wfp, endposErrors);
	}
	if (!suppress_stderr) {
		PrintString(stderr, horiz_line);
		PrintSEQString(stderr, endposErrors);
	} 
	FreeSEQString(&endposErrors); 
	}


	/* print summary statistics */
	if (!suppresslisting)
	    PrintSummaryLine(current_wfp);

	firstFile = FALSE;
}




BuildPointerLine(thisline, pointerline, lineoffset, errorcount)
String thisline;
String pointerline;
int lineoffset;
int errorcount;
{
	int i;

	TRACE("BuildPointerLine");
	if ((lineoffset > LINESIZE)||(lineoffset < 0))
	    return;

	for (i=0; i<lineoffset; i++)
	    if (thisline[i] =='\t') pointerline[i] = '\t';
	pointerline[strlen(pointerline)] = ' ';
	pointerline[lineoffset-1] = POINTERCHAR;
	pointerline[lineoffset] = '\0';
	(void) sprintf(pointerline, "%s%d", pointerline, errorcount);
}

PrintPointerLine(fp, pointerline)
FILE *fp;
String pointerline;
{
	int len;

	TRACE("PrintPointerLine");
	len = strlen(pointerline);
	if (len > 0) {
	    pointerline[0] = '*';
	    if (len > 1) pointerline[1] = '*';
	    if (len > 2) pointerline[2] = '*';
	    pointerline[len] = '\n';
	    pointerline[len+1] = '\0';
	    PrintString(fp, pointerline);
	    pointerline[len] = '\0';
	}
}
