/***********************************************************************\ 
*									* 
*   File: scorpion/src/lister/print.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include <ctype.h>
#include "lister.h"
#include "macros.h"
#include "globals.h"


PrintSummaryLine(wfp)
FILE *wfp;
{
	TRACE("PrintSummaryLine");
	if (wfp != stderr)  {
	    if (((lfile_linecount % pagelength) == 0) ||
		((lfile_linecount % pagelength) == 1))
		PrintNewPage(wfp);
		++lfile_linecount;
	}

	(void) fprintf(wfp, 
	    "\n? Fatal Errors: %d, Severe Errors: %d, Recoverable Errors: %d,",
	    numfatalerrors, numsevere_errors, numrecoverable_errors);
	if (suppresslevel == RECOVERABLELEVEL) 
	    (void) fprintf(wfp, " (suppressed)");
	(void) fprintf(wfp, "\n  Warnings: %d", numwarnings);
	if (suppresslevel >= WARNINGLEVEL) 
	    (void) fprintf(wfp, " (suppressed)");
	(void) fprintf(wfp, ", Extensions: %d", numextensions);
	if (suppresslevel >= EXTENSIONLEVEL) 
	    (void) fprintf(wfp, " (suppressed)");
	(void) fprintf(wfp, ", Comments: %d", numcomments);
	if (suppresslevel >= COMMENTLEVEL) 
	    (void) fprintf(wfp, " (suppressed)");
	(void) fprintf(wfp, "\n");
}

PrintStderrSummaryLine()
{

	TRACE("PrintStderrSummaryLine");
	(void) fprintf(stderr, 
	    "\n? Fatal Errors: %d, Severe Errors: %d, Recoverable Errors: %d,",
	    stderrnumfatalerrors, stderrnumsevere_errors, 
	    stderrnumrecoverable_errors);
	if (suppresslevel == RECOVERABLELEVEL) 
	    (void) fprintf(stderr, " (suppressed)");
	(void) fprintf(stderr, "\n  Warnings: %d", stderrnumwarnings);
	if (suppresslevel >= WARNINGLEVEL) 
	    (void) fprintf(stderr, " (suppressed)");
	(void) fprintf(stderr, ", Extensions: %d", stderrnumextensions);
	if (suppresslevel >= EXTENSIONLEVEL) 
	    (void) fprintf(stderr, " (suppressed)");
	(void) fprintf(stderr, ", Comments: %d", stderrnumcomments);
	if (suppresslevel >= COMMENTLEVEL) 
	    (void) fprintf(stderr, " (suppressed)");
	(void) fprintf(stderr, "\n");
}



PrintString(current_wfp, Astr)
FILE *current_wfp;
String Astr;
{

    char *s, *last, savech;
    int local_pagewidth;
    Boolean done;


    TRACE1("PrintString: %s", Astr);
    if (!Astr) return;
    s = Astr;
    done = FALSE;
    local_pagewidth = pagewidth;

    while (!done) {

	/* check if linecount is over pagelength, if so start new page */
 	/* only for listing files, unless first time */
	if (current_wfp != stderr) { 
	    if ((lfile_linecount % pagelength) == 0) {
		FirstTime = FALSE;
		PrintNewPage(current_wfp);
	 	++lfile_linecount;
	    }
	}

	if (strlen(s) <= local_pagewidth) {
	    (void)fputs(s, current_wfp);
	    done = TRUE;
	}
	else {
	    /* if line will be broken over page, start new page before first
	       part of line */
	    if (current_wfp != stderr) {  /* only for listing files */
		if ((lfile_linecount % pagelength) == 0) {
		    PrintNewPage(current_wfp);
		    ++lfile_linecount;
		}
	    }
	    if (*Astr == '*') {   /* error message so break line between words*/

		last = s + local_pagewidth - 1;
		while (last > s && !isspace(*last))
		    --last;
		if (last != s)
		    savech = *last;
		else
		    savech = *(last = s + local_pagewidth);  
	    }
	    else 		/* source line, just break off */
		savech = *(last = s + local_pagewidth);  

	    *last = '\0';
	    (void) fprintf(current_wfp, "%s\n", s);
	    *last = savech;
	    if (isspace(savech))
		s = last + 1;
	    else s = last;

	    if (*Astr == '*') {  /* error message */
		(void) fprintf (current_wfp, "***     ");
		if (local_pagewidth == pagewidth)
		    local_pagewidth -= 8;
	    }
	    else {		/* source line */
		(void) fprintf (current_wfp, "    | ");
		if (local_pagewidth == pagewidth)
		    local_pagewidth -= 7;
	    }
	}
    }
}

PrintNewPage(curr_wfp)
FILE *curr_wfp;
{
    char *buf;
    char *GetMessage();
    static Boolean init=TRUE;
    static ErrorInstance AnErrorInstance;

    TRACE("PrintNewPage");
    if (init) {
	init=FALSE;
	AnErrorInstance = NErrorInstance;
    }
    ++lfile_pagecount;
    buf = GetMessage(pageheader, AnErrorInstance);
    (void) fprintf(curr_wfp, "%s\n", buf);
    lfile_linecount = 2;
}

PrintStderrHeader()
{
    
    char *GetMessage();
    static Boolean init = TRUE;
    static ErrorInstance AnErrorInstance;

    TRACE("PrintStderrHeader");
    if (init) {
	init = FALSE;
	AnErrorInstance = NErrorInstance;
    }

    (void) fprintf(stderr, "\n%s",GetMessage(stderrorheader, AnErrorInstance));
}
PrintStderrNewFile()
{
    
    char *GetMessage();
    static Boolean init = TRUE;
    static ErrorInstance AnErrorInstance;

    TRACE("PrintStderrNewFile");
    if (init) {
	init = FALSE;
	AnErrorInstance = NErrorInstance;
    }

    (void) fprintf(stderr, "\n%s", GetMessage(stderrornewfile, AnErrorInstance));
}
