/***********************************************************************\ 
*									* 
*   File: scorpion/src/lister/misc.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include "lister.h"
#include "macros.h"
#include "globals.h"

filetransition FindSourceFile(allfiles, AnErrorInstance)
transitions allfiles;
ErrorInstance AnErrorInstance;
{
	SEQfiletransition SFile;
	filetransition lastFile;
	filetransition AFile;

	TRACE("FindSourceFile");

	lastFile = NULL;
	if (allfiles != NULL)  {
          if (typeof(AnErrorInstance->information->position) == Kendposition) {
  	       retrievefirstSEQfiletransition(allfiles->transitions,AFile);
	       lastFile = AFile;
	  }
	  else {
	    if (AnErrorInstance->source_position != 0)
		foreachinSEQfiletransition(allfiles->transitions, SFile, AFile){
		    if (AFile->charoffset > AnErrorInstance->source_position)
			break;
		    else lastFile = AFile;
		} 
	    else {  
	    /* if src position is zero & position != endposition, error */
  	       retrievefirstSEQfiletransition(allfiles->transitions,AFile);
	       lastFile = AFile;
	    }
	  }
	}

	return(lastFile);
}


/* return TRUE if Err2 should be before Err1 in seq */
Boolean shouldswap(Err1, Err2)
ErrorInstance Err1, Err2;
{
	Boolean swap;
	register int line1, line2;

	line1 = Err1->filetransition->filelinenumber;
	line2 = Err2->filetransition->filelinenumber;
	if (line2 < line1)
	    swap = TRUE;
	else if (line1 < line2)
	    swap = FALSE;
	else if (Err2->source_position < Err1->source_position)
	    swap = TRUE;
	else swap = FALSE;
	
	return(swap);
}
FreeSEQString(seqstr)
SEQString *seqstr;
{
	/* SEQString Sstr; */
	/* String Astr; */

	TRACE("FreeSeqString");
        /**** can't free since it's in global string table
	foreachinSEQString((*seqstr), Sstr, Astr) {
	    FreeHeap(Astr);
	}
	****/
	while (*seqstr) removefirstSEQString(*seqstr);
}

ListerError(cntlstr, arg1, arg2, arg3, arg4)
String cntlstr;
String arg1, arg2, arg3, arg4;
{
	char buf[LINESIZE*2];

	TRACE("ListerError");
	if (print_lister_errors) {
	    (void) sprintf(buf, cntlstr, arg1, arg2, arg3, arg4);
	    (void) fprintf(stderr, "lister: %s\n", buf);
	}
}

ClearBuf(buf, size)
String buf;	
int size; /* assumes storage of size 'size' */
{
	int i;
	TRACE("ClearBuf");
	for (i=0; i<size; i++)
	    buf[i] = ' ';
}


PrintErrorInstances(Asourcefile)
sourcefile Asourcefile;
{
	SEQErrorInstance SErrorInstance;
	ErrorInstance AnErrorInstance;

	TRACE("PrintErrorInstances");
	(void) fprintf(stderr, "File %s\n", Asourcefile->name);
	foreachinSEQErrorInstance(Asourcefile->errors, SErrorInstance,
				AnErrorInstance)
	    (void) fprintf(stderr, "no: %d sourcepos %d\n", 
                  AnErrorInstance->number,
		    AnErrorInstance->source_position);
}

stripsuffix(name)
String name;
{
	int len=0;
	int i;

	TRACE("stripsuffix");
	if (name) len = strlen(name);
	for (i=len-1; i>0; i--) {
	    if (name[i] == '.') {
		name[i] = '\0';
		break;
	    }
	}
}
