/***********************************************************************\ 
*									* 
*   File: scorpion/src/lister/main.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "lister.h"
#include "macros.h"
#include "globals.h"
#include "err.h"
#include <stdio.h>
#include <string.h>

extern void init_global_strings();

main(argc, argv)
int argc; 
char *argv[];
{
	FILE *fopen(),
	     *fp,
	     *errorinfofile,
	     *includefile,
	     *current_rfp,
	     *current_wfp;
        void exit();
        void usage();
	SEQErrorInstance SErrorInstance;	/* SEQ iterators */
	ErrorInstance AnErrorInstance;
	SEQString Sstr;
	String Astr;
	SEQint Sint;
	int Aint;
	SEQfiletransition SFile;
	filetransition AFile;
	SEQsourcefile Ssourcefile;
	sourcefile Asourcefile;
	SEQformat Sformat;
	format Aformat;
	SEQString errorfiles;			/* seq of error files */
	SEQint errorpipes;			/* seq of error pipes */
	String srcfilename;
	Boolean hasincludefile;
	Boolean version_only = FALSE;
	Boolean found;
	transitions allfiles;
	filetransition newfile;
	sourcefile Nosourcefile;
	int i;
	Boolean forcelisting = FALSE;	/* generate listing files regardless of 
					   whether there are errors */
	Boolean shouldswap();
	filetransition FindSourceFile();
	String GetError();
	char *GetMessage();


	/* initialize */
	hasincludefile = FALSE;
	errorinfofile = NULL;
	srcfilename = NULL;
	initializeSEQString(errorfiles);
	initializeSEQint(errorpipes);
	initializeSEQsourcefile(allsourcefiles);

	TRACE("main: process command arguments");
	/* process command line arguments */
	for (i=1; i<argc; i++) {
	    if (strequal(argv[i], "-e")) {
		if ((i+1 >= argc) || (argv[i+1][0] == '-')) {
		    ListerErr0("No file specified after -e option");
		}
		else {
		    ++i;
		    appendrearSEQString(errorfiles, NewString(argv[i]));
		}
	    }
	    else if (!strncmp(argv[i], "-e", 2)) { /* pipe */
		appendrearSEQint(errorpipes, atoi(&argv[i][2]));
	    }
	    else if (strequal(argv[i], "-D")) {
		print_lister_errors = 1;
	    }
	    else if (!strncmp(argv[i], "-w", 2)) { /* page width */
		pagewidth = atoi(&argv[i][2]);
		if (pagewidth < MIN_PAGEWIDTH) {
		    ListerErr1("Pagewidth too small. Using %d.",
				(String)MIN_PAGEWIDTH);
		    pagewidth = MIN_PAGEWIDTH;
		}
		else if (pagewidth > MAX_PAGEWIDTH) {
		    ListerErr1("Pagewidth too large. Using %d.",
				(String)MAX_PAGEWIDTH);
		    pagewidth = MAX_PAGEWIDTH;
		}
	    }
	    else if (!strncmp(argv[i], "-l", 2)) { /* page length */
		pagelength = atoi(&argv[i][2]);
		if (pagelength < MIN_PAGELENGTH) {
		    ListerErr1("Pagelength too small. Using %d.",
				(String) MIN_PAGELENGTH);
		    pagelength = MIN_PAGELENGTH;
		}
		else if (pagelength > MAX_PAGELENGTH) {
		    ListerErr1("Pagelength too large. Using %d.",
				(String) MAX_PAGELENGTH);
		    pagelength = MAX_PAGELENGTH;
		}
	    }
	    else if (strequal(argv[i], "-f")) {
		if ((i+1 >= argc)) {
		    ListerErr0("No file specified after -f option");
		}
		else if (strequal(argv[i+1], "-")) {
		    ++i;
		    hasincludefile = TRUE;
		    includefile = stdin;
		}
		else if ((argv[i+1][0]=='-')) {
		    ListerErr0("No file specified after -f option");
		}
		else {
		    ++i;
		    if ((includefile=fopen(argv[i],"r"))==NULL) {
			ListerErr1("Can't open file '%s' for reading",
				argv[i]);
		    }
		    else
		      hasincludefile = TRUE;

		}
	    }
	    else if (strequal(argv[i], "-i")) {
		if ((i+1 >= argc) || (argv[i+1][0] == '-')) {
		    ListerErr0("No file specified after -i option");
		}
		else {
		    ++i;
		    if ((errorinfofile=fopen(argv[i],"r"))==NULL) {
			ListerErr1("Can't open file '%s' for reading",
				argv[i]);
		    }
		}
	    }
	    else if (!strncmp(argv[i], "-s", 2)) {
		suppresslevel = atoi(&argv[i][2]);
		if (suppresslevel > MAXSUPPRESSLEVEL) {
		    ListerErr1("Can't suppress messages over level %d",
				(String) MAXSUPPRESSLEVEL);
		    suppresslevel = MAXSUPPRESSLEVEL;
		}
		else if (suppresslevel < MINSUPPRESSLEVEL) {
		    ListerErr1("Can't suppress messages under level %d",
				(String) MINSUPPRESSLEVEL);
		    suppresslevel = MINSUPPRESSLEVEL;
		}
	    }
	    else if (strequal(argv[i], "-V")) {
		version_only = TRUE;
	    }
	    else if (strequal(argv[i], "-m")) {
		suppress_stderr = TRUE;
	    }
	    else if (strequal(argv[i], "-d")) {
		delay_messages = TRUE;
	    }
	    else if (strequal(argv[i], "-o")) {
		ordered = TRUE;
	    }
	    else if (strequal(argv[i], "-n")) {
		suppresslisting = TRUE;
	    }
	    else if (strequal(argv[i], "-L")) {
		forcelisting = TRUE;
	    }
	    else if (argv[i][0] == '-') {
		ListerErr1("Unknown option '%s'", argv[i]);
	    }
	    else {
		if (srcfilename == NULL)
		  srcfilename = argv[i];
		else {
		    ListerErr0("Can't specify more than one source file");
		}
	    }
	  }
	if (!version_only && (srcfilename == NULL) && !hasincludefile ) {
	    ListerErr0("No source file specified");
	    exit(1);
	}
	if ((suppresslisting) && (suppress_stderr)) {
	    ListerErr0("Listing files and stderr both suppressed. No errors processed.");
	    exit(1);
	}


	/* if no errors exist, and listing is not forced, exit */
	if (!version_only && !forcelisting && 
		emptySEQString(errorfiles) && emptySEQint(errorpipes)) {
	    ListerErr0("No error files\n");
	    exit(1);
	}

	/* initialize global string variables */
	init_global_strings();
	/* read include structure if any */
	if (hasincludefile)  {
	    allfiles = INinc(includefile);
	}
	if(!hasincludefile || allfiles == NULL) {
	    allfiles = Ntransitions;
	    initializeSEQfiletransition(allfiles->transitions);
	    newfile = Nfiletransition;
	    if(srcfilename != NULL) {
	      newfile->filename = srcfilename;
	      newfile->charoffset = 1;
	      newfile->filelinenumber = 1;
	      appendrearSEQfiletransition(allfiles->transitions, newfile);
	    }
	}


	/* read error information structure if any */
	if (errorinfofile != NULL) {
	    allerrorinfo = INErr(errorinfofile);
	}
	else allerrorinfo = Nerrorinfo;


	TRACE("main: set format types");
	/* set the format types if given */
	foreachinSEQformat(allerrorinfo->formats, Sformat, Aformat) {
	    switch (typeof(Aformat->ftype)) {
		case Klistingheader:
		    pageheader = Aformat->backdrop;
		    break;
		case Kstderrheader:
		    stderrorheader = Aformat->backdrop;
		    break;
		case Kstderrnewfile:
		    stderrornewfile = Aformat->backdrop;
		    break;
		case Kfatal:
		    fprefix = Aformat->backdrop;
		    break;
		case Ksevere:
		    sprefix = Aformat->backdrop;
		    break;
		case Krecoverable:
		    rprefix = Aformat->backdrop;
		    break;
		case Kwarning:
		    wprefix = Aformat->backdrop;
		    break;
		case Kextension:
		    eprefix = Aformat->backdrop;
		    break;
		case Kcomment:
		    cprefix = Aformat->backdrop;
		    break;
		default:
		    break;
	    }
	}



	/* if listings are forced, add all source files to list */
	if (forcelisting) {
	    foreachinSEQfiletransition(allfiles->transitions, SFile, AFile){
		found = FALSE;
		foreachinSEQsourcefile(allsourcefiles, Ssourcefile,Asourcefile){
		    if (strequal(AFile->filename, Asourcefile->name)){
			found = TRUE;
			break;
		    }
		}
		if (!found) {
		    Asourcefile = Nsourcefile;
		    Asourcefile->name = AFile->filename;
		    appendrearSEQsourcefile(allsourcefiles, Asourcefile);
		}
	    }
	}

	/* add all error instances to their appropriate file in source 
	   	file list						*/

	Nosourcefile = Nsourcefile;
	Nosourcefile->name = "nofile";
	foreachinSEQString(errorfiles, Sstr, Astr) {
	    if ((fp=fopen(Astr, "r")) == NULL)
	        ListerErr1("Can't open error file '%s' for reading",
			Astr);
	    else {
		AddErrorInstance(fp, allfiles, &allsourcefiles, Nosourcefile);
	    }
	}
	foreachinSEQint(errorpipes, Sint, Aint) {
	    if ((fp=fdopen(Aint, "r")) == NULL)
	        ListerErr1("Can't open error pipe '%d' for reading",
			(String) Aint);
	    else {
		AddErrorInstance(fp, allfiles, &allsourcefiles, Nosourcefile);
	    }
	}

	/* if error instances are not ordered, sort */
	if (!ordered) {
	    foreachinSEQsourcefile(allsourcefiles, Ssourcefile, Asourcefile) {
	      sortSEQErrorInstance(Asourcefile->errors,shouldswap);
	    }
	}

	/* process all format error instances */
	foreachinSEQErrorInstance(Nosourcefile->errors, SErrorInstance,
				  AnErrorInstance) {
	    /* if number < 0 it is an argument for a format */

	    if (AnErrorInstance->number < 0) {
	        switch (AnErrorInstance->number){
		   case	ERRLISTINGHEADER:
		     pageheader = NewString(GetMessage(pageheader,AnErrorInstance));
		     break;
		   case	ERRSTDERRHEADER:
		     stderrorheader = NewString(GetMessage(stderrorheader,AnErrorInstance));
		     break;
		   case	ERRSTDNEWFILEHEADER:
		     stderrornewfile = NewString(GetMessage(stderrornewfile,AnErrorInstance));
		     break;
   		   case ERRFATAL_ERROR_FORMAT:
		     fprefix = NewString(GetMessage(fprefix,AnErrorInstance));
		     break;
		   case ERRSEVERE_ERROR_FORMAT:
		     sprefix = NewString(GetMessage(sprefix,AnErrorInstance));
		     break;
		   case ERRRECOVERABLE_ERROR_FORMAT:
		     rprefix = NewString(GetMessage(rprefix,AnErrorInstance));
		     break;
		   case ERRWARNING_FORMAT:
		     wprefix = NewString(GetMessage(wprefix,AnErrorInstance));
		     break;
		   case ERREXTENSION_FORMAT:
		     eprefix = NewString(GetMessage(eprefix,AnErrorInstance));
		     break;
		   case ERRCOMMENT_FORMAT:
	    	     cprefix = NewString(GetMessage(cprefix,AnErrorInstance));
		     break;
  	      	   default:
		     break;
		}
	    }
	}

	/* print stderr header */
	if (!suppress_stderr) {
	    if (srcfilename != NULL)
		(void) strcpy(current_file,srcfilename);
	    else
		(void) strcpy(current_file, "\0");
	    PrintStderrHeader();
	};
	if (version_only) {
	    exit(0);
        }
#ifdef DEBUG
	print_global_strings();
#endif
	/* process all error instances with no source file */
	foreachinSEQErrorInstance(Nosourcefile->errors, SErrorInstance,
				  AnErrorInstance) {
	    /* if number < 0 it is an argument for a format */
	    if (AnErrorInstance->number >= 0) {
		IncrementErrCount(AnErrorInstance);
		(void) fprintf(stderr, "%s\n", GetError(AnErrorInstance));
	    }
	}

	/* process the error instances for each source file */

	foreachinSEQsourcefile(allsourcefiles, Ssourcefile, Asourcefile) {
	    if ((current_rfp=fopen(Asourcefile->name, "r")) == NULL) {
		ListerErr1("Can't open source file '%s' for reading",
			    Asourcefile->name);
		continue;
	    }
	    (void) sprintf(current_file, Asourcefile->name);
	    if (!suppresslisting) {
		stripsuffix(Asourcefile->name);
		(void) sprintf(current_listfile, "%s.list", Asourcefile->name);
		if ((current_wfp=fopen(current_listfile, "w"))==NULL) {
		    ListerErr1("Can't open list file '%s' for writing. Using stderr", current_listfile);
		    current_wfp = stderr;
		}
	    }
	    else current_wfp = NULL;
	    lfile_linecount = 0;
	    lfile_pagecount = 0;
	    ProcessErrorInstances(current_wfp, current_rfp, Asourcefile);
	}
	if (!suppress_stderr)
	    PrintStderrSummaryLine();

	/* exit successfully */
	return 0;
}



void usage(name)
char *name;
{
 (void)fprintf(stderr,"usage: %s [-d] [-D] [-e file] [-e<number] [-f file] [-i file] [-l<number] [-L] [-m] [-n] [-o] [-s<level>] [-V] [-w<number>] [sourcefile]\n",name);
}

