/***********************************************************************\ 
*									* 
*   File: scorpion/src/lister/macros.h 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 


#define LINESIZE 300
#define MAXMESSAGELENGTH 300

#ifdef DEBUG
#define TRACE(str)	(void) fprintf(stderr, "TRACE: %s\n", str);
#define TRACE1(str,a)	{(void) fprintf(stderr, "TRACE: "); \
			 (void) fprintf(stderr, str, a); \
			 (void) fprintf(stderr, "\n"); }
#else
#define TRACE(str)	
#define TRACE1(str,a)
#endif

#define strequal(s1, s2) (!strcmp(s1,s2))

#define CopyName(nname, oname)	\
	(void) strcpy((nname = (char *)GetHeap(strlen(oname)+1)) , oname)

#define PrintSEQString(fp, strseq) \
	{SEQString Ss; String As; \
	 foreachinSEQString(strseq, Ss, As) PrintString(fp, As); }


/* pointer char for pointer line */
#define POINTERCHAR '^'

/* source line offset (%4d| ) */
#define SRCLINEOFFSET 6


/* page width and length */
#define DEFAULT_PAGEWIDTH 80
#define DEFAULT_PAGELENGTH 64
#define MIN_PAGEWIDTH 10
#define MAX_PAGEWIDTH 150
#define MIN_PAGELENGTH 10
#define MAX_PAGELENGTH 150

/* error supression levels */
#define COMMENTLEVEL 1
#define EXTENSIONLEVEL 2
#define WARNINGLEVEL 3
#define RECOVERABLELEVEL 4
#define SEVERELEVEL 5
#define FATALLEVEL 6
#define MAXSUPPRESSLEVEL 4
#define MINSUPPRESSLEVEL 0
#define DEFAULTSUPPRESSLEVEL MINSUPPRESSLEVEL 

/* argument types */
#define ABSLINE 'A'
#define EXCOL 'B'
#define ABSCOL 'C'
#define DATE 'D'
#define ERRNO 'E'
#define FILECREATEDATE 'F'
#define FILECREATETIME 'G'
#define USERINT 'I'
#define MESSAGE 'M'
#define FILENAME 'N'
#define PAGENO 'P'
#define EXLINE 'Q'
#define RELLINE 'R'
#define USERSTRING 'S'
#define TIME 'T'
#define VERSIONNO 'V'
#define COUNTINLINE 'W'
#define COUNTINFILE 'X'
#define ERRORCOUNT 'Y'

/* lister error macros */
#define NS ""
#define ListerErr0(str)			ListerError(str, NS, NS, NS, NS)
#define ListerErr1(str, a1)		ListerError(str, a1, NS, NS, NS)
#define ListerErr2(str, a1, a2)		ListerError(str, a1, a2, NS, NS)
#define ListerErr3(str, a1, a2, a3)	ListerError(str, a1, a2, a3, NS)
#define ListerErr4(str, a1, a2, a3, a4)	ListerError(str, a1, a2, a3, a4)
