/***********************************************************************\ 
*									* 
*   File: scorpion/src/lister/globals.h 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 


extern Boolean ReaderOK;
extern String horiz_line;

/* global flags */
extern Boolean suppresslisting;
extern Boolean suppress_stderr;
extern Boolean delay_messages;
extern Boolean ordered;
extern Boolean firstFile;
extern Boolean FirstTime;
extern Boolean print_lister_errors;
extern int suppresslevel;

/* contains all error information */
extern errorinfo allerrorinfo;

/* list of all source files with errors */
extern SEQsourcefile allsourcefiles;

/* default page header for each listing file */
extern String pageheader;

/* default stderr header */
extern String stderrorheader;

/* default stderr header for new file */
extern String stderrornewfile;

/* default prefixes */
extern String fprefix;
extern String sprefix;
extern String rprefix;
extern String wprefix;
extern String eprefix;
extern String cprefix;

/* current listing file */
extern char current_listfile[LINESIZE];
extern char current_file[LINESIZE];

/* linecount and pagecount for listing file */
extern int lfile_linecount;
extern int lfile_pagecount;

/* other counts */
extern int lineoffset;		/* offset of err from beginning ofline (col)*/
extern int linecount;		/* current line count in file */
extern int errorcount;		/* error count for current line */
extern int fileerrorcount;	/* error count for current file */
extern int totalerrorcount;	/* total error count for lister */

/* count for number of each type of error for current source file*/
extern int numwarnings;		/* for current file */
extern int numfatalerrors;
extern int numsevere_errors;
extern int numrecoverable_errors;
extern int numextensions;
extern int numcomments;
extern int stderrnumfatalerrors;	/* for stderr */
extern int stderrnumsevere_errors;
extern int stderrnumrecoverable_errors;
extern int stderrnumwarnings;
extern int stderrnumextensions;
extern int stderrnumcomments;

extern int pagewidth;
extern int pagelength;
