/***********************************************************************\ 
*									* 
*   File: scorpion/src/lister/globals.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include "lister.h"
#include "macros.h"

String horiz_line;

/* global flags */
Boolean suppresslisting = FALSE;
Boolean suppress_stderr = FALSE;
Boolean delay_messages = FALSE;
Boolean ordered = FALSE;
Boolean firstFile = TRUE;
Boolean FirstTime = TRUE;
Boolean print_lister_errors = FALSE;
int suppresslevel = DEFAULTSUPPRESSLEVEL;

/* contains all error information */
errorinfo allerrorinfo;

/* list of all source files with errors */
SEQsourcefile allsourcefiles = NULL;

/* default page header for each listing file */
String pageheader;

/* default stderr header */
String stderrorheader;

/* default stderr header for new file */
String stderrornewfile;

/* default prefixes */
String fprefix;
String sprefix;
String rprefix;
String wprefix;
String eprefix;
String cprefix;

/* current listing file */
char current_listfile[LINESIZE];
char current_file[LINESIZE];

/* linecount and pagecount for listing file */
int lfile_linecount;
int lfile_pagecount;

/* other counts */
int lineoffset;			/* offset of err from beginning ofline (col)*/
int linecount;			/* current line count in file */
int errorcount;			/* error count for current line */
int fileerrorcount;		/* error count for current file */
int totalerrorcount=0;		/* total error count for lister */

/* count for number of each type of error for current source file*/
int numwarnings = 0;		/* for current file */
int numfatalerrors = 0;
int numsevere_errors = 0;
int numrecoverable_errors = 0;
int numextensions = 0;
int numcomments = 0;
int stderrnumfatalerrors=0;	/* for stderr */
int stderrnumsevere_errors=0;
int stderrnumrecoverable_errors=0;
int stderrnumwarnings=0;
int stderrnumextensions=0;
int stderrnumcomments=0;

int pagewidth = DEFAULT_PAGEWIDTH;
int pagelength = DEFAULT_PAGELENGTH;


void init_global_strings()
{
	register int i;

	TRACE("init_global_strings");

	horiz_line = (String)GetHeap(pagewidth + 2);
	for (i=0; i<pagewidth-1; i++) 
	    horiz_line[i] = '_';
	horiz_line[pagewidth-1] = '\n';
	horiz_line[pagewidth] = '\0';

	pageheader = NewString("Listing File %N.list\t\t\tPage %P");
	stderrorheader = NewString("Stderr Header for lister");
	stderrornewfile = NewString("Stderr for Listing File %N.list");
	fprefix = NewString("%W Fatal Error %E: %M");
	sprefix = NewString("%W Severe Error %E: %M");
	rprefix = NewString("%W Recoverable Error %E: %M");
	wprefix = NewString("%W Warning %E: %M");
	eprefix = NewString("%W Extension %E: %M");
	cprefix = NewString("%W Comment %E: %M");
}
