/***********************************************************************\ 
*									* 
*   File: scorpion/src/lister/geterror.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include <sys/time.h>
#include <ctype.h>
#include <string.h>
#include "lister.h"
#include "macros.h"
#include "globals.h"

long time();
void exit();

char *GetTime();
char *GetDate();
char *GetFileCreateDate();
char *GetFileCreateTime();
#define GetPageNumber() lfile_pagecount
#define GetVersionNumber() allerrorinfo->version
#define GetNextarg(err,arg) {retrievefirstSEQargument(err->arguments, arg); \
			 removefirstSEQargument(err->arguments); }

String GetError(AnErrorInstance)
ErrorInstance AnErrorInstance;
{
	static char *msg;
	char *GetMessage();

	TRACE("GetError");
	switch (typeof(AnErrorInstance->information->itype)) {
	    case Kfatal:
		msg = GetMessage(fprefix, AnErrorInstance);
		break;
	    case Ksevere:
		msg = GetMessage(sprefix, AnErrorInstance);
		break;
	    case Krecoverable:
		msg = GetMessage(rprefix, AnErrorInstance);
		break;
	    case Kwarning:
		msg = GetMessage(wprefix, AnErrorInstance);
		break;
	    case Kextension:
		msg = GetMessage(eprefix, AnErrorInstance);
		break;
	    case Kcomment:
		msg = GetMessage(cprefix, AnErrorInstance);
		break;
	    default:
		ListerErr0("Invalid type in PrintError\n");
		exit(2);
	}
	
	return(msg);
}

char *GetMessage(msg, AnErrorInstance)
String msg;
ErrorInstance AnErrorInstance;
{
	static char ret_message[MAXMESSAGELENGTH]; /* for 2nd call */
	char message[MAXMESSAGELENGTH];
	int msglen=0;
	int count;
	int i;
	argument arg;
	char argtype; 
	char charstr[100];
	char intstr[100];
	char formatstr[50];
	char *cf;
	String GetArgTypeValue();


	TRACE1("GetMessage: %s", msg);

	/* build up message string */
	count = -1;
	if (msg) msglen = strlen(msg);
	for (i=0; i<MAXMESSAGELENGTH; i++) message[i] = '\0';

	for (i=0; i<msglen; i++) {
	    if ((msg[i] == '%') && (i < msglen-1) && (msg[i+1] != ' ')){

		/* check for format length */
		if (isdigit(msg[++i])) {
		    (void) strcpy(formatstr, "%");
		    cf = formatstr+1;
		    while (isdigit(msg[i])) {
			*cf++ = msg[i];
			++i;
		    }
		    *cf = '\0';
		    argtype = msg[i];
		}
		else {
		    (void) strcpy(formatstr, "%");
		    argtype = msg[i];
		}

		if (argtype == USERSTRING) { /* string argument */
		    GetNextarg(AnErrorInstance, arg);
		    if (typeof(arg) == Kstring_argument) {
			if (arg.Vstring_argument->value == NULL)
			    (void) strcat(message, "<?>");
			else {
			    (void) strcat(formatstr, "s");
			    (void) sprintf(charstr, formatstr,
				    arg.Vstring_argument->value);
			    (void) strcat(message, charstr);
			}
		    }
		    else (void) strcat(message, "<?>");
		}
		else if (argtype == USERINT) { /* integer argument */
		    GetNextarg(AnErrorInstance, arg);
		    if (typeof(arg) == Kinteger_argument) {
			(void) strcat(formatstr, "d");
		        (void) sprintf(intstr, formatstr, arg.Vinteger_argument->value);
		        (void) strcat(message,intstr);
		    }
		    else (void) strcat(message, "<?>");
		}
		else {
		    (void) strcat(message, GetArgTypeValue(argtype, formatstr,
					    AnErrorInstance));
		}
		count = strlen(message) - 1;
	    }
	    else message[++count] = msg[i];
	}

	message[++count] = '\n';
	message[++count] = '\0';
	(void) strcpy(ret_message, message);
	return(ret_message);
}


String GetArgTypeValue(argtype, formatstr, AnErrorInstance)
char argtype;
char *formatstr;
ErrorInstance AnErrorInstance;
{
	static char argtypeval[80];

	TRACE1("GetArgTypeValue %c", argtype);
	switch (argtype) {
		case ABSLINE:
		    (void) strcat(formatstr, "d");
		    (void) sprintf(argtypeval, formatstr, linecount);
		    break;
		case EXCOL:
		    (void) strcat(formatstr, "d");
		    (void) sprintf(argtypeval, formatstr, lineoffset);
		    break;
		case ABSCOL:
		    (void) strcat(formatstr, "d");
		    (void) sprintf(argtypeval, formatstr, lineoffset);
		    break;
		case DATE:
		    (void) strcat(formatstr, "s");
		    (void) sprintf(argtypeval, formatstr, GetDate());
		    break;
		case ERRNO:
		    (void) strcat(formatstr, "d");
		    (void) sprintf(argtypeval, formatstr, AnErrorInstance->number);
		    break;
		case FILECREATEDATE:
		    (void) strcat(formatstr, "s");
		    (void) sprintf(argtypeval, formatstr, GetFileCreateDate());
		    break;
		case FILECREATETIME:
		    (void) strcat(formatstr, "s");
		    (void) sprintf(argtypeval, formatstr, GetFileCreateTime());
		    break;
		case MESSAGE:
		    (void) strcat(formatstr, "s");
		    (void) sprintf(argtypeval, formatstr,
			    GetMessage(AnErrorInstance->information->message, 
				       AnErrorInstance));
		    /* take out extra new line */
		    argtypeval[strlen(argtypeval)-1] = '\0';
		    break;
		case FILENAME:
		    (void) strcat(formatstr, "s");
		    (void) sprintf(argtypeval, formatstr, current_file);
		    break;
		case PAGENO:
		    (void) strcat(formatstr, "d");
		    (void) sprintf(argtypeval, formatstr, GetPageNumber());
		    break;
		case EXLINE:
		    (void) strcat(formatstr, "d");
		    (void) sprintf(argtypeval, formatstr, linecount);
		    break;
		case RELLINE:
		    (void) strcat(formatstr, "d");
		    (void) sprintf(argtypeval, formatstr, linecount);
		    break;
		case TIME:
		    (void) strcat(formatstr, "s");
		    (void) sprintf(argtypeval, formatstr, GetTime());
		    break;
		case VERSIONNO:
		    (void) strcat(formatstr, "s");
		    (void) sprintf(argtypeval, formatstr, GetVersionNumber());
		    break;
		case COUNTINLINE:
                    if (errorcount == 0) {
			(void) strcat(formatstr, "s");
			(void) sprintf(argtypeval, formatstr, "  ");
		    }
		    else  {
			(void) strcat(formatstr, "d");
		        (void) sprintf(argtypeval, formatstr, errorcount);
		    }
		    break;
		case COUNTINFILE:
		    (void) strcat(formatstr, "d");
		    (void) sprintf(argtypeval, formatstr, fileerrorcount);
		    break;
		case ERRORCOUNT:
		    (void) strcat(formatstr, "d");
		    (void) sprintf(argtypeval, formatstr, totalerrorcount);
		    break;
		default:
		    (void) strcpy(argtypeval, "<?>");
		    break;
	}
	TRACE1("GetArgTypeValue %s", argtypeval);
	return(argtypeval);
}


int GetErrLevel(AnErrorInstance)
ErrorInstance AnErrorInstance;
{
	int errlevel;

	TRACE("GetErrLevel");
	switch (typeof(AnErrorInstance->information->itype)) {
	    case Kfatal:
		errlevel = FATALLEVEL;
		break;
	    case Ksevere:
		errlevel = SEVERELEVEL;
		break;
	    case Krecoverable:
		errlevel = RECOVERABLELEVEL;
		break;
	    case Kwarning:
		errlevel = WARNINGLEVEL;
		break;
	    case Kextension:
		errlevel = EXTENSIONLEVEL;
		break;
	    case Kcomment:
		errlevel = COMMENTLEVEL;
		break;
	    default:
		ListerErr0("Invalid type in GetErrLevel\n");
		exit(2);
	}

	return(errlevel);
}

IncrementErrCount(AnErrorInstance)
ErrorInstance AnErrorInstance;
{

	TRACE("IncrementErrCount");
	switch (typeof(AnErrorInstance->information->itype)) {
	    case Kfatal:
		++numfatalerrors;
		++stderrnumfatalerrors;
		break;
	    case Ksevere:
	        ++numsevere_errors;
	        ++stderrnumsevere_errors;
		break;
	    case Krecoverable:
	        ++numrecoverable_errors;
	        ++stderrnumrecoverable_errors;
		break;
	    case Kwarning:
	       ++numwarnings;
	       ++stderrnumwarnings;
		break;
	    case Kextension:
	       ++numextensions;
	       ++stderrnumextensions;
		break;
	    case Kcomment:
	       ++numcomments;
	       ++stderrnumcomments;
		break;
	    default:
		ListerErr0("Invalid type in IncrementErrCount\n");
		exit(2);
	}
}

GetErrorInfo(AnErrorInstance)
ErrorInstance AnErrorInstance;
{
	SEQinfo Sinfo;
	info Aninfo;
	Boolean found;

	TRACE("GetErrorInfo");
	found = FALSE;
	/* find corresponding message in error list */
	foreachinSEQinfo(allerrorinfo->errinfo, Sinfo, Aninfo) {
	    if (Aninfo->number == AnErrorInstance->number){
		AnErrorInstance->information = Aninfo;
		found = TRUE;
		break;
	    }
	}
	if (!found) {  /* default level is warning */
	    AnErrorInstance->information = Ninfo;
	    AnErrorInstance->information->itype.Vwarning = Nwarning;
	    AnErrorInstance->information->number = AnErrorInstance->number;
	    AnErrorInstance->information->position.Vcharposition = Ncharposition;
	    AnErrorInstance->information->message = "\0";
	}
}

char *GetDate()
{
    long t;
    char *d;
    char *ctime();
    char day[10];
    char month[20];
    char thetime[10];
    char edt[10];
    int dayno;
    int year;
    static int init = 1;
    static char thedate[80];

    TRACE("GetDate");
    if (init) {
	init = 0;
	(void) time(&t);
	d = ctime(&t);
	(void) sscanf(d, "%s %s %d %s %s %s", day, month, &dayno, thetime,
            edt, &year);
	(void) sprintf(thedate, "%s %s %d, %d", day, month, dayno, year);
    }
    return(thedate);
}

char *GetTime()
{
    long t;
    char *d;
    char *ctime();
    char day[10];
    char month[20];
    int dayno;
    static char thetime[10];
    static int init = 1;


    TRACE("GetTime");
    if (init) {
	init = 0;
	(void) time(&t);
	d = ctime(&t);
	(void) sscanf(d, "%s %s %d %s", day, month, &dayno, thetime);
    }
    return(thetime);
}

char *GetFileCreateDate()
{
    TRACE("GetFileCreateDate");
    return("<file create date>");
}

char *GetFileCreateTime()
{
    TRACE("GetFileCreateTime");
    return("<file create time>");
}

