/***********************************************************************\ 
*									* 
*   File: scorpion/src/lister/add.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include "lister.h"
#include "macros.h"
#include "globals.h"

AddErrorInstance(fp, allfiles, allsourcefiles, Nosourcefile)
FILE *fp;
transitions allfiles;
SEQsourcefile *allsourcefiles;
sourcefile Nosourcefile;
{
	ErrorInstance AnErrorInstance;
	Boolean found;
	SEQsourcefile Ssourcefile;
	sourcefile Asourcefile;
	filetransition AFile;
	filetransition FindSourceFile();

	while (1) {
	    ReaderOK = TRUE;
	    AnErrorInstance=INinstances(fp);
	    if (!ReaderOK) break;

	    GetErrorInfo(AnErrorInstance);

	    found = FALSE;
	    if ((AnErrorInstance->number >= 0) &&
		(AnErrorInstance->source_position > 0) &&
		(typeof(AnErrorInstance->information->position)!=
						Kstderrposition)) {
		AFile = FindSourceFile(allfiles, AnErrorInstance);
		if (AFile) {
		    AnErrorInstance->filetransition = AFile;
		    foreachinSEQsourcefile(*allsourcefiles, Ssourcefile, 
				    Asourcefile)
			if (strequal(Asourcefile->name, AFile->filename)){
			    found = TRUE;
			    break;
			}
		    if (!found) {
			Asourcefile = Nsourcefile;
			Asourcefile->name = AFile->filename;
			appendrearSEQsourcefile(*allsourcefiles, Asourcefile);
		    }
		    appendrearSEQErrorInstance(Asourcefile->errors, 
			    AnErrorInstance);
		}
		else appendrearSEQErrorInstance(Nosourcefile->errors,
			AnErrorInstance);
	    }
	    else {
		appendrearSEQErrorInstance(Nosourcefile->errors,
			AnErrorInstance);
	    }
	}
}
