/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlwrite/main.c 
*				 					* 
*   Copyright (C) 1991 Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#include "idlwrite.h"
#include <stdio.h>

#ifndef lint
static char rcsid[] = "$Header$";
#endif

void exit();
void revision_number();
void usage();
void write_node();
void write_value();

int main(argc,argv)
int argc;
char ** argv;
{
	FILE * idl_data_file;
	nodeDesc current_node;
	int status;
	
	if (argc == 1) idl_data_file = stdin;
	else if (argc != 2) {
	    usage(argv[0]);
	    exit(1);
	}
	else if (!strcmp (argv[1],"-V")) {
	    revision_number(argv[0]);
            exit(0);
	}
	else {
	  idl_data_file = fopen(argv[1],"r");
	  if (NULL == idl_data_file) {
	    (void) fprintf(stderr,"%s: ERROR can't access idl data file %s\n",
		    argv[0], argv[1]);
	    exit(1);
	  }
	}

	current_node = read_tree(idl_data_file);
	(void) fclose(idl_data_file);

	status = IDLwrite(1, current_node); /* to stdout */

	return status;
}



void usage(name)
char *name;
{
 (void) fprintf(stderr,  "usage: %s [idl_reader_file]\n", name);
}


void revision_number(name)
char *name;
{
 char revision_str[20];

 (void)sscanf("$Revision: 5.0 $","%*s %s",revision_str);
 (void)printf("%s: IDL generic writer Version %s\n",name,revision_str);
 usage(name);
}
