/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/xidlview/xwdwP2.h 
*				 					* 
*   Copyright (C) 1991 Vijay Anand
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 


/*
 * Create an xidlview window 
 */

/*
 * INCLUDE FILES
 */

#include <stdio.h>
#include <varargs.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>

#include <X11/Xaw/Cardinals.h>

#include "test"

/* MACROS */
#define MENUITEMS		10
#define BUFSIZE			30
#define POLL_INTERVAL		10000
#define BITMAPDEPTH		1

/* EXTERNAL DECLARATIONS */
void destroy_dialog(), more_detail(), expand(), explain(), end_session();
void key_help();
Pixmap icon_pixmap;
/*
 * DATA STRUCTURES
 */


String fallback_resources[] = {
  "*input:				True",
  "*WMShell.iconPixmap:			icon_pixmap",
  "*pane_main.width:			450",
  "*viewport_main.showGrip:		False",
  "*viewport_main.allowVert:		True",
  "*viewport_main.height:		600",
  "*viewport_main.width:		450",
  "*vertical*thickness:			50",
  "*vertical*length:			400",
  "*Box*allowResize:			True",
  "*Box*showGrip:			False",
  "*text_main.height:			550",
  "*text_main.width: 			450",
  "*text_main*editType:			edit",
  "*text_main*displayCaret:		FALSE",
  "*text_main*autoFill:			on",
  "*text_main*scrollVertical:		always",
  "*text_main*scrollHorizontal:		always",
  "*Command*shapeStyle:			roundedRectangle",
  "*Command*highlightThickness:		2",
  "*endsess_main.label:			endses",
  "*port_main.label:			sel port",
  "*port_main.shapeStyle:		roundedRectangle",
  "*port_main.highlightThickness:	2",
  "*help_main.label:			help",
  "*cdlfil_main.label:			cdl file",
  "*expand_main.label:			expand",
  "*mordtl_main.label:			mor dtl",
  "*detach_main.label:			detach",
  "*explain_main.label:			explain",
  "*quit_main.label:			quit",
  "*allowShellResize:			True",
  "*pane_popup_help.internalBorderWidth:3",
  "*pane_popup_help*width:		400",
  "*label_popup_help*allowResize:	True",
  "*label_popup_help*label:		This is some help text.",
  "*label_popup_help*showGrip:		False",
  "*label_popup_help*resizeToPreferred: True",
  "*ok_popup_help*allowResize:		True",
  "*ok_popup_help.label:		OK",
  "*ok_popup_help*resizeToPreferred: True",
  "*dialog_popup_cdlfilsel.height:	50",
  "*dialog_popup_cdlfilsel.value:	candle file",
  "*dialog_popup_cdlfilsel.label:	Select Candle file",
  "*dialog_popup_cdlfilsel.value.translations:	\
			#override \\n <Key>Return: destroy_dialog()",
  "*dialog_popup_quit.label:		Quit xidlview?",
  "*status_chgactnam.shapeStyle:	roundedRectangle",
  "*status_chgactnam.cornerRoundPercent:50",
  "*ok_dsperrmsg.label:			OK",
  "*box_dsperrmsg.height:		400",
  "*box_dsperrmsg.width:		300",
  "*box_dsperrmsg.orientation:		vertical",
  "*box_dsperrmsg.vspace:		10",
  "*label_dsperrmsg*height:		350",
  "*label_dsperrmsg*width:		270",
  NULL,
};


static String text_translations = 
	"Shift<Btn2Down>:	end_session() \n\
	 Shift<Btn3Down>:	explain()     \n\
	 <Btn2Down>:		more_detail() \n\
	 <Btn3Down>:		expand()      \n\
	 <Btn2Up>:		no-op()       \n\
	 <Btn3Up>:		no-op()	      ";

static String help_translations = 
	"<Btn3Down>:		key_help()";

XtActionsRec actionTable[] = {
	{"destroy_dialog",	destroy_dialog},
	{"more_detail",		more_detail},
	{"expand",		expand},
	{"end_session",		end_session},
	{"explain",		explain},
	{"key_help",		key_help}
	};

struct scrposstc {
	int begpos, endpos;
	};
