/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/xidlview/xwdwP.h 
*				 					* 
*   Copyright (C) 1991 Vijay Anand
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef XWDWPDEF
#define XWDWPDEF
/*
 * Create an xidlview window 
 */

/*
 * INCLUDE FILES
 */
#include "global.h"
#include "xwdw.h"
#include "gbox.h"
#include "ipc.h"
#include "cdl1.h"
#include "help.h"

#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/StripChart.h>





#include "test"

/* MACROS */
#define PI                      3.14159
#define ARROWSIZE               7
#define FONT                    "6x10"
#define MENUITEMS		10
#define BUFSIZE			30
#define POLL_INTERVAL		1000
#define BITMAPDEPTH		1
#define MAXBOXARRAY             128
#define MAXNODNAMLNG            128
#define MAXSTRLNG              10000
#define MAXLABLNG               25
#define MAXLEN                 1024
#define VERSION                "idlview Version 5.0"

#define NEW                    1
#define CONT                   2
#define END                    3
/* EXTERNAL DECLARATIONS */
void destroy_dialog(), more_detail(), expand(), explain(), end_session();
void key_help(), more_detail_accel(), expand_accel(), sel_menu_label();
void call_redcdl(), read_command_line_options();
void display_help(), freeze_display(), destroy_freeze();
void append_freeze_list(), append_node_list();
void identify_display(), highlight_other_freeze();
void getmnucrspos();
void handle_main_instances(), handle_frozen_instances();
void select_instance(), print_display(), print_text_to_lpr();
void print_text_to_screen(), to_printer();
void destroy_popup(), set_insert_point();
void load_font(), get_GC(), init_graphics();
void redraw_graph(), goto_return(), version(), delete_freeze_list();
void set_idlbpid();

Pixmap icon_pixmap;
/*
 * DATA STRUCTURES
 */

typedef struct freeze_list {
  float id;
  Widget freeze_display;
  struct level_list **lst;
  struct freeze_list *next;
} *FREEZE_LIST;

typedef struct node_list {
  int box;
  int start;
  int end;
  float frozenwdw;
} NODE_LIST;


FREEZE_LIST freeze_head;

String fallback_resources[] = {
  "*input:                              True",
  "*WMShell.iconPixmap:                 icon_pixmap",
  "*pane_main.width:                    650",
  "*pane_freeze.width:                  650",
  "*pane_main_instances.width:          200",
  "*pane_popup_help.internalBorderWidth:3",
  "*pane_popup_help*width:              400",
  "*buttonpane_main_instances.width:    100",
  "*buttonpane_main_instances.height:   10000",
  "*buttonlabel_main_instances.label:    ",
  "*buttonbox_main_instances.showGrip:  False",
  "*viewport_main_instances.showGrip:   False",
  "*viewport_main.showGrip:             False",
  "*viewport_freeze.showGrip:           False",
  "*direction_freeze.showGrip:          False",
  "*direction_main.showGrip:            True",
  "*box_main.showGrip:                  True",
  "*status_box_main.showGrip:           False",
  "*viewport_main.allowVert:            True",
  "*viewport_main.allowHoriz:           True",
  "*viewport_main.height:               600",
  "*viewport_main.width:                650",
  "*viewport_main.forceBars:            True",
  "*viewport_main.vertical.thickness:   15",
  "*viewport_main.horizontal.thickness: 15",
  "*viewport_main.useBottom:            True",
  "*viewport_freeze.showGrip:           False",
  "*viewport_freeze.allowVert:          True",
  "*viewport_freeze.allowHoriz:         True",
  "*viewport_freeze.height:             600",
  "*viewport_freeze.width:              650",
  "*viewport_freeze.forceBars:          True",
  "*viewport_freeze.vertical*length:    400",
  "*viewport_freeze.horizontal*thickness: 15",
  "*viewport_freeze.vertical*thickness: 15",
  "*viewport_freeze.useBottom:          True",
  "*viewport_main.vertical*thickness:   15",
  "*viewport_main.vertical*length:      400",
  "*viewport_main_instances.width:      100",
  "*viewport_main_instances.height:     100",
  "*viewport_main_instances.allowVert:  True",
  "*viewport_main_instances.forceBars:  True",
  "*viewport_main_instances.vertical.thickness:   10",
  "*viewport_freeze_instances.showGrip: True",
  "*Viewport*allowResize:               True",
  "*Box*allowResize:                    True",
  "*text_main.height:                   550",
  "*text_main.width:                    650",
  "*text_main*editType:                 edit",
  "*text_main*displayCaret:             FALSE",
  "*text_main*autoFill:                 on",
  "*text_main*scrollVertical:           always",
  "*text_main*scrollHorizontal:         always",
  "*text_main*vertical.background:      white",
  "*text_main*scrollbar.background:     white",
  "*graphics_main.height:               550000",
  "*graphics_main.width:                450000",
  "*graphics_freeze.height:             550000",
  "*graphics_freeze.width:              450000",
  "*graphics_main.jumpScroll:           1",
  "*down_main.label:                    Down",
  "*right_main.label:                   Right",
  "*left_main.label:                    Left",
  "*up_main.label:                      Up",
  "*text_freeze.height:                 550",
  "*text_freeze.width:                  650",
  "*text_freeze*editType:               read",
  "*text_freeze*displayCaret:           FALSE",
  "*text_freeze*autoFill:               on",
  "*text_freeze*scrollVertical:         never",
  "*text_freeze*scrollHorizontal:       never",
  "*Command*shapeStyle:                 roundedRectangle",
  "*Command*highlightThickness:         2",
  "*endsess_main.label:                 End Session",
  "*port_main.label:                    Select Port",
  "*port_main.shapeStyle:               roundedRectangle",
  "*port_main.highlightThickness:       2",
  "*help_main.label:                    Help",
  "*cdlfil_main.label:                  Candle File",
  "*expand_main.label:                  Expand",
  "*mordtl_main.label:                  More Detail",
  "*version_main.label:                 Version",
  "*detach_main.label:                  Detach",
  "*goto_main.label:                    Goto",
  "*explain_main.label:                 Explain",
  "*print_main.label:                   Print",  
  "*quit_main.label:                    Quit",
  "*freeze_main.label:                  Freeze",
  "*identify_main.label:                Identify",
  "*change_mode_main.label:             Change Display",
  "*identify_freeze.label:              Identify",
  "*help_freeze.label:                  Help",
  "*global_layout_main.label:           Global Layout",
  "*quit_freeze.label:                  Quit",
  "*lpr_print_display.label:            Printer",
  "*screen_print_display.label:         Screen",
  "*quit_print_display.label:           Quit",
  "*quit_main_instances.label:          Quit",
  "*refresh_main.label:                 Refresh",
  "*allowShellResize:                   True",
  "*ok_popup_help*allowResize:          True",
  "*label_popup_help*allowResize:       True",
  "*label_popup_help*label:             No help for this item.",
  "*label_popup_help*showGrip:          False",
  "*label_popup_help*resizeToPreferred: True",
  "*label_main_instances*allowResize:   True",
  "*label_main_instances*label:         Identify an instance",
  "*label_main_instances*showGrip:      False",
  "*label_main_instances*resizeToPreferred: True",
  "*ok_popup_help.label:                OK",
  "*ok_popup_help*resizeToPreferred:    True",

  "*dialog_popup_cdlfilsel.height:      50",
  "*dialog_popup_cdlfilsel.value:       File.Cdl",
  "*dialog_popup_cdlfilsel.label:       Select Candle file",
  "*dialog_popup_cdlfilsel.value.translations:  \
                       #override \\n <Key>Return: call_redcdl() destroy_dialog()",

  "*dialog_explain.height:      50",
  "*dialog_explain.value:       0",
  "*dialog_explain.label:       Specify idlbrowse PID",

  "*dialog_popup_quit.label:            Quit xidlview?",
  "*dialog_print_file_to_lpr.label:     Which Printer?",
  "*dialog_popup_freeze_quit.label:     Kill Frozen Window?",
  "*status_chgactnam.shapeStyle:        roundedRectangle",
  "*status_chgactnam.cornerRoundPercent:50",
  "*ok_dsperrmsg.label:                 OK",
  "*ok_version.label:                   OK",
  "*box_dsperrmsg.height:               400",
  "*box_dsperrmsg.width:                300",
  "*box_dsperrmsg.orientation:          vertical",
  "*box_dsperrmsg.vspace:               10",
  "*label_dsperrmsg*height:             350",
  "*label_dsperrmsg*width:              270",
  NULL,

};


static XrmOptionDescRec opTable[] = {
  {"-C", ".candle", XrmoptionSepArg, (caddr_t) NULL}
};

static String text_translations = 
	"Shift<Btn2Down>:	end_session() \n\
	 Shift<Btn3Down>:	explain()     \n\
	 <Btn2Down>:		select-start() more_detail_accel() \n\
	 <Btn3Down>:		select-start() expand_accel() \n\
	 <Btn2Up>:		no-op()       \n\
	 <Btn3Up>:		no-op()	      ";

static String help_translations = 
	"<Btn3Down>:		key_help()";

XtActionsRec actionTable[] = {
	{"destroy_dialog",	destroy_dialog},
	{"call_redcdl",         call_redcdl},
	{"more_detail",		more_detail},
	{"freeze_display",      freeze_display},
	{"destroy_freeze",      destroy_freeze},
	{"identify_display",    identify_display},
	{"expand",		expand},
	{"end_session",		end_session},
	{"explain",		explain},
	{"key_help",		key_help},
	{"expand_accel",        expand_accel},
	{"more_detail_accel",   more_detail_accel},
	{"select_instance",     select_instance},
	{"set_idlbpid",         set_idlbpid}
	};

#endif


