/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/xidlview/xwdw2.h 
*				 					* 
*   Copyright (C) 1991 Vijay Anand
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/*
 * Create an xidlview window 
 */
#include "xwdwP2.h"
#ifdef mips
int strlen();
#endif


/* XWDW GLOBAL VARIABLES */
  Widget idlview_main, pane_main, viewport_main, text_main, box_main;
  Widget status_box_main, port_main;
  static XtInputId input_id;

void main(argc,argv) /* this main function would be called iniivwwdw() when
			interfacing with idlview */
int argc;
char **argv;
{
  Widget endsess_main, help_main, cdlfil_main, quit_main;
  Widget expand_main, mordtl_main, detach_main, explain_main, status_main;
  XtAppContext app_con;
  Arg arg[1];

  void reset_wdw(), popup_help(), popup_cdlfilsel(), popup_quit();
  void set_widget_label(), polling_socket(), chgactnam(), reset_xidlview();
  void test_dsperrmsg(), explain(), more_detail(), expand(), end_session();
  void read_icon_bitmap();

  idlview_main  = XtAppInitialize(&app_con, "Xidlview", NULL, ZERO, 
			&argc, argv, fallback_resources, NULL, ZERO);

  XtAppAddActions(app_con, actionTable, XtNumber(actionTable));
/*  read_icon_bitmap();  */

  pane_main     = XtCreateManagedWidget("pane_main", panedWidgetClass, 
			idlview_main, NULL, ZERO);
  viewport_main = XtCreateManagedWidget("viewport_main",viewportWidgetClass, 
			pane_main, NULL, ZERO);
  text_main     = XtCreateManagedWidget("text_main",asciiTextWidgetClass, 
			viewport_main, NULL, ZERO);
  box_main      = XtCreateManagedWidget("box_main",boxWidgetClass, pane_main, 
			NULL, ZERO);
  status_box_main= XtCreateManagedWidget("stautus_box_main",boxWidgetClass, 
			pane_main, NULL, ZERO);
  endsess_main  = XtCreateManagedWidget("endsess_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  port_main     = XtCreateManagedWidget("port_main",menuButtonWidgetClass, 
			box_main, NULL, ZERO);
  help_main     = XtCreateManagedWidget("help_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  cdlfil_main   = XtCreateManagedWidget("cdlfil_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  expand_main   = XtCreateManagedWidget("expand_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  mordtl_main   = XtCreateManagedWidget("mordtl_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  detach_main   = XtCreateManagedWidget("detach_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  explain_main  = XtCreateManagedWidget("explain_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  quit_main     = XtCreateManagedWidget("quit_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  
  reset_wdw(); /* function to reset window */
  XtOverrideTranslations(text_main, 
		XtParseTranslationTable(text_translations)); 
  XtOverrideTranslations(box_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(status_box_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(endsess_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(port_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(help_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(cdlfil_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(expand_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(mordtl_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(detach_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(explain_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(quit_main, 
		XtParseTranslationTable(help_translations)); 


  /* Callback functions */
  XtAddCallback(help_main, XtNcallback, popup_help, NULL);
  XtAddCallback(cdlfil_main, XtNcallback, popup_cdlfilsel, NULL);
  XtAddCallback(quit_main, XtNcallback, popup_quit, NULL);
  XtAddCallback(detach_main, XtNcallback, reset_xidlview, NULL);
  XtAddCallback(explain_main, XtNcallback, explain, NULL);
  XtAddCallback(expand_main, XtNcallback, expand, NULL);
  XtAddCallback(mordtl_main, XtNcallback, more_detail, NULL);
  XtAddCallback(endsess_main, XtNcallback, end_session, NULL);
  /* this is a test callback*/

  chgactnam("Unconnected");
  XtAppAddTimeOut(app_con, POLL_INTERVAL, polling_socket, (XtPointer)app_con); 
  
  /* realize widgets */
  XtRealizeWidget(idlview_main);
  XtAppMainLoop(app_con);

}


void setprtmnu()
{
  /* Port prtlist[MAXPORT]; */
  int prtnum;
  static Widget menu_setprtmnu, menu_item_setprtmnu;
  int i;
  char buf[BUFSIZE];
  char * bufptr;
  void sel_menu_label();

  bufptr = &buf[0];
  if(menu_setprtmnu != NULL) XtDestroyWidget(menu_setprtmnu);
  if(menu_item_setprtmnu != NULL) XtDestroyWidget(menu_item_setprtmnu);
  menu_setprtmnu = XtCreatePopupShell("menu", simpleMenuWidgetClass, 
			port_main, NULL, ZERO);
  /* setprtmnucdl(prtlist, &prtnum); */
  for(i = 0; i < MENUITEMS/* this should be prtnum */; i++)
  {  
     /* if(prtlist[i]->lex_name != NULL)
     { */
     sprintf(buf, "menuEntry%d",i+1);
     menu_item_setprtmnu = XtCreateManagedWidget(buf, smeBSBObjectClass, 
			menu_setprtmnu, NULL, ZERO);
     XtAddCallback(menu_item_setprtmnu, XtNcallback, sel_menu_label, NULL/* prtlist[i] */);
     /* } */
  }


}

void popup_help(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  Arg		args[5];
  Widget	popup_popup_help, label_popup_help, pane_popup_help;
  Widget	ok_popup_help;
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;
  void destroy_popup();

  n = 0;
  XtSetArg(args[0], XtNwidth, &width);   n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 , (Position) height/2 -500,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_popup_help = XtCreatePopupShell("popup_popup_help", 
			transientShellWidgetClass, button, args, n);
  pane_popup_help  = XtCreateManagedWidget("pane_popup_help", 
			panedWidgetClass, popup_popup_help, NULL, ZERO);
  label_popup_help = XtCreateManagedWidget("label_popup_help", 
			labelWidgetClass, pane_popup_help, NULL, ZERO);
  ok_popup_help    = XtCreateManagedWidget("ok_popup_help", 
			commandWidgetClass, pane_popup_help, NULL, ZERO);
  XtAddCallback(ok_popup_help, XtNcallback, destroy_popup, 
			popup_popup_help);
  XawPanedSetMinMax(label_popup_help, 500, 500);
  XawPanedSetMinMax(ok_popup_help, 20, 20);
  XtPopupSpringLoaded(popup_popup_help/*, XtGrabNone*/);
}
  
 

void popup_cdlfilsel(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  Arg		args[5];
  Widget	popup_popup_cdlfilsel, dialog_popup_cdlfilsel;
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;
  void destroy_popup();

  n = 0;
  XtSetArg(args[0], XtNwidth, &width);   n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 , (Position) height/2 -100,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_popup_cdlfilsel = XtCreatePopupShell("popup_popup_cdlfilsel", 
			transientShellWidgetClass, button, args, n);
  dialog_popup_cdlfilsel = XtCreateManagedWidget("dialog_popup_cdlfilsel",
			dialogWidgetClass, popup_popup_cdlfilsel,
			NULL, ZERO);
  XawDialogAddButton(dialog_popup_cdlfilsel, "ok", destroy_popup, 
			popup_popup_cdlfilsel);
  XawDialogAddButton(dialog_popup_cdlfilsel, "cancel", destroy_popup, 
			popup_popup_cdlfilsel);
  XtPopupSpringLoaded(popup_popup_cdlfilsel/* , XtGrabNone */);
}

void popup_quit(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  Arg		args[5];
  Widget	popup_popup_quit, dialog_popup_quit;
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;
  void 		destroy_popup(), destroy_xidlview();

  n = 0;
  XtSetArg(args[0], XtNwidth, &width);   n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 , (Position) height/2 ,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_popup_quit = XtCreatePopupShell("popup_popup_quit", 
			transientShellWidgetClass, button, args, n);
  dialog_popup_quit = XtCreateManagedWidget("dialog_popup_quit",
			dialogWidgetClass, popup_popup_quit,
			NULL, ZERO);
  XawDialogAddButton(dialog_popup_quit, "ok", destroy_xidlview, 
			dialog_popup_quit);
  XawDialogAddButton(dialog_popup_quit, "cancel", destroy_popup, 
			popup_popup_quit);
  XtPopup(popup_popup_quit, XtGrabNone);
}


void destroy_popup(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
  Widget popup_destroy_popup;
  popup_destroy_popup  = (Widget) client_data;
  XtPopdown(popup_destroy_popup);
  XtDestroyWidget(popup_destroy_popup);
}

void destroy_dialog(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;
{
  Widget dialog_destroy_dialog = XtParent(XtParent(widget));
  XtDestroyWidget(dialog_destroy_dialog);
}

void destroy_xidlview(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
  /* if cmmmod is true call up endses() here */
  /* if(cmmmod == TRUE) endses(); */
  XtDestroyApplicationContext(XtWidgetToApplicationContext(widget));
  exit(0);
}

void chgactnam(label)
char *label;
{
  Arg arg[1];
  static Widget status_chgactnam;

  if(status_chgactnam == NULL) {
    status_chgactnam = XtCreateManagedWidget("status_main",labelWidgetClass, 
			status_box_main, NULL, ZERO);
  }
  XtSetArg(arg[0], XtNlabel, label);
  XtSetValues(status_chgactnam, arg, ONE);
}
  
void sel_menu_label(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
  void chgprtnam();

 /* dflprt = (Port) client_data;   
   if (dflprt == IVWNUL) chgprtnam(IVWNUL);
   else chgprtnam(dflprt->lex_name); */
 chgprtnam(XtName(widget));
}

void chgprtnam(port_name)
char *port_name;
{
  Arg arg[1];
  char *menu_name = "sel port";
  
  if(port_name == NULL)
    XtSetArg(arg[0], XtNlabel, menu_name);
  else
    XtSetArg(arg[0], XtNlabel, port_name);
  XtSetValues(port_main, arg, ONE);

}
void polling_socket(client_data, id) /* this is actually chknewsckcnn_notifier */
XtPointer client_data;
XtIntervalId id;
{

  /* call chknewsckcnn here */
  /* if(unncnn == IVWFLS) 		connection established
  	return;
  */
  XtAppAddTimeOut((XtAppContext)client_data, POLL_INTERVAL, polling_socket, 
			client_data);
  printf("Checking for socket connection...\n");
  chgactnam("Inactive");

}

void reset_wdw()
{
  Arg args[1];
  static XawTextSelectType sarray[] = {
					XawselectLine,
					XawselectNull,
				};

  XtSetArg(args[0], XtNstring, "");
  XtSetValues(text_main, args, ONE);
  XawTextSetSelectionArray(text_main, sarray);
  setprtmnu();
  chgprtnam(NULL);
}

void reset_xidlview(widget, closure, callData)
Widget widget;
XtPointer closure,callData;
{
  reset_wdw();
  /* some more stuff like resetting socket connections will 
     come here 
  */
}


void setbegdsppos(scrpos)
struct scrposstc *scrpos;
{
  scrpos->begpos = (int) XawTextGetInsertionPoint(text_main);
}

void setenddsppos(scrpos)
struct scrposstc *scrpos;
{
  scrpos->endpos = (int) XawTextGetInsertionPoint(text_main);
  (scrpos->endpos--);
}

void setdspposend()
{
  Arg args[1];

 XtCallActionProc(text_main, "end-of-file",NULL, NULL, ZERO);

}

/*

int appstrlin(scrpos, str, inspnt)
struct scrposstc scrpos;
char *str;
int *inspnt;
{
  Arg args[1];
  XawTextBlock text;

  XawTextSetInsertionPoint(text_main, (XawTextPosition) scrpos.endpos);
  (*inspnt) = scrpos.endpos;

  text.firstPos = 0;
  text.length = strlen(str);
  text.ptr = str;
  text.format = FMT8BIT;
  XtSetArg(args[0], XtNeditType, XawtextEdit);
  XtSetValues(text_main, args, ONE);
  XawTextReplace(text_main, (XawTextPosition) scrpos.endpos, 
			    (XawTextPosition) scrpos.endpos, &text);
  XtSetArg(args[0], XtNeditType, XawtextRead);
  XtSetValues(text_main, args, ONE);
  return strlen(str);
}

int dspstr(str)
char *str;
{
  XawTextBlock text;

  text.firstPos = 0;
  text.length = strlen(str);
  text.ptr = str;
  text.format = FMT8BIT;

  XtSetArg(args[0], XtNeditType, XawtextEdit);
  XtSetValues(text_main, args, ONE);
  XawTextReplace(text_main, XawTextGetInsertionPoint(text_main),
                            XawTextGetInsertionPoint(text_main), &text);
  XtSetArg(args[0], XtNeditType, XawtextRead);
  XtSetValues(text_main, args, ONE);
}

void clrscrpos(scrposptr)
struct scrposstc *scrposptr;
{ scrposptr->begpos = -1;
  scrposptr->endpos = -1;
}


void fndboxdtlpos(boxscrpos, dtlpos)
  struct scrposstc boxscrpos;
  struct scrposstc *dtlpos;
{
   XawTextBlock text;
   XawTextPosition beg, curpos;
   char *str = "\n";

   beg = boxscrpos.begpos;
   text.firstPos = 0;
   text.length = strlen("\n");
   text.ptr = str;
   text.format = FMT8BIT; 

   curpos = XawTextGetInsertionPoint(text_main);
   XawTextSetInsertionPoint(text_main, (XawTextPosition)beg);
   beg = XawTextSearch(text_main, XawsdRight, &text);
   XawTextSetInsertionPoint(text_main, curpos);
   dtlpos->begpos = beg;
   dtlpos->endpos = beg;
}

*/

void dsperrmsg(va_alist)
va_dcl
{
 
  Arg args[2], arg[1];
  va_list curarg;
  char *str, *items;
  int count, n;
  Dimension height, width;
  Position x, y;
  Widget popup_dsperrmsg, box_dsperrmsg, label_dsperrmsg, ok_dsperrmsg;
  void destroy_label();

  n=0;
  XtSetArg(args[0], XtNwidth, &width); n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(text_main, args, n);
  XtTranslateCoords(text_main, (Position) width/2, (Position) height/2,
			&x, &y);
  n=0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_dsperrmsg = XtCreatePopupShell("popup_dsperrmsg",
			transientShellWidgetClass, idlview_main, args, n);
  box_dsperrmsg = XtCreateManagedWidget("box_dsperrmsg", boxWidgetClass,
			popup_dsperrmsg, NULL,ZERO);
  label_dsperrmsg = XtCreateManagedWidget("label_dsperrmsg", labelWidgetClass,
			box_dsperrmsg, NULL, ZERO);
  ok_dsperrmsg = XtCreateManagedWidget("ok_dsperrmsg", commandWidgetClass,
			box_dsperrmsg, NULL, ZERO);
  XtAddCallback(ok_dsperrmsg, XtNcallback, destroy_popup, popup_dsperrmsg);
  XtAddCallback(ok_dsperrmsg, XtNcallback, destroy_label, items);
  
  count = 0;
  va_start(curarg);
  str = va_arg(curarg, char*);
  while(str != 0)
  {
    count += strlen(str)+1;
    str = va_arg(curarg, char*);
  }
  va_end(curarg);
  if((items = (char *)calloc(count+1,sizeof(char))) == NULL)
	exit(1);
  va_start(curarg);
  items[0] = '\0';
  str = va_arg(curarg, char*);
  while(str != 0)
  {
    strcat(items, str);
    strcat(items,"\n");
    str = va_arg(curarg, char*);
  }
  va_end(curarg);
  XtSetArg(arg[0], XtNlabel, items);
  XtSetValues(label_dsperrmsg, arg, ONE);
  XtPopupSpringLoaded(popup_dsperrmsg);

}


void destroy_label(widget, closure, callData)
Widget widget;
XtPointer closure, callData;
{
  String items = (String )closure;

  free(items);
}

void test_dsperrmsg(widget, closure, callData)
Widget widget;
XtPointer closure, callData;
{
  dsperrmsg("This is just a test of the error display function,",
	    " and also the list widget. So kindly ignore this",
	    " although you might be seeing a lot of this soon.",
	    0);
}


void explain(widget, closure, callData)
Widget widget;
XtPointer closure, callData;
{
  printf("Explaining...\n");
/*
  struct scrposstc crspos;
  boxhnd	   box;
  bathnd	   bat;
  int		   batpos;

  if(cmmmod != TRUE) {
	dsperrmsg("Not in xidlview session",
		  "You must enter xidlview from dbx",
		  0);
  	return;
  }
  getmnucrspos( &crspos);
  fnscrsobj(crspos, &box, &bat, &batpos);
  dspsrcopt(box, bat, batpos);
*/
}

void expand(widget, closure, callData)
Widget widget;
XtPointer closure, callData;
{
  printf("Expanding...\n");
/*
  struct scrposstc crspos;
  boxhnd	   box;
  bathnd	   bat;
  int		   batpos;

  if(cmmmod != TRUE) {
	dsperrmsg("Not in xidlview session",
		  "You must enter xidlview from dbx",
		  0);
	return;
  }
  getmnucrspos(&crspos);
  fnscrsobj(crspos, &box, &bat, &batpos);
  expattopt(box, bat);
  
*/
}

void more_detail(widget, closure, callData)
Widget widget;
XtPointer closure, callData;
{
  printf("More detail...\n");
/*
  struct scrposstc crspos;
  boxhnd	   box;
  bathnd	   bat;
  int		   batpos;

  if(cmmmod != TRUE) {
	dsperrmsg("Not in xidlview session",
		  "You must enter xidlview from dbx",
		  0);
	return;
  }
  getmnucrspos(&crspos);
  fnscrsobj(crspos, &box, &bat, &batpos);
  mordtlopt(box, bat);
*/
}

void end_session(widget, closure, callData)
Widget widget;
XtPointer closure, callData;
{
  printf("Ending session...\n");
/*

  if(cmmmod == FALSE)
     dsperrmsg("Nor in xidlview session",
	       "Use this option to end xidlview session",
		0);
  else endses();

*/
}

void getmnucrspos(pos)
struct scrposstc *pos;
{
  XawTextPosition *begin_return, *end_return;

/* even though i can get the whole selection (line) in one shot I am using only
the positions of the selections because i can interface this easily with the idlview code.
I will think about optimizations later on.
*/
  XawTextGetSelectionPos(text_main, begin_return, end_return);
  printf("begin position %d\n",*begin_return);
  if(*begin_return == *end_return) return;
  pos->begpos = *begin_return;
  pos->endpos = *begin_return;
  
}

void set_input_notifier(inphnd, input_event_handler, ivwdsc)
int *inphnd;
void (*input_event_handler)();
int ivwdsc;
{
  /* input_id is the id returned from the XtAppAddInput call */
  input_id = XtAppAddInput(XtWidgetToApplicationContext(idlview_main),
			   ivwdsc,
			   XtInputReadMask,
			   input_event_handler,
			   NULL);
  return;
}


/* Try to move this guy to ipc module because he really belongs there with all the msg stuff .
   may encounter problems in coercing the parameter pointers . */
int dbxred_notifier(closure , ivwdsc, id)
XtPointer closure;
int *ivwdsc;
XtInputId *id;
{
  printf("in dbxred_notifier...\n");
/*
  ivwmsghdr msghdr;
  ptr       blk;

  dbxred(msghdr, blk);
*/
  return;
}

void destroy_input_notifier(inphnd, ivwdsc)
int *inphnd, ivwdsc;
{
  /* input_id is the id returned from the XtAppAddInput call */
  XtRemoveInput(input_id);
  return;
}


void key_help(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;
{
  Arg		args[5];
  Widget	popup_popup_help, label_popup_help, pane_popup_help;
  Widget	ok_popup_help;
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;
  void destroy_popup();

  n = 0;
  XtSetArg(args[0], XtNwidth, &width);   n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(widget, args, n);
  XtTranslateCoords(widget, (Position) width/2 , (Position) height/2 -500,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_popup_help = XtCreatePopupShell("popup_popup_help", 
			transientShellWidgetClass, widget, args, n);
  pane_popup_help  = XtCreateManagedWidget("pane_popup_help", 
			panedWidgetClass, popup_popup_help, NULL, ZERO);
  label_popup_help = XtCreateManagedWidget("label_popup_help", 
			labelWidgetClass, pane_popup_help, NULL, ZERO);
  ok_popup_help    = XtCreateManagedWidget("ok_popup_help", 
			commandWidgetClass, pane_popup_help, NULL, ZERO);
  XtAddCallback(ok_popup_help, XtNcallback, destroy_popup, 
			popup_popup_help);
  /* Depending upon where the mouse cursor is(can be obtained from widget), 
     we have to display the corresponding help text */
  XawPanedSetMinMax(label_popup_help, 500, 500);
  XawPanedSetMinMax(ok_popup_help, 20, 20);
  XtPopupSpringLoaded(popup_popup_help/*, XtGrabNone*/);
  printf("Help from the mouse button...\n");
  
}


int updskrbar()
{
 /* function exists for compatibility with sunidlview */
 return;
}


void read_icon_bitmap()
{

  Display *display;
  int argc=0;
  char **argv=NULL;
  Window win;
  char *icon_name = "xidlview";
  char *window_name = "xidlview";
  XSizeHints size_hints;

  display = XtDisplay(idlview_main);
  win = XtWindow(idlview_main);
  icon_pixmap = XCreateBitmapFromData(display,
				      win,
				      icon_bitmap_bits,
                		      icon_bitmap_width,
				      icon_bitmap_height);
  XSetStandardProperties(display,
			 win,
			 window_name,
			 icon_name,
			 icon_pixmap,
                	 argv,argc,
			 &size_hints);

}
  
