/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/xidlview/xwdw.c
*				 					* 
*   Copyright (C) 1991 Vijay Anand
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/*
 * Module: xwdw.c
 *
 * Function : This module has all the code of my window package.
 *            Includes creating windows, and all other manipulations
 *            with windows.
 */

#include "xwdwP.h"
#ifdef mips
int strlen();
#endif

/* XWDW GLOBAL VARIABLES */
  Widget idlview_main, pane_main, viewport_main, text_main, box_main;
  Widget status_box_main, port_main, status_chgactnam, popup_freeze;
  Widget endsess_main, help_main, cdlfil_main, quit_main, freeze_main;
  Widget expand_main, mordtl_main, detach_main, explain_main, status_main;
  Widget identify_main, print_main, dialog_print_text_to_lpr, refresh_main;
  Widget serverid_main, display_mode_main, change_mode_main, graphics_main; 
  Widget goto_main, version_main, vscroll_main, hscroll_main, down_main;
  Widget right_main, up_main, left_main, global_layout_main, direction_main;

  static XtInputId input_id;
  XrmDatabase commanddb;
  NODE_LIST box_array[MAXBOXARRAY];
  int box_array_size, serverid;
  static int session_start_point;
  static char printer_name[BUFSIZE];
  static char cumul_str[MAXSTRLNG];
  static int text_offset;
  Display *display;
  GC gc, gcarrow;
  XFontStruct *font_info;
  float vthumb_pos, hthumb_pos;
  extern int currentx, currenty;

void iniivwwdw() /* this main function would be called iniivwwdw() when
			interfacing with idlview */
{
  XtAppContext app_con;
  Arg arg[5];
  char serverid_label[MAXLABLNG];
  Cardinal n;

  void reset_wdw(), popup_help(), popup_cdlfilsel(), popup_quit();
  void set_widget_label(), polling_socket(), chgactnam(), reset_xidlview();
  void test_dsperrmsg(), explain(), more_detail(), expand(), end_session();
  void read_icon_bitmap(), change_display(), redraw_graph(), graphics_scrollbar();
  void gvjump(), ghjump(), refresh_display(), goto_return(), down(), right();
  void left(), up(), global_layout();

  idlview_main  = XtAppInitialize(&app_con, "Xidlview", NULL, ZERO, 
			&argcount, argstring, fallback_resources, NULL, ZERO);


  XtAppAddActions(app_con, actionTable, XtNumber(actionTable));
  pane_main     = XtCreateManagedWidget("pane_main", panedWidgetClass, 
			idlview_main, NULL, ZERO);
  viewport_main = XtCreateManagedWidget("viewport_main",viewportWidgetClass, 
			pane_main, NULL, ZERO);
  text_main     = XtCreateManagedWidget("text_main",asciiTextWidgetClass, 
			viewport_main, NULL, ZERO);
  graphics_main = XtCreateManagedWidget("graphics_main",stripChartWidgetClass, 
			viewport_main, NULL, ZERO);
  direction_main= XtCreateManagedWidget("direction_main",boxWidgetClass, pane_main, 
			NULL, ZERO);
  box_main      = XtCreateManagedWidget("box_main",boxWidgetClass, pane_main, 
			NULL, ZERO);
  status_box_main= XtCreateManagedWidget("status_box_main",boxWidgetClass, 
			pane_main, NULL, ZERO);
  help_main     = XtCreateManagedWidget("help_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  expand_main   = XtCreateManagedWidget("expand_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  mordtl_main   = XtCreateManagedWidget("mordtl_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  port_main     = XtCreateManagedWidget("port_main",menuButtonWidgetClass, 
			box_main, NULL, ZERO);
  cdlfil_main   = XtCreateManagedWidget("cdlfil_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  freeze_main   = XtCreateManagedWidget("freeze_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  identify_main   = XtCreateManagedWidget("identify_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  detach_main   = XtCreateManagedWidget("detach_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  explain_main  = XtCreateManagedWidget("explain_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  print_main    = XtCreateManagedWidget("print_main", commandWidgetClass,
					box_main, NULL, ZERO);
  goto_main    = XtCreateManagedWidget("goto_main", commandWidgetClass,
					box_main, NULL, ZERO); 
  change_mode_main = XtCreateManagedWidget("change_mode_main", commandWidgetClass,
				       box_main, NULL, ZERO);

  refresh_main = XtCreateManagedWidget("refresh_main", commandWidgetClass,
				       box_main, NULL, ZERO);
  global_layout_main = XtCreateManagedWidget("global_layout_main", commandWidgetClass,
				       box_main, NULL, ZERO);

  endsess_main  = XtCreateManagedWidget("endsess_main",commandWidgetClass, 
			direction_main, NULL, ZERO);
  left_main = XtCreateManagedWidget("left_main", commandWidgetClass,
				       direction_main, NULL, ZERO);
  down_main = XtCreateManagedWidget("down_main", commandWidgetClass,
				       direction_main, NULL, ZERO);
  up_main = XtCreateManagedWidget("up_main", commandWidgetClass,
				       direction_main, NULL, ZERO);
  right_main = XtCreateManagedWidget("right_main", commandWidgetClass,
				       direction_main, NULL, ZERO);

  version_main = XtCreateManagedWidget("version_main", commandWidgetClass,
				       box_main, NULL, ZERO);
  quit_main     = XtCreateManagedWidget("quit_main",commandWidgetClass, 
			box_main, NULL, ZERO);
  serverid_main = XtCreateManagedWidget("serverid_main",labelWidgetClass, 
			status_box_main, NULL, ZERO);
  display_mode_main = XtCreateManagedWidget("display_mode_main",labelWidgetClass, 
			status_box_main, NULL, ZERO);

  sprintf(serverid_label, "Main Window: %d", sck_prt-SERV_PORT+1);

  XtSetArg(arg[0], XtNlabel, serverid_label);
  XtSetValues(serverid_main, arg, ONE);
  serverid = sck_prt-SERV_PORT+1;

  display_mode = TEXT;
  strcpy(serverid_label, "Text Display");
  XtSetArg(arg[0], XtNlabel, serverid_label);
  XtSetValues(display_mode_main, arg, ONE);


  XtOverrideTranslations(text_main, 
		XtParseTranslationTable(text_translations)); 
  XtOverrideTranslations(box_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(status_box_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(endsess_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(port_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(help_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(cdlfil_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(expand_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(mordtl_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(freeze_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(identify_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(detach_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(explain_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(print_main, 
		XtParseTranslationTable(help_translations)); 
  XtOverrideTranslations(quit_main, 
		XtParseTranslationTable(help_translations));
  XtOverrideTranslations(change_mode_main, 
		XtParseTranslationTable(help_translations));
  XtOverrideTranslations(refresh_main, 
		XtParseTranslationTable(help_translations));
  XtOverrideTranslations(global_layout_main, 
		XtParseTranslationTable(help_translations));
  XtOverrideTranslations(goto_main, 
		XtParseTranslationTable(help_translations));
  XtOverrideTranslations(version_main, 
		XtParseTranslationTable(help_translations));
  XtOverrideTranslations(up_main, 
		XtParseTranslationTable(help_translations));
  XtOverrideTranslations(down_main, 
		XtParseTranslationTable(help_translations));
  XtOverrideTranslations(left_main, 
		XtParseTranslationTable(help_translations));
  XtOverrideTranslations(right_main, 
		XtParseTranslationTable(help_translations));
  XtOverrideTranslations(direction_main, 
		XtParseTranslationTable(help_translations));

  /* Event handlers for the graphics widget */

  XtAddEventHandler (graphics_main, ExposureMask, FALSE,
		     redraw_graph, NULL);
  
  vscroll_main = XtNameToWidget (viewport_main, "vertical");
  hscroll_main = XtNameToWidget (viewport_main, "horizontal");

  /* Callback functions */
  XtAddCallback(help_main, XtNcallback, popup_help, NULL);
  XtAddCallback(cdlfil_main, XtNcallback, popup_cdlfilsel, NULL);
  XtAddCallback(quit_main, XtNcallback, popup_quit, NULL);
  XtAddCallback(detach_main, XtNcallback, reset_xidlview, NULL);
  XtAddCallback(explain_main, XtNcallback, explain, NULL);
  XtAddCallback(expand_main, XtNcallback, expand, NULL);
  XtAddCallback(mordtl_main, XtNcallback, more_detail, NULL);
  XtAddCallback(freeze_main, XtNcallback, freeze_display, NULL);
  XtAddCallback(identify_main, XtNcallback, identify_display, text_main);
  XtAddCallback(print_main, XtNcallback, print_display, text_main);
  XtAddCallback(endsess_main, XtNcallback, end_session, NULL);
  XtAddCallback(change_mode_main, XtNcallback, change_display, NULL);
  XtAddCallback(refresh_main, XtNcallback, refresh_display, NULL);
  XtAddCallback(goto_main, XtNcallback, goto_return, NULL); 
  XtAddCallback(version_main, XtNcallback, version, NULL); 
  XtAddCallback(down_main, XtNcallback, down, NULL); 
  XtAddCallback(right_main, XtNcallback, right, NULL); 
  XtAddCallback(up_main, XtNcallback, up, NULL); 
  XtAddCallback(left_main, XtNcallback, left, NULL); 
  XtAddCallback(global_layout_main, XtNcallback, global_layout, NULL); 

  XawPanedSetMinMax(viewport_main, 400, 1600);
  XawPanedSetMinMax(direction_main, 20, 30);
  XawPanedSetMinMax(box_main, 20, 80);
  XawPanedSetMinMax(status_box_main, 20, 30);

  /* this is a test callback*/
  bzero(box_array, MAXBOXARRAY*sizeof(struct node_list));

  /* realize widgets */
  XtRealizeWidget(idlview_main);
  chgactnam("Unconnected");
  display = XtDisplay(idlview_main);
  vthumb_pos = hthumb_pos = 0.0;

  init_graphics(); 
  read_icon_bitmap(); 

  display_mode = TEXT;
  XtSetArg(arg[0], XtNlabel, "Text Display");
  XtSetValues(display_mode_main, arg, ONE);
  XtUnmanageChild (graphics_main);
  XtManageChild (text_main);
  
  n=0;
  XtSetArg(arg[n], XtNforceBars, False); n++;
  XtSetArg(arg[n], XtNallowVert, False); n++;
  XtSetArg(arg[n], XtNallowHoriz, False); n++;
  XtSetValues(viewport_main, arg, n);

  XtAppAddTimeOut(app_con, POLL_INTERVAL, polling_socket, (XtPointer)app_con); 
  XtAppMainLoop(app_con);

}

/* This function pops a display for printer selection */

void print_display(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  Widget popup_print_display, box_print_display, lpr_print_display;
  Widget screen_print_display, quit_print_display;
  Widget textw = (Widget) client_data;
  int n = 0;
  Arg args[5];
  Dimension width, height;
  Position x, y;

  XtSetArg(args[n], XtNwidth, &width);   n++;
  XtSetArg(args[n], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 , (Position) height/2 -100,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;

  popup_print_display = XtCreatePopupShell("popup_print_display", 
			transientShellWidgetClass, button, args, n); 
  box_print_display = XtCreateManagedWidget("box_print_display",
			boxWidgetClass, popup_print_display,
			NULL, ZERO);
  lpr_print_display = XtCreateManagedWidget("lpr_print_display",
			commandWidgetClass, box_print_display,
			NULL, ZERO);
  screen_print_display = XtCreateManagedWidget("screen_print_display",
			commandWidgetClass, box_print_display,
			NULL, ZERO);
  quit_print_display = XtCreateManagedWidget("quit_print_display",
			commandWidgetClass, box_print_display,
			NULL, ZERO);
  XtAddCallback(lpr_print_display, XtNcallback,
		print_text_to_lpr, client_data);
  XtAddCallback(screen_print_display, XtNcallback,
		print_text_to_screen, client_data);
  XtAddCallback(quit_print_display, XtNcallback,
		destroy_popup, popup_print_display);
  XtPopup(popup_print_display, XtGrabNone);

}


/* This function displays a printer button */
void print_text_to_lpr(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{

  Widget popup_print_text_to_lpr, but;
  Widget textw = (Widget)client_data;
  Arg args[5];
  int n=0;
  Dimension width, height;
  Position x, y;

  XtSetArg(args[n], XtNwidth, &width);   n++;
  XtSetArg(args[n], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 , (Position) height/2 -100,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;


  popup_print_text_to_lpr = XtCreatePopupShell("popup_print_text_to_lpr", 
					       transientShellWidgetClass,
					       button, args, n); 
  dialog_print_text_to_lpr = XtCreateManagedWidget("dialog_print_text_to_lpr",
					       dialogWidgetClass,
					       popup_print_text_to_lpr,
					       NULL, ZERO);
  if(printer_name != NULL)
    {
      if(printer_name[0] == '-')
	  strcpy(printer_name, &printer_name[2]);
      XtSetArg(args[0], XtNvalue, printer_name);
      XtSetValues(dialog_print_text_to_lpr, args, ONE);
    }
  but = XtCreateManagedWidget("OK", commandWidgetClass,
			      dialog_print_text_to_lpr,
			      NULL, ZERO);
  XtAddCallback(but, XtNcallback, to_printer,client_data);
  XtAddCallback(but, XtNcallback, destroy_popup, popup_print_text_to_lpr);
  XawDialogAddButton(dialog_print_text_to_lpr, "Cancel", destroy_popup, 
			popup_print_text_to_lpr);
  XtPopup(popup_print_text_to_lpr, XtGrabNone);

}

/* This function sends stuff to the printer */

void to_printer(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  String printer, str;
  Widget textw = (Widget) client_data;
  int pfd[2], pid;
  union wait status;
  Arg args[1];

  printer = XawDialogGetValueString(dialog_print_text_to_lpr);
  strcpy(printer_name,"-P");
  strcat(printer_name, printer);

  if(pipe(pfd) == -1)
    {
      fprintf(stderr,"to_printer: pipe error\n");
      exit(1);
    }
  switch(pid = fork())
    {
    case -1:
      fprintf(stderr, "to_printer: fork error\n");
      exit(1);
    case 0:
      close(pfd[1]);
      close(0);
      dup(pfd[0]);

#ifdef DEBUG
      fprintf(stdout,"spooling display to printer\n");
      fprintf(stdout,"\n[%d]\n", getpid());
      fflush(stdout);
#endif

      execl("/usr/ucb/lpr","lpr",printer_name,NULL);
      fprintf(stderr,"Command not found\n");
      fflush(stderr);
      exit(1);
    default:
      close(pfd[0]);
      XtSetArg(args[0], XtNstring, &str);
      XtGetValues(textw, args, ONE);
      write(pfd[1], str, strlen(str)+1);
      close(pfd[1]);

      while(wait3(&status, WNOHANG|WUNTRACED, NULL) > 0);

#ifdef DEBUG
      fprintf(stdout,"done\n");
      fflush(stdout);
#endif

    }
  
  fflush(stdout);

}


/* This function prints the data onto the screen */

void print_text_to_screen(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  Widget textw = (Widget) client_data;
  Arg args[1];
  String str;

  XtSetArg(args[0], XtNstring, &str);
  XtGetValues(textw, args, ONE);

#ifdef DEBUG
  fprintf(stdout, "%s\n", str);
  fflush(stdout);
#endif

}

/* This function changes the display mode from text to graphics and vice versa */

void
change_display(button, client_data, call_data)
     Widget button;
     XtPointer client_data, call_data;

{
  Arg arg[5];
  char modelabel[MAXLABLNG];
  Cardinal n;
  String str;

  if (display_mode == TEXT)
    {
      n=0;
      XtSetArg(arg[n], XtNforceBars, True); n++;
      XtSetArg(arg[n], XtNallowVert, True); n++;
      XtSetArg(arg[n], XtNallowHoriz, True); n++;
      XtSetValues(viewport_main, arg, n);

      XtUnmanageChild (text_main);
      XtManageChild (graphics_main);
      display_mode = INCREMENTAL_GRAPHICS;
      strcpy(modelabel, "Graphics Display");
      XtSetArg(arg[0], XtNlabel, modelabel);
      XtSetValues(display_mode_main, arg, ONE);

      /* code to change from text to graphics */
      if (cmmmod == IVWTRU)
	{
	  display_mode = INCREMENTAL_GRAPHICS;
	  clear_existing_graph();
	  display_mode = GLOBAL_GRAPHICS;
	  /*      gprcrotnod (curbtmbox); */
	  XtSetArg(arg[0], XtNstring, &str); 
	  XtGetValues(text_main, arg, ONE);

#ifdef DEBUG
	  printf("String in text widget is %s\n", str);
	  fflush(stdout);
#endif

	  conv_text_graphics (curbtmbox, str);
	  display_mode = INCREMENTAL_GRAPHICS;
	}

    }
  else if(display_mode == INCREMENTAL_GRAPHICS)
    {

      XtUnmanageChild (graphics_main);
      XtManageChild (text_main);
      display_mode = TEXT;
      strcpy(modelabel, "Text Display");
      XtSetArg(arg[0], XtNlabel, modelabel);
      XtSetValues(display_mode_main, arg, ONE);

      n=0;
      XtSetArg(arg[n], XtNforceBars, False); n++;
      XtSetArg(arg[n], XtNallowVert, False); n++;
      XtSetArg(arg[n], XtNallowHoriz, False); n++;
      XtSetValues(viewport_main, arg, n);

      /* code to change from graphics to text */
      if (cmmmod == IVWTRU)
	{
	  XtSetArg(arg[0], XtNstring, ""); 
	  XtSetValues(text_main, arg, ONE);
	  /*      str = graph_to_text(); 
		  XtSetArg(arg[0], XtNstring, str); 
		  XtSetValues(text_main, arg, ONE);
		  */
	  conv_graphics_text (curbtmbox);
	}
    }
}

/*
void
change_freeze_display(button, client_data, call_data)
     Widget button;
     XtPointer client_data, call_data;

{
  Arg arg[5];
  char modelabel[MAXLABLNG];
  Cardinal n;
  String str;
  FREEZE_LIST node;
  Widget widget = (Widget)client_data;
  Widget vp, display_mode_widget;

  for ( node = freeze_head; node != NULL; node = node->next)
    {
      if ( (Widget)node->freeze_display == widget)
	{
	  mode = node->mode;
	  vp = node->vp;
	  display_mode_widget = node->mode_widget;
	}
      
    }
  if (mode == TEXT)
    {
      n=0;
      XtSetArg(arg[n], XtNforceBars, True); n++;
      XtSetArg(arg[n], XtNallowVert, True); n++;
      XtSetArg(arg[n], XtNallowHoriz, True); n++;
      XtSetValues(vp, arg, n);

      txt = XtNameToWidget(vp, "text_freeze");
      XtDestroyWidget(txt);
      graphics_freeze = XtCreateManagedWidget("graphics_freeze", stripChartWidgetClass,
					      vp, NULL);
      display_mode = INCREMENTAL_GRAPHICS;
      strcpy(modelabel, "Graphics Display");
      XtSetArg(arg[0], XtNlabel, modelabel);
      XtSetValues(display_mode_widget, arg, ONE);

      if(cmmmod == IVWFLS)
	dsperrmsg("Not in xidlview session",
		  0);
      else
	{
	  display_mode = INCREMENTAL_GRAPHICS;
	  clear_existing_graph();
	  display_mode = GLOBAL_GRAPHICS;
	  gprcrotnod (curbtmbox);
	  display_mode = INCREMENTAL_GRAPHICS;
	}

    }
  else if(display_mode == INCREMENTAL_GRAPHICS)
    {

      XtUnmanageChild (graphics_main);
      XtManageChild (text_main);
      display_mode = TEXT;
      strcpy(modelabel, "Text Display");
      XtSetArg(arg[0], XtNlabel, modelabel);
      XtSetValues(display_mode_main, arg, ONE);

      n=0;
      XtSetArg(arg[n], XtNforceBars, False); n++;
      XtSetArg(arg[n], XtNallowVert, False); n++;
      XtSetArg(arg[n], XtNallowHoriz, False); n++;
      XtSetValues(viewport_main, arg, n);

      if(cmmmod == IVWFLS)
	dsperrmsg("Not in xidlview session",
		  0);
      else
	{
	 XtSetArg(arg[0], XtNstring, ""); 
	 XtSetValues(text_main, arg, ONE);
	 str = graph_to_text();
	 XtSetArg(arg[0], XtNstring, str); 
	 XtSetValues(text_main, arg, ONE);
	}
    }
}

*/

/* Setup the port pull down menu */

void setprtmnu()
{
  static Widget menu_setprtmnu, menu_item_setprtmnu;
  char **mnu_list;
  int i, prtnum;

  if(menu_setprtmnu != NULL) XtDestroyWidget(menu_setprtmnu);
  if(menu_item_setprtmnu != NULL) XtDestroyWidget(menu_item_setprtmnu);
  menu_setprtmnu = XtCreatePopupShell("menu", simpleMenuWidgetClass, 
			port_main, NULL, ZERO);
  prtnum = getprtlist(&mnu_list);
  menu_item_setprtmnu = XtCreateManagedWidget((String)"Invariant",
					      smeBSBObjectClass, 
					      menu_setprtmnu, NULL, ZERO);
  XtAddCallback(menu_item_setprtmnu, XtNcallback, sel_menu_label,
		(XtPointer)"Invariant");
  for(i = 0; i < prtnum; i++)
  {  
    menu_item_setprtmnu = XtCreateManagedWidget((String)mnu_list[i],
						smeBSBObjectClass, 
						menu_setprtmnu, NULL, ZERO);
    XtAddCallback(menu_item_setprtmnu, XtNcallback, sel_menu_label, (XtPointer)mnu_list[i]);
  } 

}

/* This function displays the popup help window */

void popup_help(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  Arg		args[5];
  Widget	label_popup_help, popup_popup_help, pane_popup_help;
  Widget	ok_popup_help;
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;
  void destroy_popup();

  n = 0;
  XtSetArg(args[0], XtNwidth, &width);   n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 , (Position) height/2 -500,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_popup_help = XtCreatePopupShell("popup_popup_help", 
			transientShellWidgetClass, button, args, n);
  pane_popup_help  = XtCreateManagedWidget("pane_popup_help", 
			panedWidgetClass, popup_popup_help, NULL, ZERO);
  label_popup_help = XtCreateManagedWidget("label_popup_help", 
			labelWidgetClass, pane_popup_help, NULL, ZERO);
  ok_popup_help    = XtCreateManagedWidget("ok_popup_help", 
			commandWidgetClass, pane_popup_help, NULL, ZERO);
  XtAddCallback(ok_popup_help, XtNcallback, destroy_popup, 
			popup_popup_help);
  XawPanedSetMinMax(label_popup_help, 500, 500);
  XawPanedSetMinMax(ok_popup_help, 20, 20);
  display_help(label_popup_help, xidlview_help);
  XtPopup(popup_popup_help, XtGrabNone);
}

/* This function displays the help test */

void display_help(widget, string)
Widget widget;
String string;
{  
  Arg args[1];

  XtSetArg(args[0], XtNlabel, string);
  XtSetValues(widget, args, ONE);
}
 

Widget dialog_popup_cdlfilsel;

/* This function displays the Candle file select popup */

void popup_cdlfilsel(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  Arg		args[5];
  Widget	popup_popup_cdlfilsel, but;
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;
  void destroy_popup();

#ifdef DEBUG
  printf("popup_cdlfilsel: Candle file Select button pressed\n");
  fflush(stdout);
#endif

  n = 0;
  XtSetArg(args[n], XtNwidth, &width);   n++;
  XtSetArg(args[n], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 , (Position) height/2 -100,
		&x, &y);

  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_popup_cdlfilsel = XtCreatePopupShell("popup_popup_cdlfilsel", 
			transientShellWidgetClass, button, args, n);
  dialog_popup_cdlfilsel = XtCreateManagedWidget("dialog_popup_cdlfilsel",
			dialogWidgetClass, popup_popup_cdlfilsel,
			NULL, ZERO);
  if(candle_file != NULL)
    {
      XtSetArg(args[0], XtNvalue, candle_file);
      XtSetValues(dialog_popup_cdlfilsel, args, ONE);
    }
  but = XtCreateManagedWidget("OK", commandWidgetClass, dialog_popup_cdlfilsel,
			    NULL, ZERO);
  XtAddCallback(but, XtNcallback, call_redcdl,NULL);
  XtAddCallback(but, XtNcallback, destroy_popup, popup_popup_cdlfilsel);
  XawDialogAddButton(dialog_popup_cdlfilsel, "Cancel", destroy_popup, 
			popup_popup_cdlfilsel);
  XtPopup(popup_popup_cdlfilsel, XtGrabNone);

#ifdef DEBUG
  printf("Done with Candle file select button\n");
  fflush(stdout);
#endif

}

/* This function reads the selected Candle file */

void call_redcdl(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{ 
  Arg arg[1];
  char *str;

#ifdef DEBUG
  printf("call_redcdl: calling redcdl\n");
  fflush(stdout);
#endif

  if (cmmmod == IVWTRU)
    {
      dsperrmsg("Quit from session before reading Candle file",0);
      return;
    }
  str = (char *)XawDialogGetValueString(dialog_popup_cdlfilsel);
  if(candle_file != NULL) free(candle_file);
  if((candle_file = (char *)malloc((strlen(str)+1)*sizeof(char))) == NULL)
    {
      perror("malloc failure in call_redcdl");
      exit(1);
    }
  strcpy(candle_file, str);
  chgactnam ("Reading Candle");
  if(redcdl(candle_file) == -1)
    {
      perror("Candle file read error");
      exit(1);
    }

#ifdef DEBUG
  printf("call_redcdl: finishing up call_redcdl\n");
  fflush(stdout);
#endif

}


/* This function displays the frozen window */

void freeze_display(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  static int ii=0;
  Arg args[5];
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;
  Widget pane_freeze, viewport_freeze, text_freeze, box_freeze, freeze, graphics_freeze;
  Widget status_box_freeze, help_freeze, quit_freeze, identify_freeze;
  Widget freezeid_freeze, timestamp_freeze, display_mode_freeze;
  Widget direction_freeze, down_freeze, up_freeze;
  Widget left_freeze, right_freeze, change_mode_freeze;
  time_t t1;
  char *tstr;
  static int fcount=0;
  String str;
  char freezeid_label[MAXLABLNG], note[MAXLEN];
  struct level_list **lst;
  struct boxnode *globnode;
  int level;
  float freezeid;
  void popup_freeze_quit(), redraw_freeze();

  if(cmmmod == IVWFLS)
    {
      dsperrmsg("Not in xidlview session",
		0);
      return;
    }

  ii++;
  fcount++;
  n = 0;
  XtSetArg(args[0], XtNwidth, &width);   n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 - 150 - ii*60 , 
		    (Position) height/2 - 500 - ii*60,
		    &x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;

  popup_freeze    = XtCreatePopupShell("popup_freeze", 
				       transientShellWidgetClass,
				       button, args, n);

  pane_freeze     = XtCreateManagedWidget("pane_freeze", panedWidgetClass,
					  popup_freeze, NULL, ZERO);

  viewport_freeze = XtCreateManagedWidget("viewport_freeze",viewportWidgetClass,
					  pane_freeze, NULL, ZERO);

  if (display_mode == TEXT)
    text_freeze     = XtCreateManagedWidget("text_freeze",asciiTextWidgetClass,
					    viewport_freeze, NULL, ZERO);
  else 
    {
      graphics_freeze     = XtCreateManagedWidget("graphics_freeze",stripChartWidgetClass,
						  viewport_freeze, NULL, ZERO);
    }
  direction_freeze= XtCreateManagedWidget("direction_freeze",boxWidgetClass, pane_freeze,
					NULL, ZERO);
  box_freeze      = XtCreateManagedWidget("box_freeze",boxWidgetClass,
					  pane_freeze,NULL, ZERO);
  status_box_freeze= XtCreateManagedWidget("status_box_freeze",boxWidgetClass,
					 pane_freeze, NULL, ZERO);
  left_freeze = XtCreateManagedWidget("left_freeze", commandWidgetClass,
				      direction_freeze, NULL, ZERO);
  down_freeze = XtCreateManagedWidget("down_freeze", commandWidgetClass,
				      direction_freeze, NULL, ZERO);
  up_freeze = XtCreateManagedWidget("up_freeze", commandWidgetClass,
				    direction_freeze, NULL, ZERO);
  right_freeze = XtCreateManagedWidget("right_freeze", commandWidgetClass,
                                       direction_freeze, NULL, ZERO);
  help_freeze     = XtCreateManagedWidget("help_freeze",commandWidgetClass,
					  box_freeze, NULL, ZERO);
  identify_freeze  = XtCreateManagedWidget("identify_freeze",commandWidgetClass,
					  box_freeze, NULL, ZERO);
  quit_freeze     = XtCreateManagedWidget("quit_freeze",commandWidgetClass,
					  box_freeze, NULL, ZERO);
  freezeid_freeze = XtCreateManagedWidget("freezeid_freeze",labelWidgetClass, 
					  status_box_freeze, NULL, ZERO);
  timestamp_freeze = XtCreateManagedWidget("timestamp_freeze", labelWidgetClass,
					   status_box_freeze, NULL, ZERO);
  display_mode_freeze = XtCreateManagedWidget("display_mode_freeze",labelWidgetClass, 
					  status_box_freeze, NULL, ZERO);
  change_mode_freeze = XtCreateManagedWidget("change_mode_freeze", commandWidgetClass,
					     box_freeze, NULL, ZERO);

  freezeid = (float)serverid + (float)fcount/10.0;
  sprintf(freezeid_label, "Frozen Window: %4.2g at ", freezeid);

  XtSetArg(args[0], XtNlabel, freezeid_label);
  XtSetValues(freezeid_freeze, args, ONE);

  if (display_mode == TEXT)
    XtSetArg(args[0], XtNlabel, "Text Display");
  else
    XtSetArg(args[0], XtNlabel, "Graphics Display");
  XtSetValues(display_mode_freeze, args, ONE);

  XawPanedSetMinMax(viewport_freeze, 400, 1600);
  XawPanedSetMinMax(box_freeze, 10, 30);

  time(&t1);
  tstr = ctime(&t1);
  if (display_mode == TEXT)
    {
      
      sprintf(note, "\nDisplay Frozen at %s to Frozen Window %4.2f\n\n",tstr,freezeid);
      dspstr(note,NEW); dspstr("",END);
    }
  sprintf(freezeid_label, "%s", tstr);
  XtSetArg(args[0], XtNlabel, freezeid_label);
  XtSetValues(timestamp_freeze, args, ONE);
  if (display_mode == TEXT)
    {
      n = 0;
      XtSetArg(args[n], XtNstring, &str); n++;
      XtGetValues(text_main, args, n);
      n = 0;
      XtSetArg(args[n], XtNstring, str+session_start_point); n++;
      XtSetValues(text_freeze, args, n);
      XFlush(XtDisplay(text_freeze));
    }
  else /* Graphics */
    {
      /* get a copy of globallst, along with bottommost and rightmost */
      /* store these in the freeze list */
      /* register a function in the frozen window for refreshing */
      /* this function determines which frozen window is refreshed and
	 uses the corresponding data */
      lst = (struct level_list **)malloc(MAXLVLARY * sizeof(struct level_list *));
      for (level = 0; level <=bottommost; level++)
	{
	  if (globallst[level])
	  for (globnode = globallst[level]->nodlst; globnode != NULL; 
	       globnode = globnode->next)
	    insert_freezelst(lst, globnode->hnd, level);
	  lst[level]->count = globallst[level]->count;
	  lst[level]->minx  = globallst[level]->minx;
	  lst[level]->maxx  = globallst[level]->maxx;
	  lst[level]->miny  = globallst[level]->miny;
	  lst[level]->maxy  = globallst[level]->maxy;
	}
    }
  if (display_mode == TEXT)
    append_freeze_list(text_freeze, lst, freezeid);
  else
    {
      append_freeze_list(graphics_freeze, lst, freezeid);
      XtAddEventHandler (graphics_freeze, ExposureMask, FALSE, redraw_freeze, NULL);
    }

  if (display_mode == TEXT)
    XtAddCallback(identify_freeze, XtNcallback, identify_display,
		  (XtPointer) text_freeze);

  XtAddCallback(help_freeze, XtNcallback, popup_help, NULL);
/*  XtAddCallback(change_mode_freeze, XtNcallback, change_freeze_display, NULL); */

  if (display_mode == TEXT)
    XtAddCallback(quit_freeze, XtNcallback, popup_freeze_quit,
		  (XtPointer) text_freeze);
  else
    XtAddCallback(quit_freeze, XtNcallback, popup_freeze_quit,
		  (XtPointer) graphics_freeze);

  XtPopup(popup_freeze, XtGrabNone);
}

/* This function highlights all the positions in the window 
   for the selected node 
*/

void identify_display(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  String str;
  XawTextPosition begin, end;
  Arg              args[1];
  struct scrposstc crspos;
  int              batpos;
  char             node_name[MAXNODNAMLNG];
  Widget           textw;

  if(cmmmod != IVWTRU) {
        dsperrmsg("Not in xidlview session",
                  "You must enter xidlview from dbx",
                  0);
        return;
  }
  if (display_mode != TEXT) return; /* right now, support only for text */
  textw = (Widget) client_data;
  getmnucrspos(&crspos, textw);
  XtSetArg(args[0], XtNstring, &str);
  XtGetValues(textw, args, ONE);
  str += crspos.begpos;
  sscanf(str,"(%*d) %s %*s", node_name);
  highlight_other_freeze(node_name); /* highlight this node in other
				      frozen windows */
}

/* This function highlights instances in other frozen windows */

void highlight_other_freeze(node)
char *node;
{

  FREEZE_LIST wdw;
  NODE_LIST node_ptr;

  handle_main_instances(node);
  for(wdw = freeze_head; wdw != NULL; wdw = wdw->next)
    handle_frozen_instances(node, wdw);

}

/* This function displays instances of nodes in the main window */

void handle_main_instances(node)
char *node;
{
  String str;
  Arg args[5];
  int index, i, j, curpos, input;
  Cardinal n;
  Position x, y;
  char *strptr, *freezeptr, *endsesptr;
  Widget popup_main_instances, pane_main_instances, label_main_instances;
  Widget box_main_instances, button_main_instances, quit_main_instances;
  Widget buttonpane_main_instances, buttonbox_main_instances;
  Widget buttonlabel_main_instances, viewport_main_instances;
  char index_str[20], srch[20];
  Dimension width, height;
  FREEZE_LIST freeze;

  bzero(box_array, sizeof(NODE_LIST)*MAXBOXARRAY);
  curpos = XawTextGetInsertionPoint(text_main);
  XtSetArg(args[0], XtNstring, &str);
  XtGetValues(text_main, args, ONE);
  strptr = &str[0];
  index = 0;

/*  if (!strstr((char *)strptr, node)) return; 

  getmnucrspos( &crspos, text_main);
  fndcrsobj(crspos, &findbox, &findbat, &findbatpos);
  */

  while((strptr = strstr((char *)strptr,node)) != NULL)
    {

      freezeptr = strstr((char *)strptr, "Frozen Window");
      endsesptr = strstr((char *)strptr, "=== end of session ===");
      if (freezeptr && (!endsesptr || freezeptr < endsesptr))
	{
	  strncpy(srch, freezeptr, 19);
	  sscanf(srch, "Frozen Window %g", &box_array[index].frozenwdw);
	}
      else
	{
	  /* This attribute is not frozen anywhere */
	  box_array[index].frozenwdw = 0.0;
	}

      for (freeze = freeze_head; freeze!= NULL; freeze = freeze->next)
	{
	  if (freeze->id == box_array[index].frozenwdw)
	    break;
	}
      if (!freeze)
	box_array[index].frozenwdw = 0.0;
    
      XawTextSetInsertionPoint(text_main,
			       (XawTextPosition)
			       abs((int)((char *)strptr-(char *)str)));
      XtCallActionProc(text_main, "end-of-line",NULL, NULL, ZERO); 
      box_array[index].end = XawTextGetInsertionPoint(text_main);
      XtCallActionProc(text_main, "beginning-of-line",NULL, NULL, ZERO);
      box_array[index].start = XawTextGetInsertionPoint(text_main);
      sscanf((char *)(str+box_array[index].start),
	     "(%d) %*s", &box_array[index].box);
      if (box_array[index].box == 0)
	;
      else
	index++;
      strptr++;
    }
  box_array_size = index;
  XawTextSetInsertionPoint(text_main, curpos);

  n = 0;
  XtSetArg(args[0], XtNwidth, &width);   n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(text_main, args, n);
  XtTranslateCoords(text_main, (Position) width/2 , (Position) height/2,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_main_instances       = XtCreatePopupShell   ("popup_main_instances", 
						     transientShellWidgetClass, 
						     text_main, args, n);
  
  pane_main_instances        = XtCreateManagedWidget("pane_main_instances", 
						     panedWidgetClass, 
						     popup_main_instances, 
						     NULL, ZERO);
  
  label_main_instances       = XtCreateManagedWidget("label_main_instances", 
						     labelWidgetClass, 
						     pane_main_instances, 
						     NULL, ZERO);

  viewport_main_instances    = XtCreateManagedWidget("viewport_main_instances",
						     viewportWidgetClass,
						     pane_main_instances,
						     NULL, ZERO);
  
  buttonpane_main_instances  = XtCreateManagedWidget("buttonpane_main_instances", 
						     panedWidgetClass, 
						     viewport_main_instances, 
						     NULL, ZERO);
  
  quit_main_instances        = XtCreateManagedWidget("quit_main_instances",
						     commandWidgetClass,
						     pane_main_instances,
						     NULL, ZERO);

  XtAddCallback(quit_main_instances, XtNcallback, destroy_popup,
		popup_main_instances);

  for(i=0;i<index;i++)
    {
      buttonbox_main_instances   = XtCreateManagedWidget("buttonbox_main_instances", 
							 boxWidgetClass, 
							 buttonpane_main_instances, 
							 NULL, ZERO);
      button_main_instances      = XtCreateManagedWidget("box_main_instances", 
							 commandWidgetClass, 
							 buttonbox_main_instances,
							 NULL, ZERO);
      buttonlabel_main_instances = XtCreateManagedWidget("buttonlabel_main_instances", 
							 labelWidgetClass, 
							 buttonbox_main_instances, 
							 NULL, ZERO);
      
      sprintf(index_str, "%d", box_array[i].box);
      XtSetArg(args[0], XtNlabel, index_str);
      XtSetValues(button_main_instances, args, ONE);

      if (box_array[i].frozenwdw > 0.0)
	sprintf(index_str, "Frozen Window %4.2g", box_array[i].frozenwdw);
      else
	sprintf(index_str, "                  ");
      XtSetArg(args[0], XtNlabel, index_str);
      XtSetValues(buttonlabel_main_instances, args, ONE);
      XtAddCallback(button_main_instances, XtNcallback, select_instance, 
		    NULL);
    }
  XawPanedSetMinMax(label_main_instances, 20, 20);
  /*  XawPanedSetMinMax(viewport_main_instances, 100, 100); */
  XawPanedSetMinMax(quit_main_instances, 10, 20);
  /*  XawPanedSetMinMax(buttonpane_main_instances, 500, 500);*/
  XtPopup(popup_main_instances, XtGrabNone);
  
}
  
/* This function selects the instances that were chosen to be
   highlighted in the main window
*/

void select_instance(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  Arg args[1];
  String str;
  int input, i, index;

  XtSetArg(args[0], XtNlabel, &str);
  XtGetValues(button, args, ONE);
  input = atoi(str);
  for(i=0;i<box_array_size;i++)
      if(box_array[i].box == input)
	{
	  XawTextSetSelection((Widget) text_main,
			      (XawTextPosition)box_array[i].start,
			      (XawTextPosition)box_array[i].end);
	  sleep(2);
	}
  
}  

/* This function handles instances in the frozen window */

void handle_frozen_instances(node, wdw)
char *node;
FREEZE_LIST wdw;
{
  XawTextPosition start, end;
  String str;
  char *strptr;
  Arg args[1];
  if (wdw && wdw->freeze_display)
    {
      XtSetArg(args[0], XtNstring, &str);
      XtGetValues(wdw->freeze_display, args, ONE);
      strptr = &str[0];
    }
  if((strptr = strstr((char *)str,node)) == NULL)
    return;
  else
    {
      XawTextSetInsertionPoint(wdw->freeze_display, strptr - str);
      XtCallActionProc(wdw->freeze_display, "beginning-of-line",NULL, NULL, ZERO);
      start = XawTextGetInsertionPoint(wdw->freeze_display);
      XtCallActionProc(wdw->freeze_display, "end-of-line",NULL, NULL, ZERO); 
      end = XawTextGetInsertionPoint(wdw->freeze_display);
      XawTextSetSelection((Widget) wdw->freeze_display,
			  (XawTextPosition)start,
			  (XawTextPosition)end);
      sleep(1);
    }
}

  
/* This function displays the quit popup */

void popup_quit(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  Arg		args[5];
  Widget	popup_popup_quit, dialog_popup_quit;
  Widget	dialog_popup_quit_freeze;  
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;
  void 		destroy_popup(), destroy_xidlview();

  n = 0;
  XtSetArg(args[0], XtNwidth, &width);   n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 , (Position) height/2 ,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_popup_quit = XtCreatePopupShell("popup_popup_quit", 
					transientShellWidgetClass, button, args, n);
  dialog_popup_quit = XtCreateManagedWidget("dialog_popup_quit",
					    dialogWidgetClass,
					    popup_popup_quit,
					    NULL, ZERO);
  XawDialogAddButton(dialog_popup_quit, "ok", destroy_xidlview, 
		     dialog_popup_quit);
  XawDialogAddButton(dialog_popup_quit, "cancel", destroy_popup, 
		     popup_popup_quit);
  XtPopup(popup_popup_quit, XtGrabNone);
}

/* This function displays the quit popup in the freeze window */

void popup_freeze_quit(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  Arg		args[5];
  Widget	popup_popup_freeze_quit, dialog_popup_freeze_quit;
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;
  void 		destroy_popup(), destroy_freeze();

  n = 0;
  XtSetArg(args[0], XtNwidth, &width);   n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 , (Position) height/2 ,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_popup_freeze_quit = XtCreatePopupShell("popup_popup_quit", 
					transientShellWidgetClass, button, args, n);
  dialog_popup_freeze_quit = XtCreateManagedWidget("dialog_popup_quit",
					    dialogWidgetClass,
					    popup_popup_freeze_quit,
					    NULL, ZERO);
  XawDialogAddButton(dialog_popup_freeze_quit, "ok", destroy_freeze, 
		     client_data);
  XawDialogAddButton(dialog_popup_freeze_quit, "cancel", destroy_popup, 
		     popup_popup_freeze_quit);
  XtPopup(popup_popup_freeze_quit, XtGrabNone);
}


/* This function destroys the frozen window */

void destroy_freeze(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
  Widget w = (Widget) client_data;
  delete_freeze_list(w);
  XtDestroyWidget(XtParent(XtParent(XtParent(w))));
}

/* This is a generic function to destroy any popup */

void destroy_popup(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
  Widget popup_destroy_popup;
  popup_destroy_popup  = (Widget) client_data;
  XtPopdown(popup_destroy_popup);
  XtDestroyWidget(popup_destroy_popup);
}

/* This function destroys a dialog window */

void destroy_dialog(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;
{
  Widget dialog_destroy_dialog = XtParent(XtParent(widget));
  XtDestroyWidget(dialog_destroy_dialog);
}

/* This function destroys the xidlview main window */

void destroy_xidlview(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
  /* if cmmmod is true call up endses() here */
  /* if(cmmmod == IVWTRU) endses(); */
  inform_master(STSEXT);
  XtDestroyApplicationContext(XtWidgetToApplicationContext(widget));
  exit(0);
}

/* THis function changes the status of the communication between
   xidlview and xdbx in the action status window 
*/

void chgactnam(label)
char *label;
{
  Arg arg[1];
  char actlabel[MAXLABLNG];
  char *getlabel;

  getlabel = getactnam();
  sprintf(actlabel, "%s %s", label, "Status");
  if(strcmp(getlabel, actlabel)== 0) return;
  if(status_chgactnam == NULL) {

#ifdef DEBUG
    printf("Creating status widget\n");
#endif

    status_chgactnam = XtCreateManagedWidget("status_main",labelWidgetClass, 
					     status_box_main, NULL, ZERO);
  }
  sprintf(actlabel, "%s Status", label);

#ifdef DEBUG
  printf("actlabel: %s\n", actlabel);
  fflush(stdout);
#endif

  XtSetArg(arg[0], XtNlabel, actlabel);
  XtSetValues(status_chgactnam, arg, ONE);
  if(strcmp(label,"Unconnected") == 0 && unncnn == IVWTRU)
    {
      if (display_mode == GLOBAL_GRAPHICS || display_mode == INCREMENTAL_GRAPHICS)
	{
	  clear_existing_graph();
	  free_windows();
	  free_levels();
	}
      inform_master(STSCHGNOTBSY);
    }
  if(strcmp(label, "Inactive") == 0 && unncnn == IVWFLS)
    inform_master(STSCHGBSY);
  XFlush(XtDisplay(status_chgactnam));
}

/* This window gets the current status value */

char *getactnam()
{
  Arg arg[1];
  static char *label;

  if(status_chgactnam == NULL) return "";
  XtSetArg(arg[0], XtNlabel, &label);
  XtGetValues(status_chgactnam, arg, ONE);
  return label;
}
  
/* This function displays the port menu label */

void sel_menu_label(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
  void chgprtnam();
  
  setdflprt(client_data);

}

/* This function changes the port name selected on the menu button */

void chgprtnam(port_name)
char *port_name;
{
  Arg arg[1];
  char *menu_name = "Select Port";
  
  if(port_name == NULL)
    XtSetArg(arg[0], XtNlabel, menu_name);
  else
    XtSetArg(arg[0], XtNlabel, port_name);
  XtSetValues(port_main, arg, ONE);

}

/* This function continously polls the communication socket */

void polling_socket(client_data, id) /* this is actually chknewsckcnn_notifier */
XtPointer client_data;
XtIntervalId id;
{
  static int count=0;

  /* call chknewsckcnn here */
  if(count == 0) /* on the first poll read in the stuff */
    {
      count++;
      read_command_line_options();
      reset();
    }
  chknewsckcnn();
  XtAppAddTimeOut((XtAppContext)client_data, POLL_INTERVAL, polling_socket, 
		  client_data);
  if(unncnn == IVWTRU)
    chgactnam("Unconnected");

}

/* This function reset the window display */

void reset_wdw()
{
  Arg args[1];
  static XawTextSelectType sarray[] = {
					XawselectLine,
					XawselectNull,
				};
  if (display_mode == TEXT)
    {
      bzero(cumul_str,MAXSTRLNG );
      text_offset = 0;
      XtSetArg(args[0], XtNstring, "");
      XtSetValues(text_main, args, ONE);
      XawTextSetSelectionArray(text_main, sarray);
    }
  else
    {
      clear_existing_graph();
    }

  setprtmnu();
  chgprtnam(NULL);
}

/* This function resets xidlview */

void reset_xidlview(widget, closure, callData)
Widget widget;
XtPointer closure,callData;
{

  unncnn = IVWTRU;
  chgactnam("Unconnected");
  reset();

  /* some more stuff like resetting socket connections will 
     come here 
  */
  reset_ipc();
}

/* function to set window parameters */

void setbegdsppos(scrpos)
struct scrposstc *scrpos;
{
/*  scrpos->begpos = (int) XawTextGetInsertionPoint(text_main); */
  scrpos->begpos = (int) text_offset;
}

/* function to set window parameters */

void setenddsppos(scrpos)
struct scrposstc *scrpos;
{
/*
  scrpos->endpos = (int) XawTextGetInsertionPoint(text_main);
  (scrpos->endpos--);
*/
  scrpos->endpos = (int) text_offset;
  (scrpos->endpos--) ;
}

/* function to set window parameters */

void setdspposend()
{
  Arg args[1];

/*  XtCallActionProc(text_main, "end-of-file",NULL, NULL, ZERO); */

}


/* Append a string on to the existing string in the text display */

int appstrlin(scrpos, str, inspnt)
struct scrposstc scrpos;
char *str;
int *inspnt;
{
  Arg args[1];
  XawTextBlock text;
  
  XawTextSetInsertionPoint(text_main, (XawTextPosition) scrpos.endpos);
  (*inspnt) = scrpos.endpos;

  text.firstPos = 0;
  text.length = strlen(str);
  text.ptr = str;
  text.format = FMT8BIT;
  XtSetArg(args[0], XtNeditType, XawtextEdit);
  XtSetValues(text_main, args, ONE);
  XawTextReplace(text_main, (XawTextPosition) scrpos.endpos, 
			    (XawTextPosition) scrpos.endpos, &text);
  XtSetArg(args[0], XtNeditType, XawtextRead);
  XtSetValues(text_main, args, ONE);
  return strlen(str);
}

/* THis function displays a string on the text display */

int dspstr(str, status)
char *str;
int status;
{
  Arg args[1];
  XawTextBlock text;
  static int start_pos, pos;
  NODE_LIST node;
  int box;
  bathnd bat;
  int batpos;
  struct scrposstc crspos;

  switch(status) {
  case NEW: 
    if(*str == '(' && isdigit(*(str+1)))
      {
	sscanf(str,"(%d) %*s", &box);
	box_array[box].start = pos;
	box_array[box].end   = strlen(str)+pos;
/*	fprintf(stdout, "box in dspstr is %d\n", box);*/
      }

    bzero(cumul_str,MAXSTRLNG);
    XtCallActionProc(text_main, "end-of-file",NULL, NULL, ZERO);
    pos = (int) XawTextGetInsertionPoint(text_main);
    start_pos = pos;
    set_insert_point(pos);
    strcpy(cumul_str,str);
    pos += strlen(str);
    set_insert_point(pos);
    break;

  case END:
    text.firstPos = 0;
    text.length = strlen(cumul_str);
    text.ptr = &cumul_str[0];
    text.format = FMT8BIT;

    XtSetArg(args[0], XtNeditType, XawtextEdit);
    XtSetValues(text_main, args, ONE);
    XawTextReplace(text_main,
		   start_pos ,
		   start_pos ,
		   &text);
    XtSetArg(args[0], XtNeditType, XawtextRead);
    XtSetValues(text_main, args, ONE);
    XFlush(XtDisplay(text_main));
    break;

  case CONT:
    strcat(cumul_str,str);
    pos += strlen(str);
    set_insert_point(pos);
    break;
  }

      
}

/* This function set window parameters */

void set_insert_point(offset)
int offset;
{
  text_offset = offset;
}

/*
int dspstr(str,status)
char *str;
int status;
{
  Arg args[1];
  XawTextBlock text;
  int pos;
  NODE_LIST node;
  int box;
  bathnd bat;
  int batpos;
  struct scrposstc crspos;

  text.firstPos = 0;
  text.length = strlen(str);
  text.ptr = str;
  text.format = FMT8BIT;

#ifdef DEBUG
  fprintf(stdout, "status is %d\n",status);
  fflush(stdout);
#endif

  XtCallActionProc(text_main, "end-of-file",NULL, NULL, ZERO);
  pos = (int) XawTextGetInsertionPoint(text_main);
  if(*str == '(' && isdigit(*(str+1)))
    {
      sscanf(str,"(%d) %*s", &box);
      box_array[box].start = pos;
      box_array[box].end   = strlen(str)+pos;

#ifdef DEBUG
      fprintf(stdout, "box in dspstr is %d\n", box); 
#endif

    }
  XtSetArg(args[0], XtNeditType, XawtextEdit);
  XtSetValues(text_main, args, ONE);
  XawTextReplace(text_main,
                 pos ,
                 pos ,
                 &text);
  XtSetArg(args[0], XtNeditType, XawtextRead);
  XtSetValues(text_main, args, ONE);
}
*/

void clrscrpos(scrposptr)
struct scrposstc *scrposptr;
{ scrposptr->begpos = -1;
  scrposptr->endpos = -1;
}


/* This function sets window parameters */

void fndboxdtlpos(boxscrpos, dtlpos)
  struct scrposstc boxscrpos;
  struct scrposstc *dtlpos;
{
   XawTextBlock text;
   XawTextPosition beg, curpos;
   char *str = "\n";

   beg = boxscrpos.begpos;
   text.firstPos = 0;
   text.length = strlen("\n");
   text.ptr = str;
   text.format = FMT8BIT; 

   curpos = XawTextGetInsertionPoint(text_main);
   XawTextSetInsertionPoint(text_main, (XawTextPosition)beg);
   beg = XawTextSearch(text_main, XawsdRight, &text);
   XawTextSetInsertionPoint(text_main, curpos);
   dtlpos->begpos = beg;
   dtlpos->endpos = beg;
}


/* This function displays a popup error message */

void dsperrmsg(va_alist)
va_dcl
{
 
  Arg args[2], arg[1];
  va_list curarg;
  char *str, *items;
  int count, n;
  Dimension height, width;
  Position x, y;
  Widget popup_dsperrmsg, box_dsperrmsg, label_dsperrmsg, ok_dsperrmsg;
  void destroy_label();

  n=0;
  XtSetArg(args[0], XtNwidth, &width); n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(text_main, args, n);
  XtTranslateCoords(text_main, (Position) width/2, (Position) height/2,
			&x, &y);
  n=0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_dsperrmsg = XtCreatePopupShell("popup_dsperrmsg",
			transientShellWidgetClass, idlview_main, args, n);
  box_dsperrmsg = XtCreateManagedWidget("box_dsperrmsg", boxWidgetClass,
			popup_dsperrmsg, NULL,ZERO);
  label_dsperrmsg = XtCreateManagedWidget("label_dsperrmsg", labelWidgetClass,
			box_dsperrmsg, NULL, ZERO);
  ok_dsperrmsg = XtCreateManagedWidget("ok_dsperrmsg", commandWidgetClass,
			box_dsperrmsg, NULL, ZERO);
  XtAddCallback(ok_dsperrmsg, XtNcallback, destroy_popup, popup_dsperrmsg);
  XtAddCallback(ok_dsperrmsg, XtNcallback, destroy_label, items);
  
  count = 0;
  va_start(curarg);
  str = va_arg(curarg, char*);
  while(str != 0)
  {
    count += strlen(str)+1;
    str = va_arg(curarg, char*);
  }
  va_end(curarg);
  if((items = (char *)calloc(count+1,sizeof(char))) == NULL)
	exit(1);
  va_start(curarg);
  items[0] = '\0';
  str = va_arg(curarg, char*);
  while(str != 0)
  {
    strcat(items, str);
    strcat(items,"\n");
    str = va_arg(curarg, char*);
  }
  va_end(curarg);
  XtSetArg(arg[0], XtNlabel, items);
  XtSetValues(label_dsperrmsg, arg, ONE);
  XtPopup(popup_dsperrmsg, XtGrabNone);

}

/* THis function destroys a label widget */

void destroy_label(widget, closure, callData)
Widget widget;
XtPointer closure, callData;
{
  String items = (String )closure;

  free(items);
}


void test_dsperrmsg(widget, closure, callData)
Widget widget;
XtPointer closure, callData;
{
  dsperrmsg("This is just a test of the error display function,",
	    " and also the list widget. So kindly ignore this",
	    " although you might be seeing a lot of this soon.",
	    0);
}


/* This function handles the explain function */

void explain(button, closure, callData)
Widget button;
XtPointer closure, callData;
{

  Arg		   args[5];
  char             idlb_str[10];
  Widget	   popup_explain, dialog_explain, but;
  Position	   x, y;
  Dimension	   width, height;
  Cardinal	   n;
  void             destroy_popup();

  if(cmmmod != IVWTRU) {
	dsperrmsg("Not in xidlview session",
		  "You must enter xidlview from dbx",
		  0);
  	return;
  }

  n = 0;
  XtSetArg(args[n], XtNwidth, &width);   n++;
  XtSetArg(args[n], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 , (Position) height/2 -100,
		&x, &y);

  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_explain = XtCreatePopupShell("popup_explain", 
			transientShellWidgetClass, button, args, n);
  dialog_explain = XtCreateManagedWidget("dialog_explain",
			dialogWidgetClass, popup_explain,
			NULL, ZERO);
  sprintf(idlb_str, "%d", idlb_pid);

#ifdef DEBUG
  printf("idlb_str %s\n", idlb_str);
  fflush(stdout);
#endif

  XtSetArg(args[0], XtNvalue, idlb_str);
  XtSetValues(dialog_explain, args, ONE);

  but = XtCreateManagedWidget("OK", commandWidgetClass, dialog_explain,
			    NULL, ZERO);
  XtAddCallback(but, XtNcallback, set_idlbpid, dialog_explain);
  XtAddCallback(but, XtNcallback, destroy_popup, popup_explain);
  XawDialogAddButton(dialog_explain, "Cancel", destroy_popup, 
			popup_explain);
  XtPopup(popup_explain, XtGrabNone);


}

void set_idlbpid(button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{

  struct scrposstc crspos;
  boxhnd	   box;
  bathnd	   bat;
  int		   batpos;

  Widget w = (Widget) client_data;
  String tmpstr;
  char idlb_str[20];

#ifdef DEBUG
  printf("setting idlb PID\n");
  fflush(stdout);
#endif

  tmpstr = (String)XawDialogGetValueString(w);
  strcpy (idlb_str, tmpstr);
  idlb_pid = atoi(idlb_str);

#ifdef DEBUG
  printf("idlb_pid %d\n", idlb_pid);
  fflush(stdout);
#endif

  getmnucrspos( &crspos, text_main);
  fndcrsobj(crspos, &box, &bat, &batpos);
  call_idlb(box, bat, batpos);
  
}


/* This routine handles the expand function */

void expand(widget, closure, callData)
Widget widget;
XtPointer closure, callData;
{

  struct scrposstc crspos;
  boxhnd	   box;
  bathnd	   bat;
  int		   batpos;

  if(cmmmod != IVWTRU) {
	dsperrmsg("Not in xidlview session",
		  "You must enter xidlview from dbx",
		  0);
	return;
  }
  getmnucrspos(&crspos, text_main);
  fndcrsobj(crspos, &box, &bat, &batpos);
  expattopt(box, bat);
  

}

/* THis is an accelerator for the expand function */

void expand_accel()
{
  struct scrposstc crspos;
  boxhnd	   box;
  bathnd	   bat;
  int		   batpos;
  XawTextPosition  curpos;

  if(cmmmod != IVWTRU) {
	dsperrmsg("Not in xidlview session",
		  "You must enter xidlview from dbx",
		  0);
	return;
  }
  curpos = XawTextGetInsertionPoint(text_main);
  XtCallActionProc(text_main, "beginning-of-line",NULL, NULL, ZERO);  
  crspos.begpos = crspos.endpos = (int)XawTextGetInsertionPoint(text_main);
  fndcrsobj(crspos, &box, &bat, &batpos);
  expattopt(box, bat);
  XawTextSetInsertionPoint(text_main, curpos);

}

/* This function handles the mor edetail function */

void more_detail(widget, closure, callData)
Widget widget;
XtPointer closure, callData;
{

  struct scrposstc crspos;
  boxhnd	   box;
  bathnd	   bat;
  int		   batpos;

  if(cmmmod != IVWTRU) {
	dsperrmsg("Not in xidlview session",
		  "You must enter xidlview from dbx",
		  0);
	return;
  }
  getmnucrspos(&crspos, text_main);
  fndcrsobj(crspos, &box, &bat, &batpos);
  mordtlopt(box, bat);

}

/* This is the accelerator for the more detail function */

void more_detail_accel()
{
  struct scrposstc crspos;
  boxhnd	   box;
  bathnd	   bat;
  int		   batpos;
  XawTextPosition  curpos;

  if(cmmmod != IVWTRU) {
	dsperrmsg("Not in xidlview session",
		  "You must enter xidlview from dbx",
		  0);
	return;
  }
  curpos = XawTextGetInsertionPoint(text_main);
  XtCallActionProc(text_main, "beginning-of-line",NULL, NULL, ZERO);  
  crspos.begpos = crspos.endpos = XawTextGetInsertionPoint(text_main);
  fndcrsobj(crspos, &box, &bat, &batpos);
  mordtlopt(box, bat);
  XawTextSetInsertionPoint(text_main, curpos);

}

/* This routine ends a current debugging session */

void end_session(widget, closure, callData)
Widget widget;
XtPointer closure, callData;
{


  if(cmmmod == IVWFLS)
     dsperrmsg("Nor in xidlview session",
	       "Use this option to end xidlview session",
		0);
  else 
    {
      endses();
      XFlush(display);
    }
  

}

/* This function gets the position of selection */

void getmnucrspos(pos, w)
struct scrposstc *pos;
Widget w;
{
  XawTextPosition begin_return, end_return;

/* even though i can get the whole selection (line) in one shot I am using only
the positions of the selections because i can interface this easily with the idlview code.
I will think about optimizations later on.
*/
  XawTextGetSelectionPos(w, &begin_return, &end_return);
  if(begin_return == end_return) return;
  pos->begpos = begin_return;
  pos->endpos = begin_return;
  
}

/* This function sets the data input notifier */

void set_input_notifier(inphnd, input_event_handler, dsc)
int *inphnd;
void (*input_event_handler)();
int dsc;
{
  /* input_id is the id returned from the XtAppAddInput call */
  input_id = XtAppAddInput(XtWidgetToApplicationContext(idlview_main),
			   dsc,
			   XtInputReadMask,
			   input_event_handler,
			   NULL);
  return;
}


/* Try to move this guy to ipc module because he really belongs there with all the msg
 stuff. May encounter problems in coercing the parameter pointers . */
int dbxred_notifier(closure , dsc, id)
XtPointer closure;
int *dsc;
XtInputId *id;
{

  ivwmsghdr msghdr;
  ptr       blk;

  dbxred(msghdr, blk);

  return;
}

void destroy_input_notifier(inphnd, dsc)
int *inphnd, dsc;
{
  /* input_id is the id returned from the XtAppAddInput call */
  XtRemoveInput(input_id);
  return;
}


/* This handles the help function */

void key_help(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;

{
  Arg		args[5];
  Widget	popup_popup_help, label_popup_help, pane_popup_help;
  Widget	ok_popup_help;
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;
  void destroy_popup();

  n = 0;
  XtSetArg(args[0], XtNwidth, &width);   n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(widget, args, n);
  XtTranslateCoords(widget, (Position) width/2 , (Position) height/2 -500,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_popup_help = XtCreatePopupShell("popup_popup_help", 
			transientShellWidgetClass, widget, args, n);
  pane_popup_help  = XtCreateManagedWidget("pane_popup_help", 
			panedWidgetClass, popup_popup_help, NULL, ZERO);
  label_popup_help = XtCreateManagedWidget("label_popup_help", 
			labelWidgetClass, pane_popup_help, NULL, ZERO);
  ok_popup_help    = XtCreateManagedWidget("ok_popup_help", 
			commandWidgetClass, pane_popup_help, NULL, ZERO);
  XtAddCallback(ok_popup_help, XtNcallback, destroy_popup, 
			popup_popup_help);
  /* Depending upon where the mouse cursor is(can be obtained from widget), 
     we have to display the corresponding help text */

  if(widget == status_box_main)  { display_help(label_popup_help, status_help);}
  else if(widget == text_main)   { display_help(label_popup_help, text_help);}
  else if(widget == endsess_main){ display_help(label_popup_help, endsess_help);}
  else if(widget == port_main)   { display_help(label_popup_help, port_help);}
  else if(widget == help_main)   { display_help(label_popup_help, help_help);}
  else if(widget == cdlfil_main) { display_help(label_popup_help, cdlfil_help);}
  else if(widget == expand_main) { display_help(label_popup_help, expand_help);}
  else if(widget == mordtl_main) { display_help(label_popup_help, mordtl_help);}
  else if(widget == freeze_main) { display_help(label_popup_help, freeze_help);}
  else if(widget == detach_main) { display_help(label_popup_help, detach_help);}
  else if(widget == explain_main){ display_help(label_popup_help, explain_help);}
  else if(widget == quit_main)   { display_help(label_popup_help, quit_help);}
  else if(widget == version_main){ display_help(label_popup_help, version_help);}
  else if(widget == change_mode_main){display_help(label_popup_help,change_mode_help);}
  else if(widget == down_main)   { display_help(label_popup_help, down_help);}
  else if(widget == up_main)     { display_help(label_popup_help, up_help);}
  else if(widget == left_main)   { display_help(label_popup_help, left_help);}
  else if(widget == right_main)  { display_help(label_popup_help, right_help);}
  else if(widget == goto_main)   { display_help(label_popup_help, goto_help);}
  else if(widget == refresh_main){ display_help(label_popup_help, refresh_help);}
  else if(widget == global_layout_main){display_help(label_popup_help,global_layout_help);}
  else if(widget == print_main)  { display_help(label_popup_help, print_help);}
  else if(widget == direction_main){display_help(label_popup_help,freq_command_help);}

  XawPanedSetMinMax(label_popup_help, 500, 500);
  XawPanedSetMinMax(ok_popup_help, 20, 20);
  XtPopup(popup_popup_help, XtGrabNone);
  
}


/* This function updates the scroll bar */

int updskrbar()
{
 /* function exists for compatibility with sunidlview */
 return;
}


/* THis function handles xidlview bitmap functions */

void read_icon_bitmap()
{

  int argc=0;
  char **argv=NULL;

  char *icon_name = "xidlview";
  char *window_name = "xidlview";
  XWMHints wmhints;

  XStoreName(display, XtWindow(idlview_main), "xidlview");
  XSetIconName(display, XtWindow(idlview_main), "xidlview");

  wmhints.input = True;
  
  wmhints.icon_pixmap = XCreateBitmapFromData(display,
					      XtWindow(idlview_main),
					      icon_bitmap_bits,
					      icon_bitmap_width,
					      icon_bitmap_height);

  wmhints.flags = IconPixmapHint | InputHint;

  XSetWMHints(display, XtWindow(idlview_main), &wmhints);

}
  

/* Parse command line */

void read_command_line_options()
{
  Arg args[1];
  int n;
  char *str_type;
  XrmValue candle_filnam;

  XrmInitialize();
  XrmParseCommand(&commanddb, opTable, XtNumber(opTable), "xidlview",
		  &argcount, argstring);
  
}

/* Augment freeze list */

void append_freeze_list(w, lst, freezeid)
Widget w;
struct level_list **lst;
float freezeid;

{
  FREEZE_LIST freeze;

  if((freeze = (FREEZE_LIST)malloc(sizeof(struct freeze_list))) == NULL)
    {
      perror("append_freeze_list: malloc failure");
      exit(1);
    }
  freeze->freeze_display = w;
  freeze->id = freezeid;

  if (display_mode == INCREMENTAL_GRAPHICS || display_mode == GLOBAL_GRAPHICS)
    freeze->lst = lst;
  else
    freeze->lst = NULL;

  if(freeze_head == NULL)
    {
      freeze_head = freeze;
      freeze->next = NULL;
    }
  else

    {
      freeze->next = freeze_head;
      freeze_head = freeze;
    }
}

void delete_freeze_list(w)
Widget w;

{
  FREEZE_LIST freeze, tmp;

  if (freeze_head && freeze_head->freeze_display == w)
    {
      freeze = freeze_head;
      freeze_head = freeze_head->next;
      free (freeze);
    }
  else
    for (freeze = freeze_head; freeze != NULL; freeze = freeze->next)
      {
	if (freeze->next && freeze->next->freeze_display == w)
	  {
	    tmp = freeze->next;
	    freeze->next = freeze->next->next;
	    free(tmp);
	  }
      }
}



void set_session_start()
{
  int pos;

  XtCallActionProc(text_main, "end-of-file",NULL, NULL, ZERO);
  pos = (int) XawTextGetInsertionPoint(text_main);
  session_start_point = pos;
}


/* Graphics Routines */

void
init_graphics()

{

  XSelectInput (display, XtWindow(idlview_main),
		ExposureMask | KeyPressMask | ButtonPressMask |
		StructureNotifyMask );
  load_font ();

  get_GC();

  XClearWindow (display, XtWindow(graphics_main));
  XFlush(display);
}

void
get_GC ()

{

  Arg arg[2];
  XGCValues values;
  unsigned int line_width = 0;
  int line_style = LineSolid;
  int cap_style = CapRound;
  int join_style = JoinRound;
  int screen;
  Cardinal n;

  screen = DefaultScreen(display);
  n=0;
  XtSetArg (arg[n], XtNbackground, &(values.background)); n++;
  XtSetArg (arg[n], XtNforeground, &(values.foreground)); n++;
  XtGetValues(graphics_main, arg, n);

  
  gc = XCreateGC (display, XtWindow(idlview_main),
		  (GCForeground | GCBackground),
		  &values);

  XSetFunction (display, gc, GXcopy);
  XSetFont (display, gc, font_info->fid);
  XSetLineAttributes (display, gc, line_width, line_style, cap_style, join_style);
  
  gcarrow = XCreateGC (display, XtWindow(idlview_main),
		       (GCForeground | GCBackground),
		       &values);
  XSetFunction (display, gcarrow, GXcopy);
  XSetLineAttributes (display, gcarrow, 1, line_style, cap_style, join_style);
  XSetFillStyle(display, gcarrow, FillSolid);

}

void 
load_font()

{
  char *font_name = FONT;

  if ((font_info = XLoadQueryFont(display, font_name)) == NULL)
    {
      (void) fprintf(stderr, "Basic: Cannot open font\n");
      exit(-1);
    }

}

void
redraw_graph()

{
  int level;

  if (display_ready)
    refresh_graph((int)graphics_main, globallst);
  XFlush(display);
}

void 
drwbox (widget, scrpos)
Widget widget;
struct gscrposstc scrpos;

{

  XDrawRectangle ( display, XtWindow(widget), gc, 
		   scrpos.x, scrpos.y, scrpos.width, scrpos.height);
  XFlush(display);
}


void 
drwent (widget, ent, scrpos, flag)
Widget widget;
char *ent;
struct gscrposstc *scrpos;
int flag;

{
  XGCValues values;

  if (flag == 0)
    {
      values.line_width = 2;
      XChangeGC (display, gc, GCLineWidth, &values);
      XDrawLine (display, XtWindow(widget), gc,
		 scrpos->x+1, scrpos->y, scrpos->x+scrpos->width-1, scrpos->y);
      values.line_width = 0;
      XChangeGC (display, gc, GCLineWidth, &values);
    }
  else
    XDrawLine (display, XtWindow(widget), gc,
	       scrpos->x+1, scrpos->y, scrpos->x+scrpos->width-1, scrpos->y);
  
  XDrawString (display, XtWindow(widget), gc,
	       scrpos->x+INTRABOXWIDTH, scrpos->y+INTRABOXHEIGHT+font_info->ascent,
	       ent, strlen(ent));
	       
  fflush(stdout);
}

void 
drwhdr (widget, hdr, scrpos)
Widget widget;
char *hdr;
struct gscrposstc *scrpos;

{

  XDrawString (display, XtWindow(widget), gc,
	       scrpos->x+INTRABOXWIDTH, scrpos->y+INTRABOXHEIGHT+font_info->ascent,
	       hdr, strlen(hdr));
	       
  fflush(stdout);
}

void
drwarw ( widget, x1, y1, x2, y2 )
     Widget widget;
     int x1, y1, x2, y2;

{
  XSegment arrow[3];
  XPoint  points[3];
  int left, right, up, down;
  int a,b,c,d, m,n,l;
  float angle, thirty;

  left = right = up = down = 0;
  l = ARROWSIZE;
  /* direction of line */
  if (x1 < x2)
    { right = 1; left = 0; }
  else
    { right = 0; left = 1; }
  if (y1 < y2)
    { up = 0; down = 1; }
  else
    { up = 1; down = 0; }

  /* angle of inclinination of line */
  if (x2 == x1)
    angle = PI/2.0;
  else
    angle = atan ( (double)abs(y2-y1)/(double)abs(x2-x1));
  /* determine arrow geometry */
  thirty = PI/10.0;
  m = n = (int)rint(l/cos(thirty));
  a = (int)n*cos(angle-thirty); 
  b = (int)n*sin(angle-thirty);
  c = (int)m*cos(angle+thirty); 
  d = (int)m*sin(angle+thirty);
  /* Compute arrow dimensions */
  /* first segment */
  arrow[0].x1 = (short)x2;
  arrow[0].y1 = (short)y2;
  if (left)
    {
      arrow[0].x2 = (short)x2 + (short)c;
      if (down)
	arrow[0].y2 = (short)y2 - (short)d;
      else
	arrow[0].y2 = (short)y2 + (short)d;
    }
  else
    {
      arrow[0].x2 = (short)x2 - (short)c;
      if (down)
	arrow[0].y2 = (short)y2 - (short)d;
      else
	arrow[0].y2 = (short)y2 + (short)d;
    }

  /* second segment */
  arrow[1].x1 = arrow[0].x2;
  arrow[1].y1 = arrow[0].y2;
  if (left)
    {
      arrow[1].x2 = (short)x2 + (short)a;
      if (down)
	arrow[1].y2 = (short)y2 - (short)b;
      else
	arrow[1].y2 = (short)y2 + (short)b;
    }
  else
    {
      arrow[1].x2 = (short)x2 - (short)a;
      if (down)
	arrow[1].y2 = (short)y2 - (short)b;
      else
	arrow[1].y2 = (short)y2 + (short)b;
    }

  /* third segment */
  arrow[2].x1 = arrow[1].x2;
  arrow[2].y1 = arrow[1].y2;
  arrow[2].x2 = (short)x2;
  arrow[2].y2 = (short)y2;

  XDrawLine (display, XtWindow(widget), gc,
	     x1, y1, x2, y2);
  /* draw the arrow head */
  XDrawSegments (display, XtWindow(widget), gc,
		 arrow, 3);
  points[0].x = arrow[0].x1; points[0].y = arrow[0].y1;
  points[1].x = arrow[1].x1; points[1].y = arrow[1].y1;
  points[2].x = arrow[2].x1; points[2].y = arrow[2].y1;

  XFillPolygon (display, XtWindow(widget), gcarrow,
		points, 3, Convex, CoordModeOrigin);
}
  
int
getbatwidth (attnamwid)
int attnamwid;

{
  int width;

/*  if (font_info->per_char == NULL) */
    width = font_info->min_bounds.width;
/*  else
    fprintf(stderr, "Error: Use fixed size fonts\n");*/
  return (int) (width*attnamwid);
}

int
getbatheight ()

{
  return (font_info->ascent+font_info->descent+2*INTRABOXHEIGHT);
}

void
trigger_global_draw(top, bottom)
int top, bottom;

{
  int level;

  display_ready = 1;

#ifdef DEBUG
  printf("trigger_global_draw: bottom %d\n", bottom);
  fflush(stdout);
#endif

  if (!display_ready) return;

  for (level = top; level <= bottom; level++)
    drwlvl((int)graphics_main, level);
}


void
trigger_draw(currentx, currenty)
int currentx, currenty;
{
  int level;

  display_ready = 1;

#ifdef DEBUG
  printf("trigger_draw: drawing current window x %d y %d\n", currentx, currenty);
  fflush(stdout);
#endif

  if (!display_ready) return;
  drwwdw((int)graphics_main, currentx, currenty);
}


/* callback function for the vertical scrollbar in INCREMENTAL GRAPHICS mode */
void
gvjump (widget, client_data, call_data)
     Widget widget;
     XtPointer client_data, call_data;

{
  float top = *((float *) call_data);

  if (vthumb_pos == 0)
    vthumb_pos = top;
  else if ( abs(top - vthumb_pos) > 0.4 )
    {
      vthumb_pos = top;
      incremental_layout(DOWN);
    }

}

/* callback function for the horizontal scrollbar in INCREMENTAL GRAPHICS mode */
void
ghjump (widget, client_data, call_data)
     Widget widget;
     XtPointer client_data, call_data;

{
  float top = *((float *) call_data);

  if (hthumb_pos == 0)
    hthumb_pos = top;
  else if ( abs(top - hthumb_pos) > 0.4 )
    {
      hthumb_pos = top;
      incremental_layout(RIGHT);
    }

}

/*
void
graphics_scrollbar()

{
  Widget v_graphics_scrollbar, h_graphics_scrollbar;
  float top;
  XtArgVal *l_top;
  Arg args[10];
  Cardinal n;

  top = 0.0;

  n = 0;

  if (sizeof(float) > sizeof(XtArgVal))
    {
      XtSetArg (args[n], XtNtopOfThumb, &top);
      n++;
    }
  else
    {
      l_top = (XtArgVal *) &top;
      XtSetArg (args[n], XtNtopOfThumb, *l_top);
      n++;
    }
  XtSetArg (args[n], XtNorientation, XtorientVertical); n++;
  XtSetArg (args[n], XtNlength, 550); n++;
  XtSetArg (args[n], XtNx, 0); n++;
  XtSetArg (args[n], XtNy, 0); n++;
  v_graphics_scrollbar = XtCreateManagedWidget ("v_graphics_scrollbar",
						scrollbarWidgetClass,
						graphics_main,
						args,
						n);
  XtAddCallback (v_graphics_scrollbar, XtNjumpProc, vjump, NULL);
  XtAddCallback (v_graphics_scrollbar, XtNscrollProc, vscroll, NULL);

  n = 0;
  if (sizeof(float) > sizeof(XtArgVal))
    {
      XtSetArg (args[n], XtNtopOfThumb, &top);
      n++;
    }
  else
    {
      l_top = (XtArgVal *) &top;
      XtSetArg (args[n], XtNtopOfThumb, *l_top);
      n++;
    }
  XtSetArg (args[n], XtNorientation, XtorientHorizontal); n++;
  XtSetArg (args[n], XtNlength, 450); n++;
  XtSetArg (args[n], XtNx, 0); n++;
  XtSetArg (args[n], XtNy, 530); n++;
  h_graphics_scrollbar = XtCreateManagedWidget ("h_graphics_scrollbar",
						scrollbarWidgetClass,
						graphics_main,
						args,
						n);


  XtAddCallback (h_graphics_scrollbar, XtNjumpProc, hjump, NULL);
  XtAddCallback (h_graphics_scrollbar, XtNscrollProc, hscroll, NULL);

}

void
hscroll (widget, client_data, call_data)
     Widget widget;
     XtPointer client_data, call_data;

{
}

void
vscroll (widget, client_data, call_data)
     Widget widget;
     XtPointer client_data, call_data;

{
}
*/
void clear_existing_graph()
{

  XSetFunction (display, gc, GXxor);
  XSetFunction (display, gcarrow, GXxor);
  redraw_graph();
  XSetFunction (display, gcarrow, GXcopy);
  XSetFunction (display, gc, GXcopy);
}

void
refresh_display(button, client_data, call_data)
     Widget button;
     XtPointer client_data, call_data;

{

  clear_existing_graph();
  XClearWindow (display, XtWindow(graphics_main));
  redraw_graph();

}

void
goto_return(button, client_data, call_data)
     Widget button;
     XtPointer client_data, call_data;

{
  
}


void version (button, client_data, call_data)
Widget button;
XtPointer client_data, call_data;
{
  Arg		args[5];
  Widget	label_version, popup_version, pane_version;
  Widget	ok_version;
  Position	x, y;
  Dimension	width, height;
  Cardinal	n;
  void destroy_popup();

  n = 0;
  XtSetArg(args[0], XtNwidth, &width);   n++;
  XtSetArg(args[1], XtNheight, &height); n++;
  XtGetValues(button, args, n);
  XtTranslateCoords(button, (Position) width/2 , (Position) height/2 -100,
		&x, &y);
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  popup_version = XtCreatePopupShell("popup_version", 
			transientShellWidgetClass, button, args, n);
  pane_version  = XtCreateManagedWidget("pane_version", 
			panedWidgetClass, popup_version, NULL, ZERO);
  label_version = XtCreateManagedWidget("label_version", 
			labelWidgetClass, pane_version, NULL, ZERO);
  ok_version    = XtCreateManagedWidget("ok_version", 
			commandWidgetClass, pane_version, NULL, ZERO);
  XtAddCallback(ok_version, XtNcallback, destroy_popup, 
			popup_version);
  XawPanedSetMinMax(label_version, 100, 100);
  XawPanedSetMinMax(ok_version, 20, 20);
  n=0;
  XtSetArg(args[n], XtNlabel, VERSION); n++;
  XtSetValues(label_version, args, n);

  XtPopup(popup_version, XtGrabNone);
}


void
down(button, client_data, call_data)
     Widget button;
     XtPointer client_data, call_data;

{
      pre_incremental_layout(DOWN);
      display_ready = 1;

}

void
right(button, client_data, call_data)
     Widget button;
     XtPointer client_data, call_data;

{
      incremental_layout(RIGHT);

#ifdef DEBUG
      printf("right: done incremental_layout for RIGHT operation\n");
      fflush(stdout);
#endif

  /* code to scroll the window to the center of this window */
      display_ready = 1;

#ifdef DEBUG
      printf("after right: currentx %d currenty %d\n", currentx, currenty);
      fflush(stdout);
#endif

}

void
left(button, client_data, call_data)
     Widget button;
     XtPointer client_data, call_data;

{
  if (currentx > 0)
    currentx--;
  move_screen(LEFT);

#ifdef DEBUG
      printf("left: done LEFT operation\n");
      fflush(stdout);
#endif

  /* code to scroll the window to the center of this window */

#ifdef DEBUG
      printf("after left: currentx %d currenty %d\n", currentx, currenty);
      fflush(stdout);
#endif

}

void
up(button, client_data, call_data)
     Widget button;
     XtPointer client_data, call_data;

{
  if (currenty > 0)
    currenty--;
  move_screen(UP);
  /* code to scroll the window to the center of this window */ 
  
#ifdef DEBUG
  printf("up: done UP operation\n");
  fflush(stdout);
#endif

#ifdef DEBUG
  printf("after up: currentx %d currenty %d\n", currentx, currenty);
  fflush(stdout);
#endif

}

void
get_window_size (x, y)
     int *x, *y;
{
  Arg arg[5];
  Cardinal n;
  Dimension screenwidth, screenheight;

  n=0;
  XtSetArg (arg[n], XtNwidth,  &screenwidth);  n++;
  XtSetArg (arg[n], XtNheight, &screenheight);  n++;
  XtGetValues (viewport_main, arg, n);
  *x = screenwidth; *y = screenheight;
}


void
global_layout(button, client_data, call_data)
     Widget button;
     XtPointer client_data, call_data;

{
  if(cmmmod == IVWFLS)
     dsperrmsg("Not in xidlview session",
	       0);
  else
    {
      display_mode = GLOBAL_GRAPHICS;
      gprcrotnod (curbtmbox);
      display_mode = INCREMENTAL_GRAPHICS;
    }
}

void
lock_window ()

{
  static int status=0;
  Cardinal n;
  Arg arg[1];

  if (!status)
    {
      status = 1;
      n=0;
      XtSetArg(arg[n], XtNallowResize, False); n++;
      XtSetValues(viewport_main, arg, n);
      XtSetValues(box_main, arg, n);
      XtSetValues(status_box_main, arg, n);
    }
  else
    {
      status = 0;
      n=0;
      XtSetArg(arg[n], XtNallowResize, True); n++;
      XtSetValues(viewport_main, arg, n);
      XtSetValues(box_main, arg, n);
      XtSetValues(status_box_main, arg, n);
    }
}


void
redraw_freeze (widget, client_data, event, con)
     Widget widget;
     XtPointer client_data;
     XEvent *event;
     Boolean *con;

{
  FREEZE_LIST node;

  for ( node = freeze_head; node != NULL; node = node->next)
    {

#ifdef DEBUG
      printf("widget %d\n", node->freeze_display);
      fflush(stdout);
#endif

      if ( (Widget)node->freeze_display == widget)
	refresh_graph((int)node->freeze_display, node->lst);
    }
}
