/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/xidlview/utl.c 
*				 					* 
*   Copyright (C) 1991 Vijay Anand
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* Utility functions */

#include <stdio.h>
#include <sys/file.h>
#include "utl.h"

#define MSGSIZE 256      /* Max message size. Remaining space in 
			    message would be padded with nulls  */

extern int errno;

/* Read a line from a descriptor. Read in a whole line of size less
   than or equal to MSGSIZE. All messages are guaranteed to be this
   size or less. Optimize number of read calls by reading in as much
   available in the stream.
*/

void
apperr(str)
     char *str;
{
  if (errno)
    {
      fprintf(stderr, "Error: %s : ", str);
      perror("");
      fflush(stderr);
    }
      exit(errno);
}


int
readline(fd, ptr)
     register int fd;     /* file descriptor from which to be read */
     register char **ptr; /* should be allocated as ptr to
			     an array of char of size MSGSIZE */
{
  int sts;

  errno = 0;
  sts = recv (fd, *ptr, MSGSIZE, 0);
  if (sts == -1)
    apperr("recv");
  return sts;
}


/* Write line to a descriptor.
 * Use in places where fd is a stream socket.
 */
void
writeline(fd, ptr)
     register int        fd;
     register char     *ptr;

{
  errno = 0;
  if (send (fd, ptr, MSGSIZE, 0) == -1)
    apperr("send");
  return;
}




  


