/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/xidlview/notifier.h 
*				 					* 
*   Copyright (C) 1991 Vijay Anand
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef NOT
#define NOT
/*
 *
 * Description:	This file contains functions that interface with the notifier
 *		in order to register call back functions on certain events. When
 *		the event occurs, the notifier detects it and transfers control  
 *		to the event handler (call back) which is registerd for this
 *		event. This module also contains the event handler functions
 *		called by the notifier. These may in turn call other functions
 *		in other modules.
 */


/********** INCLUDE FILES **********/
#include "global.h"


/********** DECLARATIONS **********/
/*
 * Routine:	set_input_notifier
 *
 * Description:	This routine calls the notifier to register an input-pending
 *		event handler which the Notifier would call whenever there is
 *		input pending on a file descriptor.
 *
 * Arguments:	inphnd -- (IN) a client handle used by SunWindows to associate
 *			  each event with the event handler for a given client.
 *		input_event_handler -- (IN) the name of the event handler called
 *					when input pending on file descriptor.
 *		ivwdsc -- (IN) the file descriptor on which input is pending.
 *
 * Return value: None
 *
 * Side effects: None
 */ 
void set_input_notifier(/* int *inphnd, int (*input_event_handler)(),
			   int ivwdsc */);

/*
 * Routine:	set_itimer_notifier
 *
 * Description:	This routine initializes the interval timer, and register a
 *		time-out event handler. The interval timer can be set to a
 *		specified value and every time it expires a timeout event is
 *		generated, and the timer reloaded. The Notifier calls the 
 *		timeout event handler once this event is generated.
 *
 * Arguments:	timer_handler -- (IN) name of the timeout event handler.
 *
 * Return value: None
 *
 * Side effects: None
 */ 
void set_itimer_notifier(/* int (*timer_event_handler)() */);

/*
 * Routine:	set_destroy_notifier
 *
 * Description:	This routine registers with the Notifier an event handler that
 *		is called just before a client is destroyed. This is usually
 *		used when a confirmation is desired before a frame is destroyed.
 *		The notifier interposes this handler before frame destruction is
 *		called.
 *
 * Arguments:	basfrm -- (IN) the client whose destroy event is caught and the
 *		event handler interposed.
 *
 * Return value: None
 *
 * Side effects: None
 */ 
void set_destroy_notifier(/* char *client, int (*destroy_event_handler)() */);

/*
 * Routine:	destroy_input_notifier
 *
 * Description:	This routine deregisters a file descriptor that was earlier
 *		registered with the Notifier. This is called before the file
 *		descriptor is closed.
 *
 * Arguments:	inphnd -- (IN) a client handle used by SunWindows to associate
 *			  each event with the event handler for a given client.
 *		destroy_input_handler -- (IN) the name of the event handler 
 *					called when input pending on file desc.
 *		ivwdsc -- (IN) the file descriptor which is to be deregistered..
 *
 * Return value: None
 *
 * Side effects: None
 */ 
void destroy_input_notifier(/* int *inphnd, int ivwdsc */);

/*
 * Routine:	dbxred_notifier
 *
 * Description:	This routine is the event handler called ny the notifier when
 *		there is input pending on the socket connection between the user
 *		process and idlview.
 *
 * Arguments:	inphnd -- (IN) a client handle used by SunWindows to associate
 *			  each event with the event handler for a given client.
 *		ivwdsc -- (IN) the file descriptor on which input is pending.
 *
 * Return value: None
 *
 * Side effects: None
 */ 
int dbxred_notifier(/* int *inphnd, int ivwdsc */);

/*
 * Routine:	chknewsckcnn_notifier
 *
 * Description:	This routine is called by the notifier every time the interval
 *		timer expires. It polls the socket to determine if any other 
 *		process has established a connection to this socket.
 *
 * Arguments:	hnd -- (IN) a client handle used by SunWindows to associate
 *			each event with the event handler for a given client.
 *		sel -- (IN) a flag that tells the routine whether the notifi-
 *			cation is based on real time(ITIMER_REAL) or process
 *			virtual time (ITIMER_VIRTUAL).
 *
 * Return value: None
 *
 * Side effects: None
 */ 
int chknewsckcnn_notifier(/* int *hnd, int sel */);

/*
 * Routine:	dstfrm_notifier
 *
 * Description:	This routine is the event handler function called by Notifier
 *		when a frame destroy event occurs. It confirms the destroy
 *		request and terminates the idlview session.
 *
 * Arguments:	basfrm (IN) -- the client which is to be destroyed.
 *		sts    (IN) -- the status of the destroy event.
 *		possible values -- DESTROY_CHECKING - check feasible destruction
 *				   DESTROY_CLEANUP  - go ahead and destroy
 *
 * Return value: None
 *
 * Side effects: None
 */ 
int dstfrm_notifier(/* int *basfrm, int sts */);

#endif
