/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/xidlview/gbox.c
*				 					* 
*   Copyright (C) 1991 Vijay Anand
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/* Include files */
#include "gboxP.h"
#ifdef mips
int strlen();
#endif

int level_flag, maxlevel, maxcolumn; /* to implement incremental columns */
int currentx, currenty; /* current window position */
int rightmost, bottommost;
static int scrwidth, scrheight;
static int redraw_pane=0;
static int redraw_rotbox = 0;

void dspsrcopt (box, bat, batpos)
boxhnd box;
bathnd bat;
int batpos;
		/*DOC-*/
{ 
  struct boxstc   *boxptr;	/* box structure indicated by cursor */
  struct batstc   *batptr;	/* box attrib structure indicated by cursor */
  TypeEntity	   typent;
  char		   outstr[100];	/* output string for error message */
  boxhnd	   expbox = NULBOX;	/* handle of box expanded to */

  if (box==NULBOX)
    { dsperrmsg("No box at that location",0);
      return;
    }

  /* if (box < curbtmbox)
   *    { dsperrmsg("That display is from a previous IDLView session.",
   *		"Source from that attribute cannot be displayed.",
   *		0);
   *      return;
   *    }
   */

/* Attribute T of class P in view C (the port structure) of process E
 */

  boxptr = cnvboxhnd(box);
  if (bat == NULBAT)
        { dsperrmsg ("Source display not fully implemented;",
			"Requesting source for",
			boxptr->cdltypent.IDLclassCommon->sem_name,
			"from file",
			idlfilnam,
			0);
	  return;
	}
   else 
{ batptr = cnvbathnd(bat);	/* convert box attrib to pointer */

  /* was:  typent = batptr->cdlatt->rep_type; */
  if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
    { 
         dsperrmsg("Too many levels of indirection.", 
                   "This Candle file may be compiled for Pascal.",
                   0); 
    }
  else 
  { /* get entity description of attribute */
    typent = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity; 
  switch (typeof(typent))
  {
    case KAtomic:  
       if (batpos>1) { dsperrmsg("No source for value of IDL basic type", 0);
		       return;
		     }
		   dsperrmsg("Source display not implemented;",
			     "Requesting source for",
			     batptr->cdlatt->lex_name,
			     "from file",
			     idlfilnam,
			     0);
		   break;
    case KSetOf:
    case KSeqOf:
    case KClass:
       if (batpos==1) { dsperrmsg("Source display not implemented;",
			     "Requesting source for",
			     batptr->cdlatt->lex_name,
			     "from file",
			     idlfilnam,
			     0);
		      }
	else if (typeof(typent)==KClass)
	   { dsperrmsg("Source display not implemented;",
		     "Requesting source for",
		     batptr->cdlatt->rep_name,
		     "from file",
		     idlfilnam,
		     0);
	   }
	 else { dsperrmsg("Source display not implemented;",
			  "Requesting source for",
                /* was:	  batptr->cdlatt->rep_type.IDLclassCommon->sem_name, */
			  batptr->cdlatt->rep_name,
			  0);
	      }
       break;
    /* fall through to default */
    /* unknown no longer present    case Kunknown: */
    default:       dsperrmsg("Attribute type unknown to IDLView;",
			     "either Candle is out of date",
			     "or there is an unknown error",
			     0);
  }
  } /* end of 'else' from 'if typeof(...' */
}

  return;
}

void call_idlb(box, bat, batpos)
     boxhnd box;
     bathnd bat;
     int batpos;

{
  FILE *fp, *fopen();
  char idlb[128];
  struct boxstc *boxptr;
  struct batstc *batptr;

  if (!idlb_pid) return;
  if (box < curbtmbox )
    {
      dsperrmsg("Node selected not in current session",0);
      return;
    }
  
  fp = fopen(IDLBROWSEFILE, "w");

  boxptr = cnvboxhnd(box);
  batptr = cnvbathnd(bat);

  /* Candle File Name */
  fputs(candle_file, fp);

  /* Process Name */
  fputs(prcdclinv.VProcessEntity->lex_name, fp);

  /* Node Name 
  fputs();

  /* Attribute Name 
  fputs();
  */

  fflush(fp);
  fclose(fp);

  kill(idlb_pid, SIGUSR1);
}




int expattopt (box, bat, level)
 boxhnd box;
 bathnd bat;
 int level;     
		/*DOC-*/
{ 
  struct boxstc   *boxptr;	/* box structure indicated by cursor */
  struct batstc   *batptr;	/* box attrib structure indicated by cursor */
  TypeEntity	   typent;
  char		   outstr[100];	/* output string for error message */
  boxhnd	   expbox = NULBOX;	/* handle of box expanded to */
  int		   cmmsts;	/* communication status */
  int              ret;

  if ( (box==NULBOX) || (bat==NULBAT) )
    { dsperrmsg("No attribute at that location",0);
      return -1;
    }

  if (box < curbtmbox && display_mode == TEXT)
    { dsperrmsg("That display is from a previous IDLView session.",
		"That attribute cannot be expanded now.",
		0);
      return -1;
    }

  boxptr = cnvboxhnd(box);
  batptr = cnvbathnd(bat);	/* convert box attrib to pointer */

  if (batptr->dstbox != NULBOX && display_mode == TEXT)	
    /* ensure we haven't already done this */
    { sprintf(outstr, "Attribute already expanded to box #%d", batptr->dstbox);
      dsperrmsg(outstr, 0);
      return -1;
    }

  cmmsts = IVWTRU;	/* assume communication goes well */

  /* WAS:  /* get entity description of attribute */
  /* WAS: typent = batptr->cdlatt->rep_type; */

  if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
    { /* Error: too many levels of indirection */
      dsperrmsg("Too many levels of indirection.", 
                "This Candle file may be compiled for Pascal.",
                0); 
      return -1;
    }
    else
    { /* get entity description of attribute */
      typent = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity; 
      ret = 1;
      switch (typeof(typent))
	{
	case KAtomic:  
	  if (display_mode == GLOBAL_GRAPHICS || 
	      display_mode == INCREMENTAL_GRAPHICS)
	    return -1;
	  else
	    dsperrmsg("Cannot expand IDL basic type",0); 
	  break;
	  
	case KClass:   cmmsts = expnodatt(box, bat, &expbox, level, &ret); 
	  break;

	case KSetOf:   cmmsts = expllssetseq(box, bat, &expbox, level, &ret); 
	  break;

	case KSeqOf:   cmmsts = expllssetseq(box, bat, &expbox, level, &ret);
	  break;

	  /* 26-Mar-1989 unknown is no longer present */
	  /* case Kunknown: /* fall through to default */

	default:       dsperrmsg("Attribute type unknown to IDLView;",
				 "either Candle is out of date",
				 "or there is an unknown error",
				 0);
	}
      if (display_mode != GLOBAL_GRAPHICS &&
	  display_mode != INCREMENTAL_GRAPHICS)
	dspstr("",CONT);

      /* if communication status is all right:
       *     update destination box, 
       *   otherwise display error message.
       */
      if (cmmsts == IVWTRU) { batptr->dstbox = expbox;
			    }
      else 
	{
	  if (display_mode != GLOBAL_GRAPHICS &&
	      display_mode != INCREMENTAL_GRAPHICS)
	    dsperrmsg("Communications terminated abnormally",0);
	}
      
      if (ret == 0)
	return 0;
      else
	return -1;
    } /* end of 'else' from 'if (typeof(...' */
}


void mordtlopt(box, bat)
 boxhnd box;
 bathnd bat;
{ 
  struct boxstc   *boxptr;      /* box structure indicated by cursor */
  struct batstc   *batptr;      /* box attrib structure indicated by cursor */
  TypeEntity       typent;
  int		   mchnum;	/* number matched against strings (to be
				 * replaced... 
				 */
  int		   inspos;	/* position at which we inserted text */
  int		   inscnt;	/* insert count -- # of chars inserted */
  char		   outstr[100];	/* output string temp storage */
  struct scrposstc insscrpos;	/* screen position for insert */
  int		   lng;		/* length of node in bytes, if needed */


  if ( (box==NULBOX) && (bat==NULBAT) )
    { dsperrmsg("No box or attribute at that location",0);
      return;
    }

  inspos = 0;		/* clear insert position */
  inscnt = 0;		/* clear insert count */

  boxptr = cnvboxhnd(box);	/* convert box to pointer */

  /* if we expanding an attribute, handle it;
   * otherwise handle expanding a box
   */
  if (bat!=NULBAT)
  { 
    batptr = cnvbathnd(bat);      /* convert box attrib to pointer */
    if (batptr->dtldsp == IVWTRU)
      { dsperrmsg ("More detail already displayed",
		   "for that attribute.",
		   0);
	return;
      }

    batptr->dtldsp = IVWTRU;
    if (batptr->usradr == IVWNUL) { dsperrmsg("Null user address",
					      "No detail available",0);
				    return;
				  }
    /* get entity description of attribute */
    /* was:    typent = batptr->cdlatt->rep_type; */
    if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
      { 
         dsperrmsg("Too many levels of indirection.", 
                   "This Candle file may be compiled for Pascal.",
                   0); 
	 return;
      }

    /* get entity description of attribute */
    typent = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity; 

    switch (typeof(typent))
    {
      case KAtomic:  
         mchnum = mchstr(typent.IDLclassCommon->rep_name,
			"int", "long", "float", "double", "String", "Boolean");

	 switch(mchnum)
	   { case 5:
		sprintf(outstr, " (detail: %d chars at %08x)",
				strlen(batptr->valptr.strptr), batptr->usradr);
		break;
	     default:
		sprintf(outstr, " (detail: addr=%08x, hex=%x)",
			(batptr->usradr), (*(batptr->valptr.intval))
		       );
		break;
	   }
	 batptr->scrpos.endpos/*++*/;
	 inscnt = appstrlin(batptr->scrpos, outstr, &inspos);
         break;

      case KClass:
	 lng = clcnodsiz (batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity);
	 sprintf (outstr, " (detail: %d bytes at %08x)",
		  lng, batptr->usradr);
	 batptr->scrpos.endpos/*++*/;
	 inscnt = appstrlin(batptr->scrpos, outstr, &inspos);
         break;

      case KSeqOf:   
      case KSetOf:   /* need to test for llist implementation, which is
		      * all we support at present
		      */
	 sprintf(outstr, " (detail: 1st linked list node addr=%08x)",
		  batptr->usradr);
	 batptr->scrpos.endpos/*++*/;
	 inscnt = appstrlin(batptr->scrpos, outstr, &inspos);
	 break;

      /* unknown no longer present */
      /* case Kunknown: */  /* fall through to default */
      default:       dsperrmsg("Attribute type unknown to IDLView;",
                               "either Candle is out of date",
                               "or there is an unknown error",
                               0);
    }
  }
  else /* box attribute is null -- give more detail on the box */
  { 
    if (boxptr->dtldsp == IVWTRU)
      { dsperrmsg("More detail already displayed",
		  "for that box",
		  0);
	return;
      }

    boxptr->dtldsp = IVWTRU;	/* set flag -- we've done this now *

    /* find the position for detail info on the display */
    fndboxdtlpos(boxptr->scrpos, &insscrpos);

    /* build string to put on display, based on type of box */
    if (boxptr->setseqnum!=(-1)) /* if box is set or seq element */
      { sprintf(outstr, " (detail: node at %08x, value at %08x)",
		boxptr->setseqllsnodadr, boxptr->usradr);
      }
      else { /* box must be node */
	     lng = clcnodsiz(boxptr->cdltypent);
	     sprintf(outstr, " (detail: %d bytes at addr %08x)",
				lng, boxptr->usradr);
	   }
    
    /* display the string */
    inscnt = appstrlin(insscrpos, outstr, &inspos);
  }

  adjwdwpos(inscnt,inspos); /* adjust window positions by insert count */
}

/* process root node in text mode */
void prcrotnod(rotbox)
boxhnd rotbox;
		/*DOC-*/
{
   int		dspsts;		/* display status */
   struct boxstc *rotnodbox;	/* pointer to first box on screen */


   /* fill in handle for current 'bottom' box */
   curbtmbox = rotbox;

   /* get pointer and fill in name for the root node */
   /* why do we need rotnodbox - seems like its not used. (vijay) */
   /* if this is not needed we can eliminate this file and do all
      stuff in prcrotnodmsg.c (ipc module) itself */
   rotnodbox = cnvboxhnd(rotbox);

   /* display the new box */
   dspsts = dspbox (rotbox);
   dspstr("",CONT); 

   updskrbar();
   return ;
}

/* process root node in graphical mode */
void gprcrotnod(rotbox)
boxhnd rotbox;
		/*DOC-*/
{

   int		dspsts;		/* display status */
   struct boxstc *rotnodbox;	/* pointer to first box on screen */
   struct boxnode *node;
   bathnd bat;
   struct boxstc *nodeptr;
   struct batstc *batptr;
   int global_level;
   int rowcnt, maxrowcnt;
   int screenwidth, screenheight;

   /* fill in handle for current 'bottom' box */
   curbtmbox = rotbox;
   if ((rotnodbox = cnvboxhnd( rotbox )) == NULL)
     return;
   
   clear_existing_graph();
   free_windows(); init_windows();
   free_levels();

   display_ready = 0;
   global_level = 0;
   currentx = currenty = 0;

   get_window_size (&screenwidth, &screenheight);
   scrwidth = screenwidth; scrheight = screenheight;
   set_box_bounds (); /* sets the maxlevel and maxcolumn limits */
   insert_globallst(rotbox, global_level);
   
   if (globallst[global_level] == NULL || globallst[global_level]->nodlst == NULL)
     return;
   
   for( node = globallst[global_level]->nodlst; node != NULL; node = node->next )
     dspgbox (node->hnd);
   
   lock_window();
   if (display_mode == INCREMENTAL_GRAPHICS)
     {
       incremental_layout (START);
       lock_window();
       return;
     }
   global_level++;
   /* Graphical mode */
   for ( ;; )
     {
       /* lvllst is the incremental graph that is to be drawn */
       if (globallst[global_level-1])
	 for( node = globallst[global_level-1]->nodlst; node != NULL; node = node->next )
	   {
	     nodeptr = cnvboxhnd (node->hnd);
	     switch (nodeptr->boxtyp) 
	       {
	       case NODBOXTYP:
		 bat = nodeptr->batlnk;
		 while (bat != NULBAT)
		   { 
		     /* expand nodes for this screen */
		     expattopt (node->hnd, bat, global_level);
		     batptr = cnvbathnd(bat);
		     bat    = batptr->batlnk;
		   }
		 break;
		 
	       default: 
		 if (display_mode == GLOBAL_GRAPHICS ||
		     display_mode == INCREMENTAL_GRAPHICS)
		   insert_globallst (node->hnd, global_level);
		 break;
	       }
	   }
       else
	 {
	   global_level--;
	   global_level--;
	   break;
	 }
       /* stop; no more nodes to include in layout */
       if (globallst[global_level]== NULL || globallst[global_level]->nodlst == NULL)
	 {
	   global_level--;
	   break;
	 }
       rowcnt=0;
       for( node = globallst[global_level]->nodlst; node != NULL; node = node->next )
	 {
	   rowcnt++;
	   dspgbox (node->hnd);
	 }
       if (rowcnt > maxrowcnt) maxrowcnt = rowcnt;
       global_level++;
     }

   if (global_level > 0)
     {
       /* graph_layout( rotbox, global_level ); Rowe algorithm */
       trigger_global_draw(0, global_level);
       bottommost = global_level;
       rightmost = maxrowcnt;
     }
   lock_window();
   return ;
}

/* function to convert graphics to text */

void conv_graphics_text (rotbox)
boxhnd rotbox;
		/*DOC*/
{

   struct boxstc *rotnodbox;	/* pointer to first box on screen */
   struct boxnode *node;
   int level, i;

   /* Nodes above the 'curbtmbox' can be eliminated and curbtmbox could be
      be made the first box */

   /*   for (i=rotbox+1; i<=curbtmbox; i++)
	boxary[i] = NULL;
	nxtboxnum = rotbox+1;
	*/
   /* fill in handle for current 'bottom' box */

   if ((rotnodbox = cnvboxhnd( rotbox )) == NULL)
     return;
   for (level=0; level <= bottommost; level++)
     if (globallst[level])
       for( node = globallst[level]->nodlst; node != NULL; node = node->next )
	 dspbox (node->hnd);
}

void conv_text_graphics (rotbox, str)
     boxhnd rotbox;
     char *str;
{
   int		dspsts;		/* display status */
   struct boxstc *rotnodbox;	/* pointer to first box on screen */
   struct boxnode *node;
   bathnd bat;
   struct boxstc *nodeptr;
   struct batstc *batptr;
   int    global_level, level;
   int    rowcnt, maxrowcnt;
   int    screenwidth, screenheight;
   int    box, i;
   char   boxstr[20];
   char   *s;


   if ((rotnodbox = cnvboxhnd( rotbox )) == NULL)
     return;
   tmplst = NULL;
   s = str;
   while(*s)
     {
       while(*s != '\0' && *s != '(') s++;
       if (*s == '\0') break;

       if (sscanf(s, "(%d)", &box) == 0)
	 {
#ifdef DEBUG
	   printf("box is %d\n", box);
	   fflush(stdout);
#endif
	   s++;
	 }
       else
	 {
#ifdef DEBUG
	   printf("box is %d\n", box);
	   fflush(stdout);
#endif 
	   if (box >= curbtmbox && cnvboxhnd((long)box))
	     {
	       if(s == str || *(s-1) == '\n')
		 {
#ifdef DEBUG
		   printf("Inserting into tmplst box %d\n", box);
		   fflush(stdout);
#endif 
		   nodeptr = cnvboxhnd(box);
		   insert_tmplst ((long)box, nodeptr->usradr);
		}
	       sprintf(boxstr, "%d", box);
	       s += 1 + strlen(boxstr) + 1;
	     }
	   else
	     {
#ifdef DEBUG
	       printf("Invalid box read from screen\n"); fflush(stdout);
	       fflush(stdout);
#endif 
	       sprintf(boxstr, "%d", box);
	       s += 1 + strlen(boxstr) + 1;
	     }
	 }
     }

   /* Nodes above the 'curbtmbox' can be eliminated and curbtmbox could be
      be made the first box */

 for (i=rotbox+1; i<=curbtmbox; i++)
     boxary[i] = NULL;
   nxtboxnum = rotbox+1;


   clear_existing_graph();
   free_windows(); init_windows();
   free_levels();

   display_ready = 0;
   global_level = 0;
   currentx = currenty = 0;

   get_window_size (&screenwidth, &screenheight);
   scrwidth = screenwidth; scrheight = screenheight;
   set_box_bounds (); /* sets the maxlevel and maxcolumn limits */
   insert_globallst(rotbox, global_level);
   if (globallst[global_level] == NULL || globallst[global_level]->nodlst == NULL)
     return;
   
   for( node = globallst[global_level]->nodlst; node != NULL; node = node->next )
     dspgbox (node->hnd);
   
   lock_window();
   global_level++;
   if (remove_tmplst(rotbox) != 0)
     /* Graphical mode */
     for ( ;; )
     {
       /* lvllst is the incremental graph that is to be drawn */
       if (globallst[global_level-1])
	 for( node = globallst[global_level-1]->nodlst; node != NULL; node = node->next )
	   {
	     nodeptr = cnvboxhnd (node->hnd);
	     switch (nodeptr->boxtyp) 
	       {
	       case NODBOXTYP:
		 bat = nodeptr->batlnk;
		 while (bat != NULBAT)
		   { 
		     /* expand nodes for this screen */
		    if (expattopt (node->hnd, bat, global_level) == 0)
		       {
			 rowcnt = 0;
			 for( node = globallst[global_level]->nodlst; node != NULL; 
			     node = node->next )
			   {
			     rowcnt++;
			     dspgbox (node->hnd);
			   }
			 
			 if (rowcnt > maxrowcnt) maxrowcnt = rowcnt;
			 global_level++;
			 goto done_expansion;
		       }
		     batptr = cnvbathnd(bat);
		     bat    = batptr->batlnk;
		   }
		 break;
		 
	       default: 
		 insert_globallst (node->hnd, global_level);
		 break;
	       }
	   }
       else
	 {
	   global_level--;
	   global_level--;
	   break;
	 }

       /* stop; no more nodes to include in layout */
       if (globallst[global_level]== NULL || globallst[global_level]->nodlst == NULL)
	 {
	   global_level--;
	   break;
	 }
       rowcnt=0;
       for( node = globallst[global_level]->nodlst; node != NULL; node = node->next )
	 {
    	   rowcnt++;
	   dspgbox (node->hnd);
	 }
       if (rowcnt > maxrowcnt) maxrowcnt = rowcnt;
       global_level++;
     }

done_expansion:

#ifdef DEBUG
   printf("global_level at done_expansion is %d\n", global_level);
   fflush(stdout);
#endif 
   if (global_level > 0)
     {/*
       for (level = 0; level <= global_level; level++)
	 for (node = globallst[level]->nodlst; node != NULL; node = node->next)
	   if ( !node_present (node) )
	     {
#ifdef DEBUG
	       printf("Node %d not present in text version\n", node->hnd);
	       fflush(stdout);
#endif
	       delete_globallst(node, level);
	     }*/
       while (globallst[global_level] == NULL)
	 global_level--;

       trigger_global_draw(0, global_level);
       redraw_pane = global_level;
       redraw_rotbox = rotbox;
       bottommost = global_level;
       rightmost = maxrowcnt;
       lock_window();
     }
}

void
pre_incremental_layout (direction)
     int direction;

{
  int x, limit;

  limit = currentx;
  if (redraw_pane > 0)
    incremental_layout(DOWN);

  for ( x=0; x<= limit; x++ )
    {
      if (wdw[x][currenty]/* && !wdw[x][currenty]->down */)
	{
	  currentx = x;
#ifdef DEBUG
	  printf("doing incremental layout for x %d y %d\n",x,currenty);
	  fflush(stdout);
#endif
	  incremental_layout(DOWN);
	  currenty--;
	}
    }
  currenty++;
  /* code here to move screen */
}

void 
incremental_layout (direction)
     int direction;
     
{

   int		dspsts;		/* display status */
   struct boxstc *rotnodbox;	/* pointer to first box on screen */
   struct boxnode *node;
   bathnd bat;
   struct boxstc *nodeptr;
   struct batstc *batptr;
   int            i;
   int incremental_level;
   int start_level, global_level;

   display_ready = 0; /* switch off any displaying for now */
   incremental_level = 0;

#ifdef DEBUG
   printf("incremental_layout: layout in direction %d\n", direction);
   fflush(stdout);
#endif
   if (redraw_pane > 0)
     {
       clear_existing_graph();
       curbtmbox = redraw_rotbox;;
       if (cnvboxhnd( redraw_rotbox ) == NULL)
	 return;
       
       clear_existing_graph();
       free_windows(); init_windows();
       free_levels();

       display_ready = 0;
       global_level = 0;
       currentx = currenty = 0;

       insert_globallst(redraw_rotbox, global_level);
   
       if (globallst[global_level] == NULL || globallst[global_level]->nodlst == NULL)
	 return;
   
       for( node = globallst[global_level]->nodlst; node != NULL; node = node->next )
	 dspgbox (node->hnd);
       
       lock_window();
       direction = START;
       
       redraw_pane = 0;
       redraw_rotbox = 0;
     }
   
   if (direction == START)
     {
       wdw[currentx][currenty] = (struct win *)malloc (sizeof (struct win));
       wdw[currentx][currenty]->top_level = wdw[currentx][currenty]->left = 0;
       incremental_level++;
       start_level = 0;
       move_screen(START);
     }
   else if (direction == DOWN)
     {
       if (wdw[currentx][currenty] == NULL)
	 {
#ifdef DEBUG
	   printf("incremental_layout: down operation failed, current wdw NULL\n");
	   fflush(stdout);
#endif
	   return;
	 }

       start_level = wdw[currentx][currenty]->bottom_level;
       if (globallst[start_level] == NULL || globallst[start_level]->nodlst == NULL)
	 {
#ifdef DEBUG
	   printf("incremental_layout: level %d empty\n", start_level);
#endif
	   return;
	 }
       wdw[currentx][currenty]->down = 1;
       currenty++;
       move_screen(DOWN);
       if (wdw[currentx][currenty] && wdw[currentx][currenty]->drawn)
	 {
	   /* move screen to window */
	   return;
/*
	   trigger_draw (currentx, currenty);
	   for (i=0; i<incremental_level; i++)
	     lvllst[i] = NULL;
	   return;
*/
	 }
       wdw[currentx][currenty] = (struct win *)malloc (sizeof (struct win));
       wdw[currentx][currenty]->down = 0;
       wdw[currentx][currenty]->top_level = wdw[currentx][currenty-1]->bottom_level + 1;
       wdw[currentx][currenty]->left = wdw[currentx][currenty-1]->left;
#ifdef DEBUG
       printf("left for this window %d, above window %d\n", wdw[currentx][currenty]->left,
	      wdw[currentx][currenty-1]->left);
       fflush(stdout);
#endif
     }
   else if (direction == RIGHT)
     {
       if (wdw[currentx][currenty] == NULL) return; 
       if ( currenty == 0 )
	 {
#ifdef DEBUG
	   printf("incremental_level: RIGHT operation on y = 0\n");
	   printf("RIGHT: curx %d cury %d\n", currentx, currenty);
	   fflush(stdout);
#endif
	   start_level = 0;
	   incremental_level++;
	 }
       else
	 {
	   start_level = wdw[currentx][currenty]->top_level - 1;
	   incremental_level = 0;
	 }
       if (globallst[start_level] == NULL || globallst[start_level]->nodlst == NULL)
	 {
	   return;
	 }
       currentx++;
       move_screen(RIGHT);
       if (wdw[currentx][currenty] && wdw[currentx][currenty]->drawn)
	 {
	   /* move screen to the correct window */
	   return;
/*	   trigger_draw (currentx, currenty);
	   for (i=0; i<incremental_level; i++)
	     lvllst[i] = NULL;
	   return;
*/
	 }
       wdw[currentx][currenty] = (struct win *) malloc (sizeof (struct win));
       wdw[currentx][currenty]->top_level = wdw[currentx-1][currenty]->top_level;
       wdw[currentx][currenty]->left = wdw[currentx-1][currenty]->right + 1;
#ifdef DEBUG
       printf("RIGHT: curx %d cury %d\n", currentx, currenty);
#endif
     }
   
   level_flag = 0; /* flag to indicate if column is full */
   if (globallst[start_level] != NULL && globallst[start_level]->nodlst)
   for( node = globallst[start_level]->nodlst; 
        node != NULL && !level_flag; 
        node = node->next )
     {
       nodeptr = cnvboxhnd (node->hnd);
       if ( nodeptr->expanded )  /* node fully expanded */ 
	 {
#ifdef DEBUG
	   printf("curx %d cury %d\n", currentx, currenty);
	   fflush(stdout);
#endif
	   continue;
	 }
       switch (nodeptr->boxtyp) 
	 {
	 case NODBOXTYP:
	   bat = nodeptr->batlnk;
	   while (!level_flag && bat != NULBAT)
	     { 
	       batptr = cnvbathnd(bat);
	       if (!batptr->expanded)
		 {
		   expattopt (node->hnd, bat, incremental_level);
/*		   if (!level_flag) */
		   batptr->expanded = 1;
		 }
	       bat = batptr->batlnk;
	     }
	   break;
	   
	 default: 
	   insert_lvllst (node->hnd); /* insert this node in lvllst */
	   break;

	 }
       if (!level_flag)
	 nodeptr->expanded = 1;
     }
   
   if (direction == DOWN && lvllst[incremental_level] == NULL) 
     {
       /* wdw[currentx][currenty] = NULL;  (check this) */
       wdw[currentx][currenty]->drawn = 0;
       /* currenty--; */
       for (i=0; i<incremental_level; i++)
	 lvllst[i] = NULL;            /* free all memory for the lvllst */
       return;
     }
   if (lvllst[incremental_level] != NULL && lvllst[incremental_level]->nodlst)
   for( node = lvllst[incremental_level]->nodlst; node != NULL; node = node->next )
     dspgbox (node->hnd); /* setup nodes in this level for display */
   incremental_level++;
   
   for ( ; incremental_level < maxlevel ; incremental_level++ )
     {

       /* lvllst is the incremental graph that is to be drawn, start expanding this */
       level_flag = 0;

       if (globallst[wdw[currentx][currenty]->top_level + incremental_level - 1] != NULL)
       for(node=globallst[wdw[currentx][currenty]->top_level+incremental_level - 1]->nodlst;
	   node != (struct boxnode *)NULL && !level_flag;
	   node = node->next)
	 
	 {
	   nodeptr = cnvboxhnd (node->hnd);
	   if ( nodeptr->expanded )  /* node fully expanded */ 
	     continue;

	   switch (nodeptr->boxtyp) 
	     {
	     case NODBOXTYP:
	       bat = nodeptr->batlnk;
	       while (!level_flag && bat != NULBAT)
		 { 
		   batptr = cnvbathnd(bat);
		   if (!batptr->expanded)
		     {
		       expattopt (node->hnd, bat, incremental_level);
/*		       if (!level_flag) */
		       batptr->expanded = 1;
		     }
		   bat = batptr->batlnk;
		 }
	       break;
	       
	     default: 
	       insert_lvllst(node->hnd, incremental_level);
	       break;
	     }
	   if (!level_flag)
	     nodeptr->expanded = 1;
	 }
       
       if (lvllst[incremental_level-1] != NULL)
	 for( node = lvllst[incremental_level-1]->nodlst;
	   node != (struct boxnode *)NULL && !level_flag;
	   node = node->next )
	 
	 {
	   nodeptr = cnvboxhnd (node->hnd);
	   if ( nodeptr->expanded )  /* node fully expanded */ 
	     continue;

	   switch (nodeptr->boxtyp) 
	     {
	     case NODBOXTYP:
	       bat = nodeptr->batlnk;
	       while (!level_flag && bat != NULBAT)
		 { 
		   batptr = cnvbathnd(bat);
		   if (!batptr->expanded)
		     {
		       expattopt (node->hnd, bat, incremental_level);
/*		       if (!level_flag) */
			 batptr->expanded = 1;
		     }
		   bat = batptr->batlnk;
		 }
	       break;
	       
	     default: 
	       insert_lvllst(node->hnd, incremental_level);
	       break;
	     }
	   if (!level_flag)
	     nodeptr->expanded = 1;
	 }
       
       if (lvllst[incremental_level] != NULL)
	 for( node = lvllst[incremental_level]->nodlst; node != NULL; node = node->next )
	   dspgbox (node->hnd); /* setup nodes in this level for display */
     }

   /* check if anything to do RIGHT on */
   for (i=0; i<incremental_level; i++)
     if (lvllst[i] != NULL) break;
   if (i==incremental_level && direction == RIGHT)
     {
#ifdef DEBUG
       printf("incremental_level: curx %d cury %d nothing to do RIGHT on\n", 
	      currentx, currenty);
       fflush(stdout);
#endif
/*       wdw[currentx][currenty] = NULL;  ( check this ) */
       wdw[currentx][currenty]->drawn = 0;
/*       currentx--; */
       /* move the center of screen to previous window */
       for (i=0; i<incremental_level; i++)
	 lvllst[i] = NULL;            /* free all memory for the lvllst */
       return;
     }

   merge_graph (wdw[currentx][currenty]->top_level, incremental_level);

/*
   if (top_level == 0)
     for( node = globallst[top_level]->nodlst; node != NULL; node = node->next )
       graph_layout( node->hnd, incremental_level );  /* Rowe algorithm 
   else if (top_level > 0)
     for( node = globallst[top_level - 1]->nodlst; node != NULL; node = node->next )
       graph_layout( node->hnd, incremental_level );  
*/
   if (direction == START)
     {
/*       wdw[currentx][currenty]->bottom_level = wdw[currentx][currenty]->top_level +
	                                       incremental_level - 1;
       wdw[currentx][currenty]->right        = wdw[currentx][currenty]->left +
	                                       maxcolumn;*/
       wdw[currentx][currenty]->drawn        = 1;
     }
   else if (direction == DOWN)
     {
/*       wdw[currentx][currenty]->bottom_level = wdw[currentx][currenty]->top_level +
	                                       incremental_level - 1;
       wdw[currentx][currenty]->right        = wdw[currentx][currenty]->left +
	                                       maxcolumn; */

       wdw[currentx][currenty]->drawn        = 1;
     }
   else if (direction == RIGHT)
     {
/*       wdw[currentx][currenty]->bottom_level = wdw[currentx][currenty]->top_level +
	                                       incremental_level - 1;
       wdw[currentx][currenty]->right        = wdw[currentx][currenty]->left +
                                               maxcolumn; */
       wdw[currentx][currenty]->drawn        = 1;
     }
#ifdef DEBUG
   printf("current window dimensions: top %d bottom %d left %d right %d\n",
	  wdw[currentx][currenty]->top_level,
	  wdw[currentx][currenty]->bottom_level,
	  wdw[currentx][currenty]->left,
	  wdw[currentx][currenty]->right);
   fflush(stdout);
#endif
   if (direction == START/* || wdw[currentx][currenty]->left == 0*/)
     trigger_global_draw(wdw[currentx][currenty]->top_level,
			 wdw[currentx][currenty]->bottom_level);
   else
     trigger_draw (currentx, currenty);
   for (i=0; i<incremental_level; i++)
     lvllst[i] = NULL;            /* free all memory for the lvllst */
   
 }

int bldnodbox(usradr, boxhndptr)
     ptr    usradr;	/* address in user's space of node to get */
     boxhnd *boxhndptr;	/* pointer to box built for this node */
     /*DOC-*/
{
  int           getsts;    /* status from user block */
  short         *nodidtptr; /* node id from user's process */
  int           cdlsts;    /* status from Candle type search */
  int		batsts;    /* status from building box attribute */
  
  boxhnd        curbox;    /* number of box we build to expand node */
  struct boxstc *curboxptr; /* pointer to same box */
  
  TypeEntity  typptr;	/* pointer into Candle structure */
  
  SEQAttribute reminvatt; /* attributes remaining for this node in invariant */
  Attribute   curinvatt;  /* current attribute for this node in invariant */
  
  SETTypeEntity remprttyp; /* TypeEntitys in port search loop */
  TypeEntity    curprttyp; /* current TypeEntity in port search loop */
  
  SEQAttribute remprtatt; /* attributes remaining for this node in port */
  Attribute   curprtatt;  /* current attribute for this node in port */
  
  struct batstc *batptr; /* pointer to current box attribute */
  bathnd	*bathndptr;  /* pointer to current box attrib handle */
  
  ptr          tmpusradr; /* temp pointer to local block for copy of node */
  int		nodsiz;	  /* number of bytes in this node */
  
  /* get the node ID from the user space and Candle type of structure */
  getsts = getusrblk(usradr, sizeof(*nodidtptr), &nodidtptr);
  
  if (getsts == IVWFLS) { return getsts;
			}
  /* find the type of this node in Candle */
  cdlsts = fndcdltyp((*nodidtptr), &typptr);
  
  /* allocate a new box */
  allnewbox(boxhndptr, &curboxptr);
  
  nodsiz = clcnodsiz(typptr);	/* calculate number of bytes in node */
  
  /* get a copy of this node from the user process
   * set the user's address and the local copy address into the box
   * (also type of box)
   */
  getsts = getusrblk(usradr, nodsiz, &tmpusradr);
  if (getsts == IVWFLS) { return getsts;
			}
  curboxptr->lclblk = tmpusradr;
  curboxptr->usradr = usradr;
  curboxptr->boxtyp = NODBOXTYP;
  
  /* fill in the Candle Entity pointer */
  curboxptr->cdltypent = typptr;
  
  bathndptr = &(curboxptr->batlnk);
  if (dflprt == IVWNUL)
    { /* there is no default port -- each attribute in the invariant
       * is used as a box attribute
       */
      foreachinSEQAttribute (typptr.VClass->sem_allattributes, 
			     reminvatt, curinvatt)
	{ batsts = bldnewbat (curinvatt, curboxptr->lclblk,
			      (*boxhndptr), bathndptr, usradr);
	  if (batsts == IVWFLS) { return batsts;
				}
	  batptr = cnvbathnd(*bathndptr);
	  bathndptr = &(batptr->batlnk);
	}
    }
  else 
    { /* there's a default port; search its types to find the
       * type for which a box is being built
       */
      foreachinSETTypeEntity(dflprt->syn_data->sem_entity
			     .VStructureEntity->sem_types, 
			     remprttyp, curprttyp)
	{ if (typptr.IDLclassCommon->sem_name
	      == curprttyp.IDLclassCommon->sem_name)
	    { break;
	    }
	}
      
      if (typptr.IDLclassCommon->sem_name
	  != curprttyp.IDLclassCommon->sem_name)
	{ dsperrmsg("Selected node type not found in this port",0);
	}
      else
	/* for each attribute in the invariant, 
	 * search the port for that attribute
	 */
	foreachinSEQAttribute(typptr.VClass->sem_allattributes,
			      reminvatt, curinvatt)
	  { foreachinSEQAttribute(curprttyp.VClass->sem_allattributes, 
				  remprtatt, curprtatt)
	      { if (curprtatt->lex_name == curinvatt->lex_name)
		  { bldnewbat (curinvatt, curboxptr->lclblk,
			       (*boxhndptr), bathndptr,
			       usradr);
		    if (batsts == IVWFLS) return batsts;
		    batptr = cnvbathnd(*bathndptr);
		    bathndptr = &(batptr->batlnk);
		    break;
		  }
	      }
	  }
    }
  return IVWTRU;
}


void reset_box()
{

  int   boxbatctr;      /* counts boxes and box attributes in loop */
  struct boxstc* boxptr;    /* actual box pointer */
  struct batstc* batptr;    /* actual bat pointer */


  free_windows(); init_windows();
  dflprt=IVWNUL; /* moved from iniwdw to here, because dflprt is a varible
		    of this module */
  /* delete any space allocated to boxes and box attributes */
  for (boxbatctr=FSTBOXNUM; boxbatctr<nxtboxnum; boxbatctr++)
     { boxptr = cnvboxhnd(boxbatctr);
       free(boxptr->lclblk);
       free(boxptr);
     }

  for (boxbatctr=FSTBATNUM; 
       boxbatctr<nxtbatnum; 
       boxbatctr++)
     { batptr = cnvbathnd(boxbatctr);
       free(batptr);
     }

  /* reclaim memory from box and box attribute structures,
   * and reset their pointers
   */
  /* (code to reclaim memory left out here... */
  nxtboxnum = FSTBOXNUM;  nxtbatnum = FSTBATNUM; 
  curbtmbox = FSTBOXNUM;
}

void
reset_gbox()
{
  
  int   boxbatctr;      /* counts boxes and box attributes in loop */
  struct boxstc* boxptr;    /* actual box pointer */
  struct batstc* batptr;    /* actual bat pointer */

  /* delete any space allocated to boxes and box attributes */
  for (boxbatctr=FSTBOXNUM; boxbatctr<nxtboxnum; boxbatctr++)
     { boxptr = cnvboxhnd(boxbatctr);
       boxptr->expanded = boxptr->included = boxptr->drawn = 0;
     }

  for (boxbatctr=FSTBATNUM; 
       boxbatctr<nxtbatnum; 
       boxbatctr++)
     { batptr = cnvbathnd(boxbatctr);
/*       if (batptr->children)
	 free(batptr->children); */
       batptr->expanded = batptr->numexpand = 0;
     }
}


/* BOX PRIVATE MODULE */


void adjwdwpos(cnt,pos)
  int cnt;	/* count of chars inserted */
  int pos;	/* position of chars inserted */
{
  int i;
  struct boxstc * boxptr;
  struct batstc * batptr;

  for (i=1 ; i < MAXBOXARY ; i++)
    { boxptr = cnvboxhnd(i);
      if (boxptr != IVWNUL) { if (boxptr->scrpos.begpos >= pos)
				 { boxptr->scrpos.begpos += cnt; }
			      if (boxptr->scrpos.endpos >= pos)
				 { boxptr->scrpos.endpos += cnt; }
			    }
    }

  for (i=1 ; i < MAXBATARY ; i++)
    { batptr = cnvbathnd(i);
      if (batptr != IVWNUL) { if (batptr->scrpos.begpos >= pos)
				 { batptr->scrpos.begpos += cnt; }
			      if (batptr->scrpos.endpos >= pos)
				 { batptr->scrpos.endpos += cnt; }
			    }
    }
}


int allbathnd()

{ /* return ++nxtbatnum; */
  return nxtbatnum++;
}

/* allboxhnd.c  -- IDLView -- allocate a new box number
 * 11-Aug-1987  8:30
 *
 * Return the next available box number.
 */


int allboxhnd()

{ /* curtopbox = ++nxtboxnum; */
  /* return curtopbox; */
  return nxtboxnum++;
}

void allnewbat(bat, batptr)
bathnd *bat;
struct batstc **batptr;
{
   /* allocate space for this box attribute*/
   (*batptr) = (struct batstc *)malloc(sizeof(**batptr));
   if ((*batptr) == IVWNUL) { dsperrmsg("INTERNAL ERROR:",
					"allnewbat() failed memory allocation",
			   		0);
                              return;
                            }
   (*batptr)->expanded = 0;
   (*batptr)->attstr = NULL;
   (*batptr)->children = (struct childlist *)NULL;

   /* allocate a number for this box and set it into the structure */
   *bat = allbathnd();
   (*batptr)->thsbat = *bat;

   /* set the pointer for this bat into its handle */
   setbatptr ((*batptr)->thsbat, *batptr);

   /* set default values for new box attribute */
   (*batptr)->battyp           = UNKBATTYP;
   (*batptr)->srcbox           = NULBOX;
   (*batptr)->dstbox	       = NULBOX;
   (*batptr)->valptr.intval    = IVWNUL;
   (*batptr)->cdlatt           = IVWNUL;
   clrscrpos(&(*batptr)->scrpos);
   (*batptr)->setseqcnt        = 0;
   (*batptr)->batlnk           = NULBAT;
}

void allnewbox(box, boxptr)
  boxhnd *box;
  struct boxstc **boxptr;

{
   /* allocate space for this box */
   (*boxptr) = (struct boxstc *)malloc(sizeof(**boxptr));
   if ((*boxptr) == IVWNUL) { printf("IDLView: allnewbox: failed malloc");
                              return;
                            }

   (*boxptr)->batcnt = 0;
   (*boxptr)->expanded = (*boxptr)->included = (*boxptr)->drawn = 0;
   /* allocate a handle for this box */
   *box = allboxhnd();
   /* (*boxptr)->thsbox = *box; */

   /* For the time being, box handle and box number are the same.
    * I wouldn't count on it staying that way...
    */
   (*boxptr)->boxnum = *box; 

   /* set the pointer for this box into its handle */
   setboxptr ( (*box), *boxptr);
   /* setboxptr ((*boxptr)->thsbox, *boxptr); */

   /* set defaults for new box structure */
   (*boxptr)->boxtyp = UNKBOXTYP;
   (*boxptr)->srcbat = NULBAT;
/*   (*boxptr)->cdltypent.Vunknown = IVWNUL; */
   (*boxptr)->lclblk    = IVWNUL;
   (*boxptr)->usradr    = IVWNUL;
   clrscrpos(&((*boxptr)->scrpos));
   (*boxptr)->batlnk    = NULBAT;
   (*boxptr)->setseqnum = -1;
   (*boxptr)->nxtsetseqbox = NULBOX;
   (*boxptr)->setseqllsnodadr = IVWNUL;
   (*boxptr)->attnamwid    = 0;
}

int bldboobox(usrvlu, boxhndptr)
  ptr    usrvlu;	/* address in user's space of node to get */
  boxhnd *boxhndptr;	/* pointer to box built for this node */
		/*DOC-*/
{
  struct boxstc *curboxptr;

  /* allocate a new box */
  allnewbox(boxhndptr, &curboxptr);

  /* set the user's address and the local copy address into the box
   * (and type of box)
   */
  curboxptr->usradr = usrvlu;
  curboxptr->boxtyp = BOOBOXTYP;

  curboxptr->cdltypent = bldbooboxcdl();
}

int bldintbox(usrvlu, boxhndptr)
  ptr    usrvlu;	/* address in user's space of integer */
  boxhnd *boxhndptr;	/* pointer to box built for this node */
		/*DOC-*/
{
  struct boxstc *curboxptr;

  /* allocate a new box */
  allnewbox(boxhndptr, &curboxptr);

  /* set the user's address and the local copy address into the box
   * (and type of box)
   */
  curboxptr->usradr = usrvlu;
  curboxptr->boxtyp = INTBOXTYP;

  curboxptr->cdltypent = bldintboxcdl();
}


int bldnewbat (cdlatt, nodptr, srcbox, newbathnd, batusradr)
  Attribute cdlatt;	/* Candle description of this attribute */
  ptr       nodptr;	/* pointer to user node in our own memory */
  boxhnd    srcbox;	/* source box for this box attribute */
  bathnd   *newbathnd;	/* pointer to box attribute handle */
  ptr	    batusradr;	/* box attribute user address */
{ 

  ptr        	stcptr;		/* one of several types of var */
  int		bytcnt;		/* count of bytes of offset */
  TypeEntity	cdltyp;		/* Candle type entity */
  ptr 		newstr;		/* string pointer */
  ptr		attvalptr;  	/* attribute value pointer if needed */
  int		mchnum;		/* number reflecting match from mchstr */
  struct batstc *batptr;	/* pointer to box attrib structure */

  ivwmsghdr 	ivwmsg;	/* message structure between processes */
  int		msgsts;
  int		*llscntptr;	/* pointer to count of llist structure */
  int		cmmsts;

  cmmsts = IVWTRU;	/* default => communication status is ok */

  /* get a new box attribute structure */
  allnewbat (newbathnd, &batptr);

  /* initialize some values */
  batptr->srcbox = srcbox;	/* init source box number */
  batptr->cdlatt = cdlatt;	/*  and Candle attribute pointer */

  /* calculate address within structure for this attribute */
  stcptr = nodptr; /* init stc pointer with our own address */

  /* bytcnt = ((cdlatt->rep_offset) / 8) + 4; */
  /* bytcnt = (cdlatt->rep_offset) / 8; */ /* up to 25-Mar-1988 */

  bytcnt = (cdlatt->rep_descriptor->rep_offset) / 8;
  addbyt(&stcptr,bytcnt); 	/* add bytes to stcptr */

  /* addbyt(&batusradr,bytcnt);	*/  /* and to user's address */
  /* batptr->usradr = (char*)*(int*)stcptr; */

  /* following line used up until 25-Mar-1989 */
  /* cdltyp = cdlatt->rep_type; */	/* get type pointer */

  if (typeof(cdlatt->rep_descriptor->rep_type)==Kdescriptor)
    { 
         dsperrmsg("Too many levels of indirection.", 
                   "This Candle file may be compiled for Pascal.",
                   0); 
	 cmmsts = IVWFLS;
    }
  else 
  {/* get type pointer */
   cdltyp = cdlatt->rep_descriptor->rep_type.VTypeEntity;	
    
   mchnum = mchstr (cdltyp.IDLclassCommon->rep_name, 
		   "int", "long", "float", "double", "String", "Boolean");

  switch (mchnum)
  { case 1 : /* int -- local copy of structure contains value */
	     batptr->valptr.intval = (int*)stcptr;  
	     addbyt(&batusradr,bytcnt);	/*calc user's address */
	     batptr->usradr = batusradr;
	     break;

    case 2 : /* long -- local copy of structure contains value */
	     batptr->valptr.lngval = (long*)stcptr;
	     addbyt(&batusradr,bytcnt);	/*calc user's address */
	     batptr->usradr = batusradr;
	     break;

    case 3 : /* float -- local copy of structure contains value */
	     batptr->valptr.fltval = (float*)stcptr;
	     addbyt(&batusradr, bytcnt);
             batptr->usradr = batusradr;
	     break;

    case 4 : /* double-precision float.  Not tested */
	     batptr->valptr.dblval = (double*)stcptr; 
             batptr->usradr = (char*)*(int*)stcptr;
	     break;

    case 5 : /* String -- local copy of structure contains
	      * USER'S address of string.  If address non-null,
	      * obtain string from user process.
	      */
             batptr->usradr = (char*)*(int*)stcptr;
	     if (batptr->usradr != IVWNUL) 
	       { cmmsts = getusrstr (batptr->usradr, &newstr);
		 if (cmmsts == IVWTRU) 
		   { batptr->valptr.strptr = newstr; 
		   }
	       }
	     break;

    case 6 : /* Boolean -- local copy of structure contains value */
	     /* (not well-tested; idlc has, at this writing, an
	      * incompatibility between Suns and Vaxes 
	      * which makes Booleans difficult to deal with 
	      */
	     batptr->valptr.booval = (char*)stcptr; 
	     addbyt(&batusradr,bytcnt);	/*calc user's address */
	     batptr->usradr = batusradr;
	     break;

   default : /* not an atomic type */
	     /* local structure contains address of non-atomic */
	     /* batptr->valptr.intval = IVWNUL; */ /*???*/
	     batptr->usradr = (char*)*(int*)stcptr; 

	     /* if this is a set or sequence and its pointer is
	      * not null, obtain its set/sequence count and
	      * put in place.
	      */
	     /* this needs to be replaced with a test of whether 
	      * this attribute is represented by a linked list,
	      * not whether it is a set or sequence
	      */
	     if (typeof(cdltyp) == KSetOf || typeof(cdltyp) == KSeqOf)
	       { if (batptr->usradr == IVWNUL)
		      { batptr->setseqcnt = 0; }
		 else { iniivwmsg(&ivwmsg);
		        ivwmsg.msgtyp = LLSCNTREQ;
		        ivwmsg.adr    = batptr->usradr;
		        cmmsts = sndrcvusrmsg (ivwmsg, &ivwmsg, &llscntptr);
		        if (cmmsts == IVWTRU) batptr->setseqcnt = *llscntptr;
		      }
	       }
   }
   } /* end of 'else' of 'if typeof(...' */
   return cmmsts;	/* return whatever communication status we have */
}


int bldratbox(usrvlu, boxhndptr)
  ptr    usrvlu;	/* address in user's space of node to get */
  boxhnd *boxhndptr;	/* pointer to box built for this node */
		/*DOC-*/
{
  struct boxstc *curboxptr;

  /* allocate a new box */
  allnewbox(boxhndptr, &curboxptr);

  /* set the user's address and the local copy address into the box
   * (and type of box)
   */
  curboxptr->usradr = usrvlu;
  curboxptr->boxtyp = RATBOXTYP;

  curboxptr->cdltypent = bldratboxcdl();
}


int bldstrbox(usradr, boxhndptr)
  ptr    usradr;	/* address in user's space of node to get */
  boxhnd *boxhndptr;	/* pointer to box built for this node */
		/*DOC-*/
{
  int           getsts;    /* status from getting user string */
  ptr          tmpusradr; /* temp pointer to local block for copy of string */
  struct boxstc *curboxptr;

  /* debug */ /* int tmptyp; */	/* find out what 'typeof' returns */

  /* allocate a new box */
  allnewbox(boxhndptr, &curboxptr);

  /* get a copy of the string from the user process
   * set the user's address and the local copy address into the box
   * (and type of box)
   */
  getsts = getusrstr(usradr, &tmpusradr);
  curboxptr->lclblk = tmpusradr;
  curboxptr->usradr = usradr;
  curboxptr->boxtyp = STRBOXTYP;

  curboxptr->cdltypent = bldstrboxcdl();
}


void dspbat (bat, typwid)
  bathnd  bat;		/* handle to box attribute structure */
  int     typwid;	/* width given for the attribute type width */
		/*DOC-*/
{
  struct batstc *batptr;	/* pointer to box attribute structure */
  TypeEntity    typent;		/* type entity for this attribute */

  /* convert box attribute handle to pointer */
  batptr = cnvbathnd(bat);

  /* set beginning position for this attribute */
  setbegdsppos(&(batptr->scrpos));

  /* put indentation before attribute */
  dspstr("      ",CONT);

  /* display syntactic name in given width */
  dspstrwid (batptr->cdlatt->lex_name, typwid,CONT);

  /* WAS: get entity description of attribute */
  /* WAS:  typent = batptr->cdlatt->rep_type; */

  if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
       { /* Error: too many levels of indirection */
	 dsperrmsg("Too many levels of indirection.",
		   "This Candle file may be compiled for Pascal.",
		   0);
       }
  else 
  { /* get entity description of attribute */
    typent = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity;	

  switch (typeof(typent))
  {
    case KAtomic:  dspatmbat (bat);		
		   break;

    case KClass:   dspattclsnam(batptr->cdlatt);      
		   if ((batptr->usradr) == IVWNUL) /* if node uninitialized */
		     { dspstr(" ",CONT);
		       dspnoninistr();	/* display 'uninit' string */
		     }
		   break;

    case KSetOf:   dspattsetnam(batptr->cdlatt); dspstr(" ",CONT);
		   (void) dspnumsetseqelm(batptr->usradr,batptr->setseqcnt);
		   break;

    case KSeqOf:   dspattseqnam(batptr->cdlatt); dspstr(" ",CONT);
		   (void) dspnumsetseqelm(batptr->usradr,batptr->setseqcnt);
		   break;

    /* unknown no longer present */
    /* case Kunknown: */ /* fall through to default */

    default: dsperrmsg("dspbat: INTERNAL ERROR",
			"display of unknown attribute type",
			0);
  }

  dspstr("\n",CONT);

  /* set ending position for this attribute */
  setenddsppos(&(batptr->scrpos));
  }
}

char *getbat (bat, typwid)
  bathnd  bat;		/* handle to box attribute structure */
  int     typwid;	/* width given for the attribute type width */
		/*DOC-*/
{
  struct batstc *batptr;	/* pointer to box attribute structure */
  TypeEntity    typent;		/* type entity for this attribute */
  char *outstr;
  /* convert box attribute handle to pointer */
  batptr = cnvbathnd(bat);
  outstr = (char *)malloc(MAXSTRLNG);

/*  strcpy(outstr, "      ");*/

  /* display syntactic name in given width */
  strcpy(outstr, getstrwid (batptr->cdlatt->lex_name, typwid,CONT));

  /* WAS: get entity description of attribute */
  /* WAS:  typent = batptr->cdlatt->rep_type; */

  if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
       { /* Error: too many levels of indirection */
	 dsperrmsg("Too many levels of indirection.",
		   "This Candle file may be compiled for Pascal.",
		   0);
	 strcpy(outstr, "");
       }
  else 
  { /* get entity description of attribute */
    typent = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity;	

  switch (typeof(typent))
  {
    case KAtomic:  
                   strcat(outstr, getatmbat (bat));
		   break;

    case KClass:   
                   strcat(outstr, getattclsnam(batptr->cdlatt));
		   if ((batptr->usradr) == IVWNUL) /* if node uninitialized */
		     { strcat(outstr," ");
		       strcat(outstr, getnoninistr());	/* display 'uninit' string */
		     }
		   break;

    case KSetOf:   
		   strcat(outstr, getattsetnam(batptr->cdlatt)); 
		   strcat(outstr, " ");
		   strcat(outstr, getnumsetseqelm(batptr->usradr,batptr->setseqcnt));
		   break;

    case KSeqOf:   strcat(outstr, getattseqnam(batptr->cdlatt));
		   strcat(outstr, " ");
		   strcat(outstr, getnumsetseqelm(batptr->usradr,batptr->setseqcnt));
		   break;

    /* unknown no longer present */
    /* case Kunknown: */ /* fall through to default */

    default: dsperrmsg("dspbat: INTERNAL ERROR",
			"display of unknown attribute type",
			0);
  }

  }
  return (outstr);

}

void dspnumsetseqelm(usradr,num)
  ptr usradr;		/* user address of start of set */
  int num;		/* number of elements */
		/*DOC-*/
{ char outstr[25];

  if (usradr == IVWNUL) { dspnoninistr(); }
                   else { sprintf(outstr, " (%d element%s)", num, 
			          ( (num==1) ? "" : "s")
				 );
  	   dspstr(outstr,CONT);
	 }
}

char *getnumsetseqelm(usradr,num)
  ptr usradr;		/* user address of start of set */
  int num;		/* number of elements */
		/*DOC-*/
{ 
  static char outstr[25];

  if (usradr == IVWNUL) 
      strcpy(outstr, getnoninistr()); 
  else 
    sprintf(outstr, " (%d element%s)", num, 
	    ( (num==1) ? "" : "s"));
  return (outstr);
}


int dspatmbat(bat)
  bathnd  bat;		/* handle to atomic box attribute to display */
		/*DOC-*/
{ int        mchnum;	/* number to match which atomic we have */
  struct batstc *batptr;	/* pointer to atomic box attrib to display */
  TypeEntity typ;	/* Candle Entity pointer for attribute */
  int        bytcnt;	/* position of value in bytes for atomic */

  /* convert box attribute handle to bat */
  batptr = cnvbathnd(bat);

/* was:  typ = batptr->cdlatt->rep_type;	/* get type pointer */
  if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
    exit(1);			/* Error: too many levels of indirection */
  typ = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity;	/* get type pointer */
  mchnum = mchstr (typ.IDLclassCommon->rep_name, 
		   "int", "long", "float", "double", "String", "Boolean");

  switch(mchnum)
    { case 1 : dspidlint (*(batptr->valptr.intval));		break;
      case 2 : dspidlint (*(batptr->valptr.lngval));		break;
      case 3 : dspidlrat (*(batptr->valptr.fltval));		break;
      case 5 : dspidlstr (batptr->valptr.strptr);		break;
      case 6 : dspidlboo (*(batptr->valptr.booval));		break;

      default : dspstr (typ.IDLclassCommon->sem_name,CONT);
		dspstr (" (private type)",CONT);
		/*	dsperrmsg("dspbat: INTERNAL ERROR",
		 *	  "display of unsupported atomic type:",
		 *	  typ.IDLclassCommon->sem_name,
		 *	  0);
		 */
    }
}

char *getatmbat(bat)
  bathnd  bat;		/* handle to atomic box attribute to display */
		/*DOC-*/
{ 
  int        mchnum;	/* number to match which atomic we have */
  struct batstc *batptr;	/* pointer to atomic box attrib to display */
  TypeEntity typ;	/* Candle Entity pointer for attribute */
  int        bytcnt;	/* position of value in bytes for atomic */
  static char outstr[25];

  /* convert box attribute handle to bat */
  batptr = cnvbathnd(bat);

/* was:  typ = batptr->cdlatt->rep_type;	/* get type pointer */
  if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
    exit(1);			/* Error: too many levels of indirection */
  typ = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity;	/* get type pointer */
  mchnum = mchstr (typ.IDLclassCommon->rep_name, 
		   "int", "long", "float", "double", "String", "Boolean");

  switch(mchnum)
    { case 1 : strcpy(outstr, getidlint (*(batptr->valptr.intval))); break;
      case 2 : strcpy(outstr, getidlint (*(batptr->valptr.lngval)));		break;
      case 3 : strcpy(outstr, getidlrat (*(batptr->valptr.fltval)));		break;
      case 5 : strcpy(outstr, getidlstr (batptr->valptr.strptr));		break;
      case 6 : strcpy(outstr, getidlboo (*(batptr->valptr.booval)));		break;

      default : strcpy(outstr, typ.IDLclassCommon->sem_name);
		strcat (outstr, " (private type)");
		/*	dsperrmsg("dspbat: INTERNAL ERROR",
		 *	  "display of unsupported atomic type:",
		 *	  typ.IDLclassCommon->sem_name,
		 *	  0);
		 */
    }
  return (outstr);
}

void dspstrwid(str, wid)		/* display string in a given width */
  char * str;		/* string to display */
  int    wid;		/* width to use for display */
		/*DOC-*/
{ 
  int    i;

  dspstr(str,CONT);
  for (i=0; i<(wid - strlen(str)); i++) dspstr(" ",CONT);
}

char *getstrwid(str, wid)		/* display string in a given width */
  char * str;		/* string to display */
  int    wid;		/* width to use for display */
		/*DOC-*/
{ 
  int    i;
  static char outstr[25];

  strcpy(outstr, str);
  for (i=0; i<(wid - strlen(str)); i++) strcat(outstr, " ");
  return (outstr);
}


void dspattsetnam(att)	/* display name of attribute which is a set */
  Attribute att;	/* Candle attribute pointer */
		/*DOC-*/
{ NamedType semcom;	/* semantic component of attribute */

  semcom = (att->rep_descriptor->rep_type.VTypeEntity).VSetOrSeq.IDLclassCommon->sem_component;
  dspstr("{",CONT); dspstr(semcom.IDLclassCommon->sem_name,CONT); dspstr("}",CONT);
}

char *getattsetnam(att)	/* display name of attribute which is a set */
  Attribute att;	/* Candle attribute pointer */
		/*DOC-*/
{ NamedType semcom;	/* semantic component of attribute */
  static char outstr[25];

  semcom = (att->rep_descriptor->rep_type.VTypeEntity).VSetOrSeq.IDLclassCommon->sem_component;
  strcpy(outstr, "{"); strcat(outstr, semcom.IDLclassCommon->sem_name,CONT); 
  strcat(outstr, "}");
  return (outstr);
}

void dspattseqnam(att)	/* display name of attribute which is a sequence */
  Attribute att;	/* Candle attribute pointer */
{ NamedType semcom;	/* semantic component of attribute */

  semcom = (att->rep_descriptor->rep_type.VTypeEntity).VSetOrSeq.IDLclassCommon->sem_component;
  dspstr("<",CONT); dspstr(semcom.IDLclassCommon->sem_name,CONT); dspstr(">",CONT);
}

void dspattclsnam(att)	/* display name of attribute which is a class (?) */
  Attribute att;
{ dspstr("[",CONT);
/* was:dspstr(att->rep_type.IDLclassCommon->rep_name); */
  dspstr((char *)att->syn_type.IDLclassCommon->sem_entity.VClass->rep_name,CONT);
  dspstr("]",CONT);
}

void dspattunknam(att)	/* display msg for unknown attribute type */
Attribute att;
{ dspstr("unknown attribute...",CONT);
}

char *getattseqnam(att)	/* display name of attribute which is a sequence */
  Attribute att;	/* Candle attribute pointer */
{ NamedType semcom;	/* semantic component of attribute */
  static char outstr[25];

  semcom = (att->rep_descriptor->rep_type.VTypeEntity).VSetOrSeq.IDLclassCommon->sem_component;
  strcpy(outstr, "<"); strcat(outstr, semcom.IDLclassCommon->sem_name,CONT); 
  strcat(outstr, ">");
  return (outstr);
}

char *getattclsnam(att)	/* display name of attribute which is a class (?) */
  Attribute att;
{ 
  static char outstr[25];

  strcpy(outstr, "[");
/* was:dspstr(att->rep_type.IDLclassCommon->rep_name); */
  strcat(outstr, (char *)att->syn_type.IDLclassCommon->sem_entity.VClass->rep_name);
  strcat(outstr, "]");
  return (outstr);
}

char *getattunknam(att)	/* display msg for unknown attribute type */
Attribute att;

{ 
  static char outstr[25];

  strcat(outstr, "unknown attribute...");
  return (outstr);
}

int dspbox(newbox)
  boxhnd newbox;
{
   int typwid;			/* width of attribute type name */
   bathnd bat;	 		/* handle of box attribute structure */
   struct batstc *batptr;	/* pointer to box attrib structure */
   struct boxstc *newboxptr;	/* pointer to box structure to display */

   Attribute curatt;
   SEQAttribute rematt;
   TypeEntity curtyp;

   /* remove old box from display */
   /* !!! */
   dspstr("",NEW);
   /* set window insert position for new box */
   setdspposend();

   /* get pointer to this box */
   newboxptr = cnvboxhnd(newbox);

   /* set beginning display position */
   setbegdsppos(&(newboxptr->scrpos));

   /* display header for this box */
   dspboxhdr (newbox);

   /* display the box according to what kind it is */
   switch (newboxptr->boxtyp)
   { case NODBOXTYP:
	/* display node box */
	/* first calculate the width in which to display the
	 * attribute names.  Set that width into the box
	 * structure for this node.
	 */
	typwid = 0;
	bat = newboxptr->batlnk;
	while (bat != NULBAT)
	  { batptr = cnvbathnd(bat);
	    typwid = intmax(typwid, strlen(batptr->cdlatt->lex_name));
	    bat    = batptr->batlnk;
	  }
	typwid++; /* add one to width to get space between name and value */

	/* assign the calculated width into which attribute names
	 * go into the box
	 */
	newboxptr->attnamwid = typwid + strlen(INDSTR);

	/* now display each attribute, using the calced width */
	bat = newboxptr->batlnk;	/* init box attribute pointer */
	while (bat != NULBAT)	/* until end of the list */
	{ dspbat (bat, typwid);	/* display this box attrib */
	  batptr = cnvbathnd (bat); /* conv box att to pointer */
	  bat = batptr->batlnk;	/* and get next box attrib */
	}

	break;

      case STRBOXTYP: dspstr(INDSTR,CONT);
		      dspidlstr(newboxptr->lclblk); 
/*		      dspstr("\n"); */
		      break;

      case BOOBOXTYP: dspstr(INDSTR,CONT);
		      dspidlboo(newboxptr->usradr);
		      break;

      case INTBOXTYP: dspstr(INDSTR,CONT);
		      dspidlint(newboxptr->usradr);
		      break;

      case RATBOXTYP: dspstr(INDSTR,CONT);
		      dspidlrat(newboxptr->usradr);
		      break;

      default: dsperrmsg("display of unsupported box type",0);
    }

   setenddsppos(&(newboxptr->scrpos));
   dspstr("\n",CONT);
   dspstr("",END);
   return;
}

/* This function displays boxes in graphical form */
void
dspgbox(newbox)
     boxhnd newbox;
{
   int typwid;			/* width of attribute type name */
   int batcnt;                  /* count of bat in box */
   bathnd bat;	 		/* handle of box attribute structure */
   struct batstc *batptr;	/* pointer to box attrib structure */
   struct boxstc *newboxptr;	/* pointer to box structure to display */

   Attribute curatt;
   SEQAttribute rematt;
   TypeEntity curtyp;

   /* get pointer to this box */
   newboxptr = cnvboxhnd(newbox);
   if (newboxptr->drawn) return;
   /* get header for this box and store in box structure */
   newboxptr->hdr = getboxhdr (newbox);

   /* display the box according to what kind it is */
   switch (newboxptr->boxtyp)
   { case NODBOXTYP:
	/* display node box */
	/* first calculate the width in which to display the
	 * attribute names.  Set that width into the box
	 * structure for this node.
	 */
	typwid = 0;
	batcnt = 0;
	bat = newboxptr->batlnk;
	while (bat != NULBAT)
	  { 
	    batcnt++;
	    batptr = cnvbathnd(bat);
	    typwid = intmax(typwid, strlen(batptr->cdlatt->lex_name));
	    bat    = batptr->batlnk;
	  }
	newboxptr->batcnt = batcnt;

	typwid++; /* add one to width to get space between name and value */

	/* assign the calculated width into which attribute names
	 * go into the box
	 */
	newboxptr->attnamwid = typwid + strlen(INDSTR);

	/* now display each attribute, using the calced width */
	newboxptr->batwid = 0;
	bat = newboxptr->batlnk;	/* init box attribute pointer */
	while (bat != NULBAT)	/* until end of the list */
	{ 
	  batptr = cnvbathnd (bat); /* conv box att to pointer */
	  batptr->attstr = getbat (bat, typwid);	/* display this box attrib */
	  if (strlen(batptr->attstr) > newboxptr->batwid)
	    newboxptr->batwid = strlen(batptr->attstr);
	  bat = batptr->batlnk;	/* and get next box attrib */
	}

	break;

      case STRBOXTYP: 
/*	dspstr(INDSTR,CONT); */
	newboxptr->batcnt = 1;
	newboxptr->nonnodstr = getidlstr(newboxptr->lclblk); 
	newboxptr->batwid = strlen(newboxptr->nonnodstr);
	break;

      case BOOBOXTYP: 
/*	dspstr(INDSTR,CONT); */
	newboxptr->batcnt = 1;

	newboxptr->nonnodstr = getidlboo(newboxptr->usradr);
	newboxptr->batwid = strlen(newboxptr->nonnodstr);
	break;

      case INTBOXTYP: 
/*	dspstr(INDSTR,CONT); */
	newboxptr->batcnt = 1;

	newboxptr->nonnodstr = getidlint(newboxptr->usradr);
	newboxptr->batwid = strlen(newboxptr->nonnodstr);
	break;

      case RATBOXTYP: 
/*	dspstr(INDSTR,CONT); */
	newboxptr->batcnt = 1;
	
	newboxptr->nonnodstr = getidlrat(newboxptr->usradr);
	newboxptr->batwid = strlen(newboxptr->nonnodstr);
	break;

      default: 
	dsperrmsg("display of unsupported box type",0);
    }

   return;
}

void dspboxhdr (box)
boxhnd box;

{ char outstr[100];

  struct boxstc *boxptr;
  struct batstc *srcbatptr;	/* attribute pointing to this box */
  struct boxstc *srcboxptr;	/*  and box pointing to that attribute */

  char * prestr;	/* 'pre-string' -- goes ahead of source box type */
  char * pststr;	/* 'post-string' -- goes behind source box type */

  boxptr = cnvboxhnd(box);	/* get pointer to box */

  if (boxptr->srcbat == NULBOX)
	 { sprintf(outstr, "(%d) %s is ROOT DISPLAY NODE",
			boxptr->boxnum,
			boxptr->cdltypent.IDLclassCommon->sem_name);
	 }
    else { /* get pointer to source box attribute, and pointer to its box */
           srcbatptr = cnvbathnd(boxptr->srcbat);
           srcboxptr = cnvboxhnd(srcbatptr->srcbox);

           if (boxptr->setseqnum == -1)
		 /* box is not member of set or sequence */
	         { sprintf(outstr, "(%d) %s is (%d).%s",
			boxptr->boxnum,
			boxptr->cdltypent.IDLclassCommon->sem_name,
			srcboxptr->boxnum,  /* used to be `thsbox' */
			srcbatptr->cdlatt->lex_name);
	         }

	     else  /* box is member of set/sequence */
		 { sprintf(outstr, "(%d) %s is element %d of (%d).%s",
			boxptr->boxnum,
			boxptr->cdltypent.IDLclassCommon->sem_name,
			boxptr->setseqnum,
			srcboxptr->boxnum,  /* used to be `thsbox' */
			srcbatptr->cdlatt->lex_name);
	          }
         }

  dspstr(outstr,CONT);
  dspstr("\n      --------------------",CONT);
  if (dflprt != IVWNUL) { dspstr(" (through port ",CONT); dspstr(dflprt->lex_name,CONT);
			  dspstr(")",CONT);
			}
  dspstr("\n",CONT);
}

char *getboxhdr (box)
boxhnd box;

{ 
  char *outstr;

  struct boxstc *boxptr;
  struct batstc *srcbatptr;	/* attribute pointing to this box */
  struct boxstc *srcboxptr;	/*  and box pointing to that attribute */

  char * prestr;	/* 'pre-string' -- goes ahead of source box type */
  char * pststr;	/* 'post-string' -- goes behind source box type */

  boxptr = cnvboxhnd(box);	/* get pointer to box */
  outstr = (char *)malloc (MAXSTRLNG);
  if (boxptr->srcbat == NULBOX)
	 { sprintf(outstr, "(%d) %s",
			boxptr->boxnum,
			boxptr->cdltypent.IDLclassCommon->sem_name);
	 }
    else { /* get pointer to source box attribute, and pointer to its box */
           srcbatptr = cnvbathnd(boxptr->srcbat);
           srcboxptr = cnvboxhnd(srcbatptr->srcbox);

           if (boxptr->setseqnum == -1)
		 /* box is not member of set or sequence */
	         { sprintf(outstr, "(%d) %s",
			boxptr->boxnum,
			boxptr->cdltypent.IDLclassCommon->sem_name);
	         }

	     else  /* box is member of set/sequence */
		 { sprintf(outstr, "(%d) %s",
			boxptr->boxnum,
			boxptr->cdltypent.IDLclassCommon->sem_name);
	          }
         }

  if (dflprt != IVWNUL) { strcat(outstr," (through port");  
			  strcat(outstr, dflprt->lex_name,CONT);
			  strcat(outstr, ")");
			}
  return (outstr);
}


int expllssetseq(srcbox, srcbat, newboxptr, level, ret)
  boxhnd srcbox;	/* box which cursor pointed to when option selected */
  bathnd srcbat;	/* box attribute pointed to when option selected */
  boxhnd *newboxptr;	/* handle of (first) box we expand to */
  int    level;
  int    *ret;

{
  struct boxstc *srcboxptr;
  struct batstc *srcbatptr;

  Attribute	cmpatt;		/* component Attribute */
  NamedType	cmpnmdtyp;	/* component Named Type */
  nmdtyptyp	cmptyp;		/* type of component of set */

  int		getsts;		/* status from getusrblk */

  /* node for each linked list elm */
  typedef struct { ptr nxtadr; ptr vlu; } llsnod; 
  llsnod	*llsnodptr;

  ptr		usrllsnodadr;	/* address of 'current' llist node */
  int		curelmnum;	/* number of 'current' element */

  boxhnd	cmpbox;		/* box for 'current' component element */
  struct boxstc *cmpboxptr;	/* and pointer to the structure */

  /* START OF CODE */
  /* convert both box and box attribute to pointers */
  *ret = 1;
  srcboxptr = cnvboxhnd(srcbox);
  srcbatptr = cnvbathnd(srcbat);

  /* make sure the pointer to the first element is not nil;
   * if it is, report empty set and exit.  
   */
  if (srcbatptr->usradr == IVWNUL)
    { 
      if ( display_mode != GLOBAL_GRAPHICS &&
   	   display_mode != INCREMENTAL_GRAPHICS)
	dsperrmsg("Set/Sequence is uninitialized",0); 
      return IVWFLS; 
    }

  cmpatt = srcbatptr->cdlatt; /* get attribute of component,
			       * then named type of component
			       */
  /* WAS: cmpnmdtyp = 
     cmpatt->rep_type.VSetOrSeq.IDLclassCommon->sem_component; */
  cmpnmdtyp = 
    cmpatt->rep_descriptor->rep_type.VSetOrSeq.IDLclassCommon->sem_component;
  cmptyp = typnmdtyp(cmpnmdtyp); /* now type of named type of component */

  /* set address for 1st llist node */
  /* and number of first element */
  usrllsnodadr = srcbatptr->valptr.strptr; /*old*/
  usrllsnodadr = srcbatptr->usradr;
  curelmnum = 1;

  /* loop while the user's addresses are non-null */
  while (usrllsnodadr != IVWNUL)
    { 
      /* get the llist node from the user */
      getsts = getusrblk (usrllsnodadr, sizeof(*llsnodptr), &llsnodptr);
      if (getsts == IVWFLS) return getsts;
      
      /* Build a box for this element.  
       * (includes getting block from memory if necessary)
       */
      switch (cmptyp)
	{ case NODNMDTYP: bldnodbox (llsnodptr->vlu, &cmpbox); break;
	case STRNMDTYP: bldstrbox (llsnodptr->vlu, &cmpbox); break;
	case INTNMDTYP: bldintbox (llsnodptr->vlu, &cmpbox); break;
	case BOONMDTYP: bldboobox (llsnodptr->vlu, &cmpbox); break;
	case RATNMDTYP: bldratbox (llsnodptr->vlu, &cmpbox); break;
	default:        dsperrmsg("Unimplemented Llist component type",
				  sprintf("type %d",cmptyp),
				  0);
	}
      
      /* if we haven't filled in the handle of the box being
       * expanded to, do so now
       */
      if ((*newboxptr) == NULBOX) (*newboxptr) = cmpbox;
      
      /* convert box handle 
       * and initialize source box, element number, and
       * address of node.
       */
      cmpboxptr = cnvboxhnd(cmpbox);
      cmpboxptr->srcbat    = srcbat;
      cmpboxptr->setseqnum = curelmnum++;
      cmpboxptr->usradr    = llsnodptr->vlu;
      cmpboxptr->setseqllsnodadr = usrllsnodadr; /* set val of addr of node */
      if (!cmpboxptr->included && display_mode == GLOBAL_GRAPHICS ||
	  display_mode == INCREMENTAL_GRAPHICS)
	insert_childlst (srcbat, cmpbox);
      /* display this box */
      /* if text mode */
      if (display_mode == GLOBAL_GRAPHICS)
	{
	  insert_globallst (cmpbox, level);
	  if (remove_tmplst (*newboxptr) == 0)
	    {
	      *ret = 0;
	      return IVWTRU;
	    }
	}
      else if (!cmpboxptr->included && display_mode == INCREMENTAL_GRAPHICS)
	insert_lvllst (cmpbox, level);
      else if (display_mode == TEXT)
	dspbox(cmpbox);
      cmpboxptr->included = 1;
      
      /* load pointer to next element in the set */
      usrllsnodadr = llsnodptr->nxtadr;
      
    } /* end of 'while (usrllselm != IVWNUL)' */

    /* update scroll bar from this set */
    updskrbar();

    /* return successful completion status */
    return IVWTRU;
}

int expnodatt(box,bat,newboxptr, level, ret)
  boxhnd box;	/* box containing attribute being expanded */
  bathnd bat;	/* box attribute being expanded */
  boxhnd *newboxptr;
  int    level;
  int    *ret;

{
  int		 bldsts;    /* status from building of node box */
  int		 dspsts;    /* display status */
  struct batstc *batptr;
  struct boxstc *nodboxptr;

  *ret = 1;
  /* convert the box attribute handle being expanded */
  batptr = cnvbathnd(bat);

  if ((batptr->usradr) == IVWNUL && display_mode == TEXT)
    { dsperrmsg ("Node is uninitialized",0);
      return;
    }

  /* build display box for this node */
  bldsts = bldnodbox (batptr->usradr, newboxptr); 
  if (bldsts == IVWFLS) return bldsts;

  nodboxptr = cnvboxhnd(*newboxptr);
  nodboxptr->srcbat = bat;	     /* set source box attribute into new box */

  if (!batptr->expanded && (display_mode == GLOBAL_GRAPHICS ||
			    display_mode == INCREMENTAL_GRAPHICS))
    insert_childlst (bat, *newboxptr);

  /* if text mode */
  if (/*!batptr->expanded && */display_mode == GLOBAL_GRAPHICS)
    {
      insert_globallst (*newboxptr, level);
      if (remove_tmplst (*newboxptr) == 0)
	{
	  *ret = 0;
	  return IVWTRU;
	}
    }
  else if (!batptr->expanded && display_mode == INCREMENTAL_GRAPHICS)
    {
      insert_lvllst (*newboxptr, level);
#ifdef DEBUG
      printf("expnodatt: inserting newbox %d into lvllst level %d\n", *newboxptr, level);
      fflush(stdout);
#endif
    }
  else if (display_mode == TEXT)
    dspsts = dspbox(*newboxptr);	/* set up the box for display    */
/*  batptr->expanded = 1;  */
  dspsts = updskrbar();			/*  and update the scroll bar(s) */

  /* return successful completion */
  return IVWTRU;
}

int mchstr(tgt, one, two, three, four, five, six)
char * tgt;
char * one;
char * two;
char * three;
char * four;
char * five;
{
  if (strcmp(tgt,one)  ==0) return 1;
  if (strcmp(tgt,two)  ==0) return 2;
  if (strcmp(tgt,three)==0) return 3;
  if (strcmp(tgt,four) ==0) return 4;
  if (strcmp(tgt,five) ==0) return 5;
  if (strcmp(tgt,six)  ==0) return 6;
  return 0;
}

void setbatptr (bat, batptr)
  bathnd bat;
  struct batstc *batptr;
{
  if (bat < 0 || bat > MAXBATARY) 
         { dsperrmsg("INTERNAL ERROR",
		     "setbatptr received illegal bat number",
		     0); 
	 }
    else { batary[bat] = batptr; }
}

void setboxptr (box, boxptr)
  int box;
  struct boxstc *boxptr;
{
  if (box < 0 || box > MAXBOXARY) 
         { dsperrmsg("INTERNAL ERROR",
			"setboxptr received illegal box number",0); 
	 }
    else { boxary[box] = boxptr; }
}

int dspidlstr(strptr)
  ptr strptr;

{ int cnt; 
  if (strptr == IVWNUL) {/*cnt = */dspnoninistr();}
		   else {dspstr("\"",CONT);/* cnt =*/ dspstr(strptr,CONT);
			 dspstr("\"",CONT);
			 cnt = cnt + 2;
			}
  return cnt;
}

char *getidlstr(strptr)
  ptr strptr;

{ int cnt; 
  static char outstr[25];

  if (strptr == IVWNUL) 
    /*cnt = */strcpy(outstr, getnoninistr());
  else 
    { strcpy(outstr, "\"");/* cnt =*/ 
      strcat(outstr, strptr);
      strcat(outstr, "\"");
/*      cnt = cnt + 2; */
    }
  return outstr;
}



int dspidlboo(vlu)
  char vlu;
{ 

  if (vlu) { dspstr("TRUE",CONT);  return 4; }
      else { dspstr("FALSE",CONT); return 5; }
}


int dspidlint(vlu)
  int vlu;
{ char outstr[25];
  int  cnt;

  sprintf (outstr, "%d", vlu);
  cnt = dspstr(outstr,CONT);
  return cnt;
}

int dspidlrat(vlu)
  float vlu;
{ char outstr[50];
  int  cnt;

  sprintf (outstr, "%#g", vlu); /* "#" flag insures decimal point */
  cnt = dspstr(outstr,CONT);
  return cnt;
}


void dspnoninistr()
{ dspstr("(uninitialized)",CONT);
}

char *getidlboo(vlu)
  char vlu;
{ 

  static char outstr[25];

  if (vlu) 
    strcpy(outstr, "TRUE");
  else  
    strcpy(outstr, "FALSE");

  return (outstr);
}


char *getidlint(vlu)
  int vlu;
{ 
  static char outstr[25];

  sprintf (outstr, "%d", vlu);
  return (outstr);;
}

char *getidlrat(vlu)
  float vlu;
{ 
  static char outstr[25];

  sprintf (outstr, "%#g", vlu); /* "#" flag insures decimal point */
  return (outstr);;
}


char *getnoninistr()
{ 
  static char outstr[25];

  strcpy(outstr, "(uninitialized)");
  return (outstr);
}

int fndcrsobj(scrpos, box, bat, batpos)
  struct scrposstc scrpos;
  boxhnd   	   *box;
  bathnd   	   *bat;
  int		   *batpos;	/* 1=first part of bat, 2=second */

{
  struct boxstc *boxptr;	/* pointer to successive boxes */
  struct batstc *batptr;	/* pointer to successive box attributes */

  boxptr = NULL;
  batptr = NULL;
  (*box) = FSTBOXNUM;		/* start at first box */
  boxptr = cnvboxhnd (*box);	/* (converted to pointer) */

  /* the screen position passed in actually has the text
   * subwindow index for the start of the line containing
   * the cursor in the 'beginning' position.  This will
   * likely get more exciting in the graphics version.
   */
  while ( (boxptr != IVWNUL) && 
	  (boxptr->scrpos.endpos < scrpos.begpos) 
	)
    { (*box)++;
      boxptr = cnvboxhnd(*box);
    }

  if ( boxptr == IVWNUL)
         { (*box) = NULBOX;
	   (*bat) = NULBAT;
	   (*batpos) = 0;
           return 0;			/* return 'no object found' */
         }
    else 
	 /* starting from the current box, search box attributes
	  * the last box attribute will have NULBAT as a box attrib
	  * handle, ending the search.
	  */
	 { (*bat) = boxptr->batlnk;
	   batptr = cnvbathnd(*bat);
	   while ((*bat) != NULBAT &&
	          ( (batptr->scrpos.endpos < scrpos.begpos) ||
		    (batptr->scrpos.begpos > scrpos.begpos)
		  )
		 )
	     { (*bat) = batptr->batlnk;
	       batptr = cnvbathnd(*bat); /* pointer goes null on null bat */
	     }

	   /* if we're past all the box attribute structures,
	    * or past the ones for this box,
	    * return flag that we found box
	    * but not box attrib.  Otherwise, set correct box attrib
	    * handle and return flag that we found both.
	    */
	   if ((*bat) == NULBAT) { *bat = NULBAT;
				   (*batpos) = 0;
		                   return 1;
		                 }
	     else { /* (*bat) = batptr->thsbat; */ /* do we need this? */
		    if (boxptr->attnamwid > (scrpos.begpos - 
						batptr->scrpos.begpos))
			   (*batpos) = 1;
		      else (*batpos) = 2;
		    return 2;
		  }
	 }
}

struct boxstc *cnvboxhnd(box)
  boxhnd box;
{ if (box==NULBOX) return (struct boxstc*)IVWNUL;
    else if (box >= 0 && box <= MAXBOXARY) return (boxary[box]);
    else dsperrmsg("INTERNAL ERROR:",
		   "cnvboxhnd() received bad box handle",
		   0);
}

struct batstc *cnvbathnd(bat)
  bathnd bat;
{ if (bat==NULBAT) return (struct batstc*)IVWNUL;
    else if (bat >= 0 && bat <= MAXBATARY) return (batary[bat]);
    else dsperrmsg("INTERNAL ERROR:", 
		   "cnvbathnd() received bad box attribute handle",
		   0);
}

int intmax(x,y)		/* determine maximum of two integers */
int x,y;
		/*DOC-*/
{ if (x<y) return y; else return x;
}

void setdflprt(select_port)
char *select_port;
{
  Port prtlist[MAXPORT];
  int prtnum, i;

  if(strcmp(select_port, "Invariant") == 0)
    {
      dflprt = IVWNUL;
      chgprtnam(IVWNUL);
      return;
    }
  setprtmnucdl(prtlist, &prtnum);
  for(i=0; i<prtnum;i++)
    {
      if(strcmp(select_port, prtlist[i]->lex_name) == 0)
	{
	  dflprt = (Port)prtlist[i];
	  if (dflprt==IVWNUL) chgprtnam(IVWNUL);
	  else chgprtnam (dflprt->lex_name);
	}
    }
}


void drwgbox(newbox)
     boxhnd newbox;

{

  struct boxstc *newboxptr;
  struct batstc *batptr;
  bathnd bat;

  newboxptr = cnvboxhnd(newbox);
  switch(newboxptr->boxtyp)
  { case NODBOXTYP:
        /* display node box */
        /* first calculate the width in which to display the
         * attribute names.  Set that width into the box
         * structure for this node.
         */
      bat = newboxptr->batlnk; /* init box attribute pointer */
        while (bat != NULBAT)   /* until end of the list */
        { 
          batptr = cnvbathnd (bat); /* conv box att to pointer */
          bat = batptr->batlnk; /* and get next box attrib */
        }

        break;
      case STRBOXTYP: 
       break;

      case BOOBOXTYP: 
       break;

      case INTBOXTYP: 
       break;

      case RATBOXTYP: 
       break;

      default: dsperrmsg("display of unsupported box type",0);
    }
}


void 
insert_freezelst (lst, box, level)
     struct level_list **lst;
     boxhnd box;
     int level;

{

  struct boxnode *node;

#ifdef DEBUG
  printf("insert_freezelst: inserting box %d into level %d\n", box, level);
  fflush(stdout);
#endif

  node = (struct boxnode *)malloc(sizeof(struct boxnode));
  if ( lst[level] == NULL)
    {
      lst[level] = (struct level_list *)
	malloc(sizeof(struct level_list));
      lst[level]->nodlst = NULL;
      lst[level]->tail = NULL;
    }

  if (lst[level]->nodlst == NULL)
    {
      node->hnd = box;
      node->next = NULL;

      lst[level]->count = 1;
      lst[level]->nodlst = node;
      lst[level]->tail = node;
    }
  else
    {
      node->hnd = box;
      node->next = NULL;
      
      lst[level]->count++;
      lst[level]->tail->next = node;
      lst[level]->tail = node;
    }
}


void 
insert_tmplst (box, usradr)
     boxhnd box;
     ptr usradr;

{

  struct boxnode *node;
  int level;

#ifdef DEBUG
  printf("box %d inserted into tmplst\n", box);
  fflush(stdout);
#endif

  node = (struct boxnode *)malloc(sizeof(struct boxnode));
  if ( tmplst== NULL)
    {
      tmplst = (struct level_list *)
	malloc(sizeof(struct level_list));
      tmplst->nodlst = NULL;
      tmplst->tail = NULL;
    }

  if (tmplst->nodlst == NULL)
    {
      node->hnd = box;
      node->next = NULL;
      node->usradr = usradr;

      tmplst->count = 1;
      tmplst->nodlst = node;
      tmplst->tail = node;
    }
  else
    {
      node->hnd = box;
      node->next = NULL;
      node->usradr = usradr;
      
      tmplst->count++;
      tmplst->tail->next = node;
      tmplst->tail = node;
    }
}


int node_present (node)
     struct boxnode *node;

{
  struct boxstc *nodeptr, *boxptr;
  struct boxnode *box;

  nodeptr = cnvboxhnd (node->hnd);
  for (box = tmplst->nodlst; box != NULL; box = box->next)
    {
/*      boxptr = cnvboxhnd(box->hnd);*/
      if (nodeptr->usradr == box->usradr)
	return 1;
    }
  return 0;
}

int remove_tmplst(node)
     boxhnd node;
{
  struct boxnode *box;
  struct boxstc *nodeptr;

  if (!tmplst || !tmplst->nodlst) return 0;

  nodeptr = cnvboxhnd (node);
  if (tmplst->nodlst->usradr == nodeptr->usradr)
    {
      tmplst->nodlst = tmplst->nodlst->next;
      if (!tmplst->nodlst) return 0;
      else return 1;
    }
  for (box = tmplst->nodlst; box!= NULL;box = box->next)
    {
      if (!box->next)
	return 1;
      if (nodeptr->usradr == box->next->usradr)
	{
	  box->next = box->next->next;
	  break;
	}
    }
  if (!tmplst->nodlst) return 0;
  else return 1;
}


void delete_globallst (boxnode, level)
     struct boxnode *boxnode;
     int level;
{
  struct boxnode *node;

  if (globallst[level]->nodlst == boxnode)
    globallst[level]->nodlst = globallst[level]->nodlst->next;

  for (node = globallst[level]->nodlst; node != NULL; node = node->next)
    if (node->next == boxnode)
      node->next = node->next->next;
  /* free the deleted node */
}


void 
insert_globallst (box, level)
     boxhnd box;
     int level;

{

  struct boxnode *node;

#ifdef DEBUG
  printf("insert_globallst: inserting box %d into level %d\n", box, level);
  fflush(stdout);
#endif

  node = (struct boxnode *)malloc(sizeof(struct boxnode));
  if ( globallst[level] == NULL)
    {
      globallst[level] = (struct level_list *)
	malloc(sizeof(struct level_list));
      globallst[level]->nodlst = NULL;
      globallst[level]->tail = NULL;
    }

  if (globallst[level]->nodlst == NULL)
    {
      node->hnd = box;
      node->next = NULL;

      globallst[level]->count = 1;
      globallst[level]->nodlst = node;
      globallst[level]->tail = node;
    }
  else
    {
      node->hnd = box;
      node->next = NULL;
      
      globallst[level]->count++;
      globallst[level]->tail->next = node;
      globallst[level]->tail = node;
    }
}


void 
insert_lvllst (box, level)
     boxhnd box;
     int level;

{

  struct boxnode *node;
  static int lvlcnt;

#ifdef DEBUG
  printf("insert_lvllst: inserting box %d into level %d\n", box, level);
  fflush(stdout);
#endif

  node = (struct boxnode *)malloc(sizeof(struct boxnode));
  if ( lvllst[level] == NULL)
    {
      lvllst[level] = (struct level_list *)
	malloc(sizeof(struct level_list));
      lvllst[level]->nodlst = NULL;
      lvllst[level]->tail = NULL;
    }
  
  if (lvllst[level]->nodlst == NULL)
    {
      node->hnd = box;
      node->next = NULL;
      lvlcnt = 1;
      lvllst[level]->count = 1;
      lvllst[level]->nodlst = node;
      lvllst[level]->tail = node;
    }
  else
    {
      lvlcnt++;
      node->hnd = box;
      node->next = (struct boxnode *)NULL;
      
      lvllst[level]->count++;
      lvllst[level]->tail->next = node;
      lvllst[level]->tail = node;
      if (lvlcnt >= maxcolumn)
	level_flag = 1;
    }

}


void 
insert_childlst (bat, newbox)
     bathnd bat;
     boxhnd newbox;

{
  
  struct childnode *node;
  struct batstc *batptr;

  node = (struct childnode *)malloc(sizeof(struct childnode));
  batptr = cnvbathnd(bat);

  if (batptr->children  == (struct childlist *)NULL)
    {
      batptr->children = (struct childlist *)
	malloc(sizeof(struct childlist));
      batptr->children->nodlst = (struct childnode *)NULL;
      batptr->children->tail = (struct childnode *)NULL;
      batptr->children->count = 0;
    }

  if (batptr->children->nodlst == (struct childnode *)NULL)
    {
      node->hnd = newbox;
      node->next = (struct childnode *)NULL;

      batptr->children->count = 1;
      batptr->children->nodlst = node;
      batptr->children->tail = node;
    }
  else
    {
      node->hnd = newbox;
      node->next = NULL;

      batptr->children->count++;
      batptr->children->tail->next = node;
      batptr->children->tail = node;
    }
}

void 
drwlvl (widget, level)
int widget;
int level;
{
  int cumul_width, max_height, width, height;
  int center_above, start_point, i, first;
  int arrow_x1, arrow_y1, arrow_x2, arrow_y2;
  struct boxnode *node;
  struct boxstc *nodeptr;
  struct batstc *batptr, *srcbatptr;
  bathnd bat;
  struct gscrposstc scrpos;
  struct level_list **lst;

#ifdef DEBUG
  printf("drwlvl: drwing level %d\n", level);
  fflush(stdout);
#endif

  if (globallst[level] == NULL || 
      globallst[level]->nodlst == NULL)
    return;

  cumul_width = 0;
  max_height  = 0;
  if (display_mode == INCREMENTAL_GRAPHICS)
    {
      if (wdw[currentx][currenty]->bottom_level > bottommost)
	bottommost = wdw[currentx][currenty]->bottom_level;
      if (wdw[currentx][currenty]->right > rightmost)
	rightmost = wdw[currentx][currenty]->right;
    }

  for (node = globallst[level]->nodlst; 
       node != NULL; node = node->next)
    {
      nodeptr = cnvboxhnd(node->hnd);
      if (nodeptr->batwid > strlen(nodeptr->hdr))
	width  = getbatwidth (nodeptr->batwid);/* highest width of bat in box in pixels */
      else
	width = getbatwidth (strlen(nodeptr->hdr));
      width += 2*INTRABOXWIDTH;                 /* gap between box and text inside */

      height = getbatheight ();               /* height of bat in pixels */
      height = (nodeptr->batcnt + 1)*height;     /* height of box */
      
      nodeptr->gscrpos.width  = width;
      nodeptr->gscrpos.height = height;

      if (max_height < height)
	max_height = height;

      cumul_width += width + INTERBOXGAP;

    }

  if (level == 0) /* root node */
    {
      if (display_mode == GLOBAL_GRAPHICS)
	globallst[level]->minx = GROOT_XLOCATION - (int)rint((double)cumul_width/2.0);
      else
	globallst[level]->minx = (int)rint((double)cumul_width/2) + 
	                         (int)rint(scrwidth/2.0);
      globallst[level]->maxx = globallst[level]->minx + cumul_width;
      globallst[level]->miny = ROOT_YLOCATION;
      globallst[level]->maxy = globallst[level]->miny + max_height;
    }
  else
    {
      center_above = (int)rint((double)(globallst [level-1]->maxx - 
			   globallst[level-1]->minx)/2) + 
			     globallst[level-1]->minx;

      globallst[level]->minx = center_above - (int)rint((double)cumul_width/2);
      globallst[level]->maxx = globallst[level]->minx + cumul_width;
      globallst[level]->miny = globallst[level-1]->maxy + INTERROWGAP;
      globallst[level]->maxy = globallst[level]->miny + max_height;
    }

  if (display_mode == INCREMENTAL_GRAPHICS)
    {
      if (wdw[currentx][currenty]->maxx < globallst[level]->maxx)
	wdw[currentx][currenty]->maxx = globallst[level]->maxx;
    }

  start_point = globallst[level]->minx;
  /*  for (node = globallst[level]->nodlst; node != NULL; node = node->next) */
  if (globallst[level] != NULL)
  for (node = globallst[level]->nodlst; node != NULL; node = node->next)
    {
      nodeptr = cnvboxhnd (node->hnd);
      nodeptr->gscrpos.x = start_point;
      start_point += nodeptr->gscrpos.width + INTERBOXGAP;
      nodeptr->gscrpos.y = globallst[level]->miny;
      drwbox (widget, nodeptr->gscrpos);  /* draw a box with given dimensions */
      drwhdr(widget, nodeptr->hdr, &(nodeptr->gscrpos)); /* write header string as first entry */
      first = 0; 
      switch(nodeptr->boxtyp)
	{ 
	case NODBOXTYP:
	  
	  bat = nodeptr->batlnk;
	  i=1;

	  while (bat != NULBAT)
	    { 
	      batptr = cnvbathnd(bat);
	      batptr->gscrpos.x      = nodeptr->gscrpos.x;
	      batptr->gscrpos.y      = nodeptr->gscrpos.y + i*getbatheight();
	      batptr->gscrpos.width  = nodeptr->gscrpos.width;
	      batptr->gscrpos.height = getbatheight();
	      drwent (widget, batptr->attstr, &(batptr->gscrpos), first);
	      first = 1;
	      bat    = batptr->batlnk;
	      i++;
	    }
	  break;

	default: 
	  scrpos.x = nodeptr->gscrpos.x;
	  scrpos.y = nodeptr->gscrpos.y + getbatheight();
	  scrpos.width  = nodeptr->gscrpos.width;
	  scrpos.height = nodeptr->gscrpos.height;
	  drwent (widget, nodeptr->nonnodstr, &scrpos, 0);
	  break;
	}

      /* Draw the arrow */
      srcbatptr = cnvbathnd(nodeptr->srcbat);
      if (srcbatptr == NULL) 
	continue; 
      
      if (srcbatptr->gscrpos.x > 
	  (int)rint((double)nodeptr->gscrpos.x+(double)(nodeptr->gscrpos.width/2.0)))
	arrow_x1 = srcbatptr->gscrpos.x; /*left side of box */
      else /* right side of box */
	arrow_x1 = srcbatptr->gscrpos.x + srcbatptr->gscrpos.width;

      arrow_y1 = (int)rint((double)srcbatptr->gscrpos.y + 
			   (double)(srcbatptr->gscrpos.height/2.0));

      arrow_x2 = (int)rint((double)nodeptr->gscrpos.x + 
			   (double)(nodeptr->gscrpos.width/2.0));
      arrow_y2 = nodeptr->gscrpos.y;
      drwarw (widget, arrow_x1, arrow_y1, arrow_x2, arrow_y2);
    }

  /* This level is drawn */
  for (node = globallst[level]->nodlst; 
       node != NULL; node = node->next)
    {
      nodeptr = cnvboxhnd (node->hnd);
      nodeptr->drawn = 1;
    }
}


void drwwdw (widget, curx, cury)
int widget;
int curx, cury;

{

  int cumul_width, max_height, width, height;
  int center_above, start_point, i, first, level;
  int arrow_x1, arrow_y1, arrow_x2, arrow_y2;
  int screenwid, screenht;
  struct boxnode *node;
  struct boxstc *nodeptr;
  struct batstc *batptr, *srcbatptr;
  bathnd bat;
  struct gscrposstc scrpos;

#ifdef DEBUG
  printf("drwwdw: drawing current window x %d y %d\n", currentx, currenty);
  fflush(stdout);
#endif

  if (wdw[curx][cury] == NULL) return;
  if (wdw[curx][cury]->bottom_level > bottommost)
    bottommost = wdw[curx][cury]->bottom_level;
  if (wdw[curx][cury]->right > rightmost)
    rightmost = wdw[curx][cury]->right;

  for (level = wdw[curx][cury]->top_level; level <= wdw[curx][cury]->bottom_level;
       level++)
    {
      if (globallst[level] == NULL) continue;
      for (node = globallst[level]->nodlst; node != NULL; node = node->next)
	{
	  nodeptr = cnvboxhnd(node->hnd);
	  if ( !nodeptr->drawn )
	    {
	      if (nodeptr->batwid > strlen(nodeptr->hdr))
		width  = getbatwidth (nodeptr->batwid);
	      else
		width = getbatwidth (strlen(nodeptr->hdr));
	      width += 2*INTRABOXWIDTH;
	      
	      height = getbatheight ();     
	      height = (nodeptr->batcnt + 1)*height; 
	      
	      nodeptr->gscrpos.width  = width;
	      nodeptr->gscrpos.height = height;
	      
	      if (max_height < height)
		max_height = height;
	      
	      cumul_width += width + INTERBOXGAP;
	    }
	}
      if (globallst[level]->maxx)
	{
	  start_point = globallst[level]->maxx;
	  if ((globallst[level]->miny + max_height) > globallst[level]->maxy)
	    globallst[level]->maxy = globallst[level]->miny + max_height;  
	}
      else
	{
	  /* check this code */
	  if ((curx-1) >= 0 && cury >= 0 && wdw[curx-1][cury])
	    start_point = wdw[curx-1][cury]->maxx;
	  else if ((curx-1)>=0 && (cury-1)>=0 &&  wdw[curx-1][cury-1])
	    start_point = wdw[curx-1][cury-1]->maxx;
/*
	  else if (curx>=0 && (cury-1)>=0 && wdw[curx][cury-1])
	    {
	      get_window_size();
	      start_point = wdw[curx][cury-1]->maxx - (int)rint((double)screenwid/2.0);
	    }
*/
	  else
	    start_point = 0;

	  globallst[level]->miny = globallst[level-1]->maxy + INTERROWGAP;
	  globallst[level]->maxy = globallst[level]->miny + max_height;
	}
      
      globallst[level]->maxx = start_point + cumul_width;
      wdw[curx][cury]->maxx = globallst[level]->maxx;

      for (node = globallst[level]->nodlst; node != NULL; node = node->next)
	{
	  nodeptr = cnvboxhnd (node->hnd);
	  if (nodeptr->drawn) continue;
	  nodeptr->gscrpos.x = start_point;
	  start_point += nodeptr->gscrpos.width + INTERBOXGAP;
	  nodeptr->gscrpos.y = globallst[level]->miny;
	  drwbox (widget, nodeptr->gscrpos);  /* draw a box with given dimensions */
	  drwhdr(widget, nodeptr->hdr, &(nodeptr->gscrpos)); 
	  first = 0; 
	  switch(nodeptr->boxtyp)
	    { 
	    case NODBOXTYP:
	      
	      bat = nodeptr->batlnk;
	      i=1;
	      
	      while (bat != NULBAT)
		{ 
		  batptr = cnvbathnd(bat);
		  batptr->gscrpos.x      = nodeptr->gscrpos.x;
		  batptr->gscrpos.y      = nodeptr->gscrpos.y + i*getbatheight();
		  batptr->gscrpos.width  = nodeptr->gscrpos.width;
		  batptr->gscrpos.height = getbatheight();;
		  drwent (widget, batptr->attstr, &(batptr->gscrpos), first);
		  first = 1;
		  bat    = batptr->batlnk;
		  i++;
		}
	      break;
	      
	    default: 
	      scrpos.x = nodeptr->gscrpos.x;
	      scrpos.y = nodeptr->gscrpos.y + getbatheight();
	      scrpos.width  = nodeptr->gscrpos.width;
	      scrpos.height = nodeptr->gscrpos.height;
	      drwent (widget, nodeptr->nonnodstr, &scrpos, 0);
	      break;
	    }

	  /* Draw the arrow */
	  srcbatptr = cnvbathnd(nodeptr->srcbat);
	  if (srcbatptr == NULL) 
	    continue; 
	  
	  if (srcbatptr->gscrpos.x > 
	      (int)rint((double)nodeptr->gscrpos.x+(double)(nodeptr->gscrpos.width/2.0)))
	    arrow_x1 = srcbatptr->gscrpos.x; /*left side of box */
	  else /* right side of box */
	    arrow_x1 = srcbatptr->gscrpos.x + srcbatptr->gscrpos.width;
	  
	  arrow_y1 = (int)rint((double)srcbatptr->gscrpos.y + 
			       (double)(srcbatptr->gscrpos.height/2.0));
	  
	  arrow_x2 = (int)rint((double)nodeptr->gscrpos.x + 
			       (double)(nodeptr->gscrpos.width/2.0));
	  arrow_y2 = nodeptr->gscrpos.y;
	  drwarw (widget, arrow_x1, arrow_y1, arrow_x2, arrow_y2);
	}
      
      /* This level is drawn */
      for (node = globallst[level]->nodlst; 
	   node != NULL; node = node->next)
	{
	  nodeptr = cnvboxhnd (node->hnd);
	  if (nodeptr->drawn) continue;
	  nodeptr->drawn = 1;
	}
    }
}

void
refresh_graph (widget, lst)
     int widget;
     struct level_list **lst;

{
  int i, first;
  int arrow_x1, arrow_y1, arrow_x2, arrow_y2;
  struct boxnode *node;
  struct boxstc *nodeptr;
  struct batstc *batptr, *srcbatptr;
  bathnd bat;
/*  struct level_list **lst; */
  int top, bottom, left, right, level, nodecnt;

  /* Draw the full graph */
  top = 0;
  bottom = bottommost;
  left = 0;
  right = rightmost;

#ifdef DEBUG
  printf("refresh_graph: bottommost %d\n", bottommost);
#endif

  for (level = top; level <= bottom; level++)
    {
      if (lst[level] == NULL)
	continue;
      nodecnt = 0;
      for (node = lst[level]->nodlst; node != NULL && nodecnt <= right ;
	   node = node->next)
	{
	  nodecnt++;
	  if (nodecnt < left) continue;
	  
	  nodeptr = cnvboxhnd (node->hnd);
	  drwbox (widget, nodeptr->gscrpos);  /* draw a box with given dimensions */
	  drwhdr(widget, nodeptr->hdr, &(nodeptr->gscrpos)); 
	  first = 0; 
	  switch(nodeptr->boxtyp)
	    { 
	    case NODBOXTYP:
	      
	      bat = nodeptr->batlnk;
	      i=1;
	      
	      while (bat != NULBAT)
		{ 
		  batptr = cnvbathnd(bat);
		  drwent (widget, batptr->attstr, &(batptr->gscrpos), first);
		  first = 1;
		  bat    = batptr->batlnk;
		  i++;
		}
	      break;
	      
	    default: 
	      drwent (widget, nodeptr->nonnodstr, &(nodeptr->gscrpos), 0);
	      break;
	    }
	  
	  /* Draw the arrow */
	  srcbatptr = cnvbathnd(nodeptr->srcbat);
	  if (srcbatptr == NULL) 
	    {
	      continue; 
	    }
	  
	  if (srcbatptr->gscrpos.x > 
	      (int)rint((double)nodeptr->gscrpos.x+(double)(nodeptr->gscrpos.width/2.0)))
	    arrow_x1 = srcbatptr->gscrpos.x; /*left side of box */
	  else /* right side of box */
	    arrow_x1 = srcbatptr->gscrpos.x + srcbatptr->gscrpos.width;
	  
	  arrow_y1 = (int)rint((double)srcbatptr->gscrpos.y + 
			       (double)(srcbatptr->gscrpos.height/2.0));
	  
	  arrow_x2 = (int)rint((double)nodeptr->gscrpos.x + 
			       (double)(nodeptr->gscrpos.width/2.0));
	  arrow_y2 = nodeptr->gscrpos.y;
	  drwarw (widget, arrow_x1, arrow_y1, arrow_x2, arrow_y2);
	}
    }
}


void
free_levels()

{
  int i;

  for (i=0; i< MAXLVLARY; i++)
    if (globallst[i] != NULL)
      {
	globallst[i]->nodlst = NULL;
	globallst[i]->minx   = 0;
	globallst[i]->maxx   = 0;
	globallst[i]->miny   = 0;
	globallst[i]->maxy   = 0;
	globallst[i]->count  = 0;
	globallst[i] = NULL;
      }
}

void
graph_layout( rotbox , ilevel)
     boxhnd rotbox;
     int ilevel;
{
  
  struct boxstc *rotnodptr, *nodeptr, *parentptr, *childptr;
  struct batstc *parentbatptr, *batptr;
  int i, cumulpos, level, cumulcnt, layout_level;
  struct boxnode *node;
  bathnd bat;
  struct childnode *child;
  struct level_list **lst;

  if (display_mode == GLOBAL_GRAPHICS)
    {
      rotnodptr = cnvboxhnd (rotbox);
      rotnodptr->pos = rotnodptr->upbc = rotnodptr->downbc = 1;
    }
  /* Select which array to use */
  if (display_mode == INCREMENTAL_GRAPHICS)
    {
      lst = lvllst;
      layout_level = ilevel;
    }
  else if (display_mode == INCREMENTAL_GRAPHICS)
    {
      lst = globallst;
      layout_level = ilevel;
    }
  /* Perform finite number of passes over graph */
  
  for (i=0; i<NUMPASS; i++)
    {

      /* down pass */
      for (level = 0; level < layout_level; level++)
	{
	  if (lst[level] != NULL && lst[level]->nodlst != NULL)
	    {
	      for (node = lst[level]->nodlst; node != NULL; node = node->next)
		{
		  nodeptr = cnvboxhnd (node->hnd);
		  if (nodeptr->drawn) continue;
		  parentbatptr = cnvbathnd(nodeptr->srcbat);
		  parentptr = cnvboxhnd(parentbatptr->srcbox);
		  nodeptr->upbc = parentptr->pos;
		  if ( i == 0 || nodeptr->downbc == 0 )
		    nodeptr->pos    = (int) nodeptr->upbc;
		  else
		    nodeptr->pos    = (int) (nodeptr->upbc + nodeptr->downbc)/2;
		}
	      sort_level (level);
	    }
	}

      /* up pass */
      for (level = layout_level; level > 0; level--)
	{
	  if (lst[level] != NULL && lst[level]->nodlst != NULL)
	    {
	      for (node = lst[level]->nodlst; node != NULL; node = node->next)
		{
		  nodeptr = cnvboxhnd (node->hnd);
		  if (nodeptr->drawn) continue;
		  cumulpos = cumulcnt = 0;
		  switch (nodeptr->boxtyp)  
		    {  
		    case NODBOXTYP:
		      
		      bat = nodeptr->batlnk;
		      if (bat != NULBAT)
			{
			  while (bat != NULBAT)
			    { 
			      batptr = cnvbathnd(bat);
			      if (batptr->children != (struct childlist *)NULL)
				{
				  for(child = batptr->children->nodlst; 
				      child != (struct childnode *)NULL; 
				      child = child->next)
				    {
				      childptr = cnvboxhnd (child->hnd);
				      cumulpos += childptr->pos;
				      cumulcnt ++;
				    }
				}
			      bat = batptr->batlnk;
			    }

			  if (batptr->children != (struct childlist *)NULL)
			    {
			      nodeptr->downbc = (int) rint((double)cumulpos/
							   (double)cumulcnt);
			    }
			  
			  if (i==0 || nodeptr->upbc == 0)
			    nodeptr->pos = (int) nodeptr->downbc;
			  else
			    nodeptr->pos    = (int) rint((double)nodeptr->upbc + 
							 (double)nodeptr->downbc)/2.0;
			  
			}
		      else
			nodeptr->pos = nodeptr->downbc = nodeptr->upbc;
		      
		      break;
		      
		    default: 
		      nodeptr->pos = nodeptr->downbc = nodeptr->upbc;
		      break;
		    }
		}
	      sort_level(level);
	    }
	}
    }
}  
		
/* sort_level sorts the nodes in a level based on their barycenters and allocated
   positions in the level after sorting on the average of the two barycenters. */

int
compare(x, y)
     struct boxnode **x, **y;

{
  struct boxstc *xboxptr, *yboxptr;

  xboxptr = cnvboxhnd ((*x)->hnd);
  yboxptr = cnvboxhnd ((*y)->hnd);

  if (xboxptr->pos < yboxptr->pos)
    return -1;
  else if (xboxptr->pos == yboxptr->pos)
    return 0;
  else
    return 1;
}


void
sort_level(level)
     int level;
{
  struct boxnode **nodearray, *node, **nodeptr;
  struct boxstc *boxptr;
  int i;
  struct level_list **lst;


  /* Select which array to use */
  if (display_mode == INCREMENTAL_GRAPHICS)
    lst = lvllst;
  else if (display_mode == GLOBAL_GRAPHICS)
    lst = globallst;

  /* create an array first */
  nodearray = (struct boxnode **) malloc (lst[level]->count * sizeof(struct boxnode *));
  for (i=0, node = lst[level]->nodlst; node != NULL; node = node->next, i++)
    {
      boxptr= cnvboxhnd (node->hnd);
      if   (boxptr->drawn) continue;
      else nodearray[i] = node;
    }
  qsort(nodearray, lst[level]->count, sizeof(struct boxnode *), compare);

  nodeptr = &(lst[level]->nodlst);
  
  for (i=0; i<lst[level]->count; i++)
    {
      *nodeptr = nodearray[i];
      boxptr = cnvboxhnd ((*nodeptr)->hnd);
      boxptr->pos = i+1;
      nodeptr = &((*nodeptr)->next);
    }
  *nodeptr = (struct boxnode *)NULL;
}


void
merge_graph(global_level, incremental_level)
     int global_level, incremental_level;
{
 
  int level;
  struct boxnode *node;
  int columncnt, maxcolumncnt;
  int rowcnt;

#ifdef DEBUG
  printf("merge_graph: merging incremental_level %d with global_level %d\n", 
	 incremental_level, global_level);
  fflush(stdout);
#endif

  maxcolumncnt = 0;
  rowcnt = 0;
  for (level = 0; level < incremental_level; level++)
    {
      columncnt = 0;
      rowcnt++;
      if (lvllst[level] != NULL && lvllst[level]->nodlst != NULL)
	{
	  for (node = lvllst[level]->nodlst; node != NULL; node = node->next )
	    {
	      insert_globallst(node->hnd, global_level);
	      columncnt++;
	    }
	  columncnt--;
	}
      if (columncnt > maxcolumncnt)
	maxcolumncnt = columncnt;
      global_level++;
    }
  for (level = incremental_level-1; level >= 0; level--)
    {
      if (lvllst[level] == NULL || lvllst[level]->nodlst == NULL)
	{
	  rowcnt--;
	}
      else break;
    }
  if (rowcnt == 0) rowcnt++;
#ifdef DEBUG
  printf("Merge: rowcnt(after --) = %d\n", rowcnt);
  fflush(stdout);
#endif

  wdw[currentx][currenty]->right = wdw[currentx][currenty]->left + maxcolumncnt;
  wdw[currentx][currenty]->bottom_level = wdw[currentx][currenty]->top_level + rowcnt-1;

}


/* function should get window size and compute number of levels and columns */
void
set_box_bounds ()
{

#ifdef DEBUG
  printf("set_box_bounds: width %d, height %d\n", scrwidth, scrheight);
#endif

  maxcolumn = (int) rint(scrwidth/250.0);
  maxlevel = (int) rint(scrheight/200.0);
#ifdef DEBUG
  printf("set_box_bounds: maxlevel %d maxcolumn %d\n", maxlevel, maxcolumn);
  fflush(stdout);
#endif

}

void
init_windows ()

{
  int i, j;

#ifdef DEBUG
  printf("init_windows: initialization\n");
  fflush(stdout);
#endif

  for ( i = 0; i< MAXWINDOWS; i++ )
    {
      wdw[i] = (struct win **) malloc (MAXWINDOWS * sizeof(struct win *));
      for (j = 0; j <MAXWINDOWS; j++)
	wdw[i][j] = NULL;
    }
}

void
free_windows()
{
  int i;

  for ( i = 0; i< MAXWINDOWS; i++ )
    if (wdw[i])
      {
	free ( wdw[i] );
	wdw[i] = NULL;
      }
}

void
move_screen(direction)
     int direction;

{
} 


char *
graph_to_text()
{
  static char str[20000];
  int level;
  struct boxstc *nodeptr;
  struct boxnode *node;
  struct batstc *batptr;
  bathnd bat;

  strcpy(str, "");
  for (level = 0; level <= bottommost; level++)
    {
      for (node = globallst[level]->nodlst; node != NULL; 
	   node = node->next)
	{
	  nodeptr = cnvboxhnd (node->hnd);

	  strcat(str, nodeptr->hdr); strcat(str, "\n");
	  switch (nodeptr->boxtyp) 
	    {
	    case NODBOXTYP:
	      bat = nodeptr->batlnk;
	      while (bat != NULBAT)
		{ 
		  batptr = cnvbathnd(bat);
		  strcat(str, batptr->attstr); strcat(str, "\n");
		  bat    = batptr->batlnk;
		}
	      break;
	      
	    default: 
	      strcat(str, nodeptr->nonnodstr); strcat(str, "\n");
	      break;
	    }/* switch */
	  strcat (str, "\n\n");
	}/* node */

    }/* level */
  return str;
}
