/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/xidlview/cdl.c
*				 					* 
*   Copyright (C) 1991 Vijay Anand
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/* CANDLE MODULE */
#include "cdlP.h"
#ifdef mips
int strlen();
#endif
char *IDLstrchr();

int redcdl(filnam)	/* read Candle */
 char* filnam;		/* name of Candle file */
{
  FILE       *cdlfil;	/* Candle instance file */
  char *     perpos;	/* position of the period in the filename */
  int        sts;	/* scratch status */
  int        erssts;	/* erase status */
  char        *action;

/* Don't need the following three box/bat declarations */
/* int        boxbatctr;	/* counts boxes and box attributes in loop */
/* struct boxstc* boxptr;	/* actual box pointer */
/* struct batstc* batptr;    /* actual bat pointer */

  static char    prvfilnam[MAXFILNAMLNG] = " ";
  struct stat    sttbuf;
  static time_t  prvmodtim; /* as of this writing, time_t is a
                             * 'long' integer on this system.  
			     * If this should change, the
                             * method used for saving and comparing 
			     * it to the previous time will have to
			     * be changed
			     */

  /* if the previous name is the same as this one, let's
   * check to see if the dates are the same.
   */
#ifdef DEBUG
  printf("redcdl: start reading Candle file\n");
  fflush(stdout);
#endif 
  sts = stat (filnam, &sttbuf);
  if (sts != 0)
    {
    perror ("redcdl: getting file status");
    dsperrmsg("Error opening Candle file", filnam,0);
    return sts;
  }
  if (0==strcmp(prvfilnam,filnam)
      && sttbuf.st_mtime == prvmodtim)
	 { 
		;
	 }
    else

  { /* we have determined we need to read this file.
     * save its file and time to compare to the next file
     */
     (void) strcpy (prvfilnam,filnam);
     prvmodtim = sttbuf.st_mtime;

    /* convert the Candle name into an IDL file name; the 
     * option to display source code will need the IDL name.
     * (It is not clear anymore that this is where it will
     * GET the idl file name, but that's what we thought
     * at the time...)
     */
    idlfilnam = (char *)malloc(strlen(filnam));
    (void) strcpy (idlfilnam, filnam);
    perpos = IDLstrchr(idlfilnam, '.Cdl');
    if (perpos!=0) (*(++perpos)) = 'i';

    /* set the activity header in the window */

    /* open Candle file, report error if we cannot */
    cdlfil = fopen(filnam, "r");
    if (cdlfil==IVWNUL) 
	     { dsperrmsg("Error opening Candle file", filnam,0);
               sts = -1;
             }
       else {

              /* read candle file into its compilation unit 'variable' */
              cmpunt = ivwidlprt (cdlfil);

              if (cmpunt == IVWNUL) 
                       { dsperrmsg("Error reading compilation unit;",
		                   "Candle file may not be proper format",
		                 0);
                         sts = -1;
                       }
                  else { sts = 0;
                       }
	    }
  }

  /* change window title back */
    chgactnam ("Inactive"); 
#ifdef DEBUG
  printf("redcdl: finished reading Candle file\n");
  fflush(stdout);
#endif
  return sts;
}

int fndcdltyp (nodidt, cdlptr)	/* find Candle description */
   int    nodidt;	/* node identifier */
   ptr  * cdlptr;	/* (output) pointer to Candle description */
		/*DOC-*/
{ SEQDeclaration remdcl;
  Declaration    curdcl;
  StructureEntity stcent;
  SETTypeEntity  remtyp;
  TypeEntity     curtyp;
  TypeEntity *   stcptr;
  char       *   tgttyp;
  int		 fnd;		/* IVWTRU if type found, IVWFLS if not */

  fnd = IVWFLS;
  foreachinSEQDeclaration (cmpunt->syn_body, remdcl, curdcl)
    { if (typeof(curdcl)==KProcessEntity)
        { stcent = curdcl.VProcessEntity->sem_invariant;
          foreachinSETTypeEntity (stcent->sem_types, remtyp, curtyp)
            { { if (nodidt == curtyp.VClass->rep_typeId)
	              			/* (strcmp(typstr, 
		       			 * curtyp.IDLclassCommon->sem_name)==0)
		        		 */
		  { *cdlptr = (char*)curtyp.IDLclassCommon;
		    fnd = IVWTRU;
		    break;
		  }
              }
            }   
            break; /* once we've done ProcessEntity, break */
        }
    } 
  return fnd;
}

int clcnodsiz(typptr)
  TypeEntity typptr;
{
  SEQAttribute	rematt;
  Attribute	curatt;
  int 		maxoffset = 0;

  foreachinSEQAttribute (typptr.VClass->sem_allattributes, rematt, curatt)
    { /* WAS:  maxoffset = intmax(maxoffset, curatt->rep_offset); */
      maxoffset = intmax(maxoffset, curatt->rep_descriptor->rep_offset);
    }

  maxoffset = (maxoffset/8) + 8;	/* convert bits to bytes,
					 * plus enough bytes for the last
					 * attribute
					 */
 return maxoffset;
}


nmdtyptyp typnmdtyp(nmdtyp)
  NamedType nmdtyp;
{
  static int fstflg=IVWTRU;
  static String cmnstrint; /* 'common' string "Integer" */
  static String	cmnstrboo; /* 'common' string "Boolean" */
  static String	cmnstrrat; /* 'common' string "Rational" */
  static String	cmnstrstr; /* 'common' string "String" */

  /* debug code -- do we make these global or what? */
  if (fstflg==IVWTRU) 
    { cmnstrint = NewString("Integer"); cmnstrboo = NewString("Boolean");
      cmnstrrat = NewString("Rational"); cmnstrstr = NewString("String");
      fstflg = IVWFLS;
    }

  switch(typeof(nmdtyp))
  { case KClass: return NODNMDTYP; break;

    case KAtomic: 
          if (nmdtyp.IDLclassCommon->sem_name==cmnstrint) return (INTNMDTYP); 
     else if (nmdtyp.IDLclassCommon->sem_name==cmnstrboo) return (BOONMDTYP);
     else if (nmdtyp.IDLclassCommon->sem_name==cmnstrrat) return (RATNMDTYP);
     else if (nmdtyp.IDLclassCommon->sem_name==cmnstrstr) return (STRNMDTYP);
     else return UNKNMDTYP;
     break;

    default: return UNKNMDTYP;
  }
}


TypeEntity bldbooboxcdl()
{
  static TypeEntity   bootypent;  /* TypeEntity representing Boolean */
  static int   fnd=IVWFLS; /* 'logical' indicating end of search */

  SEQDeclaration remdcl;	/* remaining declarations in loop */
  Declaration	 curdcl;	/* current declaration in loop */
  StructureEntity stcent;	/* structure entity as invariant */
  SETTypeEntity  remtyp;	/* remaining types in loop */
  TypeEntity     curtyp;	/* current type in loop */

  /* fill in the Candle Entity pointer */
  if (fnd == IVWFLS)
    { foreachinSEQDeclaration (cmpunt->syn_body, remdcl, curdcl)
        { if (typeof(curdcl)==KProcessEntity)
            { stcent = curdcl.VProcessEntity->sem_invariant;
              foreachinSETTypeEntity (stcent->sem_types, remtyp, curtyp)
                { if (strcmp("Boolean", curtyp.IDLclassCommon->sem_name)==0)
                      { bootypent = curtyp;
                        fnd = IVWTRU;
                      }
                }
                break; /* once we've done ProcessEntity, break */
            }    
        }
    }

  return bootypent;
}

TypeEntity bldintboxcdl()
{
  static TypeEntity   inttypent;  /* TypeEntity representing string */
  static int   fnd=IVWFLS; /* 'logical' indicating end of search */

  SEQDeclaration remdcl;	/* remaining declarations in loop */
  Declaration	 curdcl;	/* current declaration in loop */
  StructureEntity stcent;	/* structure entity as invariant */
  SETTypeEntity  remtyp;	/* remaining types in loop */
  TypeEntity     curtyp;	/* current type in loop */

  /* fill in the Candle Entity pointer */
  if (fnd == IVWFLS)
    { foreachinSEQDeclaration (cmpunt->syn_body, remdcl, curdcl)
        { if (typeof(curdcl)==KProcessEntity)
            { stcent = curdcl.VProcessEntity->sem_invariant;
              foreachinSETTypeEntity (stcent->sem_types, remtyp, curtyp)
                { if (strcmp("Integer", curtyp.IDLclassCommon->sem_name)==0)
                      { inttypent = curtyp;
                        fnd = IVWTRU;
                      }
                }
                break; /* once we've done ProcessEntity, break */
            }    
        }
    }
    return inttypent;
}

TypeEntity bldstrboxcdl()
{
  static TypeEntity   strtypent;  /* TypeEntity representing string */
  static int   fnd=IVWFLS; /* 'logical' indicating end of search */

  SEQDeclaration remdcl;	/* remaining declarations in loop */
  Declaration	 curdcl;	/* current declaration in loop */
  StructureEntity stcent;	/* structure entity as invariant */
  SETTypeEntity  remtyp;	/* remaining types in loop */
  TypeEntity     curtyp;	/* current type in loop */

  /* debug */ /* int tmptyp; */	/* find out what 'typeof' returns */

  /* fill in the Candle Entity pointer */
  if (fnd == IVWFLS)
    { foreachinSEQDeclaration (cmpunt->syn_body, remdcl, curdcl)
        { /* tmptyp = typeof(curdcl); */ /* debug */
	  if (typeof(curdcl)==KProcessEntity)
            { stcent = curdcl.VProcessEntity->sem_invariant;
              foreachinSETTypeEntity (stcent->sem_types, remtyp, curtyp)
                { if (strcmp("String", curtyp.IDLclassCommon->sem_name)==0)
                      { strtypent = curtyp;
                        fnd = IVWTRU;
                      }
                }
                break; /* once we've done ProcessEntity, break */
            }    
        }
    }

  return strtypent;
}


void reset_cdl()
{
  /* remaining and current IDL declarations (loop variables) */
  SEQDeclaration remdcl; Declaration curdcl; 

  /* FIND PROCESS BEING DEBUGGED IN THIS COMPILATION UNIT */

  /* search for the first Process Entity mentioned in the 
   * declarations, and initialize the Declarations and
   * the Structure Entity representing its invariant 
   */
  if(candle_file == NULL) return;
  foreachinSEQDeclaration (cmpunt->syn_body, remdcl, curdcl)
    { if (typeof(curdcl)==KProcessEntity) break;
    }
  prcdclinv    = curdcl;
  prcstcentinv = curdcl.VProcessEntity->sem_invariant;

}


void setprtmnucdl(prtlist, prtnum)
Port prtlist[];
int *prtnum;
{
	SETPort remprt; Port curprt;
	int i=0;

  /* if the current process invariant is not null,
   * generate the list of available ports to view through
   */
  if (prcdclinv.VProcessEntity != IVWNUL)
    foreachinSETPort (prcdclinv.VProcessEntity->sem_ports, remprt, curprt)
     {  prtlist[i] = curprt;
        i++;
     }
  *prtnum = i;

}

TypeEntity bldratboxcdl()
		/*DOC-*/
{
  static TypeEntity   bootypent;  /* TypeEntity representing rational */
  static int   fnd=IVWFLS; /* 'logical' indicating end of search */

  SEQDeclaration remdcl;	/* remaining declarations in loop */
  Declaration	 curdcl;	/* current declaration in loop */
  StructureEntity stcent;	/* structure entity as invariant */
  SETTypeEntity  remtyp;	/* remaining types in loop */
  TypeEntity     curtyp;	/* current type in loop */

  /* fill in the Candle Entity pointer */
  if (fnd == IVWFLS)
    { foreachinSEQDeclaration (cmpunt->syn_body, remdcl, curdcl)
        { if (typeof(curdcl)==KProcessEntity)
            { stcent = curdcl.VProcessEntity->sem_invariant;
              foreachinSETTypeEntity (stcent->sem_types, remtyp, curtyp)
                { if (strcmp("Rational", curtyp.IDLclassCommon->sem_name)==0)
                      { bootypent = curtyp;
                        fnd = IVWTRU;
                      }
                }
                break; /* once we've done ProcessEntity, break */
            }    
        }
    }

  return bootypent;
}

int getprtlist(mnu_list)
char ***mnu_list;
{
  Port prtlist[MAXPORT];
  char *mnu_name;
  char **mnu_ptr;
  int prtnum;
  int i;

  setprtmnucdl(prtlist, &prtnum);
  if((*mnu_list = (char **)malloc(prtnum*sizeof(char *))) == NULL)
    {
      printf("XIDLVIEW: getprtlist: failed malloc");
      exit(1);
    }
  mnu_ptr = *mnu_list;
  for(i = 0; i < prtnum; i++)
    {
      if(prtlist[i]->lex_name != NULL)
	{
	  if((mnu_name = (char *)malloc((strlen(prtlist[i]->lex_name)+1)*sizeof(char)))
	     == NULL)
	    {
	      printf("XIDLVIEW: getprtlist: failed malloc");
	      exit(1);
	    }
	  strcpy(mnu_name, prtlist[i]->lex_name);
	  *mnu_ptr++ = mnu_name;
	}
    }
  return prtnum;

}


void reset()
{
  reset_box();
  reset_cdl(); 
  reset_wdw();
}
