/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/sidlview/wdwP.h 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef WDWPDEF
#define WDWPDEF
/*
 *  File:	wdwP.h
 * 
 *  Author:	Vijay Anand
 *
 * Description:	This file has the declarations of functions that are used
 *		only by other window module functions. Hence they are hidden
 *		from other modules. It also has header files included and 
 *		variable declarations which are seen throughout this module.
 */


/********** INCLUDE FILES **********/

#include "global.h"
#include "wdw.h"

#include "box.h"
#include "ipc.h"
#include "cdl.h"
#include "notifier.h"

#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <suntool/sunview.h>
#include <suntool/textsw.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <suntool/textsw.h>
#include <suntool/scrollbar.h>
#include <suntool/icon.h>
#include <suntool/walkmenu.h>
#include <suntool/window.h>

/********** MACROS **********/
#define FSTTTL "SunIDLView v2.0"

/*********** VARIABLES  DECLARATIONS **********/

	Frame	basfrm;		/* SunWindow base frame handle */
	Textsw	cmdwdw;		/* SunWindow text subwindow for idlview */
	Menu	cmdwdwmnu;	/* menu for command window */
	Menu	prtmnu;		/* menu of available ports */
	Menu	frmmnu;		/* menu for the idlview window frame */
	int	lstcrsxps;	/* last cursor x position */
	int 	lstcrsyps;	/* last cursor y position */
	char 	frmttl[100];

	struct 
  	{ char * act;		/* 'active/inactive' */
    	  char * curprt;	/* current port name */
  	} wdwttlstc;

/* Data file for IDLView cursor */
	short wdwcrsdat[] = 
	{
#include "idlview.crs"
	};
	mpr_static(wdwcrs, 16, 16, 1, wdwcrsdat);  /* See Sun manual */

/* Data file for IDLView icon */
	short wdwicndat[] =
	{
#include "../../../misc/idlview_bitmap"
	};
/* Icon wdwicn; */
	DEFINE_ICON_FROM_IMAGE (wdwicn, wdwicndat); /* See Sun manual */


/********** ROUTINE INTERFACE **********/

/* confirmer -- confirm exit from idlview. This is a sub-module which includes
  		the following functions. */
int confirm_yes(/* char *message */);
int confirm_ok(/* char *message */);
int confirm(/* char *message, int ok_only */);
Frame init_confirmer(/* char *message, int ok_only */);
void yes_no_ok(/* Panel_item item, Event *event */);

/* setdflprt -- procedure for setting default port selected */
int setdflprt(/* Menu mnu, Menu_item mnuitm */);

/* explainint -- the sunview interface to the explain call which displays source
*/
void explainint( /* Menu mnu, Menu_item mnuitm */);

/* expattoptint -- the sunview interface to the expattopt call which expands
 		   nodes/attributes
*/
void expattoptint( /* Menu mnu, Menu_item mnuitm */);

/* mordtloptint -- the sunview interface to the mordtlopt call which displays
 		   address/memory info about nodes/attributes
*/
void mordtloptint( /* Menu mnu, Menu_item mnuitm */);


/* endcmmopt -- end communications with the user process */
/* this function simply calls endses() */
void endcmmopt(/* Menu mnu, Menu_item mnu_itm */);

/* endses -- end current session */
/* this function just calls sndendcmm() which is a ipcP function */
void endses( );

/* setprtmnu -- create menu of available IDL ports and set into Ports */
Menu setprtmnu( );

int retprc(); /* internal function used by dsperrmsg() */

/* getmnucrspos -- get cursor position as of latest menu event */
void getmnucrspos(/* Menu mnu, struct scrposstc *pos */);

/* set_menu_selection_notifier -- notifer routine which registers a menu call
				back function with the menu button */
void set_menu_selection_notifier(/* int (*menu_selection_handler)() */);
 
#endif
