/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/sidlview/wdw.h 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef WDWDEF
#define WDWDEF
/*
 *
 * Description:	Window module interface; Data structures and routines that
 *		interfaces with the window system to display and manipulate
 *		data on the idlview window. Contains routines to initialize,
 *		window, write to window, position the text cursor, and display
 *		error messages.
 */

/********** INCLUDE FILES **********/
#include <varargs.h>

/********** GLOBAL VARIABLES **********/

/* scrposstc -- structure describing screen position of box */
struct scrposstc
{ int		begpos;		/* beginning position */
  int		endpos;		/* ending position */
};

/********** ROUTINE INTERFACE **********/

/*
 *  Routine:	iniivwwdw
 *
 * Description:	This routine creates the idlview window, establishes the
		socket connection to a well known socket, creates all 
 *		menus that are associated with the window, creates the cursor
 *		and icon for the idlview window, registers callback functions
 *		that are associated with certain events that happen in the
 *		window and also registers a callback that listens on the 
 *		established socket to detect whether any other process is 
 *		trying to connect to this socket. It then starts the loop 
 *		that catches events and invokes the appropriate event-
 *		handler that was registered earlier with the notifier.
 *
 *  Arguments:	None
 *
 * Return value: None
 *
 * Side effects: None
 */
void iniivwwdw(/* */ );

/*
 * Routine:	reset_wdw
 *
 * Description:	This routine resets the window every time a socket connection
 *		is established between the user process and idlview. It clears
 *		the window, creates a menu of available ports and resets the
 *		active port to invariant.
 *
 * Arguments:	None
 *
 * Return value: None
 * 
 * Side effects: None
 */
void reset_wdw( );

/*
 * Routine:	setbegdsppos
 *
 * Description:	This routine sets the begpos field in the scrpos record which
 *		represents the beginning position of the box to the current
 *		text display position in the window.
 *
 * Arguments:	scrpos -- (IN/OUT) screen position of the box is set.
 *
 * Return value: None
 *
 * Side effects: None
 */
void setbegdsppos(/* struct scrposstc *scrpos */);

/*
 * Routine:	setenddsppos
 *
 * Description:	This routine sets the endpos field in the scrpos record which
 *		represents the end position of the box, to the current text 
 *		display position in the window.
 *
 * Arguments:	scrpos -- (IN/OUT) screen position of the box is set.
 *
 * Return value: None
 *
 * Side effects: None
 */
void setenddsppos(/* struct scrposstc *scrpos */);

/*
 * Routine:	appstrlin
 *
 * Description:	This routine sets the text insert position to the end of the
 *		display and writes text on the window. Basically, it appends
 *		text on the window.
 *
 * Arguments:	scrpos -- (IN)  screen position to insert text.
 *		str    -- (IN)  text to be printed on window.
 *		inspnt -- (OUT) return the point where text was inserted.
 *
 * Return value: Number of characters actually inserted in the window. Should
 *		be equal to strlen(str) if no errors occurred.
 *
 * Side effects: None
 */
int appstrlin(/* struct scrposstc scrpos, char *str, int *inspnt */);

/*
 * Routine:	chgprtnam
 *
 * Description:	This routine gets the port name as a string and displays
 *		this string on the idlview window.
 *
 * Arguments:	prtnamstr -- (IN) string containing the name of the port
 *				  selected.
 *		possible values -- "Invariant" or any one of the port names.
 *
 * Return value: None
 *
 * Side effects: None
 */
void chgprtnam( /* char *prtnamstr */);

/*
 * Routine:	chgactnam
 *
 * Description:	This routine gets the string containing the status of comm-
 *		unication between the user process and idlview and displays
 *		it on the idlview window.
 *
 * Arguments:	actnamstr -- (IN) string containing the status of connection.
 *		possible values -- "Unconnected", "Inactive", "Active".
 *
 * Return value: None
 *
 * Side effects: None
 */
void chgactnam( /* char *actnamstr */ );

/*
 * Routine:	dspstr
 *
 * Description:	This routine inserts the string passed at the current text
 *		display position in the window.
 *
 * Arguments:	str -- (IN) string that is to be written on the screen.
 *
 * Return value: Number of characters inserted in the window.
 *
 * Side effects: None
 */
int dspstr(/* char *str */);

/*
 * Routine:	clrscrpos
 *
 * Description:	This routine sets the screen position structure of a box
 *		to an initial value.
 *
 * Arguments:	scrposptr -- (IN/OUT) screen position of the box is set
 *				      to an initial value.
 *
 * Return value: None
 *
 * Side effects: None
 */
void clrscrpos(/* struct scrposstc *scrposptr */);

/* fndboxdtlpos -- find screen position for 'more detail'info for
   a given box's screen position
*/
/*
 * Routine:	fndboxdtlpos
 *
 * Description:	This routine determines the position in the window where
 *		the string generated by mordtlopt(more detail) function
 *		is written. The position is actually the end of the first
 *		line of output for that particular box/box attribute. The
 *		function searches for a newline character at the end of the
 *		first line and return this position.
 *
 * Arguments:	boxscrpos -- (IN) screen position of the box whose more detail
 *				  string is to be displayed. Used as the start
 *				  position to begin search for '\n'.
 *		dtlpos    -- (OUT) screen position of the '\n' character that
 *				   was found. The more detail string should be
 *				   printed here.
 *
 * Return value: None
 *
 * Side effects: None
 */
void fndboxdtlpos(/* struct scrposstc boxscrpos, struct scrposstc *dtlpos */);

/* setdspposend -- set display position to end of window */
/*
 * Routine:	setdspposend
 *
 * Description:	This routine sets the current text insert position in the window
 *		to the end of the text already present in the window.
 *
 * Arguments:	None
 *
 * Return value: None
 *
 * Side effects: The text insert position in the window which is window varible
 *		 is set to the end of text.
 */
void setdspposend( );

/*
 * Routine:	dsperrmsg
 *
 * Description:	This routine displays a variable length error message in 
 *		a popup window, and seeks confirmation. 
 *
 * Arguments:	va_alist -- (IN) a variable length array of strings, which
 *				 is displayed in a popup window.
 *
 * Return value: None
 *
 * Side effects: None
 */
void dsperrmsg( /* va_dcl va_alist */);

/*
 * Routine:	updskrbar
 *
 * Description:	This routine calles a window routine to update the scroll
 *		bar after text has been inserted in the window. It is 
 *		usually called after a box has been displayed.
 *
 * Arguments:	None
 *
 * Return value: None
 *
 * Side effects: None
 */
int updskrbar();

#endif

