/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/sidlview/wdw.c
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/* WINDOW MODULE */
#include "wdwP.h"
int strlen();

int appstrlin(scrpos, str, inspnt)
  struct scrposstc scrpos;
  char * str;
  int  *inspnt;
{
  window_set (cmdwdw, TEXTSW_BROWSING, FALSE, 0);
  (void) window_set (cmdwdw, TEXTSW_INSERTION_POINT, scrpos.endpos, 0);
  window_set (cmdwdw, TEXTSW_BROWSING, TRUE, 0);
  (*inspnt) = scrpos.endpos;
  return ((int)textsw_insert(cmdwdw, str, strlen(str)));
}



void chgactnam (str)
  char*     str;	/* string to add if added */
{
    wdwttlstc.act = str; 
    if (wdwttlstc.curprt==IVWNUL)
           sprintf (frmttl, "%s  %s", 
				FSTTTL, wdwttlstc.act);
    else sprintf (frmttl, "%s  %s   (using port %s)",
				FSTTTL, wdwttlstc.act, wdwttlstc.curprt);
    window_set (basfrm, 
		FRAME_LABEL, frmttl, 
		0);
}

void chgprtnam (str)
  char*     str;	/* string to add if added */
{
    wdwttlstc.curprt = str;

    if (wdwttlstc.curprt==IVWNUL)
           sprintf (frmttl, "%s  %s", 
				FSTTTL, wdwttlstc.act);
    else sprintf (frmttl, "%s  %s   (using port %s)",
				FSTTTL, wdwttlstc.act, wdwttlstc.curprt);
    window_set (basfrm, 
		FRAME_LABEL, frmttl, 
		0);
}

    

void iniivwwdw()
{
  /* create the base frame */
  basfrm = window_create(0,      		FRAME,
			 /* FRAME_LABEL,      	"IDLView", */
			 /* FRAME_NO_CONFIRM, 	TRUE, */
			 FRAME_ICON,		&wdwicn,
			 /* WIN_X,            	0,  */
			 /* WIN_Y,            	100,*/
			 0);

  chgactnam ("Unconnected");

  /* create a menu */
  cmdwdwmnu = menu_create
		(MENU_TITLE_ITEM, "node options",
		   MENU_ITEM,
		     MENU_ACTION_ITEM, "expand attribute", expattoptint,
		     0,
		   MENU_ITEM,
		     MENU_ACTION_ITEM, "more detail",      mordtloptint,
		     0,
/* #ifdef DSPSRCOPT */
		   MENU_ITEM,
		     MENU_ACTION_ITEM, "display source",   explainint,
		     0,
/* #endif */
		 0);

  /* create the window itself */
  /* limited to 20,000 characters by default; use
   * TEXTSW_MEMORY_MAXIMUM to set to a higher value if
   * needed.
   */
  cmdwdw = window_create(   basfrm, 		TEXTSW,
			 WIN_ROWS,		20,
			 WIN_COLUMNS,		80,
			 TEXTSW_MENU,		cmdwdwmnu,
			 TEXTSW_BLINK_CARET,	FALSE,
			 WIN_CURSOR,		
			     cursor_create(CURSOR_IMAGE, &wdwcrs,
					   CURSOR_XHOT, 8,
					   CURSOR_YHOT, 8,
					   0),
			 0);

  /* NOTE: Sun documentation says this may be set during create,
   * but if I do it there it bombs.  It works here.
   */
  window_set (cmdwdw, TEXTSW_LINE_BREAK_ACTION, TEXTSW_CLIP, 
		      TEXTSW_BROWSING, TRUE,
		      0);

  set_itimer_notifier(chknewsckcnn_notifier);
  window_fit(basfrm);	/* make the frame the size of the window */	

  /* establish 'dstfrm' as function to be called before 
   * default destroy function, and 'dbxred' to be called
   * on input from dbx process.
   */
  /* whereis dbxred call back notified? -vijay */

  set_destroy_notifier(basfrm); /* call the notifier module for dstfrm */

  /* obtain the menu that we get from the frame */
  frmmnu = (Menu)window_get (basfrm, WIN_MENU);

  /* insert our 'exit IDLView' option into the frame's menu (!) */
  menu_set(frmmnu, 
		MENU_INSERT, 0, menu_create_item 
				  (MENU_STRING, "IDL", 
				   MENU_FEEDBACK, FALSE,
				   MENU_BOXED, TRUE, 
				   0), 
		0);
  menu_set(frmmnu, 
		MENU_INSERT, 1, menu_create_item 
				  (MENU_STRING, "end session", 
				   MENU_NOTIFY_PROC, endcmmopt,
				   0),
	   0);
  menu_set(frmmnu, 
		MENU_INSERT, 2, menu_create_item 
				  (MENU_STRING, "<for ports>", 
				   MENU_FEEDBACK, FALSE,
				   0), 
		0);
  menu_set(frmmnu,
		MENU_INSERT, 3, menu_create_item
				  (MENU_STRING, "Frame",
				   MENU_FEEDBACK, FALSE,
				   MENU_BOXED, TRUE,
				   0),
	   0); 

/*  return IVWTRU;	/* return 'all is ok' code */
  window_main_loop(basfrm);
}

int dspstr(str)
  char * str;
{ textsw_insert(cmdwdw, str, strlen(str));
}


int updskrbar()
{ int sts;
  sts = window_set(cmdwdw, TEXTSW_UPDATE_SCROLLBAR, 0);
}

void getmnucrspos (mnu,pos)
  Menu		    mnu;
  struct scrposstc *pos;
{
  Event *mnuevt;        /* 'menu' event */

  int   toplin, btmlin; /* in lines: top and bottom visible in the window */
  int   topmrg, linhit, lingap; /* in pixels: top margin, height of line,
                                 * gap between lines
                                 */
  int   colwid;	/* width of a column */
  int	colpos;	/* position of cursor within column */
  int   lftmrg;	/* width of scrollbar + window's left margin */
  int   colgap; /* gap between columns */
  int	clccol;	/* calculated column position */

  int   clclin, linpos; /* calculated line number, position within line */

  Textsw_index tswidx;

  Scrollbar cmdwdwskrbar;

  /* get x and y position of cursor when menu invoked */
  mnuevt = (Event*) menu_get(mnu, MENU_FIRST_EVENT);
  lstcrsxps = event_x(mnuevt);  lstcrsyps = event_y(mnuevt);

  /* determine width of scrollbar */
  cmdwdwskrbar = window_get(cmdwdw, TEXTSW_SCROLLBAR);

  /* determine what lines are on the screen */
  (void) textsw_file_lines_visible(cmdwdw, &toplin, &btmlin);

  /* overall width of a column is gap plus column width */
  /* (the constant '3' in the following call is an experimentally
   * determined value.  I cannot find, in Sun's documentation,
   * what the value or name of the gap is between the right-hand
   * edge of the scrollbar and the beginning of the text, but
   * it is there and appears to be about one-third the width
   * of a column.
   */
  lftmrg = (int)scrollbar_get(cmdwdwskrbar, SCROLL_WIDTH) +
		(int)window_get(cmdwdw, WIN_LEFT_MARGIN)  +
		3;
  colgap = (int) window_get (cmdwdw, WIN_COLUMN_GAP);
  colwid = (int) window_get (cmdwdw, WIN_COLUMN_WIDTH);

  colpos = (lstcrsxps - lftmrg) % (colwid + colgap);
  clccol = (lstcrsxps - lftmrg) / (colwid + colgap);

  /* get margin, gap between lines, and line height */
  topmrg = (int) window_get (cmdwdw, WIN_TOP_MARGIN);
  lingap = (int) window_get (cmdwdw, WIN_ROW_GAP);
  linhit = (int) window_get (cmdwdw, WIN_ROW_HEIGHT);

  linpos = (lstcrsyps - topmrg) % (linhit + lingap);
  clclin = ((lstcrsyps - topmrg) / (linhit + lingap)) + toplin;

  tswidx = textsw_index_for_file_line (cmdwdw, clclin);

  pos->begpos = (int)tswidx + clccol;
  pos->endpos = (int)tswidx + clccol;
}


void clrscrpos(scrposptr)
  struct scrposstc *scrposptr;

{ scrposptr->begpos = -1;
  scrposptr->endpos = -1;
}

void fndboxdtlpos(boxscrpos, dtlpos)
  struct scrposstc boxscrpos;
  struct scrposstc *dtlpos;
{
  /* find the newline after the starting position for the box:
   * we insert in front of that first newline (i.e. at the end
   * of the first line
   */
   int beg, end, sts;

   beg = boxscrpos.begpos;
   sts = textsw_find_bytes(cmdwdw, &beg, &end, "\n", 1, 0);
   dtlpos->begpos = beg;
   dtlpos->endpos = beg;
}

void setbegdsppos(scrpos)	/* set beginning display position */
struct scrposstc *scrpos;	/* screen position structure */
{
  scrpos->begpos = (int) window_get(cmdwdw, TEXTSW_INSERTION_POINT);
}
  
void setenddsppos(scrpos)	/* set ending display position */
struct scrposstc *scrpos;	/* screen position structure */
{  scrpos->endpos = (int) window_get(cmdwdw, TEXTSW_INSERTION_POINT);
   (scrpos->endpos--) ;
}
  

void setdspposend()		/* set display position to end of window */
{
        window_set(cmdwdw, TEXTSW_BROWSING, FALSE, 0);
	(void)window_set (cmdwdw, 
			    TEXTSW_INSERTION_POINT, TEXTSW_INFINITY,
			    0);
        window_set(cmdwdw, TEXTSW_BROWSING, TRUE, 0);
}

void reset_wdw()
{
/*   int erssts;  */

  /* remove any text in the window */
/*  erssts = textsw_reset (cmdwdw, 0, 0);*/
  textsw_reset (cmdwdw, 0, 0);

  /* create a menu for available IDL ports, and set it into 
   * the menu for the command window
   */
  setprtmnu();

  /* INITIALIZE THE DEFAULT VIEWING PORT */
/*  dflprt = IVWNUL;  */
  chgprtnam (IVWNUL);

}



int confirm_yes (message)
char *message;
{ return(confirm(message, FALSE)); }

int confirm_ok(message)
char *message;
{ return (confirm(message, TRUE)); }

static int confirm(message, ok_only) 
char *message;
int ok_only;

{ Frame confirmer;
  int answer;

  /* create the confirmer */
  confirmer = init_confirmer(message, ok_only);
  /* make the user answer */
  answer = (int) window_loop(confirmer);
  /* destroy the confirmer */
  window_set (confirmer, FRAME_NO_CONFIRM, TRUE, 0);
  window_destroy(confirmer);
  return answer;
}

static Frame init_confirmer(message, ok_only)
  char *message;
  int ok_only;

{
  Frame confirmer;
  Panel panel;
  Panel_item message_item;
  int left,top,width,height;
  Rect *r;
  struct pixrect *pr;

confirmer = window_create(0, FRAME, FRAME_SHOW_LABEL, FALSE, 0);
panel = window_create(confirmer, PANEL, 0);
message_item = panel_create_item(panel, PANEL_MESSAGE, PANEL_LABEL_STRING,
				message,0);
if (ok_only) { pr = panel_button_image(panel, "OK", 3, 0);
		width = pr->pr_width;
	     }
	else { pr = panel_button_image(panel, "NO", 3, 0);
		width = 2 * pr->pr_width + 10;
	     }

/* center the yes/no or ok buttons under the message */
r = (Rect *) panel_get(message_item, PANEL_ITEM_RECT);
left = (r->r_width - width) / 2;
if (left < 0) left = 0;
top = rect_bottom(r) + 5;

if (ok_only) { panel_create_item(panel, PANEL_BUTTON,
				PANEL_ITEM_X, left,
				PANEL_ITEM_Y, top,
				PANEL_LABEL_IMAGE, pr,
				PANEL_CLIENT_DATA, 1,
				PANEL_NOTIFY_PROC, yes_no_ok,
				0);
	      }
	else { panel_create_item(panel, PANEL_BUTTON,
				PANEL_ITEM_X, left,
				PANEL_ITEM_Y, top,
				PANEL_LABEL_IMAGE, pr,
				PANEL_CLIENT_DATA, 0,
				PANEL_NOTIFY_PROC, yes_no_ok,
				0);
	       panel_create_item(panel, PANEL_BUTTON,
				PANEL_LABEL_IMAGE, 
				  panel_button_image(panel, "YES", 3, 0),
				PANEL_CLIENT_DATA, 1,
				PANEL_NOTIFY_PROC, yes_no_ok,
				0);
	     }

window_fit(panel);
window_fit(confirmer);
/* center the confirmer frame on the screen */
r = (Rect *) window_get(confirmer, WIN_SCREEN_RECT);
width = (int) window_get (confirmer, WIN_WIDTH);
height = (int) window_get(confirmer, WIN_HEIGHT);
left = (r->r_width - width) / 2;
top  = (r->r_height - height) / 2;
if (left < 0) left = 0;
if (top < 0)  top = 0;
window_set(confirmer, WIN_X, left, WIN_Y, top, 0);
return (confirmer);
}

static void yes_no_ok(item, event)
Panel_item item;
Event *event;
{ window_return(panel_get(item, PANEL_CLIENT_DATA));
}



int setdflprt(mnu, mnuitm)
   Menu mnu;
   Menu_item mnuitm;
{
   Port prtptr;
   dflprt = (Port)menu_get(mnuitm, MENU_CLIENT_DATA, 0);
   if (dflprt==IVWNUL) chgprtnam(IVWNUL);
		  else chgprtnam (dflprt->lex_name);
  return 0; /* NOTIFY_DONE */
}


void explainint (mnu, mnuitm)
  Menu          mnu;
  Menu_item     mnuitm;
		/*DOC-*/
{ 
  struct scrposstc crspos;	/* cursor position */
  boxhnd           box;		/* box indicated by cursor */
  bathnd           bat;		/* box attrib indicated by cursor */
  int		   batpos;	/* box attribute position */

  /* determine whether we're accepting such commands at the moment */
  if (cmmmod != IVWTRU) { dsperrmsg("Not in IDLView session",
				    "You must enter IDLView from dbx",
				    0);
			  return;
			}

  getmnucrspos (mnu, &crspos); /* get cursor position at time menu invoked */

  fndcrsobj (crspos, &box, &bat, &batpos); /* find objects under cursor */
  dspsrcopt(box,bat,batpos);

}

void expattoptint (mnu, mnuitm)
  Menu          mnu;
  Menu_item     mnuitm;
		/*DOC-*/
{ 
  struct scrposstc crspos;	/* cursor position */
  boxhnd           box;		/* box indicated by cursor */
  bathnd           bat;		/* box attrib indicated by cursor */
  int		   dummy;	/* dummy integer for 'fndcrsobj' call */

  /* determine whether we're accepting such commands at the moment */
  if (cmmmod != IVWTRU) { dsperrmsg("Not in IDLView session",
				    "You must enter IDLView from dbx",
				    0);
			  return;
			}

  getmnucrspos (mnu, &crspos); /* get cursor position at time menu invoked */

  fndcrsobj (crspos, &box, &bat, &dummy);  /* find objects under cursor */
  expattopt(box,bat);
}

void mordtloptint(mnu, mnuitm)
  Menu      mnu;
  Menu_item mnuitm;
{ 
  struct scrposstc crspos;      /* cursor position */
  boxhnd           box;         /* box indicated by cursor */
  bathnd           bat;         /* box attrib indicated by cursor */
  int		   dummy;	/* dummy integer for 'fndcrsobj' call */

  /* determine whether we're accepting such commands at the moment */
  if (cmmmod != IVWTRU) { dsperrmsg("Not in IDLView session",
                                    "You must enter IDLView from dbx",
                                    0);
                          return;
                        }

  getmnucrspos (mnu, &crspos); /* get cursor position at time menu invoked */

  fndcrsobj (crspos, &box, &bat, &dummy);  /* find objects under cursor */
  mordtlopt(box,bat);

}



void endcmmopt(mnu,mnuitm)
  Menu      mnu;
  Menu_item mnuitm;
		/*DOC-*/
{
  if (cmmmod == IVWFLS) 
         {
	  dsperrmsg("Not in IDLView session",
		    "Use this option to end IDLView session",
		    0);
	 }
    else { endses();
	 }

}


Menu setprtmnu()
{
  Port prtlist[MAXPORT];
  int prtnum,i;
  /* remaining and current port for loop through ports */

  /* if the port menu is not IVWNUL, destroy it before 
   * recreating it
   */
  if (prtmnu != IVWNUL) { menu_destroy (prtmnu);
			}

  /* create a blank menu for the port names */
  prtmnu = menu_create(0);

  /* create a title and an entry for resetting to the invariant */
  menu_set (prtmnu, MENU_TITLE_ITEM, "Available IDL Ports",
		    MENU_ITEM,
		    MENU_STRING, "reset to invariant",
		    MENU_CLIENT_DATA, IVWNUL,
		    0,
	    0);
   setprtmnucdl(prtlist,&prtnum);
   for(i=0;i<prtnum;i++)
    {  if(prtlist[i]->lex_name != IVWNUL)
	 menu_set (prtmnu, MENU_ITEM,
			   MENU_STRING, prtlist[i]->lex_name,
			   MENU_CLIENT_DATA, prtlist[i],
			   0,
		   0);
    }
  
   set_menu_selection_notifier(setdflprt);/* put a notifier procedure on the
					 pull right menu */

  /* replace the second menu item with this one */
  menu_set ( frmmnu, MENU_REPLACE, 3,
			menu_create_item
				(MENU_STRING, "set port",
				 MENU_PULLRIGHT, prtmnu,
				0),
	     0);

}


void dsperrmsg(va_alist)
  va_dcl
{
  Frame pnlfrm;			/* frame to hold error message panel */
  Panel pnl;			/* panel to hold our error message */
  Panel_item pnltxt;		/* successive lines of text */
  struct pixrect *pnlbtn;	/* picture of a button */

  va_list curarg;		/* 'current' argument of variable number
				 * of arguments to this proc
				 */
  char *  str;			/* 'current' string from argument list */
  int     row;			/* vertical position of next string */

  row = 0;	/* initialize row where strings go */
  pnlfrm = window_create (basfrm, FRAME, 
			  WIN_X,  0,
			  WIN_Y,  0,
			  PANEL_EVENT_PROC, retprc,
			  0);

  pnl = window_create (pnlfrm, PANEL, 0);

  /* add all the strings passed to here to the panel */
  va_start(curarg);
  str = va_arg(curarg,char*);
  while( str != 0)
    { pnltxt = panel_create_item(pnl, PANEL_MESSAGE, 
			     PANEL_LABEL_STRING, str,
			     PANEL_LABEL_X, ATTR_COL(0),
			     PANEL_LABEL_Y, ATTR_ROW(row++),
			     0);
      str = va_arg(curarg, char*);
    }
  va_end(curarg);

  /* put button at bottom of panel so the user can tell us when
   * he's done with the error message
   */
  pnlbtn = panel_button_image(pnl, "ok", 3, 0);
  panel_create_item(pnl, PANEL_BUTTON,
		    PANEL_LABEL_IMAGE, pnlbtn,
		    PANEL_ITEM_X, ATTR_COL(0),
		    PANEL_ITEM_Y, ATTR_ROW(row),
		    PANEL_NOTIFY_PROC, retprc,
		    0);

  window_set(pnlfrm, 
		WIN_X,			15,
		WIN_Y,			lstcrsyps,
		0);

  window_fit(pnl);
  window_fit(pnlfrm); 

  window_loop(pnlfrm);

  window_set(pnlfrm, 
		FRAME_NO_CONFIRM,	TRUE, 
		0);
  window_destroy(pnlfrm);

}

int retprc()
{
   window_return(0);
}


void set_menu_selection_notifier(menu_selection_handler)
int (*menu_selection_handler)();
{
  menu_set(prtmnu,MENU_NOTIFY_PROC,menu_selection_handler,0,0);
  return;
}

