/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/sidlview/notifier.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* NOTIFY MODULE */
#include "notifierP.h"

/* Generic notifier functions */
/* ^^^^^^^^^^^^^^^^^^^^^^^^^^ */

void set_input_notifier(inphnd, input_event_handler, ivwdsc)
int *inphnd;
int (*input_event_handler)();
int ivwdsc;
{
  notify_set_input_func(inphnd, input_event_handler, ivwdsc);
  return;
}

void destroy_input_notifier(inphnd, ivwdsc)
int *inphnd;
int ivwdsc;
{
  notify_set_input_func(inphnd, NOTIFY_FUNC_NULL,ivwdsc);
  return;
}

void set_itimer_notifier(itimer_handler)
int (*itimer_handler)();
{ static int tmrhndint;
  static int *tmrhnd = &tmrhndint;
  struct itimerval scktmr;

  /* set the interval timer for checking on socket connection */
  scktmr.it_interval.tv_usec = 0;	/* periodic setting */
  scktmr.it_interval.tv_sec = 3;
  scktmr.it_value.tv_usec = 0;		/* first setting */
  scktmr.it_value.tv_sec = 3;
  (void) notify_set_itimer_func (tmrhnd, itimer_handler,
			       ITIMER_REAL, &scktmr, ITIMER_NULL);
}

void set_destroy_notifier(basfrm)
Notify_client basfrm;
{
  (void) notify_interpose_destroy_func(basfrm, dstfrm_notifier);
  return;
}

/* Functions specific to sunview version of idlview */
/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */
int dbxred_notifier(inphnd,ivwdsc)
int *inphnd;
int ivwdsc;
{

  ivwmsghdr msghdr;
  int       redsts, unxsts; /* stati */
  ptr blk;

  dbxred(msghdr,blk);
  return (NOTIFY_DONE);
}

int dstfrm_notifier(basfrm,sts)
  Notify_client basfrm;         /* base frame */
  Destroy_status sts;   	/* ending status */
{
  /* NEEDED: a pop-up confirmer like the one they use by default
   * in the windows; if we try to exit 'normally', the textsw
   * defaults don't let us because the text has been changed.
   * if we 'reset' the text first, the text disappears and the
   * confirmation is useless (why go back to the text NOW?).
   */
  if (sts==DESTROY_CHECKING)
         { if (confirm_yes("Destroy IDLView window?"))
	          { return (NOTIFY_DONE); }
	     else { notify_veto_destroy(); }
	 }
    else { 
	   if (cmmmod == IVWTRU) endses();
	   exit();
         }
  return (NOTIFY_DONE);
}


int chknewsckcnn_notifier(hnd,sel)
  Notify_client hnd;
  int           sel;
{
  chknewsckcnn();
  return NOTIFY_DONE;
}

