/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/sidlview/ipcP.h 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef IPCPDEF
#define IPCPDEF
/*
 *
 * Description: This file has function declarations called from within the
 *		inter-process communication module. These cannot be referenced
 *		from outside. It also has some header files and variables
 *		global to this module.
 */

/********** INCLUDE FILES **********/
#include "global.h"
#include "ipc.h"
#include "box.h"
#include "wdw.h"
#include "cdl.h"
#include "cdl1.h"
#include "notifier.h"

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/errno.h>
#include <malloc.h>
#include <string.h>

/********** VARIABLES **********/
	int cmmmod = IVWFLS;   /* whether in comm. with user or not    */
	int ivwdsc;	/* input/output desriptor number for idlview */
	int lissck;	/* socket number for listening */
	int unihnd;	/* alloc storage */
	int *inphnd = &unihnd; /* unique handle for SunW */
	int unncnn = IVWTRU;   /* t=> not connected to socket */
extern	int errno;

#define SCKSELTIMOUT 0  


/********** ROUTINE INTERFACE **********/

/* chkacktrl -- check acknowledgement trailer */
int chkacktrl(/* char *trladr */);

/* rcvusrmsg -- receive complete message from user process, include 
		additional message(if any) and completion status trailer */
int rcvusrmsg(/* int *unxsts, ivwmsghdr *rcvivwmsg, ptr *blkptr */);

/* sndendcmm -- send end communications message */
void sndendcmm( );

/* prcrotnodmsg -- process first box message. Ensure first node can be
		   accepted, get it from user process, display it. */
int prcrotnodmsg(/* ivwmsghdr ivwmsg */);

#endif
