/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/sidlview/ipc.h 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef IPCDEF
#define IPCDEF
/*
 *
 *  Description: This file gives the interface to the inter-process comm-
 *		 unication module. It declares the functions that are accessible
 *		 outside of this module. It also has variables that can be 
 *		 accessed from outside.
 */

/********** INCLUDE FILES **********/
#include "global.h"

/********** DATA STRUCTURES ***********/

/* Data structures and global variables exported */
extern	int	lissck;		/* socket number for listening */
extern	int	cmmmod;		/* whether in comm. with user or not */
extern	int	unncnn;		/* if TRUE then not connected to socket */


/********** ROUTINE INTERFACE **********/

/* chknewsckcnn -- check socket connection */
/* This is a polling callback function to  check for a socket connection.
*/
void chknewsckcnn();

/* cnncmm -- connect to communications; create, set and bind to a socket
	     and return a descriptor number */
int cnncmm( );

/* getusrblk -- get block of memory from user process */
int getusrblk(/* ptr blkadr, int blklng, ptr *blkptr */);

/* getusrstr -- get user string */
int getusrstr(/* ptr usrptr, ptr *valptr */);

/* sndrcvusrmsg -- send a message/command to the user/dbx process,
		   receive a reply and return it to caller */
int sndrcvusrmsg(/* ivwmsghdr sndivwmsg, ivwmsghdr rcvivwmsg, ptr *blkptr */);


/* dbxred -- read dbx information and write it to the window */
void dbxred(/* ivwmsghdr ivwmsg, ptr blk */);

/* endses -- end current session */
/* this function just calls sndendcmm() which is a ipcP function */
void endses( );

#endif



