/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/sidlview/ipc.c 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* IPC MODULE */
/* Include files */
#include "ipcP.h"

void chknewsckcnn()

{  int sts;
   fd_set redrdy;		/* file desc bits for 'select()' call */
   struct timeval timout;	/* timeout value */

   if (unncnn==IVWTRU)
     { sts = listen (lissck,5);
       if (sts != 0) { perror("listen() call");
		            return;
		          }
       redrdy.fds_bits[0] = 1 << lissck;
       timout.tv_sec = SCKSELTIMOUT;
       timout.tv_usec = 0;
       sts = select (lissck+1, &redrdy, 0, 0, &timout);
       if (sts != -1 && sts != 0)
             { ivwdsc = accept(lissck,0,0);
               if (ivwdsc == -1) { perror("idlview: socket accept error");
		                   sts = -1;
                                 }
                 else {(void) set_input_notifier(inphnd,dbxred_notifier,ivwdsc);
		        unncnn = IVWFLS; /* Connected to socket */
		        chgactnam("Inactive");
                      }
             }
      }
   return;
}

int cnncmm()
{ int sock;
  struct sockaddr_in sockstruct;
  int sts;

  /* create a socket */
  sock = socket (AF_INET, SOCK_STREAM, 0);
  if (sock < 0) { perror("opening stream socket");
                  exit(1);
                }

  bzero((char *)&sockstruct, sizeof(sockstruct));
  /* set the type and port number of the socket */ 
  sockstruct.sin_family = AF_INET; 
  sockstruct.sin_port = htons(SCKPRTNUM);

  sockstruct.sin_addr.s_addr = INADDR_ANY;
  /* bind to the socket */
  sts = bind (sock,(struct sockaddr *)&sockstruct, sizeof(struct sockaddr_in));
  if (sts) { perror("binding to socket");
	     printf("errno=%d\n", errno);
             exit(1);
           }

  return sock;

}

int sndrcvusrmsg (sndivwmsg, rcvivwmsg, blkptr)
  ivwmsghdr sndivwmsg;
  ivwmsghdr *rcvivwmsg;
  ptr *  blkptr;

{ int wrtsts, redsts, unxsts;

  wrtsts = write (ivwdsc, &sndivwmsg, sizeof(sndivwmsg), 0);
  if (wrtsts == -1) 
    { dsperrmsg("INTERNAL ERROR:",
		"sndrcvusrmsg: failed socket write",
		"see dbx window for error code",
		0);
      perror("IDLView: sndrcvusrmsg: error sending message to user process");
      return IVWFLS;
    }

  redsts = rcvusrmsg (&unxsts, rcvivwmsg, blkptr);
  return redsts;
}



/* IPC PRIVATE MODULE */


/* An acknowledgement trailer is a structure sent after
 * "additional message" bytes in inter-process comm in
 * IDLView.  The idea is that, if communications are
 * aborted before completion, a process which has posted
 * a read can get 'hung' waiting for a message which does
 * not come.  The ack trailer alleviates this by allowing
 * the sending process to trap the error and send a message
 * which does not contain a valid ack message, thereby allowing
 * the reader to complete the read and then take action.
 */

int chkacktrl (trladr)
  char trladr[ACKTRLSIZ];
{ if ((trladr[0] == 's') && (trladr[1] = 's'))
         { return IVWTRU;
         }
    else { return IVWFLS;
	 }
}


int rcvusrmsg (unxsts, rcvivwmsg, blkptr)
  int * unxsts;		/* unix status from read i/o */
  ivwmsghdr *rcvivwmsg;
  ptr *  blkptr;

{ 
  char acktrl[ACKTRLSIZ];
  int  sts;

  *unxsts = read (ivwdsc, rcvivwmsg, sizeof(*rcvivwmsg), 0);
  if (*unxsts == 0)
    { return IVWFLS;
    }

  if (*unxsts == -1) 
    { dsperrmsg("INTERNAL ERROR:",
		"rcvusrmsg: failed socket read",
		"see dbx window for error code",
		0);
      perror("IDLView: error reading message from user");
      return IVWFLS;
    }

  if (rcvivwmsg->addmsglng > 0) 
    { *blkptr = malloc(rcvivwmsg->addmsglng);

      if (*blkptr == IVWNUL)
     	{ dsperrmsg("INTERNAL ERROR:",
		    "rcvusrmsg: Failed block request for socket read",
		    0);
	  return IVWFLS;
	}

      *unxsts = read (ivwdsc, *blkptr, rcvivwmsg->addmsglng, 0);
      if (*unxsts == -1) 
	     { dsperrmsg("INTERNAL ERROR:",
			"rcvusrmsg: failed additional msg socket read",
			"see dbx window for error code",
			0);
	       perror("IDLView: error reading message block");
	       return IVWFLS;
	     }
	else { (*unxsts) = read (ivwdsc, acktrl, ACKTRLSIZ, 0);
	       sts = chkacktrl (acktrl);
	       if (sts!=IVWTRU)
		 { dsperrmsg("COMMUNICATIONS ERROR",
			     "rcvusrmsg: invalid trailer ack",
			     0);
		   return IVWFLS;
		 }
	     }

    }

  return IVWTRU;
}

int prcrotnodmsg(ivwmsg)
  ivwmsghdr ivwmsg;	/* message from IDL library */
		/*DOC-*/
{
   int	   	cdlsts;		/* status from Candle search */
   TypeEntity	typptr;		/* pointer into Candle structure */
   int		blksts;		/* status of block read */
/* ptr		blkptr;		/* pointer to block from user */
   boxhnd	rotbox;

   chgactnam ("Active");

   cdlsts = fndcdltyp (ivwmsg.nodidt, &typptr); 
   if (cdlsts == IVWFLS) 
	 { dsperrmsg("Node type is unknown to IDLView.",
		     "Candle may be out of date, or the variable",
		     "chosen may not be an IDL node",
		     0);
	   /* BUG? -- shouldn't we send an ENDCMM message to
	    * IDLVlib, which will be waiting for communication
	    * from IDLView at this point?
	    */
	   return IVWFLS;
	 }

   /* build a display box for this node */
   blksts = bldnodbox (ivwmsg.adr, &rotbox);
   if (blksts == IVWFLS) { return blksts; }
   prcrotnod(rotbox);
   return IVWTRU;
}

int getusrblk(blkadr, blklng, blkptr)	/* get user block */
  ptr    blkadr; /* block address (in user's address space) */
  int    blklng; /* length of block to get */
  ptr  * blkptr; /* pointer to block of memory (in this proc address space) */
{ 
  int	    sndsts;	/* write/read status -- from socket write */
  ivwmsghdr ivwmsg;	/* IDLView messaage header */
  ptr	    tmpptr;

  /* build and write block request message */
  iniivwmsg(&ivwmsg);
  ivwmsg.msgtyp = BLKREQMSG;
  ivwmsg.adr    = blkadr;
  ivwmsg.blklng = blklng;

  sndsts = sndrcvusrmsg (ivwmsg, &ivwmsg, &tmpptr);
  if (sndsts==IVWTRU) { *blkptr = tmpptr;
                      }
  return sndsts;
}

void sndendcmm()	/* send 'end communications' */
{
  ivwmsghdr     ivwmsg;		/* message structure */
  int		wrtsts;		/* status of write to socket */

  iniivwmsg(&ivwmsg);
  ivwmsg.msgtyp = ENDCMM;
  ivwmsg.adr    = IVWNUL;
  wrtsts = write (ivwdsc, &ivwmsg, sizeof(ivwmsg), 0);
  if (wrtsts == -1) printf ("Error sending command to end communications");

}

int getusrstr(usrptr, valptr)
  ptr usrptr;
  ptr *valptr;

{ ivwmsghdr ivwmsg;
  int sndrcvsts;
  ptr  alcptr;		/* pointer for malloc to use */

  iniivwmsg(&ivwmsg);
  ivwmsg.msgtyp = STRREQMSG;
  ivwmsg.adr    = usrptr;

  sndrcvsts = sndrcvusrmsg (ivwmsg, &ivwmsg, &alcptr);
  if (sndrcvsts == IVWTRU) { *valptr = alcptr;
			   }
  return sndrcvsts;
}

void dbxred(msghdr, blk)
  ivwmsghdr msghdr;
  ptr       blk;		/* message memory block */
/*  int *hnd;	/* handle from SunWindows */
/*  int fildes;	/* 'file' descriptor for socket */
		/*DOC-*/
{
  int       sts,redsts,unxsts; /* stati */
  int       cmmsts;		/* communication status */
  char      outstr[100];	/* holds error message string */


  redsts = rcvusrmsg (&unxsts, &msghdr, &blk);

  if (redsts == IVWFLS)
    { 
      if (unxsts == -1) { perror ("IDLView: Error reading msg header");
		        }

      if (unxsts == 0) /* broken socket connection */
		   { /* unregister input on this descriptor */
		     /*notify_set_input_func(inphnd, NOTIFY_FUNC_NULL,ivwdsc);*/
		     destroy_input_notifier(inphnd,ivwdsc);

		     chgactnam("Unconnected");
		     unncnn = IVWTRU; 
		   }
      /*return (NOTIFY_DONE);*/
	return;
     }

  switch (msghdr.msgtyp)
  { case CDLMSG    : cmmmod = IVWTRU;	/* legal comm start */
		     sts = redcdl (blk);/* get Candle file name and read it */
		     if (sts == 0)	/* if successful, */
		       /* iniidlglb();	/* initialize IDL global variables */
			reset_cdl(); reset_box(); reset_wdw();
		     sndendcmm();       /* end communications */
		     cmmmod = IVWFLS;
		     break;

    case FSTNODMSG : cmmmod = IVWTRU;	/* legal comm start */
		     cmmsts = prcrotnodmsg(msghdr); /* display root node */
		     if (cmmsts == IVWFLS) { cmmmod = IVWFLS;
			                     chgactnam ("Inactive");
		                           }
		     break;

    default        : 
		     sprintf(outstr,
			    "dbxred: Bad message header, type %d", 
			    msghdr.msgtyp);

		     dsperrmsg ("INTERNAL ERROR:",
		                outstr,
		                0);
  }

  return;
  /*return (NOTIFY_DONE);*/
}


void endses() /* this should be in ipc.h and ipc.c */
{
  struct scrposstc scrpos;

    setdspposend();	/* set display position to end of window */
    dspstr("=== end of session ===\n\n");
    sndendcmm();
    cmmmod = IVWFLS;
    chgactnam("Inactive");
}
