/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/sidlview/cdl.h 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef CDLDEF
#define CDLDEF
/*
 *  
 *  Description: This file contains the public interface to the Candle module.
 *		 These implement the candle functions like read, and also 
 *		 contains the idl routines generated by idlc.
 *
 */

/********** INCLUDE FILES **********/

#include "global.h"
#include "ivwidlprc.h"

/*********** MACROS **********/
#define MAXPORT		10

/*********** DATA STRUCTURES **********/
extern	char *	idlfilnam;	/* name of IDL file (derived from name of
				   Candle file */
extern	Port	dflprt;		/* default port for viewing nodes */

extern	Declaration	prcdclinv;	/* process' invariant declaration */

typedef enum {    NODNMDTYP
		, STRNMDTYP
		, INTNMDTYP
		, BOONMDTYP
		, RATNMDTYP
		, UNKNMDTYP
	     } nmdtyptyp;

/********** ROUTINE INTERFACE ******** */

/* reset_cdl -- reset candle variables every time ipc connection reset */
void reset_cdl(/* */);

/* fncdltyp -- find candle type pointer for given node id */
int fndcdltyp(/* int nodidt, TypeEntity *cdlptr */);

/* nodidt - node identifier
   cdlptr - pointer to candle description 
*/

/* clcnodsiz -- calculate node size. Calculate number of types
		occupied in memory by a node of a given TypeEntity */
int clcnodsiz(/* TypeEntity typptr */);


/* typnmdtyp -- determine type of Namedtype we are dealing with */
nmdtyptyp typnmdtype(/* NamedType nmdtyp */);

/* bldbooboxcdl -- candle manipulations in building a bool box */
TypeEntity bldbooboxcdl();

/* bldintboxcdl -- candle manipulations in building a int box */
TypeEntity bldintboxcdl();

/* bldratboxcdl -- candle manipulations in building a rat box */
TypeEntity bldratboxcdl();

/* bldstrboxcdl -- candle manipulations in building a str box */
TypeEntity bldstrboxcdl();

/* setprtmnucdl -- cdl routines in the setprtmnu function */
void setprtmnucdl(/* Port *prtlist, int *prtnum */);

#endif
