/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/sidlview/boxP.h 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef BOXPDEF
#define BOXPDEF

/*
 *
 *  Description: This file contains the declarations of functions that are
 *		 used within the box module and cannot be accessed from within
 *		 any other module. It also has the header files of the various
 *		 libraries that are needed and also the variables global to
 *		 this module.
 */

/********** INCLUDE FILES **********/

#include "global.h" /* include global definitions */
#include "box.h"
#include "wdw.h"    /* access the window interface */
#include "ivwidlprc.h" 
#include "cdl.h"

/*********** MACROS ***********/

/* Just adds a certain number of bytes to a pointer */
#define addbyt(ptr, bytcnt)  { *ptr = *ptr + bytcnt; }
#define INDSTR "      "

/********** DATA STRUCTURES **********/

/* boxhnd.h */
typedef long bathnd;            /* integer into array of box attrib handles */
typedef long boxhnd;            /* integer into array of box handles */

/* boxstc.h -- structures describing box on screen */
typedef enum {    UNKBOXTYP	/* unknown or uninitialized type */
		, NODBOXTYP	/* box for an IDL node */
		, STRBOXTYP	/*  string */
		, INTBOXTYP	/*  integer */
		, RATBOXTYP	/*  float */
		, BOOBOXTYP	/*  Boolean */
	     } boxtyptyp;

#define FSTBOXNUM 1    /* first number used as index to array of boxes */
#define MAXBOXARY 2500 /* maximum number of boxes in IDLView */
#define NULBOX -1      /* non-existent box handle */

/* boxdscstc -- structure describing box */
struct boxstc
{ boxtyptyp	boxtyp;		    /* type of box */
  int		boxnum;		    /* identifying number of this box */
  bathnd	srcbat; 	    /* box attribute pointing to this box */
  TypeEntity   	cdltypent;	    /* Candle type entity */
  ptr		lclblk;		/**//* ptr to representation for this block */
  ptr		usradr;		    /* address of block in user addr space */
  struct scrposstc scrpos;	    /* screen description */
  bathnd	batlnk;		    /* handle to first attribute */
  int		setseqnum;	    /* number of this element in set or seq 
				     * -1 indicates not member of set or seq 
				     */
  boxhnd	nxtsetseqbox;	    /* next next box in set or seq */
  ptr		setseqllsnodadr;    /* user's address of linked list node */
  int		attnamwid;	    /* width for display of attribute names */
  int		dtldsp;		    /* IVWTRU=>detail displayed */
} ;

/* batstc.h -- box attribute (bat) description */

/* valptrunn.h -- union for one of each C data type */
union valptrunn { int    *intval;
                  long   *lngval;
                  float  *fltval;
                  double *dblval;
                  char   *strptr;
                  char   *booval;
		} ;

#define NULBAT -1		/* non-existent box attribute handle */
#define MAXBATARY 10000		/* maximum box attributes in IDLView */

#define FSTBATNUM 1		/* first index into box attribute pointers */

typedef enum {   UNKBATTYP	/* unknown or uninitialized box attribute */
	       , ATMBATTYP	/* atomic box attribute */
	       , SETBATTYP	/* set box attribute */
	       , SEQBATTYP	/* sequence box attribute */
	       , NODBATTYP	/* node box attribute */
	     } battyptyp;

struct batstc
{  
   battyptyp	    battyp;	    /* type of box attribute */
   boxhnd           srcbox;	    /* box containing this box attribute */
   bathnd           thsbat;	    /* handle to this box attribute */
   boxhnd	    dstbox;	    /* destination box -- box expanded to */
   union valptrunn  valptr;	    /* pointer to value in memory */
   ptr		    usradr;	    /* pointer to value in user's memory */
   Attribute	    cdlatt;	    /* Candle attribute */
   bathnd           batlnk;	    /* handle to next box attribute */
   struct scrposstc scrpos;	    /* position on screen */
   int		    setseqcnt;	/**//* count of set or sequence */
   int		    dtldsp;	    /* detail displayed */
};

	boxhnd	curbtmbox;	/* current bottom box */
	struct boxstc *boxary[MAXBOXARY]; /* pointers to boxes on the screen */
	struct batstc *batary[MAXBATARY]; /* pointers to box attributes */
	boxhnd nxtboxnum=FSTBOXNUM;	  /* next box number to allocate */
	bathnd nxtbatnum=FSTBATNUM;	  /* next bat number to allocate */

/********** DECLARATIONS **********/

/* adjwdwpos -- adjust window positions after an insert */
void adjwdwpos(/* int cnt, int pos */); /* cnt - count of chars inserted;
   					   pos - position of chars inserted 
					*/

/* allbathnd -- allocate a new bat number */
int allbathnd( );

/* allboxhnd -- allocate a new box number */
int allboxhnd( );

/* allnewbat -- allocate a new box attribute, complete with storage and 
		handle */
void allnewbat(/* bathnd *bat, struct batstc **batptr */);

/* allnewbox -- allocate a new box, complete with storage and new box number */
void allnewbox(/* boxhnd box, struct boxstc **boxptr */);

/* bldboobox -- build display box for a boolean */
int bldboobox(/* ptr usrvlu, boxhnd *boxhndptr */);
				/* usrvlu - address in user's space of integer.
   				boxhndptr - pointer to box built for this node.
				*/

/* bldintbox -- build display box for an integer */
int bldintbox(/* ptr usrvlu, boxhnd *boxhndptr */);

/* bldnewbat -- build new attribute description */
int bldnewbat(/* Attribute cdlatt, ptr nodptr, boxhnd srcbox,   \
	 bathnd *newbathnd, ptr batusradr */);
/* cdlatt - Candle description of this attribute.
   nodptr - pointer to user node in our own memory.
   srcbox - source box for this box attribute.
   newbathnd - pointer to the box attribute handle.
   batusradr - box attribute user address.
*/

/* bldratbox -- build display box for a rational */
int bldratbox(/* ptr usrvlu, boxhnd *boxhndptr */);

/* bldstrbox -- build display box for string */
int bldstrbox(/* ptr usrvlu, boxhnd *boxhndptr */);

/* dspbat -- display box attribute */
void dspbat(/* bathnd bat, int typwid */);
/* bat - handle to box attibute structure.
   typwid - width given for the attribute type width.
*/

/* dspatmbat -- display atomic box attribute */
int dspatmbat(/* bathnd bat */);
/* bat - handle to atomic box attr to display */

/* dspbox -- display box on screen */
int dspbox(/* boxhnd newbox */);

/* dspboxhdr -- display header for a node box */
void dspboxhdr(/* boxhnd box */);

/* expllssetseq -- expand an attribute which is a set */
int expllssetseq(/* boxhnd srcbox, bathnd srcbat, boxhnd *newboxptr */);
/* srcbox - box which cursor points to when selected 
   srcbat - box attribute pointed to when selected
   newboxptr - handle of first box we expand to
*/

/* expnodatt -- expand node attribute */
int expnodatt(/* boxhnd box, bathnd bat, boxhnd *newboxptr */);
/* box - box containing attribute to be expanded.
   bat - box attribute being expanded.
*/

/* mchstr -- match string among the alternatives */
int mchstr(/* char *tgt, char *one, char *two, char *three, char *four,
	      char *five, char *six */);

/* setbatptr -- set bat pointer */
void setbatptr(/* bathnd bat, struct batstc *batptr */);

/* setboxptr -- set box pointer */
void setboxptr(/* int box, struct boxstc *boxptr */);

/* dspnumsetseqelm --  */
void dspnumsetseqelm(/* ptr usradr, int num */);
/* usradr - user address of start of set
   num - number of elements
*/

/* dspstrwid -- display string in given width */
void dspstrwid(/* char *str, int wid */);

/* dspattsetnam -- display name of attribute which is a set */
void dspattsetnam(/* Attribute att */);
/* att - Candle attribute pointer */

/* dspattseqnam -- display name of attribute which is a sequence */
void dspattseqnam(/* Attribute att */);

/* dspattclsnam -- display name of attribute which is a class */
void dspattclsnam(/* Attribute att */);

/* dspattunknam -- display msg for unknown attribute type */
void dspattunknam(/* Attribute att */);

/* dspidlboo -- display idl boolean */
int dspidlboo(/* char vlu */);

/* dspidlint -- display idl integer */
int dspidlint(/* int vlu */);

/* dspidlrat -- display idl rational */
int dspidlrat(/* float vlu */);

/* dspidlstr -- display idl string */
int dspidlstr(/* ptr *strptr */);

/* dspnoninistr -- display string indicating uninitialized variable */
void dspnoninistr( );

/* fndcrsobj -- given a cursor position determine what kind of object
		in the idlview window is being pointed */
int fndcrsobj(/* struct scrposstc scrpos, boxhnd *box, bathnd *bat,
		int *batpos */);
/* batpos - 1=first part of bat, 2=second */


/* cnvbathnd -- convert box attribute handle */
struct batstc *cnvbathnd(/* bathnd bat */);

/* cnvboxhnd -- convert box handle */
struct boxstc *cnvboxhnd(/* boxhnd box */);

#endif /* for BOXPDEF */
