/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/sidlview/box.h 
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef  BOXDEF
#define  BOXDEF 
/* The Public interface file for the BOX MODULE */
/*
 *
 *  Description: This file contains the interface to the box module. These
 *		 routines implement box and box attribute manipulation 
 *		 functions. It hides the actual implementation of boxes and
 *		 their attributes and just exposes box, bat handles to the
 *		 outside world. 
 */

/********** INCLUDE FILES **********/


/********** DATA STRUCTURES **********/
/* since box and box attribute handles are in box and box attribute
 * structures, they both define the handles used in the structures.
 */
typedef long bathnd;		/* integer into array of box attrib handles */
typedef long boxhnd;		/* integer into array of box handles */

/********** ROUTINE INTERFACE **********/

/* reset_box -- reset box variables */
void reset_box( );

/* prcrotnod -- process first box .*/
void prcrotnod(/* boxhnd rotbox */);

/* bldnodbox -- build display box for a node */
int bldnodbox(/* ptr usradr, boxhnd *boxhndptr */);

/* expattopt -- expand attribute at given window position */
void expattopt(/*  */);

/* mordtlopt -- display more detail about a given object */
void mordtlopt(/*  */);

/* explain -- writes out the node/attribute name onto an action file and
	      signals the idlbrowse process. This process displays source */
void explain(/*  */);


#endif /* for BOXDEF */
