/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/sidlview/box.c
*				 					* 
*   Copyright (C) 1991 Ralph Cook
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/* BOX MODULE */
/* Include files */
#include "boxP.h"

int strlen();

void dspsrcopt (box, bat, batpos)
boxhnd box;
bathnd bat;
int batpos;
		/*DOC-*/
{ 
  struct boxstc   *boxptr;	/* box structure indicated by cursor */
  struct batstc   *batptr;	/* box attrib structure indicated by cursor */
  TypeEntity	   typent;
  char		   outstr[100];	/* output string for error message */
  boxhnd	   expbox = NULBOX;	/* handle of box expanded to */

  if (box==NULBOX)
    { dsperrmsg("No box at that location",0);
      return;
    }

  /* if (box < curbtmbox)
   *    { dsperrmsg("That display is from a previous IDLView session.",
   *		"Source from that attribute cannot be displayed.",
   *		0);
   *      return;
   *    }
   */

/* Attribute T of class P in view C (the port structure) of process E
 */

  boxptr = cnvboxhnd(box);
  if (bat == NULBAT)
        { dsperrmsg ("Source display not fully implemented;",
			"Requesting source for",
			boxptr->cdltypent.IDLclassCommon->sem_name,
			"from file",
			idlfilnam,
			0);
	  return;
	}
   else 
{ batptr = cnvbathnd(bat);	/* convert box attrib to pointer */

  /* was:  typent = batptr->cdlatt->rep_type; */
  if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
    { 
         dsperrmsg("Too many levels of indirection.", 
                   "This Candle file may be compiled for Pascal.",
                   0); 
    }
  else 
  { /* get entity description of attribute */
    typent = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity; 
  switch (typeof(typent))
  {
    case KAtomic:  
       if (batpos>1) { dsperrmsg("No source for value of IDL basic type", 0);
		       return;
		     }
		   dsperrmsg("Source display not implemented;",
			     "Requesting source for",
			     batptr->cdlatt->lex_name,
			     "from file",
			     idlfilnam,
			     0);
		   break;
    case KSetOf:
    case KSeqOf:
    case KClass:
       if (batpos==1) { dsperrmsg("Source display not implemented;",
			     "Requesting source for",
			     batptr->cdlatt->lex_name,
			     "from file",
			     idlfilnam,
			     0);
		      }
	else if (typeof(typent)==KClass)
	   { dsperrmsg("Source display not implemented;",
		     "Requesting source for",
		     batptr->cdlatt->rep_name,
		     "from file",
		     idlfilnam,
		     0);
	   }
	 else { dsperrmsg("Source display not implemented;",
			  "Requesting source for",
                /* was:	  batptr->cdlatt->rep_type.IDLclassCommon->sem_name, */
			  batptr->cdlatt->rep_name,
			  0);
	      }
       break;

    /* fall through to default */
    /* unknown no longer present    case Kunknown: */

    default:       dsperrmsg("Attribute type unknown to IDLView;",
			     "either Candle is out of date",
			     "or there is an unknown error",
			     0);
  }
  } /* end of 'else' from 'if typeof(...' */
}

  return;
}

void expattopt (box, bat)
 boxhnd box;
 bathnd bat;
		/*DOC-*/
{ 
  struct boxstc   *boxptr;	/* box structure indicated by cursor */
  struct batstc   *batptr;	/* box attrib structure indicated by cursor */
  TypeEntity	   typent;
  char		   outstr[100];	/* output string for error message */
  boxhnd	   expbox = NULBOX;	/* handle of box expanded to */
  int		   cmmsts;	/* communication status */

  if ( (box==NULBOX) || (bat==NULBAT) )
    { dsperrmsg("No attribute at that location",0);
      return;
    }

  if (box < curbtmbox)
    { dsperrmsg("That display is from a previous IDLView session.",
		"That attribute cannot be expanded now.",
		0);
      return;
    }

  boxptr = cnvboxhnd(box);
  batptr = cnvbathnd(bat);	/* convert box attrib to pointer */

  if (batptr->dstbox != NULBOX)	/* ensure we haven't already done this */
    { sprintf(outstr, "Attribute already expanded to box #%d", batptr->dstbox);
      dsperrmsg(outstr, 0);
      return;
    }

  cmmsts = IVWTRU;	/* assume communication goes well */

  /* WAS:  /* get entity description of attribute */
  /* WAS: typent = batptr->cdlatt->rep_type; */

  if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
    { /* Error: too many levels of indirection */
      dsperrmsg("Too many levels of indirection.", 
                "This Candle file may be compiled for Pascal.",
                0); 
    }
    else
    { /* get entity description of attribute */
      typent = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity; 
  switch (typeof(typent))
  {
    case KAtomic:  dsperrmsg("Cannot expand IDL basic type",0); 
         break;

    case KClass:   cmmsts = expnodatt(box, bat, &expbox); 
	 break;

    case KSetOf:   cmmsts = expllssetseq(box, bat, &expbox); 
	 break;

    case KSeqOf:   cmmsts = expllssetseq(box, bat, &expbox);
	 break;

    /* 26-Mar-1989 unknown is no longer present */
    /* case Kunknown: /* fall through to default */

    default:       dsperrmsg("Attribute type unknown to IDLView;",
			     "either Candle is out of date",
			     "or there is an unknown error",
			     0);
  }

  /* if communication status is all right:
   *     update destination box, 
   *   otherwise display error message.
   */
  if (cmmsts == IVWTRU) { batptr->dstbox = expbox;
			}
		   else { dsperrmsg("Communications terminated abnormally",
				    0);
			}
  return;
  } /* end of 'else' from 'if (typeof(...' */
}

void mordtlopt(box, bat)
 boxhnd box;
 bathnd bat;
{ 
  struct boxstc   *boxptr;      /* box structure indicated by cursor */
  struct batstc   *batptr;      /* box attrib structure indicated by cursor */
  TypeEntity       typent;
  int		   mchnum;	/* number matched against strings (to be
				 * replaced... 
				 */
  int		   inspos;	/* position at which we inserted text */
  int		   inscnt;	/* insert count -- # of chars inserted */
  char		   outstr[100];	/* output string temp storage */
  struct scrposstc insscrpos;	/* screen position for insert */
  int		   lng;		/* length of node in bytes, if needed */


  if ( (box==NULBOX) && (bat==NULBAT) )
    { dsperrmsg("No box or attribute at that location",0);
      return;
    }

  inspos = 0;		/* clear insert position */
  inscnt = 0;		/* clear insert count */

  boxptr = cnvboxhnd(box);	/* convert box to pointer */

  /* if we expanding an attribute, handle it;
   * otherwise handle expanding a box
   */
  if (bat!=NULBAT)
  { 
    batptr = cnvbathnd(bat);      /* convert box attrib to pointer */
    if (batptr->dtldsp == IVWTRU)
      { dsperrmsg ("More detail already displayed",
		   "for that attribute.",
		   0);
	return;
      }

    batptr->dtldsp = IVWTRU;
    if (batptr->usradr == IVWNUL) { dsperrmsg("Null user address",
					      "No detail available",0);
				    return;
				  }
    /* get entity description of attribute */
    /* was:    typent = batptr->cdlatt->rep_type; */
    if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
      { 
         dsperrmsg("Too many levels of indirection.", 
                   "This Candle file may be compiled for Pascal.",
                   0); 
	 return;
      }

    /* get entity description of attribute */
    typent = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity; 

    switch (typeof(typent))
    {
      case KAtomic:  
         mchnum = mchstr(typent.IDLclassCommon->rep_name,
			"int", "long", "float", "double", "String", "Boolean");

	 switch(mchnum)
	   { case 5:
		sprintf(outstr, " (detail: %d chars at %08x)",
				strlen(batptr->valptr.strptr), batptr->usradr);
		break;
	     default:
		sprintf(outstr, " (detail: addr=%08x, hex=%x)",
			(batptr->usradr), (*(batptr->valptr.intval))
		       );
		break;
	   }
	 inscnt = appstrlin(batptr->scrpos, outstr, &inspos);
         break;

      case KClass:
	 lng = clcnodsiz (batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity);
	 sprintf (outstr, " (detail: %d bytes at %08x)",
		  lng, batptr->usradr);
	 inscnt = appstrlin(batptr->scrpos, outstr, &inspos);
         break;

      case KSeqOf:   
      case KSetOf:   /* need to test for llist implementation, which is
		      * all we support at present
		      */
          sprintf(outstr, " (detail: 1st linked list node addr=%08x)",
		     batptr->usradr);
		  inscnt = appstrlin(batptr->scrpos, outstr, &inspos);
                  break;

      /* unknown no longer present */
      /* case Kunknown: */  /* fall through to default */
      default:       dsperrmsg("Attribute type unknown to IDLView;",
                               "either Candle is out of date",
                               "or there is an unknown error",
                               0);
    }
  }
  else /* box attribute is null -- give more detail on the box */
  { 
    if (boxptr->dtldsp == IVWTRU)
      { dsperrmsg("More detail already displayed",
		  "for that box",
		  0);
	return;
      }

    boxptr->dtldsp = IVWTRU;	/* set flag -- we've done this now *

    /* find the position for detail info on the display */
    fndboxdtlpos(boxptr->scrpos, &insscrpos);

    /* build string to put on display, based on type of box */
    if (boxptr->setseqnum!=(-1)) /* if box is set or seq element */
      { sprintf(outstr, " (detail: node at %08x, value at %08x)",
		boxptr->setseqllsnodadr, boxptr->usradr);
      }
      else { /* box must be node */
	     lng = clcnodsiz(boxptr->cdltypent);
	     sprintf(outstr, " (detail: %d bytes at addr %08x)",
				lng, boxptr->usradr);
	   }
    
    /* display the string */
    inscnt = appstrlin(insscrpos, outstr, &inspos);
  }

  adjwdwpos(inscnt,inspos); /* adjust window positions by insert count */
}

void prcrotnod(rotbox)
boxhnd rotbox;
		/*DOC-*/
{
   int		dspsts;		/* display status */
   struct boxstc *rotnodbox;	/* pointer to first box on screen */


   /* fill in handle for current 'bottom' box */
   curbtmbox = rotbox;

   /* get pointer and fill in name for the root node */
   /* why do we need rotnodbox - seems like its not used. (vijay) */
   /* if this is not needed we can eliminate this file and do all
      stuff in prcrotnodmsg.c (ipc module) itself */
   rotnodbox = cnvboxhnd(rotbox);

   /* display the new box */
   dspsts = dspbox (rotbox);
   updskrbar();
   return ;
}

	int bldnodbox(usradr, boxhndptr)
	  ptr    usradr;	/* address in user's space of node to get */
	  boxhnd *boxhndptr;	/* pointer to box built for this node */
			/*DOC-*/
	{
	  int           getsts;    /* status from user block */
	  short         *nodidtptr; /* node id from user's process */
	  int           cdlsts;    /* status from Candle type search */
	  int		batsts;    /* status from building box attribute */

	  boxhnd        curbox;    /* number of box we build to expand node */
	  struct boxstc *curboxptr; /* pointer to same box */

	  TypeEntity  typptr;	/* pointer into Candle structure */

	  SEQAttribute reminvatt; /* attributes remaining for this node in invariant */
	  Attribute   curinvatt;  /* current attribute for this node in invariant */

	  SETTypeEntity remprttyp; /* TypeEntitys in port search loop */
	  TypeEntity    curprttyp; /* current TypeEntity in port search loop */

	  SEQAttribute remprtatt; /* attributes remaining for this node in port */
	  Attribute   curprtatt;  /* current attribute for this node in port */

	  struct batstc *batptr; /* pointer to current box attribute */
	  bathnd	*bathndptr;  /* pointer to current box attrib handle */

	  ptr          tmpusradr; /* temp pointer to local block for copy of node */
	  int		nodsiz;	  /* number of bytes in this node */

	  /* get the node ID from the user space and Candle type of structure */
	  getsts = getusrblk(usradr, sizeof(*nodidtptr), &nodidtptr);

	  if (getsts == IVWFLS) { return getsts;
	                        }
	  /* find the type of this node in Candle */
	  cdlsts = fndcdltyp((*nodidtptr), &typptr);

	  /* allocate a new box */
	  allnewbox(boxhndptr, &curboxptr);

	  nodsiz = clcnodsiz(typptr);	/* calculate number of bytes in node */

	  /* get a copy of this node from the user process
	   * set the user's address and the local copy address into the box
	   * (also type of box)
	   */
	  getsts = getusrblk(usradr, nodsiz, &tmpusradr);
	  if (getsts == IVWFLS) { return getsts;
				}
	  curboxptr->lclblk = tmpusradr;
	  curboxptr->usradr = usradr;
	  curboxptr->boxtyp = NODBOXTYP;
	  
	  /* fill in the Candle Entity pointer */
	  curboxptr->cdltypent = typptr;
	  
	  bathndptr = &(curboxptr->batlnk);
	  if (dflprt == IVWNUL)
	    { /* there is no default port -- each attribute in the invariant
	       * is used as a box attribute
	       */
	      foreachinSEQAttribute (typptr.VClass->sem_allattributes, 
				     reminvatt, curinvatt)
		{ batsts = bldnewbat (curinvatt, curboxptr->lclblk,
				      (*boxhndptr), bathndptr, usradr);
		  if (batsts == IVWFLS) { return batsts;
					}
		  batptr = cnvbathnd(*bathndptr);
		  bathndptr = &(batptr->batlnk);
		}
	    }
	  else 
	    { /* there's a default port; search its types to find the
	       * type for which a box is being built
	       */
	      foreachinSETTypeEntity(dflprt->syn_data->sem_entity
				     .VStructureEntity->sem_types, 
				     remprttyp, curprttyp)
		{ if (typptr.IDLclassCommon->sem_name
		      == curprttyp.IDLclassCommon->sem_name)
		    { break;
		    }
		}
	      
	      if (typptr.IDLclassCommon->sem_name
		  != curprttyp.IDLclassCommon->sem_name)
		{ dsperrmsg("Selected node type not found in this port",0);
		}
	      else
		/* for each attribute in the invariant, 
		 * search the port for that attribute
		 */
		foreachinSEQAttribute(typptr.VClass->sem_allattributes,
				      reminvatt, curinvatt)
		  { foreachinSEQAttribute(curprttyp.VClass->sem_allattributes, 
					  remprtatt, curprtatt)
		      { if (curprtatt->lex_name == curinvatt->lex_name)
			  { bldnewbat (curinvatt, curboxptr->lclblk,
				       (*boxhndptr), bathndptr,
				       usradr);
			    if (batsts == IVWFLS) return batsts;
			    batptr = cnvbathnd(*bathndptr);
			    bathndptr = &(batptr->batlnk);
			    break;
			  }
		      }
		  }
	    }
	  return IVWTRU;
	}


void reset_box()
{

  int   boxbatctr;      /* counts boxes and box attributes in loop */
  struct boxstc* boxptr;    /* actual box pointer */
  struct batstc* batptr;    /* actual bat pointer */



  dflprt=IVWNUL; /* moved from iniwdw to here, because dflprt is a varible
		    of this module */
  /* delete any space allocated to boxes and box attributes */
  for (boxbatctr=FSTBOXNUM; boxbatctr<nxtboxnum; boxbatctr++)
     { boxptr = cnvboxhnd(boxbatctr);
       free(boxptr->lclblk);
       free(boxptr);
     }

  for (boxbatctr=FSTBATNUM; 
       boxbatctr<nxtbatnum; 
       boxbatctr++)
     { batptr = cnvbathnd(boxbatctr);
       free(batptr);
     }

  /* reclaim memory from box and box attribute structures,
   * and reset their pointers
   */
  /* (code to reclaim memory left out here... */
  nxtboxnum = FSTBOXNUM;  nxtbatnum = FSTBATNUM;
  curbtmbox = FSTBOXNUM;
}



/* BOX PRIVATE MODULE */


void adjwdwpos(cnt,pos)
  int cnt;	/* count of chars inserted */
  int pos;	/* position of chars inserted */
{
  int i;
  struct boxstc * boxptr;
  struct batstc * batptr;

  for (i=1 ; i < MAXBOXARY ; i++)
    { boxptr = cnvboxhnd(i);
      if (boxptr != IVWNUL) { if (boxptr->scrpos.begpos >= pos)
				 { boxptr->scrpos.begpos += cnt; }
			      if (boxptr->scrpos.endpos >= pos)
				 { boxptr->scrpos.endpos += cnt; }
			    }
    }

  for (i=1 ; i < MAXBATARY ; i++)
    { batptr = cnvbathnd(i);
      if (batptr != IVWNUL) { if (batptr->scrpos.begpos >= pos)
				 { batptr->scrpos.begpos += cnt; }
			      if (batptr->scrpos.endpos >= pos)
				 { batptr->scrpos.endpos += cnt; }
			    }
    }
}


int allbathnd()
		/*DOC-*/
{ /* return ++nxtbatnum; */
  return nxtbatnum++;
}

		/*DOC+*/
/* allboxhnd.c  -- IDLView -- allocate a new box number
 * 11-Aug-1987  8:30
 *
 * Return the next available box number.
 */


int allboxhnd()
		/*DOC-*/
{ /* curtopbox = ++nxtboxnum; */
  /* return curtopbox; */
  return nxtboxnum++;
}

void allnewbat(bat, batptr)
bathnd *bat;
struct batstc **batptr;
{
   /* allocate space for this box attribute*/
   (*batptr) = (struct batstc *)malloc(sizeof(**batptr));
   if ((*batptr) == IVWNUL) { dsperrmsg("INTERNAL ERROR:",
					"allnewbat() failed memory allocation",
			   		0);
                              return;
                            }

   /* allocate a number for this box and set it into the structure */
   *bat = allbathnd();
   (*batptr)->thsbat = *bat;

   /* set the pointer for this bat into its handle */
   setbatptr ((*batptr)->thsbat, *batptr);

   /* set default values for new box attribute */
   (*batptr)->battyp           = UNKBATTYP;
   (*batptr)->srcbox           = NULBOX;
   (*batptr)->dstbox	       = NULBOX;
   (*batptr)->valptr.intval    = IVWNUL;
   (*batptr)->cdlatt           = IVWNUL;
   clrscrpos(&(*batptr)->scrpos);
   (*batptr)->setseqcnt        = 0;
   (*batptr)->batlnk           = NULBAT;
}

void allnewbox(box, boxptr)
  boxhnd *box;
  struct boxstc **boxptr;
{
   /* allocate space for this box */
   (*boxptr) = (struct boxstc *)malloc(sizeof(**boxptr));
   if ((*boxptr) == IVWNUL) { printf("IDLView: allnewbox: failed malloc");
                              return;
                            }

   /* allocate a handle for this box */
   *box = allboxhnd();
   /* (*boxptr)->thsbox = *box; */

   /* For the time being, box handle and box number are the same.
    * I wouldn't count on it staying that way...
    */
   (*boxptr)->boxnum = *box;

   /* set the pointer for this box into its handle */
   setboxptr ( (*box), *boxptr);
   /* setboxptr ((*boxptr)->thsbox, *boxptr); */

   /* set defaults for new box structure */
   (*boxptr)->boxtyp = UNKBOXTYP;
   (*boxptr)->srcbat = NULBAT;
/*   (*boxptr)->cdltypent.Vunknown = IVWNUL; */
   (*boxptr)->lclblk    = IVWNUL;
   (*boxptr)->usradr    = IVWNUL;
   clrscrpos(&((*boxptr)->scrpos));
   (*boxptr)->batlnk    = NULBAT;
   (*boxptr)->setseqnum = -1;
   (*boxptr)->nxtsetseqbox = NULBOX;
   (*boxptr)->setseqllsnodadr = IVWNUL;
   (*boxptr)->attnamwid    = 0;
}

int bldboobox(usrvlu, boxhndptr)
  ptr    usrvlu;	/* address in user's space of node to get */
  boxhnd *boxhndptr;	/* pointer to box built for this node */
		/*DOC-*/
{
  struct boxstc *curboxptr;

  /* allocate a new box */
  allnewbox(boxhndptr, &curboxptr);

  /* set the user's address and the local copy address into the box
   * (and type of box)
   */
  curboxptr->usradr = usrvlu;
  curboxptr->boxtyp = BOOBOXTYP;

  curboxptr->cdltypent = bldbooboxcdl();
}

int bldintbox(usrvlu, boxhndptr)
  ptr    usrvlu;	/* address in user's space of integer */
  boxhnd *boxhndptr;	/* pointer to box built for this node */
		/*DOC-*/
{
  struct boxstc *curboxptr;

  /* allocate a new box */
  allnewbox(boxhndptr, &curboxptr);

  /* set the user's address and the local copy address into the box
   * (and type of box)
   */
  curboxptr->usradr = usrvlu;
  curboxptr->boxtyp = INTBOXTYP;

  curboxptr->cdltypent = bldintboxcdl();
}


int bldnewbat (cdlatt, nodptr, srcbox, newbathnd, batusradr)
  Attribute cdlatt;	/* Candle description of this attribute */
  ptr       nodptr;	/* pointer to user node in our own memory */
  boxhnd    srcbox;	/* source box for this box attribute */
  bathnd   *newbathnd;	/* pointer to box attribute handle */
  ptr	    batusradr;	/* box attribute user address */
{ 

  ptr        	stcptr;		/* one of several types of var */
  int		bytcnt;		/* count of bytes of offset */
  TypeEntity	cdltyp;		/* Candle type entity */
  ptr 		newstr;		/* string pointer */
  ptr		attvalptr;  	/* attribute value pointer if needed */
  int		mchnum;		/* number reflecting match from mchstr */
  struct batstc *batptr;	/* pointer to box attrib structure */

  ivwmsghdr 	ivwmsg;	/* message structure between processes */
  int		msgsts;
  int		*llscntptr;	/* pointer to count of llist structure */
  int		cmmsts;

  cmmsts = IVWTRU;	/* default => communication status is ok */

  /* get a new box attribute structure */
  allnewbat (newbathnd, &batptr);

  /* initialize some values */
  batptr->srcbox = srcbox;	/* init source box number */
  batptr->cdlatt = cdlatt;	/*  and Candle attribute pointer */

  /* calculate address within structure for this attribute */
  stcptr = nodptr; /* init stc pointer with our own address */

  /* bytcnt = ((cdlatt->rep_offset) / 8) + 4; */
  /* bytcnt = (cdlatt->rep_offset) / 8; */ /* up to 25-Mar-1988 */

  bytcnt = (cdlatt->rep_descriptor->rep_offset) / 8;
  addbyt(&stcptr,bytcnt); 	/* add bytes to stcptr */

  /* addbyt(&batusradr,bytcnt);	*/  /* and to user's address */
  /* batptr->usradr = (char*)*(int*)stcptr; */

  /* following line used up until 25-Mar-1989 */
  /* cdltyp = cdlatt->rep_type; */	/* get type pointer */

  if (typeof(cdlatt->rep_descriptor->rep_type)==Kdescriptor)
    { 
         dsperrmsg("Too many levels of indirection.", 
                   "This Candle file may be compiled for Pascal.",
                   0); 
	 cmmsts = IVWFLS;
    }
  else 
  {/* get type pointer */
   cdltyp = cdlatt->rep_descriptor->rep_type.VTypeEntity;	
    
   mchnum = mchstr (cdltyp.IDLclassCommon->rep_name, 
		   "int", "long", "float", "double", "String", "Boolean");

  switch (mchnum)
  { case 1 : /* int -- local copy of structure contains value */
	     batptr->valptr.intval = (int*)stcptr;  
	     addbyt(&batusradr,bytcnt);	/*calc user's address */
	     batptr->usradr = batusradr;
	     break;

    case 2 : /* long -- local copy of structure contains value */
	     batptr->valptr.lngval = (long*)stcptr;
	     addbyt(&batusradr,bytcnt);	/*calc user's address */
	     batptr->usradr = batusradr;
	     break;

    case 3 : /* float -- local copy of structure contains value */
	     batptr->valptr.fltval = (float*)stcptr;
	     addbyt(&batusradr, bytcnt);
             batptr->usradr = batusradr;
	     break;

    case 4 : /* double-precision float.  Not tested */
	     batptr->valptr.dblval = (double*)stcptr; 
             batptr->usradr = (char*)*(int*)stcptr;
	     break;

    case 5 : /* String -- local copy of structure contains
	      * USER'S address of string.  If address non-null,
	      * obtain string from user process.
	      */
             batptr->usradr = (char*)*(int*)stcptr;
	     if (batptr->usradr != IVWNUL) 
	       { cmmsts = getusrstr (batptr->usradr, &newstr);
		 if (cmmsts == IVWTRU) 
		   { batptr->valptr.strptr = newstr; 
		   }
	       }
	     break;

    case 6 : /* Boolean -- local copy of structure contains value */
	     /* (not well-tested; idlc has, at this writing, an
	      * incompatibility between Suns and Vaxes 
	      * which makes Booleans difficult to deal with 
	      */
	     batptr->valptr.booval = (char*)stcptr; 
	     addbyt(&batusradr,bytcnt);	/*calc user's address */
	     batptr->usradr = batusradr;
	     break;

   default : /* not an atomic type */
	     /* local structure contains address of non-atomic */
	     /* batptr->valptr.intval = IVWNUL; */ /*???*/
	     batptr->usradr = (char*)*(int*)stcptr; 

	     /* if this is a set or sequence and its pointer is
	      * not null, obtain its set/sequence count and
	      * put in place.
	      */
	     /* this needs to be replaced with a test of whether 
	      * this attribute is represented by a linked list,
	      * not whether it is a set or sequence
	      */
	     if (typeof(cdltyp) == KSetOf || typeof(cdltyp) == KSeqOf)
	       { if (batptr->usradr == IVWNUL)
		      { batptr->setseqcnt = 0; }
		 else { iniivwmsg(&ivwmsg);
		        ivwmsg.msgtyp = LLSCNTREQ;
		        ivwmsg.adr    = batptr->usradr;
		        cmmsts = sndrcvusrmsg (ivwmsg, &ivwmsg, &llscntptr);
		        if (cmmsts == IVWTRU) batptr->setseqcnt = *llscntptr;
		      }
	       }
   }
   } /* end of 'else' of 'if typeof(...' */
   return cmmsts;	/* return whatever communication status we have */
}


int bldratbox(usrvlu, boxhndptr)
  ptr    usrvlu;	/* address in user's space of node to get */
  boxhnd *boxhndptr;	/* pointer to box built for this node */
		/*DOC-*/
{
  struct boxstc *curboxptr;

  /* allocate a new box */
  allnewbox(boxhndptr, &curboxptr);

  /* set the user's address and the local copy address into the box
   * (and type of box)
   */
  curboxptr->usradr = usrvlu;
  curboxptr->boxtyp = RATBOXTYP;

  curboxptr->cdltypent = bldratboxcdl();
}

int bldstrbox(usradr, boxhndptr)
  ptr    usradr;	/* address in user's space of node to get */
  boxhnd *boxhndptr;	/* pointer to box built for this node */
		/*DOC-*/
{
  int           getsts;    /* status from getting user string */
  ptr          tmpusradr; /* temp pointer to local block for copy of string */
  struct boxstc *curboxptr;

  /* debug */ /* int tmptyp; */	/* find out what 'typeof' returns */

  /* allocate a new box */
  allnewbox(boxhndptr, &curboxptr);

  /* get a copy of the string from the user process
   * set the user's address and the local copy address into the box
   * (and type of box)
   */
  getsts = getusrstr(usradr, &tmpusradr);
  curboxptr->lclblk = tmpusradr;
  curboxptr->usradr = usradr;
  curboxptr->boxtyp = STRBOXTYP;

  curboxptr->cdltypent = bldstrboxcdl();
}


void dspbat (bat, typwid)
  bathnd  bat;		/* handle to box attribute structure */
  int     typwid;	/* width given for the attribute type width */
		/*DOC-*/
{
  struct batstc *batptr;	/* pointer to box attribute structure */
  TypeEntity    typent;		/* type entity for this attribute */

  /* convert box attribute handle to pointer */
  batptr = cnvbathnd(bat);

  /* set beginning position for this attribute */
  setbegdsppos(&(batptr->scrpos));

  /* put indentation before attribute */
  dspstr("      ");

  /* display syntactic name in given width */
  dspstrwid (batptr->cdlatt->lex_name, typwid);	

  /* WAS: get entity description of attribute */
  /* WAS:  typent = batptr->cdlatt->rep_type; */

  if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
       { /* Error: too many levels of indirection */
	 dsperrmsg("Too many levels of indirection.",
		   "This Candle file may be compiled for Pascal.",
		   0);
       }
  else 
  { /* get entity description of attribute */
    typent = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity;	

  switch (typeof(typent))
  {
    case KAtomic:  dspatmbat (bat);		
		   break;

    case KClass:   dspattclsnam(batptr->cdlatt);      
		   if ((batptr->usradr) == IVWNUL) /* if node uninitialized */
		     { dspstr(" ");
		       dspnoninistr();	/* display 'uninit' string */
		     }
		   break;

    case KSetOf:   dspattsetnam(batptr->cdlatt); dspstr(" ");
		   (void) dspnumsetseqelm(batptr->usradr,batptr->setseqcnt);
		   break;

    case KSeqOf:   dspattseqnam(batptr->cdlatt); dspstr(" ");
		   (void) dspnumsetseqelm(batptr->usradr,batptr->setseqcnt);
		   break;

    /* unknown no longer present */
    /* case Kunknown: */ /* fall through to default */

    default: dsperrmsg("dspbat: INTERNAL ERROR",
			"display of unknown attribute type",
			0);
  }

  dspstr("\n");

  /* set ending position for this attribute */
  setenddsppos(&(batptr->scrpos));
  }
}

void dspnumsetseqelm(usradr,num)
  ptr usradr;		/* user address of start of set */
  int num;		/* number of elements */
		/*DOC-*/
{ char outstr[25];

  if (usradr == IVWNUL) { dspnoninistr(); }
                   else { sprintf(outstr, " (%d element%s)", num, 
			          ( (num==1) ? "" : "s")
				 );
  	   dspstr(outstr);
	 }
}


int dspatmbat(bat)
  bathnd  bat;		/* handle to atomic box attribute to display */
		/*DOC-*/
{ int        mchnum;	/* number to match which atomic we have */
  struct batstc *batptr;	/* pointer to atomic box attrib to display */
  TypeEntity typ;	/* Candle Entity pointer for attribute */
  int        bytcnt;	/* position of value in bytes for atomic */

  /* convert box attribute handle to bat */
  batptr = cnvbathnd(bat);

/* was:  typ = batptr->cdlatt->rep_type;	/* get type pointer */
  if (typeof(batptr->cdlatt->rep_descriptor->rep_type)==Kdescriptor)
    exit(-1);			/* Error: too many levels of indirection */
  typ = batptr->cdlatt->rep_descriptor->rep_type.VTypeEntity;	/* get type pointer */
  mchnum = mchstr (typ.IDLclassCommon->rep_name, 
		   "int", "long", "float", "double", "String", "Boolean");

  switch(mchnum)
    { case 1 : dspidlint (*(batptr->valptr.intval));		break;
      case 2 : dspidlint (*(batptr->valptr.lngval));		break;
      case 3 : dspidlrat (*(batptr->valptr.fltval));		break;
      case 5 : dspidlstr (batptr->valptr.strptr);		break;
      case 6 : dspidlboo (*(batptr->valptr.booval));		break;

      default : dspstr (typ.IDLclassCommon->sem_name);
		dspstr (" (private type)");
		/*	dsperrmsg("dspbat: INTERNAL ERROR",
		 *	  "display of unsupported atomic type:",
		 *	  typ.IDLclassCommon->sem_name,
		 *	  0);
		 */
    }
}

void dspstrwid(str, wid)		/* display string in a given width */
  char * str;		/* string to display */
  int    wid;		/* width to use for display */
		/*DOC-*/
{ 
  int    i;

  dspstr(str);
  for (i=0; i<(wid - strlen(str)); i++) dspstr(" ");
}


void dspattsetnam(att)	/* display name of attribute which is a set */
  Attribute att;	/* Candle attribute pointer */
		/*DOC-*/
{ NamedType semcom;	/* semantic component of attribute */

  semcom = (att->rep_descriptor->rep_type.VTypeEntity).VSetOrSeq.IDLclassCommon->sem_component;
  dspstr("{"); dspstr(semcom.IDLclassCommon->sem_name); dspstr("}");
}

void dspattseqnam(att)	/* display name of attribute which is a sequence */
  Attribute att;	/* Candle attribute pointer */
{ NamedType semcom;	/* semantic component of attribute */

  semcom = (att->rep_descriptor->rep_type.VTypeEntity).VSetOrSeq.IDLclassCommon->sem_component;
  dspstr("<"); dspstr(semcom.IDLclassCommon->sem_name); dspstr(">");
}

void dspattclsnam(att)	/* display name of attribute which is a class (?) */
  Attribute att;
{ dspstr("[");
/* was:dspstr(att->rep_type.IDLclassCommon->rep_name); */
dspstr(att->rep_name);
 dspstr("]");
}

void dspattunknam(att)	/* display msg for unknown attribute type */
Attribute att;
{ dspstr("unknown attribute...");
}

int dspbox(newbox)
  boxhnd newbox;
{
   int typwid;			/* width of attribute type name */
   bathnd bat;	 		/* handle of box attribute structure */
   struct batstc *batptr;	/* pointer to box attrib structure */
   struct boxstc *newboxptr;	/* pointer to box structure to display */

   Attribute curatt;
   SEQAttribute rematt;
   TypeEntity curtyp;

   /* remove old box from display */
   /* !!! */

   /* set window insert position for new box */
   setdspposend();

   /* get pointer to this box */
   newboxptr = cnvboxhnd(newbox);

   /* set beginning display position */
   setbegdsppos(&(newboxptr->scrpos));

   /* display header for this box */
   dspboxhdr (newbox);

   /* display the box according to what kind it is */
   switch (newboxptr->boxtyp)
   { case NODBOXTYP:
	/* display node box */
	/* first calculate the width in which to display the
	 * attribute names.  Set that width into the box
	 * structure for this node.
	 */
	typwid = 0;
	bat = newboxptr->batlnk;
	while (bat != NULBAT)
	  { batptr = cnvbathnd(bat);
	    typwid = intmax(typwid, strlen(batptr->cdlatt->lex_name));
	    bat    = batptr->batlnk;
	  }
	typwid++; /* add one to width to get space between name and value */

	/* assign the calculated width into which attribute names
	 * go into the box
	 */
	newboxptr->attnamwid = typwid + strlen(INDSTR);

	/* now display each attribute, using the calced width */
	bat = newboxptr->batlnk;	/* init box attribute pointer */
	while (bat != NULBAT)	/* until end of the list */
	{ dspbat (bat, typwid);	/* display this box attrib */
	  batptr = cnvbathnd (bat); /* conv box att to pointer */
	  bat = batptr->batlnk;	/* and get next box attrib */
	}

	break;

      case STRBOXTYP: dspstr(INDSTR); 
		      dspidlstr(newboxptr->lclblk); 
		      dspstr("\n");
		      break;

      case BOOBOXTYP: dspstr(INDSTR);
		      dspidlboo(newboxptr->usradr);
		      break;

      case INTBOXTYP: dspstr(INDSTR);
		      dspidlint(newboxptr->usradr);
		      break;

      case RATBOXTYP: dspstr(INDSTR);
		      dspidlrat(newboxptr->usradr);
		      break;

      default: dsperrmsg("display of unsupported box type",0);
    }

  setenddsppos(&(newboxptr->scrpos));
  dspstr("\n");
  return;
}

void dspboxhdr (box)
boxhnd box;

{ char outstr[100];

  struct boxstc *boxptr;
  struct batstc *srcbatptr;	/* attribute pointing to this box */
  struct boxstc *srcboxptr;	/*  and box pointing to that attribute */

  char * prestr;	/* 'pre-string' -- goes ahead of source box type */
  char * pststr;	/* 'post-string' -- goes behind source box type */

  boxptr = cnvboxhnd(box);	/* get pointer to box */

  if (boxptr->srcbat == NULBOX)
	 { sprintf(outstr, "(%d) %s is ROOT DISPLAY NODE",
			boxptr->boxnum,
			boxptr->cdltypent.IDLclassCommon->sem_name);
	 }
    else { /* get pointer to source box attribute, and pointer to its box */
           srcbatptr = cnvbathnd(boxptr->srcbat);
           srcboxptr = cnvboxhnd(srcbatptr->srcbox);

           if (boxptr->setseqnum == -1)
		 /* box is not member of set or sequence */
	         { sprintf(outstr, "(%d) %s is (%d).%s",
			boxptr->boxnum,
			boxptr->cdltypent.IDLclassCommon->sem_name,
			srcboxptr->boxnum,  /* used to be `thsbox' */
			srcbatptr->cdlatt->lex_name);
	         }

	     else  /* box is member of set/sequence */
		 { sprintf(outstr, "(%d) %s is element %d of (%d).%s",
			boxptr->boxnum,
			boxptr->cdltypent.IDLclassCommon->sem_name,
			boxptr->setseqnum,
			srcboxptr->boxnum,  /* used to be `thsbox' */
			srcbatptr->cdlatt->lex_name);
	          }
         }

  dspstr(outstr);
  dspstr("\n      --------------------");
  if (dflprt != IVWNUL) { dspstr(" (through port "); dspstr(dflprt->lex_name);
			  dspstr(")");
			}
  dspstr("\n");
}


int expllssetseq(srcbox, srcbat, newboxptr)
  boxhnd srcbox;	/* box which cursor pointed to when option selected */
  bathnd srcbat;	/* box attribute pointed to when option selected */
  boxhnd *newboxptr;	/* handle of (first) box we expand to */
{
  struct boxstc *srcboxptr;
  struct batstc *srcbatptr;

  Attribute	cmpatt;		/* component Attribute */
  NamedType	cmpnmdtyp;	/* component Named Type */
  nmdtyptyp	cmptyp;		/* type of component of set */

  int		getsts;		/* status from getusrblk */

  /* node for each linked list elm */
  typedef struct { ptr nxtadr; ptr vlu; } llsnod; 
  llsnod	*llsnodptr;

  ptr		usrllsnodadr;	/* address of 'current' llist node */
  int		curelmnum;	/* number of 'current' element */

  boxhnd	cmpbox;		/* box for 'current' component element */
  struct boxstc *cmpboxptr;	/* and pointer to the structure */

  /* START OF CODE */
  /* convert both box and box attribute to pointers */
  srcboxptr = cnvboxhnd(srcbox);
  srcbatptr = cnvbathnd(srcbat);

  /* make sure the pointer to the first element is not nil;
   * if it is, report empty set and exit.  
   */
  if (srcbatptr->usradr == IVWNUL)
    { dsperrmsg("Set/Sequence is uninitialized",0); 
      return IVWFLS; 
    }

  cmpatt = srcbatptr->cdlatt; /* get attribute of component,
			       * then named type of component
			       */
/* WAS: cmpnmdtyp = 
	    cmpatt->rep_type.VSetOrSeq.IDLclassCommon->sem_component; */
  cmpnmdtyp = 
    cmpatt->rep_descriptor->rep_type.VSetOrSeq.IDLclassCommon->sem_component;
  cmptyp = typnmdtyp(cmpnmdtyp); /* now type of named type of component */

  /* set address for 1st llist node */
  /* and number of first element */
  usrllsnodadr = srcbatptr->valptr.strptr; /*old*/
  usrllsnodadr = srcbatptr->usradr;
  curelmnum = 1;

  /* loop while the user's addresses are non-null */
  while (usrllsnodadr != IVWNUL)
    { 
      /* get the llist node from the user */
      getsts = getusrblk (usrllsnodadr, sizeof(*llsnodptr), &llsnodptr);
      if (getsts == IVWFLS) return getsts;

      /* Build a box for this element.  
       * (includes getting block from memory if necessary)
       */
      switch (cmptyp)
      { case NODNMDTYP: bldnodbox (llsnodptr->vlu, &cmpbox); break;
	case STRNMDTYP: bldstrbox (llsnodptr->vlu, &cmpbox); break;
	case INTNMDTYP: bldintbox (llsnodptr->vlu, &cmpbox); break;
	case BOONMDTYP: bldboobox (llsnodptr->vlu, &cmpbox); break;
	case RATNMDTYP: bldratbox (llsnodptr->vlu, &cmpbox); break;
	default:        dsperrmsg("Unimplemented Llist component type",
			           sprintf("type %d",cmptyp),
				   0);
      }

      /* if we haven't filled in the handle of the box being
       * expanded to, do so now
       */
      if ((*newboxptr) == NULBOX) (*newboxptr) = cmpbox;

      /* convert box handle 
       * and initialize source box, element number, and
       * address of node.
       */
      cmpboxptr = cnvboxhnd(cmpbox);
      cmpboxptr->srcbat    = srcbat;
      cmpboxptr->setseqnum = curelmnum++;
      cmpboxptr->usradr    = llsnodptr->vlu;
      cmpboxptr->setseqllsnodadr = usrllsnodadr; /* set val of addr of node */

      /* display this box */
      dspbox(cmpbox);

      /* load pointer to next element in the set */
      usrllsnodadr = llsnodptr->nxtadr;
 
    } /* end of 'while (usrllselm != IVWNUL)' */

    /* update scroll bar from this set */
    updskrbar();

    /* return successful completion status */
    return IVWTRU;
}

int expnodatt(box,bat,newboxptr)
  boxhnd box;	/* box containing attribute being expanded */
  bathnd bat;	/* box attribute being expanded */
  boxhnd *newboxptr;
{
  int		bldsts;    /* status from building of node box */
  int		dspsts;    /* display status */
  struct batstc *batptr;
  struct boxstc *nodboxptr;


  /* convert the box attribute handle being expanded */
  batptr = cnvbathnd(bat);

  /* 19-Nov-1987 -- install check for null user address */
  if ((batptr->usradr) == IVWNUL)
    { dsperrmsg ("Node is uninitialized",0);
      return;
    }

  /* build display box for this node */
  bldsts = bldnodbox (batptr->usradr, newboxptr); 
  if (bldsts == IVWFLS) return bldsts;

  nodboxptr = cnvboxhnd(*newboxptr);
  nodboxptr->srcbat = bat;	     /* set source box attribute into new box */

  dspsts = dspbox(*newboxptr);		/* finally, display the box */
  dspsts = updskrbar();			/*  and update the scroll bar(s) */

  /* return successful completion */
  return IVWTRU;
}

int mchstr(tgt, one, two, three, four, five, six)
char * tgt;
char * one;
char * two;
char * three;
char * four;
char * five;
{
  if (strcmp(tgt,one)  ==0) return 1;
  if (strcmp(tgt,two)  ==0) return 2;
  if (strcmp(tgt,three)==0) return 3;
  if (strcmp(tgt,four) ==0) return 4;
  if (strcmp(tgt,five) ==0) return 5;
  if (strcmp(tgt,six)  ==0) return 6;
  return 0;
}

void setbatptr (bat, batptr)
  bathnd bat;
  struct batstc *batptr;
{
  if (bat < 0 || bat > MAXBATARY) 
         { dsperrmsg("INTERNAL ERROR",
		     "setbatptr received illegal bat number",
		     0); 
	 }
    else { batary[bat] = batptr; }
}

void setboxptr (box, boxptr)
  int box;
  struct boxstc *boxptr;
{
  if (box < 0 || box > MAXBOXARY) 
         { dsperrmsg("INTERNAL ERROR",
			"setboxptr received illegal box number",0); 
	 }
    else { boxary[box] = boxptr; }
}

int dspidlstr(strptr)
  ptr strptr;

{ int cnt; 
  if (strptr == IVWNUL) {/*cnt = */dspnoninistr();}
		   else {dspstr("\"");/* cnt =*/ dspstr(strptr); dspstr("\"");
			 cnt = cnt + 2;
			}
  return cnt;
}



int dspidlboo(vlu)
  char vlu;
{ 
  /* Shouldn't the booleans be IVWTRU, IVWFLS instead -vijay */
  if (vlu) { dspstr("TRUE");  return 4; }
      else { dspstr("FALSE"); return 5; }
}


int dspidlint(vlu)
  int vlu;
{ char outstr[25];
  int  cnt;

  sprintf (outstr, "%d", vlu);
  cnt = dspstr(outstr);
  return cnt;
}

int dspidlrat(vlu)
  float vlu;
{ char outstr[50];
  int  cnt;

  sprintf (outstr, "%#g", vlu); /* "#" flag insures decimal point */
  cnt = dspstr(outstr);
  return cnt;
}


void dspnoninistr()
{ dspstr("(uninitialized)");
}

int fndcrsobj(scrpos, box, bat, batpos)
  struct scrposstc scrpos;
  boxhnd   	   *box;
  bathnd   	   *bat;
  int		   *batpos;	/* 1=first part of bat, 2=second */
{
  struct boxstc *boxptr;	/* pointer to successive boxes */
  struct batstc *batptr;	/* pointer to successive box attributes */

  (*box) = FSTBOXNUM;		/* start at first box */
  boxptr = cnvboxhnd (*box);	/* (converted to pointer) */

  /* the screen position passed in actually has the text
   * subwindow index for the start of the line containing
   * the cursor in the 'beginning' position.  This will
   * likely get more exciting in the graphics version.
   */
  while ( (boxptr != IVWNUL) && 
	  (boxptr->scrpos.endpos < scrpos.begpos) 
	)
    { (*box)++;
      boxptr = cnvboxhnd(*box);
    }

  if ( boxptr == IVWNUL)
         { (*box) = NULBOX;
	   (*bat) = NULBAT;
	   (*batpos) = 0;
           return 0;			/* return 'no object found' */
         }
    else 
	 /* starting from the current box, search box attributes
	  * the last box attribute will have NULBAT as a box attrib
	  * handle, ending the search.
	  */
	 { (*bat) = boxptr->batlnk;
	   batptr = cnvbathnd(*bat);
	   while ((*bat) != NULBAT &&
	          ( (batptr->scrpos.endpos < scrpos.begpos) ||
		    (batptr->scrpos.begpos > scrpos.begpos)
		  )
		 )
	     { (*bat) = batptr->batlnk;
	       batptr = cnvbathnd(*bat); /* pointer goes null on null bat */
	     }

	   /* if we're past all the box attribute structures,
	    * or past the ones for this box,
	    * return flag that we found box
	    * but not box attrib.  Otherwise, set correct box attrib
	    * handle and return flag that we found both.
	    */
	   if ((*bat) == NULBAT) { *bat = NULBAT;
				   (*batpos) = 0;
		                   return 1;
		                 }
	     else { /* (*bat) = batptr->thsbat; */ /* do we need this? */
		    if (boxptr->attnamwid > (scrpos.begpos - 
						batptr->scrpos.begpos))
			   (*batpos) = 1;
		      else (*batpos) = 2;
		    return 2;
		  }
	 }
}

struct boxstc *cnvboxhnd(box)
  boxhnd box;
{ if (box==NULBOX) return (struct boxstc*)IVWNUL;
    else if (box >= 0 && box <= MAXBOXARY) return (boxary[box]);
    else dsperrmsg("INTERNAL ERROR:",
		   "cnvboxhnd() received bad box handle",
		   0);
}

struct batstc *cnvbathnd(bat)
  bathnd bat;
{ if (bat==NULBAT) return (struct batstc*)IVWNUL;
    else if (bat >= 0 && bat <= MAXBATARY) return (batary[bat]);
    else dsperrmsg("INTERNAL ERROR:", 
		   "cnvbathnd() received bad box attribute handle",
		   0);
}

int intmax(x,y)		/* determine maximum of two integers */
int x,y;
		/*DOC-*/
{ if (x<y) return y; else return x;
}
