/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview_master/idlview_master.c 
*				 					* 
*   Copyright (C) 1991 Vijay Anand
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

/*
 *  Master Process: This module is the Master process code containing IPC between
 *                  Master process, User process and xidlview. The Master process
 *                  maintains a table of associations between xidlview and User
 *                  processes.
 */

#include "idlview_master.h"
#include "ivwutl.h"



int nextport = SERV_PORT;
NETTABLE connect_table[MAXPRTNUM];

char *nameofprogram = NULL;


/* The main function sets up the socket connection between the xidlview master and
 * the xdbx debugger. Upon request it creates a new xidlview server or resuses an
 * an existing server. It also sets up the socket connection between the server and
 * the xdbx client .
 */

main(argc, argv)
     int argc;
     char **argv;

{

  int sockfd, newsockfd, clilen, childpid, port, i;
  int bcastfd, newbcastfd, wdwsys, busy;
  int nextwait = 0;


  char newsock_str[MAXSCKNAMLNG];
  char disp_host[MAXHSTNAMLNG], serv_host[MAXHSTNAMLNG], cdlfil[MAXFILNAMLNG];
  char ivwses[MAXSESLNG];
  char *serv_ptr, *disp_ptr, *ivwses_ptr, *cdlfil_ptr, *wdw_ptr, *port_ptr;
  char port_str[MAXHSTNAMLNG], command[MAXHSTNAMLNG], wdw[MAXHSTNAMLNG];
  char *host_addr, idlb[MAXHSTNAMLNG], *idlb_ptr;
  
  STARTUP waitforstart[MAXWAIT];
  union wait status;
  struct sockaddr_in cli_addr, serv_addr;
  struct hostent *hp;
  fd_set readfds;
  FILE *fp, *fopen();

  nameofprogram = argv[0];
  bzero(connect_table, MAXPRTNUM);


/* Fault Tolerance of the Master Process. Restart sessions from log file 


  if ((fp = fopen (MASTERFILE, "r")) == NULL)
    {
      fprintf(stderr, "%s: Master File open error.\n",argv[0]);
      fflush(stderr);
      return;
    }
  
  while (fscanf (fp, "%s %s %s %d\n", port_str, serv_host, disp_host, &busy) != EOF)
    {
#ifdef DEBUG
      printf("file: %s %s %s %d\n", port_str, serv_host, disp_host, busy);
      fflush(stdout);
#endif      
      switch(childpid = fork())
	{
	case -1:
	  {
	    fprintf(stderr,"%s: ", argv[0]);
	    perror("error in fork");
	    fflush(stderr);
	    exit(1);
	  }
	  break;
	  
	case 0:
	  sleep(1);
	  if (port_str[0] != 'I')
	    {
	      strcpy(command, "rsh ");
	      strcat(command, serv_host);
              strcat(command, " ");
	      strcat(command, LIBDIR);
	      strcat(command, "/IDLxidlview");
              strcat(command, " ");
	      strcat(command, "-x ");
	      strcat(command, " -port ");
	      strcat(command, port_str);
	      strcat(command, " -serv ");
	      strcat(command, serv_host);
	      strcat(command, " -display ");
	      strcat(command, disp_host);
	      if (strlen(idlb_ptr))
		{
		  strcat(command, " -idlb ");
		  strcat(command, idlb);
		}
	      strcat(command, " &");
#ifdef DEBUG	      
	      printf("command is %s\n", command);
	      fflush(stdout);
#endif	    
	      port = atoi(port_str);
	      if(system(command) != 0)
		remove_nettable(port);
	      
	      exit(0);
	    }
	  break;

	default:
	  break;

	}
    }
  fclose(fp);
*/


  gethostname(serv_host, MAXHSTNAMLNG);
  if (strcmp(serv_host,MASTERHOST)) 
    {
      fprintf(stderr, "%s: Must be run only on %s\n",argv[0],MASTERHOST);
      exit(1);
    }

  if((sockfd = socket(AF_INET, SOCK_STREAM, 0)) <0)
    {
      fprintf(stderr,"%s: ",argv[0]);
      perror("can't open stream socket");
      exit(1);
    }

  bzero((char *) &serv_addr, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  serv_addr.sin_port = htons(MASTER_PORT);


  /* bind to well-known port MASTER_PORT */

  if(bind(sockfd, (struct sockadr_in *) &serv_addr,
	  sizeof(serv_addr)) <0)
    {
      fprintf(stderr,"%s: ",argv[0]);
      perror("can't bind stream socket");
      exit(1);
    }

  listen(sockfd, 5); /* 5 is the maximum size of the queue */

  for( ; ; )
    {

      /* Initialize */

      bzero(ivwses, MAXSESLNG);
      bzero(cdlfil, MAXFILNAMLNG);
      bzero(serv_host, MAXHSTNAMLNG);
      bzero(disp_host, MAXHSTNAMLNG);
      bzero(idlb, MAXHSTNAMLNG);
      bzero(wdw, MAXHSTNAMLNG);

      ivwses_ptr = &ivwses[0];
      cdlfil_ptr = &cdlfil[0];
      serv_ptr = &serv_host[0];
      disp_ptr = &disp_host[0];
      idlb_ptr = &idlb[0];
      wdw_ptr = &wdw[0];

      clilen = sizeof(cli_addr);

#ifdef DEBUG
      fprintf(stdout, "Stream Socket Accept\n");
      fflush(stdout);
#endif

      if((newsockfd = accept(sockfd, (struct sockaddr *)
			     &cli_addr, &clilen)) <0)
	{
	  fprintf(stderr,"%s: ",argv[0]);
	  perror("can't accept stream connection");
	  exit(1);
	}
      
      readline(newsockfd, &serv_ptr); /* read in the type of message sent */

      /* type of message is xidlview status busy */

      if(strcmp(serv_ptr, "STSCHGBSY") == 0)
	{
	  bzero(serv_host, MAXHSTNAMLNG);
	  readline(newsockfd, &serv_ptr);
	  status_nettable(atoi(serv_host), TRUE);
	}

      /* type of message is xidlview status not busy */
      else if(strcmp(serv_ptr, "STSCHGNOTBSY") == 0)
	{
	  bzero(serv_host, MAXHSTNAMLNG);
	  readline(newsockfd, &serv_ptr);
	  status_nettable(atoi(serv_host), FALSE);
	}

      /* type of message is xidlview status exit */
      else if(strcmp(serv_ptr, "STSEXT") == 0)
	{
	  bzero(serv_host, MAXHSTNAMLNG);
	  readline(newsockfd, &serv_ptr);
	  remove_nettable(atoi(serv_host));
	}

      /* type of message is dbx connection request */
      else if (strcmp(serv_ptr, "DBXCON") == 0)
	{
	  bzero(serv_host, MAXHSTNAMLNG);
	  bzero(disp_host, MAXHSTNAMLNG);
	  bzero(port_str, MAXHSTNAMLNG);
	  disp_ptr = &disp_host[0];
	  port_ptr = &port_str[0];
	  readline(newsockfd, &disp_ptr); /* read in host name for the display */

	  readline(newsockfd, &serv_ptr); /* read in host name for the server */
	  readline(newsockfd, &cdlfil_ptr); /* read in Candle file to be used */
	  readline(newsockfd, &ivwses_ptr); /* read in preferred server id */
	  readline(newsockfd, &idlb_ptr); /* read in pid for idlbrowse */
	  readline(newsockfd, &wdw_ptr); /* read in pid for idlbrowse */
	  readline(newsockfd, &port_ptr);

	  sscanf (wdw_ptr, "%d", &wdwsys);

	  /* find if there exists an unconnected server in the net table matching 
	     the requirements asked for by the client  */
	  if (strlen(port_str) > 0)
	    {
	      port = atoi(port_str);
	      add_nettable(cdlfil_ptr, serv_ptr, disp_ptr, port);
	    }

	  if((port = search_nettable(ivwses_ptr, cdlfil, serv_host, disp_ptr)) != -1)
	    /* if so, then send the address over to client */
	    {
	      bzero(port_str, MAXHSTNAMLNG);
	      sprintf(port_str, "%d", port);
	      writeline(newsockfd, port_str, MAXHSTNAMLNG);
	      writeline(newsockfd, connect_table[port-SERV_PORT]->serv_host, MAXHSTNAMLNG);
	    }
	  else
	    {
	      disp_ptr = &disp_host[0];
	      port = add_nettable(cdlfil_ptr, serv_ptr, disp_ptr, 0);

	      /* store record for waiting in the array */
	      for ( i=0; i<nextwait;i++ )
		if (waitforstart[i].flag == 0)
		  {
		    /* got an intermediate spot */
		    waitforstart[nextwait].flag = 1;
		    waitforstart[nextwait].fd = newsockfd;
		    waitforstart[nextwait].port = port;
		  }

	      /* didn't find an intermediate spot, put at the end */

	      waitforstart[nextwait].flag = 1;
	      waitforstart[nextwait].fd = newsockfd;
	      waitforstart[nextwait].port = port;

	      nextwait++;

	      switch(childpid = fork())
		{
		case -1:
		  {
		    fprintf(stderr,"%s: ",argv[0]);
		    perror("error in fork");
		    fflush(stderr);
		    exit(1);
		  }
		  break;

		case 0:
		  close(sockfd);

		  /* start xidlview on the machine requested passing the display
		     parameter along. The Client will now hook up with this new
		     xidlview server */

		  bzero(port_str, MAXHSTNAMLNG);
		  sprintf(port_str, "%d", port);
		  bzero(command, MAXHSTNAMLNG);

		  if (wdwsys == XWDW)
		    {
		      strcpy(command, "rsh ");
		      strcat(command, serv_host);
                      strcat(command, " ");
		      strcat(command, LIBDIR);
		      strcat(command, "/IDLxidlview");
                      strcat(command, " ");
		      strcat(command, port_str);
		      strcat(command, " -display ");
		      strcat(command, disp_host);
		      strcat(command, ":0 ");
		      if (strlen(idlb_ptr))
			strcat(command, idlb);
		      else
			strcat(command, "-1");
		      strcat(command, " ");
		      gethostname(serv_ptr, MAXHSTNAMLNG);
		      strcat(command, serv_host);
		      sprintf(port_str, " %d ", MASTER_PORT);
		      strcat(command, port_str);
		      strcat(command, " &");
#ifdef DEBUG		      
		      printf("command is %s\n", command);
		      fflush(stdout);
#endif

		    }
		  else if (wdwsys == SUNWDW)
		    {
		      strcpy(command, "rsh ");
		      strcat(command, serv_host);
                      strcat(command, " ");
		      strcat(command, LIBDIR);
		      strcat(command, "/IDLsidlview &");
#ifdef DEBUG		      
		      printf("command is %s\n", command);
		      fflush(stdout);
#endif
		    }
		  else if (wdwsys == OPENWDW)
		    {
			fprintf(stderr,"%s: Open Windows not supported\n",argv[0]);
		    }
		  else
		    {
		      fprintf(stderr, "%s: Window System requested not valid.\n",argv[0]);
		      fflush(stderr);
		      exit(1);
		    }

		  if(system(command) != 0)
		    remove_nettable(port);

		  exit(0);
		  
		default:
		  while(wait3(&status, WNOHANG|WUNTRACED, NULL) > 0);
		}
	    }
	}
      else if (strcmp(serv_ptr, "STARTUP") == 0) /* xidlview started up */
	{
	  /* find who wanted this xidlview session started up */

	  readline(newsockfd, &serv_ptr);
	  port = atoi(serv_ptr);

	  for (i=0;i<nextwait;i++)
	    if (waitforstart[i].flag && waitforstart[i].port == port)
	      {
		/* found the guy */

		sprintf(port_str, "%d", waitforstart[i].port);
		writeline(waitforstart[i].fd, port_str, MAXHSTNAMLNG);
		writeline(waitforstart[i].fd, connect_table[port-SERV_PORT]->serv_host,
			  MAXHSTNAMLNG);

		close(waitforstart[i].fd);
		waitforstart[i].flag = 0;
	      }
	}
    }
}


/* add a session to the table */
int 
add_nettable(cdlfil, serv, disp, port)
  char *cdlfil;
  char *serv, *disp;
  int port;

{

  NETTABLE entry;
  static int i=0;
  char *serv_host, *disp_host, *cdlfil_entry;

  if((entry = (NETTABLE)malloc(sizeof(struct nettable))) == NULL)
    {
      fprintf(stderr, "%s: Malloc failure\n",nameofprogram);
      exit(1);
    }

  if((serv_host = (char *)malloc((strlen(serv)+1)*sizeof(char))) == NULL ||
     (disp_host = (char *)malloc((strlen(disp)+1)*sizeof(char))) == NULL ||
     (cdlfil_entry = (char *)malloc((strlen(cdlfil)+1)*sizeof(char))) == NULL)
    {
      fprintf(stderr, "%s: Malloc failure\n",nameofprogram);
      exit(1);
    }

  strcpy(serv_host, serv);
  strcpy(disp_host, disp);
  strcpy(cdlfil_entry, cdlfil);

  entry->serv_host = serv_host;
  entry->disp_host = disp_host;
  entry->cdlfil    = cdlfil_entry;
  entry->busy = TRUE;

  if (port)
    connect_table[port] = entry;
  else
    {
      i = (i+1)%MAXPRTNUM;
      while (connect_table[i] != NULL)
	i = (i+1)%MAXPRTNUM;
      entry->port = i+SERV_PORT;
      connect_table[i] = entry;
    }

  addbackup (entry);

  return entry->port;

}

/* Store the process-display association in a file */

void
addbackup (entry)
     NETTABLE entry;

{

  FILE *fp;
  FILE *fopen();
  char record[MAXLEN];

  if ((fp = fopen (MASTERFILE, "a")) == NULL)
    {
      fprintf(stderr, "%s: Master File open error.\n",nameofprogram);
      fflush(stderr);
      return;
    }

  sprintf(record, "%d\t%s\t%s\t%s\t%d\n", entry->port, entry->cdlfil, entry->serv_host,
	  entry->disp_host, entry->busy);
#ifdef DEBUG
  printf("record: %s\n", record);
  fflush(stdout);
#endif

  fputs(&record[0], fp);
  fclose(fp);

}


void
deletebackup (entry)
     NETTABLE entry;

{
  FILE *fp, *fopen();
  long pos, oldpos;
  int port, busy;
  char str[MAXLEN], cdlfil[MAXLEN], serv[MAXLEN], disp[MAXLEN];

  if((fp = fopen (MASTERFILE, "r+")) == NULL)
    {
      fprintf(stderr, "%s: Master File open error.\n",nameofprogram);
      fflush(stderr);
      return;
    }

  pos = ftell (fp);
  while (fgets(str, MAXLEN, fp) != NULL)
    {
      oldpos = ftell(fp);
      sscanf(str, "%d %s %s %s %d", &port, cdlfil, serv, disp, &busy);
      if (port == entry->port)
	{
	  fseek(fp, pos, 0);
	  fputs("I", fp);
	  fseek(fp, oldpos, 0);
	}
      pos = oldpos;
    }
}

void
startbackup ()

{
  
}


/* remove a session from the table */
void 
remove_nettable(port)
     int port;

{
  deletebackup (connect_table[port-SERV_PORT]);
  free(connect_table[port-SERV_PORT]);
  connect_table[port-SERV_PORT] = NULL;

}


/* change the busy status of a session in the table */

void 
status_nettable(port, busy)
     int port, busy;

{
  
  connect_table[port-SERV_PORT]->busy = busy;

}


/* search for a free session in the table that matches the requirements
   of a client connection */

int 
search_nettable(ivwses, cdlfil, serv, disp)
     char *ivwses, *cdlfil;
     char *serv, *disp;

{

  int i, ses;
  int backup = -1;
#ifdef DEBUG
  printf("in search ivwses %s\n", ivwses);
  printf("search: display is %s\n", disp);
  fflush(stdout);
#endif

  if (ivwses && strlen(ivwses) > 0)
    {
      ses = atoi(ivwses);
      ses--;
      if ( ses >= 0 && connect_table[ses] && !connect_table[ses]->busy)
	{
#ifdef DEBUG
	  printf("picking up %d\n", ses);
#endif
	  return (ses+SERV_PORT);
	}
    }
  for(i=0; i<MAXPRTNUM; i++)
    {

      if(connect_table[i] != NULL && strcmp(serv, connect_table[i]->serv_host) == 0 &&
	 strcmp(disp, connect_table[i]->disp_host) == 0 && !connect_table[i]->busy)

	if (strcmp(cdlfil, connect_table[i]->cdlfil) != 0)
	  {
	    backup = i;
	    continue;
	  }
	else
	  {
	    return (i+SERV_PORT);
	  }

    }

  if (backup != -1)
    {
      return (backup+SERV_PORT);
    }
  else
    {
      return -1;
    }
}



