/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlview/idlview.c 
*				 					* 
*   Copyright (C) 1991 Vijay Anand
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>

#define MAXLEN 128
#define MAXID   20

#define SUNWDW     's'
#define XWDW       'x'
#define OPENWDW    'o'
#define VERSION    5.0


extern void sndcdlwdw();
void revision_number();
char *IDLcandlefilename;


main(argc, argv)
     int argc;
     char *argv[];

{

  char server[MAXLEN], display[MAXLEN], port[MAXLEN];
  int i, wdw, idlb;
  IDLcandlefilename = (char *)malloc(MAXLEN);

  wdw = idlb = 0;
  bzero(IDLcandlefilename, MAXLEN);
  bzero(server, MAXLEN);
  bzero(display, MAXLEN);
  bzero(port, MAXLEN);
  strcpy (IDLcandlefilename, "");
  for (i=1; i<argc; i++)
    {
      if (!strcmp(argv[i], "-C")) /* Candle file */
	{
	  if (argv[i+1])
	    {
	      strcpy(IDLcandlefilename, argv[i+1]);
	      i++;
	    }
	}
      else if (!strcmp(argv[i], "-s")) /* sidlview */
	{
	  if (!wdw)
	    wdw = SUNWDW;
	  else
	    {
	      fprintf(stderr, "idlview: Window system already specified in Command line.\n"
		      );
	      fflush(stderr);
	      exit(1);
	    }
	  
	}
      else if (!strcmp(argv[i], "-x")) /* xidlview */
	{
	  if (!wdw)
	    wdw = XWDW;
	  else
	    {
	      fprintf(stderr, "idlview: Window system already specified in Command line.\n"
		      );
	      fflush(stderr);
	      exit(1);
	    }
	}
      else if (!strcmp(argv[i], "-o")) /* xidlview */
	{
	  if (!wdw)
	    wdw = OPENWDW;
	  else
	    {
	      fprintf(stderr, "idlview: Window system already specified in Command line.\n"
		      );
	      fflush(stderr);
	      exit(1);
	    }
	}
      else if (!strcmp(argv[i], "-V")) /* Candle file */
	{
	  revision_number(argv[0]);
	  fflush(stdout);
	  exit(0);
	}
      else if (!strcmp(argv[i], "-server")) /* server location */
	{
	  if (argv[i+1])
	    {
	      strcpy(server, argv[i+1]);
	      i++;
	    }
	}
      else if (!strcmp(argv[i], "-display")) /* display location */
	{
	  if (argv[i+1])
	    {
	      strcpy (display, argv[i+1]);
	      i++;
	    }
	}
      else if (!strcmp(argv[i], "-port")) /* Port Number */
	{
	  if (argv[i+1])
	    {
	      strcpy (port, argv[i+1]);
	      i++;
	    }
	}
      else if (!strcmp(argv[i], "-pid")) /* idlbrowse */
	{
	  if (argv[i+1])
	    {
	      idlb = atoi (argv[i+1]);
	      i++;
	    }
	}
      else /* error in command line argument */
	{
	  fprintf(stderr, "idlview: Incorrect command line argument: %s\n", argv[i]);
	  fflush(stderr);
	  exit(1);
	}
    }
    if (!wdw) {
      if (!strcmp(DEFAULTWM,"SUNTOOLS")) 
         wdw =  's';
      else if (!strcmp(DEFAULTWM,"XWINDOWS"))
         wdw =  'x';
      else if (!strcmp(DEFAULTWM,"OPENWINDOWS"))
         wdw =  'o';
      else {
	fprintf(stderr,"idlview: Invalid default window manager specification\n");
	exit (1);
      }
    }

  sndcdlwdw("", wdw, server, display, idlb, port);
  exit(0);
}

void usage(name)
char *name;
{
 (void)fprintf(stderr,"usage: %s [-V] [-C Candlefile] [-s -x -o] [-server servername] [-display displayname] [-pid idlbrowsepid]\n",name);
}

void get_revision_number(str)
char *str;
{
 (void)sscanf("$Revision: 5.0 $","%*s %s",str);
}

void revision_number(name)
char *name;
{
 char revision_str[20];

 (void)get_revision_number(revision_str);
 (void)printf("%s: A Graphical Data Display Server Version %s\n",name,revision_str);
 (void)printf("Default Window System is %s\n",DEFAULTWM);
 (void)printf("Default Master Host is %s\n",MASTERHOST);
 usage(name);
}
