/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlread/main.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include "idlread.h"
#include "C/IDLIO.h"

#ifndef lint
static char rcsid[] = "$Header$";
#endif

int nodepos = FALSE;
int attrpos = FALSE;
int fileflag = FALSE;
int fdesc;

main(argc,argv)
int argc;
char *argv[];
{
        nodeDesc root_node;
        
	IDLreaderror[0] = IDLStructureName[0] = '\0';
        args_process (argc,argv);

	if ((root_node = IDLread(fdesc)) != NULL)
	    {
               if (attrpos == TRUE)
 		  out2(stdout, root_node, TWOPASS);
               else if (nodepos == TRUE)
  		  out1(stdout, root_node, TWOPASS);
	       else /* default idldata */
		  out(stdout, root_node, TWOPASS);
	    }
  	else {
	       (void) fprintf(stdout, "#\n");
	}
	return 0;
}


int
args_process (argc,argv)
int argc;
char *argv[];
{
  int i;
  void exit();
  void revision_number(), usage();

  fdesc = 0;
  for (i=1;i<argc;i++)
    {
      if (!strcmp (argv[i], "-V")) {
	revision_number(argv[0]);
        exit (0);
      }
      else if (!strcmp (argv[i],"-a"))
	attrpos = TRUE;
      else if (!strcmp (argv[i],"-n"))
	nodepos = TRUE;
      else if (!strcmp (argv[i],"-"))
	{
	  if (fileflag == TRUE)
	    {
	      (void) fprintf (stderr,"A redefinition of the input file\n");
	      usage(argv[0]);
	      exit (1);
	    }
	  fileflag = TRUE;
	}
      else if (argv[i][0] == '-')
	{
	  (void) fprintf (stderr,"Illegal option: %-s\n",argv[i]);
	  usage(argv[0]);
	  exit (1);
	}
      else
	{
	  if (fileflag == TRUE)
	    {
	      (void) fprintf (stderr,"A redefinition of the input file\n");
	      usage(argv[0]);
	      exit (1);
	    }
	  if ((fdesc = open (argv[i],O_RDONLY)) == -1)
	    {
	      perror (argv[i]);
	      exit (1);
	    }
	  fileflag = 1;
	}
    }
}


void usage(name)
char *name;
{
 (void) fprintf (stderr,"usage: %s [-n] [-a] [-] [file]\n",name);
}


void revision_number(name)
char *name;
{
 char revision_str[20];

 (void)sscanf("$Revision: 5.0 $","%*s %s",revision_str);
 (void)printf("%s: IDL generic reader Version %s\n",name,revision_str);
 usage(name);
}

