/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlformat/format.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*									* 
\***********************************************************************/ 

#ifndef lint
    static char rcsid[] = "$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/idlformat/RCS/format.c,v 4.0 89/04/12 07:34:31 cheung Exp Locker: cheung $";
#endif

   /* ******************************************************************* *\
   *   Revision Log:                                                       *
   *       $Log:	format.c,v $
 * Revision 4.0  89/04/12  07:34:31  cheung
 * format.c  Ver 4.0
 * 
 * Revision 3.9  89/03/02  15:33:53  cheung
 * format.c  Ver 3.9
 * 
 * Revision 3.8  89/03/02  15:26:53  cheung
 * format.c  Ver 3.9
 *                                                           *
   *                                                                       *
   *   Edit Log:                                                           *
   *                                                                       *
   *                                                                       *
   \* ******************************************************************* */

#include <stdio.h>
#include <ctype.h>
#define TRUE 1
#define FALSE 0
#define LINESIZE 2000
#define LINELEN 70


main(argc, argv)
int argc;
char *argv[];
{

	int c;
	int savec;
	int blanks;
	int indentsize;
	int set;
	int seq;
	int lastwasblank;
	int bracket;
	int linelen;
	char buf[LINESIZE];
        void exit(), revision_number(), usage();
	
	if (argc == 1) {
	    indentsize = 4;
	}
	else if (argc == 2) {
            if (!strcmp(argv[1],"-V")) {
		revision_number(argv[0]);
		exit (0);
	    }
            else {
	      indentsize = atoi(argv[1]);
	      if ((indentsize < 0)  || (indentsize > 20)) {
	  	indentsize = 4;
		(void) fprintf(stderr,"indentsize = %d\n", indentsize);
	      }
            }
	}
	else if (argc != 2) {
		usage(argv[0]);
		exit(1);
	}

	blanks = 0;
	set= FALSE;
	seq = FALSE;
	bracket = FALSE;
	lastwasblank = FALSE;
	linelen = 0;
	while ((c=getchar()) != EOF) {

		if (c=='[') {
			blanks = blanks + indentsize;
			(void) printf("\n");
			printblanks(blanks-1);
			linelen = blanks;
			(void) printf("[");
			lastwasblank = FALSE;
			bracket = TRUE;
		}
		else if ((c=='{') || (c=='<')) {
			blanks = blanks + indentsize;
			(void) printf("\n");
			printblanks(blanks-1);
			linelen = blanks;
			(void) printf("%c",c);
			if (c=='{') set = TRUE;
			else if (c=='<') seq = TRUE;
			lastwasblank = FALSE;
		}
		else if (c==';'){
			(void) printf(";\n");
			printblanks(blanks);
			linelen = blanks;
			lastwasblank = TRUE;
		}
		else if ((c=='>') || (c=='}')) {
			if (c=='}') set = FALSE;
			else if (c=='>') seq = FALSE;
			savec = c;
			while (isspace(c=getchar()))
			    ;
			if (c == ';') {
			    (void) printf("%c;\n",savec);
			}
			else {
			    (void) printf("%c\n",savec);
			    (void) ungetc(c, stdin);
			}
			blanks = blanks-indentsize;
			printblanks(blanks);
			linelen = blanks;
			lastwasblank = TRUE;
		}
		else if (c=='#'){
			(void) printf("\n#\n");
		}
		else if ((c=='^')  &&  ((set)||(seq)) && !(bracket)) {
			(void) printf("%c\n",c);
			printblanks(blanks);
			lastwasblank = TRUE;
		}
		else if	 (c==']') {
			while (isspace(c=getchar()))
			    ;
			if (c == ';') {
			    (void) printf("];\n");
			}
			else {
			    (void) printf("]\n");
			    (void) ungetc(c, stdin);
			}
			blanks = blanks-indentsize;
			printblanks(blanks);
			linelen = blanks;
			lastwasblank = TRUE;
			bracket = FALSE;
		}
		else if (c==' ') {
			if (!lastwasblank) {
				lastwasblank = TRUE;
				if (linelen > LINELEN-15) {
				    (void) printf("\n");
				    printblanks(blanks);
				    linelen=blanks;
				}
				else {
				    (void) printf(" ");
				    ++linelen;
				}
			}
		}
		else if ((c=='\n') || (c=='\t')) {
			if (!lastwasblank) {
			    (void) printf(" ");
			    ++linelen;
			    lastwasblank = TRUE;
			}
		}
		else if (c=='-') { /* may be comment */
		   if ((c = getchar())=='-') {
		        (void) fgets(buf, LINESIZE, stdin);
		        (void) printf("\n-- %s", buf);
			printblanks(blanks);
			linelen = blanks;
			lastwasblank = TRUE;
		   }
		   else {
		        (void) printf("-");
			++linelen;
			lastwasblank = FALSE;
		        (void) ungetc(c, stdin);
		   }
		}
		else if (c=='"')
		       { (void) printf("\"");
			 while ((c=getchar()) != EOF && c != '"') {
			     (void) printf("%c",c);
			     ++linelen;
			 }
			 (void) printf("\"");
			 ++linelen;
			 lastwasblank = FALSE; /* last was double quote */
		       }
		else {
			(void) printf("%c",c);
			++linelen;
			lastwasblank = FALSE;
		}
		
	}
 	return 0;
}



printblanks(num_blanks)
int num_blanks;
{

	int i;
	int numtabs;
	int blanksleft;

	numtabs =  num_blanks/8;
	blanksleft = num_blanks%8;

	for (i=0; i<numtabs; i++)
		(void) printf("\t");
	for (i=0; i<blanksleft; i++)
		(void) printf(" ");
}

void usage(name)
char *name;
{
 (void) fprintf(stderr,"usage: %s [[indentsize][-V]]\n",name);
}

void revision_number(name)
char *name;
{
 char revision_str[20];

 (void)sscanf("$Revision: 5.0 $","%*s %s",revision_str);
 (void)printf("%s: IDL ASCII representation instance formatter Version %s\n",name,revision_str);
 usage(name);
}

