/***********************************************************************\ 
*									* 
*   File: scorpion/src/idldatacount/main.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 

#ifndef lint
   static char rcsid[] = "$Header: /r/zep/usr/rts/p/personal/hkaram/tech/src/idldatacount/RCS/main.c,v 4.2 90/08/20 16:21:52 hkaram Release42 Locker: hkaram $";
#endif

   /* ******************************************************************* *\
   *   Revision Log:                                                       *
   *       $Log:	main.c,v $
 * Revision 4.2  90/08/20  16:21:52  hkaram
 * @
 * 
 * Revision 4.0  89/04/12  07:42:47  cheung
 * main.c  Ver 4.0
 * 
 * Revision 3.9  89/04/02  12:59:49  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  11:17:40  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.8  89/03/05  18:32:39  cheung
 * main.c  Ver 3.9
 * 
   *                                                                       *
   *   Edit Log:                                                           *
   *     Jan 9 1985 (shannon) Created.                                     *
   *                                                                       *
   \* ******************************************************************* */

#include <stdio.h>
#include "idldatacount.h"
#define strequal(s1, s2) (s1==s2)

/*
 *    Forward References:
 */
void    DetermineCounts();
void    DetermineAttType();
Boolean campare_nodes();
void    PrintCounts();
void exit();
void usage(), revision_number();


main(argc,argv)
int argc;
char *argv[];
{
	nodeDesc root, inputIDLinstance();
	nodes nodelist;
	FILE *outfp;


	if (argc == 2){
	  if(!strcmp(argv[1],"-V")){
	    revision_number(argv[0]);
	    exit(0);
          }
          else {
            usage(argv[0]);
            exit(-1);
          }
        }
        else if(argc != 1) {
          usage(argv[0]);
            exit(-1);
        }

	outfp = stdout;
	nodelist = Nnodes;
	root = inputIDLinstance(0);

	DetermineCounts(root, nodelist);
	PrintCounts(outfp, nodelist);

	return 0;
}


nodeDesc
inputIDLinstance(fdesc)
int fdesc;
{
  nodeDesc rootnode, IDLread();
  extern char IDLreaderror[];
  if ((rootnode = IDLread(fdesc)) == NULL) {
    (void)fprintf(stderr, "%s\n",IDLreaderror);
    exit(-1);
  }
  return rootnode;
}


void DetermineCounts(AnodeDesc, nodelist)
nodeDesc AnodeDesc;
nodes nodelist;
{
	SEQattrDesc Satt;
	attrDesc Anatt;
	SEQnode Snode;
	node Anode;
	Boolean found=FALSE;

	if (inSEQnodeDesc(nodelist->descriptions, AnodeDesc))
	    return;
	else appendfrontSEQnodeDesc(nodelist->descriptions, AnodeDesc);

	foreachinSEQnode(nodelist->list, Snode, Anode) {
	    if (strequal(Anode->name, AnodeDesc->name)) {
		found = TRUE;
		++(Anode->count);
		break;
	    }
	}
	if (!found) { /* add to list */
	    Anode= Nnode;
	    Anode->name = AnodeDesc->name;
	    Anode->count = 1;
	    appendfrontSEQnode(nodelist->list, Anode);
	}

	foreachinSEQattrDesc(AnodeDesc->attributes, Satt, Anatt) {
	    ++(nodelist->attcount);
	    DetermineAttType(nodelist, Anatt->value);
	}
}

void DetermineAttType(nodelist, attributeval)
nodes nodelist;
IDLVALUE attributeval;
{
	SEQIDLVALUE Sval;
	SEQIDLVALUE Stval;
	IDLVALUE Aval;

	switch (typeof(attributeval)) {
	    case KnodeDesc:
		DetermineCounts(attributeval.VnodeDesc, nodelist);
		break;
	    case KintegerDesc:
		++(nodelist->intcount);
		break;
	    case KrationalDesc:
		++(nodelist->ratcount);
		break;
	    case KstringDesc:
		++(nodelist->strcount);
		break;
	    case KbooleanDesc:
		++(nodelist->boolcount);
		break;
	    case KsetDesc:
		++(nodelist->setcount);
		foreachinSEQIDLVALUE(attributeval.VsetDesc->value, 
							Stval, Aval){
		    DetermineAttType(nodelist, Aval);
		}
		break;
	    case KsequenceDesc:
		++(nodelist->seqcount);
		foreachinSEQIDLVALUE(attributeval.VsequenceDesc->value, 
							Sval, Aval){
		    DetermineAttType(nodelist, Aval);
		}
		break;
	    }
}


Boolean compare_nodes(Anode1,Anode2)
node Anode1;
node Anode2;
{
 return (Anode1->count < Anode2->count) ? TRUE : FALSE;
}
   
   

void PrintCounts(outfp, nodelist)
FILE *outfp;
nodes nodelist;
{
	SEQnode Snode;
	node Anode;
	int nodecount;

	nodecount = 0;
	foreachinSEQnode(nodelist->list, Snode, Anode) {
	    nodecount += Anode->count;
	}
	(void)fprintf(outfp, "Total number of nodes: %d\n", nodecount);
	sortSEQnode(nodelist->list,compare_nodes);
	foreachinSEQnode(nodelist->list, Snode, Anode) {
	    (void)fprintf(outfp, "\tnode '%s': %d\n", Anode->name, Anode->count);
	}
	(void)fprintf(outfp, "Total number of attributes: %d\n", nodelist->attcount);
	(void)fprintf(outfp, "\ttype Integer: %d\n", nodelist->intcount);
	(void)fprintf(outfp, "\ttype Rational: %d\n", nodelist->ratcount);
	(void)fprintf(outfp, "\ttype String: %d\n", nodelist->strcount);
	(void)fprintf(outfp, "\ttype Boolean: %d\n", nodelist->boolcount);
	(void)fprintf(outfp, "\ttype Sequence: %d\n", nodelist->seqcount);
	(void)fprintf(outfp, "\ttype Set: %d\n", nodelist->setcount);
	(void)fprintf(outfp, "\ttype Node: %d\n", nodecount-1); /* don't count root */
}


void
usage(name)
char *name;
{
 (void)fprintf(stderr,"usage: %s [-V]\n",name);
}

void revision_number(name)
char *name;
{
 char revision_str[20];

 (void)sscanf("$Revision: 5.0 $","%*s %s",revision_str);
 (void)printf("%s: Collect statistics on an IDL instance Version %s\n",name,revision_str);
 usage(name);
}
