/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlcheck/check/retrieve.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Check.h"
#include "macros.h"
#include <stdio.h>

retrieve_type(type_refs, index, type_value)
SEQTypeEntity type_refs;
int index;
TypeEntity *type_value;
{
    SEQTypeEntity Stype;
    TypeEntity Atype;

    TRACE("retrieve_type");

    if (lengthSEQTypeEntity(type_refs) < index) {
	DEBUG1("Error in retrieve_type index = %d type seq =", index);
	foreachinSEQTypeEntity(type_refs, Stype, Atype)
	    DEBUG1(" %s", Atype.IDLclassCommon->sem_name);
	DEBUG0("\n");
	fatal_error(1);
    }
    else {
	 ithinSEQTypeEntity(type_refs,index,(*type_value));	
    }
    DEBUG1("\tretrieved type '%s'\n", type_value->IDLclassCommon->sem_name);
}

retrieve_def(define_refs,index,def_value)
SEQDefinition define_refs;
int index;
Definition *def_value;
{
    SEQDefinition Sdefine;
    Definition Adefine;

    TRACE("retrieve_def");
    if (lengthSEQDefinition(define_refs) < index) {
	DEBUG1("Error in retrieve_def index = %d define seq =", index);
	foreachinSEQDefinition(define_refs, Sdefine, Adefine)
	    DEBUG1(" %s", Adefine->sem_name);
	DEBUG0("\n");
	fatal_error(1);
    }
    else {
	 ithinSEQDefinition(define_refs,index,(*def_value));	
    }
    DEBUG1("\tretrieved def %s\n", (*def_value)->sem_name);
}

retrieve_string(string_refs, index, string_value)
SEQString string_refs;
int index;
String *string_value;
{
    SEQString Sstring;
    String Astring;

    TRACE("retrieve_string");

    if (lengthSEQString(string_refs) < index) {
	DEBUG1("Error in retrieve_string index = %d string seq =", index);
	foreachinSEQString(string_refs, Sstring, Astring)
	    DEBUG1(" %s", Astring);
	DEBUG0("\n");
	fatal_error(1);
    }
    else {
	 ithinSEQString(string_refs,index,(*string_value));	
    }
    DEBUG1("\tretrieved string %s\n", *string_value);
}
retrieve_rat(rat_refs, index, rat_value)
SEQfloat rat_refs;
int index;
float *rat_value;
{
    SEQfloat Srat;
    float Arat;

    TRACE("retrieve_rat");

    if (lengthSEQfloat(rat_refs) < index) {
	DEBUG1("Error in retrieve_rat index = %d rat seq =", index);
	foreachinSEQfloat(rat_refs, Srat, Arat)
	    DEBUG1(" %6.2f", Arat);
	DEBUG0("\n");
	fatal_error(1);
    }
    else {
	 ithinSEQfloat(rat_refs,index,(*rat_value));	
    }
    DEBUG1("\tretrieved rational %6.2f\n", *rat_value);
}

retrieve_int(int_refs, index, int_value)
SEQint int_refs;
int index;
int *int_value;
{
    SEQint Sint;
    int Aint;

    TRACE("retrieve_int");

    if (lengthSEQint(int_refs) < index) {
	DEBUG1("Error in retrieve_int index = %d int seq =", index);
	foreachinSEQint(int_refs, Sint, Aint)
	    DEBUG1(" %d", Aint);
	DEBUG0("\n");
	fatal_error(1);
    }
    else {
	 ithinSEQint(int_refs,index,(*int_value));	
    }
    DEBUG1("\tretrieved integer %d\n", *int_value);
}

int get_index(body, code_pos)
SEQint body;
int *code_pos;
{
    int hi, lo;
    int index;

    TRACE("get_index");
    if (lengthSEQint(body) < *code_pos + 1) {
	DEBUG1("Error in get_index: code_pos = %d\n", *code_pos);
	fatal_error(1);
    }
    ithinSEQint(body,(*code_pos)++,lo);
    ithinSEQint(body,(*code_pos),hi);
    index = (hi << 8) | lo;
    return(index);
}


int get_op(body, pos)
SEQint body;
int pos;
{
    int val;
    char buf[80];

    if (lengthSEQint(body) < pos ) {
	DEBUG1("Error in get_op: code_pos = %d\n", pos);
	fatal_error(1);
    }
    ithinSEQint(body, pos, val);
    TRACE(sprintf(buf, "get_op val %d", val));
    return(val);
}
