/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlcheck/check/oper.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include "Check.h"
#include "instructions.h"
#include "macros.h"

/* extern int invalid_arg(entry, num_args, arg1, arg2)
int entry;
int num_args;
runstackEntry arg1, arg2; */

#define TOLERANCE 	.0005	/* for equality of rational */
#define abs(x)		((x)<0 ? -(x) : (x))

extern char 		*instr_type();
extern runstackEntry	get_object();
Boolean			equalSETIDLVALUE();
Boolean			equalSEQIDLVALUE();

runstackEntry IDLrunstackEntry;
#define TVALUETorunstackEntry(tvalue) (IDLrunstackEntry.VTVALUE=tvalue,IDLrunstackEntry)

/* operators which work on collections */
collection_op(arg1, arg2, oper, result)
runstackEntry arg1;
runstackEntry arg2;
int oper;
runstackEntry *result;
{
	collect		col1, col2;
	SEQIDLVALUE	Sobj;
	IDLVALUE	obj;
	Boolean		eq;

	/* test that arguments are the right type */
	if (typeof(arg1) != Kcollect || typeof(arg2) != Kcollect) {
		invalid_arg(oper, 2, arg1, arg2);
	}
	col1 = arg1.Vcollect;
	col2 = arg2.Vcollect;

	switch (oper) {

	case union_op:
		result->Vcollect = Ncollect;
		foreachinSEQIDLVALUE(col1->objects,Sobj,obj)
			appendrearSEQIDLVALUE(result->Vcollect->objects,obj);
		foreachinSEQIDLVALUE(col2->objects,Sobj,obj)
			if (!inSEQIDLVALUE(result->Vcollect->objects,obj))
				appendrearSEQIDLVALUE(result->Vcollect->objects,
							obj);
		break;

	case intersect_op:
		result->Vcollect = Ncollect;
		foreachinSEQIDLVALUE(col1->objects,Sobj,obj)
			if (inSEQIDLVALUE(col2->objects,obj))
				appendrearSEQIDLVALUE(result->Vcollect->objects,
							obj);
		break;

	case subset_op:
		eq = TRUE;
		foreachinSEQIDLVALUE(col1->objects,Sobj,obj)
			if (!inSEQIDLVALUE(col2->objects,obj))
				eq = FALSE;

		if (eq == TRUE)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;

		break;

	case propSubset_op:
		eq = TRUE;
		foreachinSEQIDLVALUE(col1->objects,Sobj,obj)
			if (!inSEQIDLVALUE(col2->objects,obj))
				eq = FALSE;

		if (eq == TRUE && (lengthSEQIDLVALUE(col1->objects)
				 < lengthSEQIDLVALUE(col2->objects)))
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;
	case same_op:
		if (equalSEQIDLVALUE(col1->objects, col2->objects))
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;
	default:
		invalid_oper(oper, "collection_op");
		break;
	}
}


/* operators which work on numbers */
number_op(arg1, arg2, oper, result)
runstackEntry arg1;
runstackEntry arg2;
int oper;
runstackEntry *result;
{
	
	float num1, num2;
	Boolean is_rational=FALSE;

	/* singleton collections */
	if (typeof(arg1) == Kcollect)
		arg1 = get_object(arg1);
	if (typeof(arg2) == Kcollect)
		arg2 = get_object(arg2);

	/* get number arguments		         */
	/* arguments must be integer or rational */
	get_num(&num1, arg1, &is_rational, oper);
	get_num(&num2, arg2, &is_rational, oper);

	switch (oper) {

	case plus_op:
		if (is_rational) {
			result->VrationalDesc = NrationalDesc;
			result->VrationalDesc->value = num1 + num2;
		}
		else {
			result->VintegerDesc = NintegerDesc;
			result->VintegerDesc->value = (int)num1 + (int)num2;
		}
		break;

	case minus_op:
		if (is_rational) {
			result->VrationalDesc = NrationalDesc;
			result->VrationalDesc->value = num1 - num2;
		}
		else {
			result->VintegerDesc = NintegerDesc;
			result->VintegerDesc->value = (int)num1 - (int)num2;
		}
		break;

	case times_op:
		if (is_rational) {
			result->VrationalDesc = NrationalDesc;
			result->VrationalDesc->value = num1 * num2;
		}
		else {
			result->VintegerDesc = NintegerDesc;
			result->VintegerDesc->value = (int)num1 * (int)num2;
		}
		break;

	case divide_op:
		result->VrationalDesc = NrationalDesc;
		result->VrationalDesc->value = num1 / num2;
		break;

	case num_less_op:
		if (num1 < num2)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case num_lessEq_op:
		if (num1 <= num2)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case num_greater_op:
		if (num1 > num2)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case num_grtrEq_op:
		if (num1 >= num2)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case num_equal_op:
		if (abs(num1-num2) < TOLERANCE )
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case num_notEqual_op:
		if (abs(num1-num2) > TOLERANCE )
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	default:
		invalid_oper(oper, "number_op");
		break;
	}
}


/* get the number argument     */
/* must be rational or integer */
get_num(num, arg, is_rational, oper)
float 		*num;
runstackEntry 	arg;
Boolean		*is_rational;
int		oper;
{
	if (typeof(arg) == KrationalDesc) {
		*is_rational = TRUE;
		*num = arg.VrationalDesc->value;
	}
	else if (typeof(arg) == KintegerDesc) {
		*num = (float)arg.VintegerDesc->value;
	}
	else {	  
		invalid_arg(oper, 1, arg, TVALUETorunstackEntry(NTVALUE));
	}
}

/* operators which work on booleans */
boolean_op(arg1, arg2, oper, result)
runstackEntry arg1;
runstackEntry arg2;
int oper;
runstackEntry *result;
{
	Boolean type1, type2;

	/* singleton collections */
	if (typeof(arg1) == Kcollect)
		arg1 = get_object(arg1);
	if (typeof(arg2) == Kcollect)
		arg2 = get_object(arg2);

	/* test that arguments are true or false values */
	switch (typeof(arg1)) {
	    case KbooleanDesc:
		type1 = arg1.VbooleanDesc->value;
		break;
	    case KTVALUE:
		type1 = TRUE;
		break;
	    case KFVALUE:
		type1 = FALSE;
		break;
	    default:
		invalid_arg(oper, 2, arg1, arg2);
		break;
	}
	switch (typeof(arg2)) {
	    case KbooleanDesc:
		type2 = arg2.VbooleanDesc->value;
		break;
	    case KTVALUE:
		type2 = TRUE;
		break;
	    case KFVALUE:
		type2 = FALSE;
		break;
	    default:
		invalid_arg(oper, 2, arg1, arg2);
		break;
	}

	switch (oper) {

	case and_op:
		if (type1 == TRUE && type2 == TRUE)
			result->VTVALUE = NTVALUE;
		else 
			result->VFVALUE = NFVALUE;
		break;

	case or_op:
		if (type1 == TRUE || type2 == TRUE)
			result->VTVALUE = NTVALUE;
		else 
			result->VFVALUE = NFVALUE;
		break;

	case bool_equal_op:
		if (type1 == type2)
			result->VTVALUE = NTVALUE;
		else 
			result->VFVALUE = NFVALUE;
		break;

	case bool_notEqual_op:
		if (type1 != type2)
			result->VTVALUE = NTVALUE;
		else 
			result->VFVALUE = NFVALUE;
		break;

	default:
		invalid_oper(oper, "boolean_op");
		break;

	}
}

/* operators which work on strings */
string_op(arg1, arg2, oper, result)
runstackEntry arg1;
runstackEntry arg2;
int oper;
runstackEntry *result;
{
	String s1, s2;

	/* singleton collections */
	if (typeof(arg1) == Kcollect)
		arg1 = get_object(arg1);
	if (typeof(arg2) == Kcollect)
		arg2 = get_object(arg2);

	/* test that both arguments are string arguments */
	if (typeof(arg1) != KstringDesc || typeof(arg2) != KstringDesc) {
		invalid_arg(oper, 2, arg1, arg2);
	}
	s1 = arg1.VstringDesc->value;
	s2 = arg2.VstringDesc->value;

	switch (oper) {

	case str_less_op:
		if (strcmp(s1,s2) < 0)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case str_lessEq_op:
		if (strcmp(s1,s2) <= 0)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case str_greater_op:
		if (strcmp(s1,s2) > 0)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case str_grtrEq_op:
		if (strcmp(s1,s2) >= 0)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case str_equal_op:
		if (strcmp(s1,s2) == 0)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case str_notEqual_op:
		if (strcmp(s1,s2) != 0)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	default:
		invalid_oper(oper, "string_op");
		break;
	}
}

/* operators which work on sets */
set_op(arg1, arg2, oper, result)
runstackEntry arg1;
runstackEntry arg2;
int oper;
runstackEntry *result;
{

	SEQIDLVALUE set1, set2;

	/* singleton collections */
	if (typeof(arg1) == Kcollect)
		arg1 = get_object(arg1);
	if (typeof(arg2) == Kcollect)
		arg2 = get_object(arg2);

	/* test that arguments are sets */
	if (typeof(arg1) != KsetDesc || typeof(arg2) != KsetDesc) {
		invalid_arg(oper, 2, arg1, arg2);
	}
	set1 = arg1.VsetDesc->value;
	set2 = arg2.VsetDesc->value;

	switch (oper) {
	case set_equal_op: 
	case is_op:
		if (equalSEQIDLVALUE(set1, set2))
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case set_notEqual_op: 
		if (!equalSEQIDLVALUE(set1, set2))
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;
	default:
		invalid_oper(oper, "set_op");
		break;

	}
}


/* operators which work on sequences */
seq_op(arg1, arg2, oper, result)
runstackEntry arg1;
runstackEntry arg2;
int oper;
runstackEntry *result;
{

	SEQIDLVALUE seq1, seq2;

	/* singleton collections */
	if (typeof(arg1) == Kcollect)
		arg1 = get_object(arg1);
	if (typeof(arg2) == Kcollect)
		arg2 = get_object(arg2);

	/* test that arguments are sequences */
	if (typeof(arg1) != KsequenceDesc || typeof(arg2) != KsequenceDesc) {
		invalid_arg(oper, 2, arg1, arg2);
	}
	seq1 = arg1.VsequenceDesc->value;
	seq2 = arg2.VsequenceDesc->value;

	switch (oper) {
	case seq_equal_op: 
		if (equalSEQIDLVALUE(seq1, seq2))
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case seq_notEqual_op: 
		if (!equalSEQIDLVALUE(seq1, seq2))
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	default:
		invalid_oper(oper, "seq_op");
		break;
	}
}

/* operators which work on nodes */
node_op(arg1, arg2, oper, result)
runstackEntry arg1;
runstackEntry arg2;
int oper;
runstackEntry *result;
{
	nodeDesc n1, n2;

	/* singleton collections */
	if (typeof(arg1) == Kcollect)
		arg1 = get_object(arg1);
	if (typeof(arg2) == Kcollect)
		arg2 = get_object(arg2);

	/* test that arguments are nodes */
	if (typeof(arg1)!=KnodeDesc || typeof(arg2)!=KnodeDesc) {
		invalid_arg(oper, 2, arg1, arg2);
	}
	n1 = arg1.VnodeDesc;
	n2 = arg2.VnodeDesc;

	switch (oper) {
	case node_equal_op:
		if (n1->label == n2->label)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case is_op:
		if (n1->name == n2->name)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;

	case node_notEqual_op:
		if (n1->label != n2->label)
			result->VTVALUE = NTVALUE;
		else
			result->VFVALUE = NFVALUE;
		break;
	default:
		invalid_oper(oper, "node_op");
		break;
	}
}


Boolean equalSEQIDLVALUE(s1, s2)
SEQIDLVALUE s1, s2;
{
    SEQIDLVALUE sval;
    IDLVALUE val;
    Boolean eq = TRUE;

    TRACE("equalSEQIDLVALUE");
    foreachinSEQIDLVALUE(s1, sval, val)
	if (!inSEQIDLVALUE(s2, val)) {
	    eq = FALSE;
	    break;
	}
    if (eq)
	foreachinSEQIDLVALUE(s2, sval, val)
	    if (!inSEQIDLVALUE(s1, val)) {
		eq = FALSE;
		break;
	    }

    return(eq);
}


Boolean equalSETIDLVALUE(s1, s2)
SEQIDLVALUE s1, s2;
{
    SEQIDLVALUE sval;
    IDLVALUE val;
    Boolean eq = TRUE;

    TRACE("equalSETIDLVALUE");

    foreachinSEQIDLVALUE(s1, sval, val)
	if (!inSEQIDLVALUE(s2, val)) {
	    eq = FALSE;
	    break;
	}
    if (eq) {
	foreachinSEQIDLVALUE(s2, sval, val)
	    if (!inSEQIDLVALUE(s1, val)) {
		eq = FALSE;
		break;
	    }
    }

    return(eq);
}

/*ARGSUSED*/
invalid_arg(entry, num_args, arg1, arg2)
int entry;
int num_args;
runstackEntry arg1, arg2;
{
#ifdef DEBUG
	(void) fprintf(stderr, "Invalid argument to operator '%s'\n",
		instr_type(entry));
	if (num_args == 1) {
	    (void) fprintf(stderr, "\tArgument is ");
	    print_runstackEntry(stderr, arg1);
	}
	else {
	    (void) fprintf(stderr, "\tArguments are ");
	    print_runstackEntry(stderr, arg1);
	    (void) fprintf(stderr, " and ");
	    print_runstackEntry(stderr, arg2);
	}
	(void) fprintf(stderr, "\n");
#endif
	fatal_error(1);
}

/*ARGSUSED*/
invalid_oper(oper, name)
int oper;
char *name;
{
	DEBUG2("Invalid operator '%s' for procedure '%s'\n",
		instr_type(oper), name);
	fatal_error(1);
}
