/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlcheck/check/main.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: main driver for interpreter for assertion checker		*	
*									*
*									*
\* ******************************************************************* */

/* 	static char rcsid = "$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/idlcheck/check/RCS/main.c,v 4.0 89/04/12 02:44:32 cheung Exp Locker: cheung $"					*/

/***********************************************************************\
* Revision Log:								*
*	$Log:	main.c,v $
 * Revision 4.0  89/04/12  02:44:32  cheung
 * main.c  Ver 4.0
 * 
 * Revision 3.9  89/04/02  12:20:20  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  13:31:42  cheung
 * main.c  Ver 3.9
 * 
 * Revision 1.8  86/04/09  08:37:43  kickenso
 * modifying for integer byte codes
 * 
 * Revision 1.7  86/01/12  22:24:34  kickenso
 * rewrote code to handle Type function
 * 
 * Revision 1.6  85/12/27  14:15:11  kickenso
 * added code to handle noncyclic definitions
 * 
 * Revision 1.5  85/12/25  15:07:08  kickenso
 * Added code to handle all operators except formal args & applications
 * 
 * Revision 1.4  85/12/24  17:07:31  kickenso
 * Added supplied functions
 * modified code to make all literals standard ...Desc as in idlData
 * 
 * Revision 1.3  85/12/24  12:50:44  kickenso
 * Added more operators
 * 
 * Revision 1.2  85/12/23  16:37:35  kickenso
 * added code to handle binary operators
 * 
 * Revision 1.1  85/12/23  12:05:25  kickenso
 * Initial revision
 * 								*
*									*
\***********************************************************************/


#include <stdio.h>
#include "Check.h"
#include "macros.h"
#include "instructions.h"

typedef int		OPERATION;
typedef char		BYTE;
typedef SEQint		SEQOPERATION;

#define MAXSTRUCS	20	/* maximum number of structures that can
				   be read in for one process	*/

runstackEntry	runtime_result[1000];  /* array which saves results of all
					 intermediate expressions.  Used by
					 routine that generates error log */
FILE	*errorfile;
Boolean			verbose = FALSE;
int                     assertioncounter = 0;

main(argc,argv)
int	argc;
char	*argv[];
{

    extern Boolean	ReaderOK;
    runstackEntry	interpret();	/* interpret may return a postfix code
				         entry if a definition is interpreted */
    compilationUnit	code;		/* postfix code structure	     */
    FILE	*in;			/* specific instances of structures  */
    struc allstrucs[MAXSTRUCS];		/* all structures read */

    struc in_data;	/* one instance of a read structure 	*/

    SEQDeclaration		stprs;
    SEQDeclaration		SDecl;
    Declaration			ADecl;
    SETAssertion		Sas;
    Assertion			as;
    SETPort			Spt;
    Port			pt;
    StructureEntity		st;
    ProcessEntity		pr;
    StructureOrProcess		StOrPr;

    IDLVALUE			forms[50];	/* holds formal arguments */

    int				stindex;
    int				numstruc;	/* number of instances	*/
    FILE			*fopen();
    char			*malloc();
    void                        exit();

    if (argc == 1) {
	(void) fprintf(stderr, "Usage: %s [-v] [-w] [ portname instance ]+ < postfixcode\n",
		argv[0]);
	exit(1);
    }

    /* read in postfix code	*/
    code = Code(stdin);
    if (!ReaderOK) {
	(void) fprintf(stderr, "idlcheck: read error on CandlePostfix\n");
	exit(1);
    }

    /* read in all structure instances */

    numstruc = -1;
    for(stindex=1;stindex<argc;stindex++)
    {
	if (!strcmp(argv[stindex], "-v")) {
	    verbose = TRUE;
	    (void) fprintf(stderr, "idlcheck: idl assertion checker\n");
	}
	else
	{
	    in_data.portname = NewString(argv[stindex]);
	    if (verbose)  {
		(void) fprintf(stderr, "idlcheck:    reading instance for port '%s'\n",
			in_data.portname);
	    }
	    if (streq(argv[++stindex],"-")) {
		ReaderOK = TRUE;
		in_data.st = data_in(stdin);
		if (!ReaderOK) {
		    (void) fprintf(stderr, "idlcheck: read error on structure instance for port %s\n", in_data.portname);
		    exit(1);
		}
	    }
	    else
	    {
	        if ((in = fopen(argv[stindex],"r")) == NULL) {
		    (void) fprintf(stderr,"idlcheck: File %s cannot be opened for reading.\n",
				argv[stindex]);
		    exit(1);
		}
		ReaderOK = TRUE;
	        in_data.st = data_in(in);
		if (!ReaderOK) {
		    (void) fprintf(stderr, "idlcheck: read error on structure instance for port %s\n", in_data.portname);
		    exit(1);
		}
	    }
	    allstrucs[++numstruc] = in_data;
	}
    }

    /* collect all structures and processes */
    collect_stprs(code, &stprs);

    /* add structure names to structure instances */
    foreachinSEQDeclaration(stprs, SDecl, ADecl) 
    {
	if (typeof(ADecl) == KProcessEntity) {
	    pr = ADecl.VProcessEntity;
	    foreachinSETPort(pr->sem_ports, Spt, pt) {
		for (stindex=0; stindex<=numstruc; stindex++)
		    if (allstrucs[stindex].portname == pt->lex_name) {
			allstrucs[stindex].stname = pt->syn_data->sem_entity.
						VStructureEntity->lex_name;
			break; 
		    }
	    }
	}
    }

    /* interpret all assertions		*/
    foreachinSEQDeclaration(stprs, SDecl, ADecl) 
    {
	/* first handle assertions within structures, excepting invariants */
	if (typeof(ADecl) == KStructureEntity)
	{
	    st = ADecl.VStructureEntity;
	    for (stindex = 0; stindex <= numstruc; stindex++) 
		if (st->lex_name == allstrucs[stindex].stname) {
		    if (verbose) {
			(void) fprintf(stderr, "idlcheck:    interpreting assertions for structure '%s' in port '%s'\n", 
			st->lex_name, allstrucs[stindex].portname);
		    }
		    foreachinSETAssertion(st->sem_assertions, Sas,as) {
			if (verbose) {
			    (void) fprintf(stderr, "idlcheck:       interpreting assertion '%s'\n", as->lex_name);
			    (void) fflush(stderr);
			}
			StOrPr.VStructureEntity = st;
			interpret(as->postfixBody, as->lex_name, StOrPr, 
				 forms, allstrucs, numstruc, stindex,
				 as->syn_body,FALSE,FALSE);
		    }
		}
	}
	/* now handle assertions within processes	*/
	else if (typeof(ADecl) == KProcessEntity)
	{
	    pr = ADecl.VProcessEntity;
	    if (verbose) {
		(void) fprintf(stderr, "idlcheck:    interpreting assertions for process '%s' \n", pr->lex_name);
	    }
	    foreachinSETAssertion(pr->sem_assertions, Sas,as) {
		if (verbose)
		    (void) fprintf(stderr, "idlcheck:       interpreting assertion '%s'\n", as->lex_name);
		StOrPr.VProcessEntity = pr;
		interpret(as->postfixBody, as->lex_name, StOrPr, 
			  forms, allstrucs, numstruc, -1, as->syn_body,
			  FALSE, FALSE);
	    }
        }

    }
    return 0;
}	/* end of main */
