/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlcheck/check/macros.h 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: macros used by all phases of assertion interpretation	*
*									*
*									*
\* ******************************************************************* */


/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	macros.h,v $
 * Revision 4.0  89/04/12  02:44:24  cheung
 * macros.h  Ver 4.0
 * 
 * Revision 3.9  89/04/02  12:20:17  cheung
 * macros.h  Ver 3.9
 * 
 * Revision 3.9  89/03/26  13:31:39  cheung
 * macros.h  Ver 3.9
 * 
*									*
*   Edit Log:								*
*     	November 19 1985 (kickenson).					*
*									*
\* ******************************************************************* */

#include <stdio.h>

#define K(str)		(void) fprintf(stderr,"str \n");
#define check(X,N,SP,TREE)	interpret(X,N,SP,forms,allstrucs,\
				numstruc,stindex,TREE)

#define streq(s1,s2)	strcmp(s1,s2) == 0
#define error(str)	if(pass >= 2) (void) fprintf(stderr,str)

typedef struct {		/* structure instance */
    	    nodeDesc  st;	/* pointer to root of structure instance */
    	    String  portname;	/* name of port associated with structure */
    	    String  stname;	/* name of structure */
} struc;


#define HEAD	"Head"
#define MEMBERS	"Members"
#define TYPE	"Type"
#define SIZE	"Size"
#define TAIL	"Tail"

#define UNKNOWN	"Unknown"

#define strequal(s1,s2)	!strcmp(s1,s2)

#define COMMENT		-1 
#define EXTENSION	-2
#define WARNING		-3
#define RECOVERABLE	-4
#define SERIOUS		-5
#define FATAL		-6


#define Comment0(n,spos)		ErrHandler(COMMENT,n,spos,"","")
#define Comment1(n,spos,a1)		ErrHandler(COMMENT,n,spos,a1,"")
#define Comment2(n,spos,a1,a2)		ErrHandler(COMMENT,n,spos,a1,a2)

#define Extension0(n,spos)		ErrHandler(EXTENSION,n,spos,"","")
#define Extension1(n,spos,a1)		ErrHandler(EXTENSION,n,spos,a1,"")
#define Extension2(n,spos,a1,a2)	ErrHandler(EXTENSION,n,spos,a1,a2)

#define Warning0(n,spos)		ErrHandler(WARNING,n,spos,"","")
#define Warning1(n,spos,a1)		ErrHandler(WARNING,n,spos,a1,"")
#define Warning2(n,spos,a1,a2)		ErrHandler(WARNING,n,spos,a1,a2)

#define Recoverable0(n,spos)		ErrHandler(RECOVERABLE,n,spos,"","")
#define Recoverable1(n,spos,a1)		ErrHandler(RECOVERABLE,n,spos,a1,"")
#define Recoverable2(n,spos,a1,a2)	ErrHandler(RECOVERABLE,n,spos,a1,a2)

#define Serious0(n,spos)		ErrHandler(SERIOUS,n,spos,"","")
#define Serious1(n,spos,a1)		ErrHandler(SERIOUS,n,spos,a1,"")
#define Serious2(n,spos,a1,a2)		ErrHandler(SERIOUS,n,spos,a1,a2)

#define Fatal0(n,spos)			ErrHandler(FATAL,n,spos,"","")
#define Fatal1(n,spos,a1)		ErrHandler(FATAL,n,spos,a1,"")
#define Fatal2(n,spos,a1,a2)		ErrHandler(FATAL,n,spos,a1,a2)

#define SET		"Set"
#define SEQ		"Seq"
#define INT		"Integer"
#define BOOL		"Boolean"
#define STR		"String"
#define RAT		"Rational"
#define IsBoolean(t)	(!strcmp(t->sem_name, BOOL))
#define IsInteger(t)	(!strcmp(t->sem_name, INT))
#define IsRational(t)	(!strcmp(t->sem_name, RAT))
#define IsString(t)	(!strcmp(t->sem_name, STR))

/* void *sprintf(); 
char *sprintf(); */

/* debugging macros */
#ifdef DEBUG
char xxxbuf[1000];
#define TRACE(proc)		(void) fprintf(stderr, "TRACE: in %s\n", proc)
#define TRACE1(proc, arg)	(void) fprintf(stderr, "TRACE: in %s\n", sprintf(xxxbuf, proc, arg))
#define DEBUG0(ctrl)		(void) fprintf(stderr, ctrl)
#define DEBUG1(ctrl, a1)	(void) fprintf(stderr, ctrl, a1)
#define DEBUG2(ctrl, a1, a2)	(void) fprintf(stderr, ctrl, a1, a2)
#define DEBUG3(ctrl, a1, a2, a3)	(void) fprintf(stderr, ctrl, a1, a2, a3)
#else
#define TRACE(proc)
#define TRACE1(proc, arg)
#define DEBUG0(ctrl)
#define DEBUG1(ctrl, a1)
#define DEBUG2(ctrl, a1, a2)
#define DEBUG3(ctrl, a1, a2, a3)
#endif
