/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlcheck/check/errorprint.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: Prints error log for unsatisfied assertion on stout	*	
*									*
*									*
\* ******************************************************************* */



#include <stdio.h>
#include <string.h>
#include "Check.h"
#include "macros.h"


#define NONBOOL	-1

#define write0(str)		(void) fprintf(stderr,str)
#define write1(str,s1)		(void) fprintf(stderr,str,s1)
#define write2(str,s1,s2)	(void) fprintf(stderr,str,s1,s2)


extern runstackEntry	runtime_result[1000];

/***********************************************************************
*	print	print an error log reporting values of intermediate	*
*		expressions in the given expression tree.  		*
*									*
*	Last revised:	June 7,1986					*
************************************************************************/

print(exp,TF,ind,head)
expression	exp;	/* expression to be printed	*/
Boolean		TF;	/* print only if TRUE or FALSE	*/
int		ind; 	/* indentation level	*/
int		head;	/* header - 0 is '>'(because), 1 is '&' (and)	*/
{


	String	nameof();
	String	entry_to_string();
	String	type_to_string();
	int	pos;	/* position in runtime result array	*/
	int	boolvalue;	/* boolean value of result  	*/
	char	temp_str[80];
	int	p;
	Boolean	found;
	SEQexpressionPair	Sep;
	expressionPair		ep;


	/* get position in result array where result of expression is */
	pos = exp.IDLclassCommon->valuepos + 1;

#ifdef DEBUG
	DEBUG2("errorprint get pos %d for exp type=%d\n", pos,typeof(exp));
	DEBUG0("errorprint: ");
	print_runstackEntry(stderr, runtime_result[pos]);
	DEBUG0("\n");
#endif
	if (typeof(runtime_result[pos]) == KTVALUE)
		boolvalue = TRUE;
	else if (typeof(runtime_result[pos]) == KFVALUE)
		boolvalue = FALSE;
	else
	    boolvalue = NONBOOL;


	switch (typeof(exp))	{

		case Kbinary:
		/* if value of expression is boolean, print only if it
		   agrees with given truth value (TF)	*/

			if (boolvalue == FALSE && boolvalue == TF)
			{
			       	indent(ind);		
				header(head);
				write1("%s not satisfied.\n",
					nameof(exp.Vbinary->syn_op));
				print(exp.Vbinary->syn_left,FALSE,ind+1,0);
				if (typeof(runtime_result[exp.Vbinary->syn_left.
				    IDLclassCommon->valuepos + 1]) == KTVALUE)

				    print(exp.Vbinary->syn_right,FALSE,ind+1,0);
				else
				    print(exp.Vbinary->syn_right,FALSE,ind+1,1);

			}
			else if (boolvalue == TRUE && boolvalue == TF)
			{
				indent(ind);
				header(head);
				write1("%s is satisfied.\n",
					nameof(exp.Vbinary->syn_op));
				print(exp.Vbinary->syn_left,TRUE,ind+1,0);
				if (typeof(runtime_result[exp.Vbinary->syn_left.
				    IDLclassCommon->valuepos + 1]) == KFVALUE)

				    print(exp.Vbinary->syn_right,TRUE,ind+1,0);
				else
				    print(exp.Vbinary->syn_right,TRUE,ind+1,1);
			}
			else if (boolvalue == NONBOOL)
			/* print all non-boolean expressions */
			{
				indent(ind);
				header(head);
				(void) strcpy(temp_str,entry_to_string(
					runtime_result[pos]));
				write2("%s is %s.\n",nameof(exp.Vbinary->syn_op),
					temp_str);	
				print(exp.Vbinary->syn_left,TRUE,ind+1,0);
				print(exp.Vbinary->syn_right,TRUE,ind+1,1);
			}
			break;

		case Kunary:

			/* if boolean Not, print if value agrees with
			   passed truth value (TF)	*/
			if (typeof(exp.Vunary->syn_op) == KnotOp)
			{
			if (boolvalue == TF)
			{
			    indent(ind);
			    header(head);
				if (boolvalue == FALSE)
				{
				    write0("NOT is not satisfied.\n");
				    print(exp.Vunary->syn_body,TRUE,ind+1,0);
				}
				else	/* boolvalue = TRUE	*/
				{
				    write0("NOT is satisfied.\n");
				    print(exp.Vunary->syn_body,FALSE,ind+1,0);
				}
			}
			}
			else /* print non-boolean minus always */
			{
				indent(ind);
				header(head);
				(void) strcpy(temp_str,entry_to_string(
					runtime_result[pos]));
				write1("INVERSE is %s.\n",temp_str);
				print(exp.Vunary->syn_body,TRUE,ind+1,0);
			}
			break;

		case Kdotted:

		    	indent(ind);
			header(head);
			/* get attribute name */
			(void) strcpy(temp_str,entry_to_string(runtime_result[pos]));
			write2(".%s is %s\n",exp.Vdotted->syn_right->lex_name,
				temp_str);
			print(exp.Vdotted->syn_left,TRUE,ind+1,0);
			break;

		case KExpSetRef:
		case KExpSeqRef:

			indent(ind);
			header(head);
			/* get type name */
			(void) strcpy(temp_str,entry_to_string(runtime_result[pos]));
			if (typeof(exp)==KExpSetRef)
			    write2("Set Of %s is %s\n", exp.VExpSetRef->
				syn_component->lex_name, temp_str);
			else 
			    write2("Seq Of %s is %s\n", exp.VExpSeqRef->
				syn_component->lex_name, temp_str);
			break;

		case KExpNameRef:

			indent(ind);
			header(head);
			/* get exp name */
			(void) strcpy(temp_str,entry_to_string(runtime_result[pos]));
			write2("%s is %s\n", exp.VExpNameRef->lex_name, 
				temp_str);
			break;

		case KrootExp:
	
			indent(ind);
			header(head);
			(void) strcpy(temp_str,entry_to_string(runtime_result[pos]));
			write1("ROOT is %s\n",temp_str);
			break;

		case Kforallq: /* quantifiers */

			if (boolvalue == TF && boolvalue == TRUE)
			{
			    indent(ind);
			    header(head);
			    write0("FORALL is satisfied.\n");
			}
			/* if value is not TRUE then the position+1 was used
			 * to store the value of the object that caused
			 * the forall to be FALSE
			 */
			else {
			    indent(ind);
			    header(head);
			   /* get name of object for which ForAll failed */
			   (void) strcpy(temp_str,entry_to_string(
				    runtime_result[pos+1]));
			   write2("FORALL is not satisfied when %s is %s\n",
					exp.Vforallq->syn_control->lex_name,
					temp_str);
			    print(exp.Vforallq->syn_set,TRUE,ind+1,0);
			    print(exp.Vforallq->syn_body,FALSE,ind+1,1);
			}

			break;

		case Kexistsq:

			/* if value is FALSE then endExists is not 
			 * satisfied
			 */
			if (boolvalue == TF && boolvalue == FALSE)
			{
			    indent(ind);
			    header(head);
			    write0("EXISTS is not satisfied.\n");	
			}

			/* if value is not FALSE then the position was used
			 * to store the value of the object that caused
			 * the exists to be TRUE
			 */
			
			else {
			    indent(ind);
			    header(head);
			    /* get name of object for which Exists was
			      satisfied */
			    (void) strcpy(temp_str,entry_to_string(
					runtime_result[pos]));
			    write2("EXISTS is satisfied when %s is %s\n",
					exp.Vexistsq->syn_control->lex_name,
					temp_str);
			    print(exp.Vexistsq->syn_set,TRUE,ind+1,0);
			    print(exp.Vexistsq->syn_body,TRUE,ind+1,1);
			}

			break;

		case Kconditional:

			indent(ind);
			header(head);
			if (boolvalue == TRUE && boolvalue == TF)
			{
			    write0("Conditional is satisfied.\n");
			}
			else if ((boolvalue == FALSE && boolvalue == TF) ||
				 (boolvalue == NONBOOL))
			{
			    write0("Conditional is not satisfied.\n");    
			    p = exp.Vconditional->syn_test.IDLclassCommon
						->valuepos;
			    if (typeof(runtime_result[p+1]) == KTVALUE)
		            {
		   	        print(exp.Vconditional->syn_test,TRUE,ind+1,0);
			        print(exp.Vconditional->syn_then,FALSE,ind+1,1);
		            }
		            else 
		            {
			        found = FALSE;
			        foreachinSEQexpressionPair(
				    exp.Vconditional->syn_orif, Sep, ep) {
			        if (!found)
			        {
				     p = ep->syn_test.IDLclassCommon->valuepos;
				     if (typeof(runtime_result[p+1]) == KTVALUE)
				     {
				       print(ep->syn_test,TRUE,ind+1,0);
				       print(ep->syn_then,FALSE,ind+1,1);
				       found = TRUE;
				     }
				}
				}
			     }

			      if (!found)
				    print(exp.Vconditional->syn_else,
						TRUE,ind+1,0);
			}
			     
			break;

	}
}


			
					
/***********************************************************************
*	indent		indent the given amount of levels.  One level	*
*			is 4 spaces.					*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

indent(x)
int	x;	/* indent level */
{

	int	i;

	for(i=1;i<=4*x;i++)
		write0(" ");
}

				
/***********************************************************************
*	header		print the symbol '>' (because) or '&' (and)	*
*			depending on whether the given argument is 	*
*			0 (>) or 1 (&)					*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

header(head)
int	head;	/* header code */
{

	if (head == 0)
		write0("> ");
	else
		write0("& ");
}


/***********************************************************************
*	nameof		return the string equivalent of the given	*
*			operator					*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

String	nameof(op)
binaryOp	op;	/* operator to get string equivalent of */
{


	switch (typeof(op))	{

	    	case KandOp:
			return("And");
		case KorOp:
			return("Or");
		case KunionOp:
			return("Union");
		case KintersectOp:
			return("Intersection");
		case Kplus:
			return("Sum");
		case Kminus:
			return("Difference");
		case Ktimes:
			return("Product");
		case Kdivide:
			return("Quotient");
		case Kless:
			return("Less");
		case KlessEq:
			return("Less_Eq");
		case Kgreater:
			return("Greater");
		case KgrtrEq:
			return("Greater_Eq");
		case Kequal:
			return("Equality");
		case KnotEqual:
			return("InEquality");
		case KsameOp:
			return("Same");
		case KinSet:
			return("Set Inclusion");
		case Ksubset:
			return("Subset");
		case KpropSubset:
			return("Proper Subset");

	}
        return NULL;

}


	
/***********************************************************************
*	entry_to_string		returns a string equivalent of the	*
*				given runstack entry			*
*									*
*	Last revised: 	April 14, 1986					*
************************************************************************/

String	entry_to_string(entry)
runstackEntry	entry;	/* runstack entry to get string equivalent of */
{
	char		temp[80];	
	IDLVALUE	val;
	SEQIDLVALUE	Sval;
	int		n;

	temp[0] = '\0';
	switch  (typeof(entry))	{

		case KintegerDesc:
			(void)sprintf(temp,"%d",entry.VintegerDesc->value);
			break;
		case KrationalDesc:	
			(void)sprintf(temp,"%f",entry.VrationalDesc->value);
			break;
		case KstringDesc:
			(void) strcpy(temp,entry.VstringDesc->value);
			break;
		case KbooleanDesc:
			if (entry.VbooleanDesc->value == TRUE)
				(void) strcpy(temp,"TRUE");
			else
				(void) strcpy(temp,"FALSE");
			break;
		case KnodeDesc:
			if (strlen(entry.VnodeDesc->label) > 0)
			    (void)sprintf(temp,"%s:%s", 
				    entry.VnodeDesc->label,
				    entry.VnodeDesc->name);
			else (void)sprintf(temp, "<no label>:%s",
				    entry.VnodeDesc->name);
			break;
		case KsetDesc:
			(void) strcpy(temp,"{ ");
			foreachinSEQIDLVALUE(entry.VsetDesc->value,Sval,val)
			{
				(void) strcat(temp,entry_to_string(val));
				(void) strcat(temp," ");
			}
			(void) strcat(temp,"}");
			break;
		case KsequenceDesc:
			(void) strcpy(temp,"< ");
			foreachinSEQIDLVALUE(entry.VsequenceDesc->value,Sval,
								val)
			{
				(void) strcat(temp,entry_to_string(val));
				(void) strcat(temp," ");
			}
			(void) strcat(temp,">");
			break;
		case KTVALUE:
			(void) strcpy(temp,"TRUE");
			break;
		case KFVALUE:
			(void) strcpy(temp,"FALSE");
			break;
		case Kcollect:
			(void) strcpy(temp,"{ ");
			n = 0;
			foreachinSEQIDLVALUE(entry.Vcollect->objects,
							Sval,val)
			{
			    n++;
			    if (n <= 15)
			    {
				(void) strcat(temp,entry_to_string(val));
				(void) strcat(temp," ");
			    }
			}
			if (n < lengthSEQIDLVALUE(entry.Vcollect->objects))
			    (void) strcat(temp,"...");
			(void) strcat(temp,"}");
			break;

	}

	return(temp);
}
