/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlcheck/check/debug.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include "Check.h"
#include "instructions.h"

char *instr_names[] = {
    "Zero_op",
    "One_op",
    "intToken",
    "ratToken",
    "strToken",
    "true_op",
    "false_op",
    "empty_op",
    "Root_op",
    "typeExpression_op",
    "portRoot_op",
    "portExpression_op",
    "union_op",
    "intersect_op",
    "subset_op",
    "propSubset_op",
    "plus_op",
    "minus_op",
    "times_op",
    "divide_op",
    "and_op",
    "or_op",
    "str_less_op",
    "str_lessEq_op",
    "str_greater_op",
    "str_grtrEq_op",
    "str_equal_op",
    "str_notEqual_op",
    "num_lessEq_op",
    "num_less_op",
    "num_greater_op",
    "num_grtrEq_op",
    "num_equal_op",
    "num_notEqual_op",
    "bool_equal_op",
    "bool_notEqual_op",
    "set_equal_op",
    "set_notEqual_op",
    "seq_equal_op",
    "seq_notEqual_op",
    "node_equal_op",
    "node_notEqual_op",
    "same_op",
    "inSet_op",
    "inSeq_op",
    "inCollection_op",
    "unaryMinus_op",
    "not_op",
    "jump",
    "jtrue",
    "jfalse",
    "members_op",
    "head_op",
    "tail_op",
    "str_size_op",
    "setseq_size_op",
    "type_op",
    "forall_op",
    "exists_op",
    "endForAll",
    "endExists",
    "control_op",
    "formArg_op",
    "dot_op",
    "application_op",
    "RETURN",
    "ENDASSERTION",
    "is_op",
    "casename_op",
    "cyclic_appl_op"
};

static int num_instr_names = sizeof(instr_names) / sizeof(char *);


char *instr_type(i)
int i;
{
    if (i >= num_instr_names)
	return("?");
    else
	return(instr_names[i]);
}

print_op_stack(body)
SEQint body;
{
    SEQint Sint;
    int aint;
    int i;

    (void) fprintf(stderr, "op stack: ");
    i=0;
    foreachinSEQint(body, Sint, aint) {
	++i;
	(void) fprintf(stderr, " %d:%s", aint, instr_type(aint));
	if (i%5 == 0) (void) fprintf(stderr, "\n\t");
    }
    (void) fprintf(stderr, "\n");
}
print_op(entry)
int entry;
{
    (void) fprintf(stderr, "interpreter entry = %d:%s\n", entry, instr_type(entry));
}

print_controlArray(carray, num)
IDLVALUE carray[];
int num;
{
    int i;

    (void) fprintf(stderr, "Control Array: ");
    for (i=0; i<num; i++) {
	(void) fprintf(stderr, " %d", typeof(carray[i]));
    }
    (void) fprintf(stderr, "\n");
}

print_strings(procname, strset)
char *procname;
SETString strset;
{
    SETString SStr;
    String AStr;
    int i=0;

    (void) fprintf(stderr, "%s stringset:", procname);
    foreachinSETString(strset, SStr, AStr) {
	(void) fprintf(stderr, " %s", AStr);
	if (++i % 6 == 0) (void) fprintf(stderr, "\n\t");
    }
    (void) fprintf(stderr, "\n");
}

print_SEQIDLVALUE(fp, args)
FILE *fp;
SEQIDLVALUE args;
{
    SEQIDLVALUE SI;
    IDLVALUE I;

    foreachinSEQIDLVALUE(args, SI, I) {
	print_IDLVALUE(fp, I);
    }
}

print_IDLVALUE(fp, val)
FILE *fp;
IDLVALUE val;
{
    switch (typeof(val)) {
	case KintegerDesc:
	    (void) fprintf(fp, "%d ", val.VintegerDesc->value);
	    break;
	case KrationalDesc:
	    (void) fprintf(fp, "%6.2f ", val.VrationalDesc->value);
	    break;
	case KbooleanDesc:
	    if (val.VbooleanDesc->value)
		(void) fprintf(fp, "TRUE ");
	    else 
		(void) fprintf(fp, "FALSE ");
	    break;
	case KstringDesc:
	    (void) fprintf(fp, "%s ", val.VstringDesc->value);
	    break;
	case KsetDesc:
	    (void) fprintf(fp, "{ ");
	    print_SEQIDLVALUE(fp, val.VsetDesc->value);
	    (void) fprintf(fp, "} ");
	    break;
	case KsequenceDesc:
	    (void) fprintf(fp, "< ");
	    print_SEQIDLVALUE(fp, val.VsequenceDesc->value);
	    (void) fprintf(fp, "> ");
	    break;
	case KnodeDesc:
	    (void) fprintf(fp, "node '%s' ", val.VnodeDesc->name);
	    break;
	case Kempty_collect:
	    (void) fprintf(fp, "empty collection ");
	    break;
	default:
	    (void) fprintf(fp, "??? ");
	    break;
    }
}


print_runtime_result(runtime_result, num)
runstackEntry	runtime_result[];  
int num;
{
	register int i;
	for (i=0; i<num; i++) {
	    (void) fprintf(stderr, "\t%d:",i);
	    print_runstackEntry(stderr, runtime_result[i]);
	    (void) fprintf(stderr, "\n");
	}
}

print_runstackEntry(fp, entry)
FILE *fp;
runstackEntry entry;
{
    switch (typeof(entry)) {
	case Kcollect:
	    (void) fprintf(fp, "collect of { ");
	    print_SEQIDLVALUE(fp, entry.Vcollect->objects);
	    (void) fprintf(fp, " }");
	    break;
	case KTVALUE:
	    (void) fprintf(fp, "TRUE ");
	    break;
	case KFVALUE:
	    (void) fprintf(fp, "FALSE ");
	    break;
	default:
	    print_IDLVALUE(fp, entry.VIDLVALUE);
	    break;
    }
}


print_AssertType_name(fp, t)
FILE *fp;
AssertType t;
{
    switch (typeof(t)) {
	case Ksingleton: 
		(void) fprintf(fp, "singleton of ");
		print_AssertType_name(fp,  t.Vsingleton->sem_type);
		break;
	case Karbitrary: 
		(void) fprintf(fp, "arbitrary of ");
		print_AssertType_name(fp,  t.Varbitrary->sem_type);
		break;
	case KAtomic:
	case KClass:
	case KSetOf:
	case KSeqOf:
		(void) fprintf(fp, "%s", t.VTypeEntity.IDLclassCommon->sem_name);
		break;
    }
}
