/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlcheck/check/collect.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Check.h"
#include "macros.h"

StructureOrProcess IDLStructureOrProcess;
#define StructureEntityToStructureOrProcess(IDLStructureEntity) \
  (IDLStructureOrProcess.VStructureEntity=IDLStructureEntity, IDLStructureOrProcess)
#define ProcessEntityToStructureOrProcess(IDLProcessEntity) \
  (IDLStructureOrProcess.VProcessEntity=IDLProcessEntity, IDLStructureOrProcess)

/***************************************************************************\
 *  collect all structures and processes in compilationUnit		   *
 ***************************************************************************/
collect_stprs(compUnit, stprs)
compilationUnit compUnit;
SEQDeclaration *stprs;
{
    	SEQDeclaration SDecl;
	Declaration Decl;
	SEQStructureOrProcessRef SStPrRef;
	StructureOrProcessRef AStPrRef;
	StructureOrProcess StorPr;
	Declaration aDeclaration;

	initializeSEQDeclaration(*stprs);
	foreachinSEQDeclaration(compUnit->syn_body, SDecl, Decl) {
	    if (typeof(Decl)==KStructureEntity || typeof(Decl)==KProcessEntity){
		if (!inSEQDeclaration(*stprs, Decl)) {
		    appendfrontSEQDeclaration(*stprs, Decl);
		    collect_stprs2(Decl, stprs);
		}
	    }
	    else { /* import */
		foreachinSEQStructureOrProcessRef(Decl.VImportDecl->syn_specs,
						    SStPrRef, AStPrRef) {
		    if (typeof(AStPrRef->sem_entity)!= Kerror) {
			StorPr = AStPrRef->sem_entity.VStructureOrProcess;
			aDeclaration.VStructureOrProcess = StorPr;
			if (!inSEQDeclaration(*stprs, aDeclaration)) {
			    appendfrontSEQDeclaration(*stprs, aDeclaration);
			    collect_stprs2(StorPr, stprs);
			}
		    }
		}
	    }
	}
}

collect_stprs2(StOrPr, stprs)
StructureOrProcess StOrPr;
SEQDeclaration *stprs;
{
    StructureEntity st, st2;
    ProcessEntity pr, pr2;
    Declaration aDeclaration;
    SEQStructureRef SStRef;
    StructureRef StRef;
    SETPort SPort;
    Port APort;

    if (typeof(StOrPr)==KStructureEntity) {
	st = StOrPr.VStructureEntity;
	if (typeof(st->syn_refines)==KStructureRef &&
	    typeof(st->syn_refines.VStructureRef->sem_entity)==KStructureEntity)
	{
	    st2 = st->syn_refines.VStructureRef->sem_entity.VStructureEntity;
	    aDeclaration.VStructureEntity = st2;
	    if (!inSEQDeclaration(*stprs, aDeclaration)) {
		appendfrontSEQDeclaration(*stprs, aDeclaration);
		collect_stprs2(StructureEntityToStructureOrProcess(st2), stprs);
	    }
	}
	foreachinSEQStructureRef(st->syn_from, SStRef, StRef) {
	    if (typeof(StRef->sem_entity)==KStructureEntity) {
		st2 = StRef->sem_entity.VStructureEntity;
		aDeclaration.VStructureEntity = st2;
		if (!inSEQDeclaration(*stprs, aDeclaration)) {
		    appendfrontSEQDeclaration(*stprs, aDeclaration);
		    collect_stprs2(StructureEntityToStructureOrProcess(st2), stprs);
		}
	    }
	}
    }
    else { /* process */
	pr = StOrPr.VProcessEntity;
	if (typeof(pr->syn_refines)==KProcessRef &&
	    typeof(pr->syn_refines.VProcessRef->sem_entity)==KProcessEntity) {
	    pr2 = pr->syn_refines.VProcessRef->sem_entity.VProcessEntity;
	    aDeclaration.VProcessEntity = pr2;
	    if (!inSEQDeclaration(*stprs, aDeclaration)) {
		appendfrontSEQDeclaration(*stprs, aDeclaration);
		collect_stprs2(ProcessEntityToStructureOrProcess(pr2), stprs);
	    }
	}
	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    if (typeof(APort->syn_data->sem_entity) != KStructureEntity)
		continue;
	    st2 = APort->syn_data->sem_entity.VStructureEntity;
	    aDeclaration.VStructureEntity = st2;
	    if (!inSEQDeclaration(*stprs, aDeclaration)) {
		appendfrontSEQDeclaration(*stprs, aDeclaration);
		collect_stprs2(StructureEntityToStructureOrProcess(st2), stprs);
	    }
	}
    }
}

/* test if the argument type is one string */
Boolean ArgTypeIsString(args)
SEQexpression args;
{
    expression first;
    if (lengthSEQexpression(args) != 1)
	return(FALSE);
    retrievefirstSEQexpression(args, first);
    if (typeof(first.IDLclassCommon->sem_type)==KAtomic &&
	first.IDLclassCommon->sem_type.VAtomic->sem_name == NewString("String"))
	    return(TRUE);
    else return(FALSE);
}
/***********************************************************************
*	collect_st_objs	place in the given collection all objects in	*
*			given structure of the same type as the given	*
*			object.						*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

collect_st_objs(obj,data,collects)
IDLVALUE	obj;	/* get objects with same type as this object */
nodeDesc	data;	/* structure */
SEQIDLVALUE	*collects; /* collection in which to place found objects */
{
    TRACE("collect_st_objs");

    collect_objs(obj,data,collects);
    untouch(data);	/* unmark nodes marked by procedure collect */
#ifdef DEBUG
    if (typeof(obj)==KnodeDesc) {
	DEBUG1("collect for node %s\n", obj.VnodeDesc->name);
	DEBUG1("collection size = %d\n", lengthSEQIDLVALUE(*collects));
    }
#endif
}

collect_objs(obj,data,collects)
IDLVALUE	obj;	/* get objects with same type as this object */
nodeDesc	data;	/* structure */
SEQIDLVALUE	*collects; /* collection in which to place found objects */
{

    SEQattrDesc		Sad;
    attrDesc		ad;
    SEQIDLVALUE		Ssetval;
    IDLVALUE		val, anIDLVALUE;
    SEQIDLVALUE		Sseqval;

    if (NodeTouched(data))
	return;
    MarkTouched(data);

    if (typeof(obj) == KnodeDesc) {
	/* if node has same name, place in collection */
	if (streq(obj.VnodeDesc->name,data->name)) {
	  anIDLVALUE.VnodeDesc = data;
	    appendrearSEQIDLVALUE((*collects), anIDLVALUE);
	  }
    }

    foreachinSEQattrDesc(data->attributes,Sad,ad) {
	switch (typeof(ad->value)) {
	    case KsetDesc:
		if (typeof(obj) == KsetDesc) {
		    /* get only sets with same component type */
		    if (set_subset(ad->value.VsetDesc->value,
				   obj.VsetDesc->value))
			appendrearSEQIDLVALUE((*collects), ad->value);
		}
		foreachinSEQIDLVALUE(ad->value.VsetDesc->value, Ssetval,val)
		    if (typeof(val) == KnodeDesc)
			collect_objs(obj,val.VnodeDesc,collects);
		break;

	    case KsequenceDesc:
		if (typeof(obj) == KsequenceDesc) {
		    /* get only sequences with same component type */
		    if (seq_subset(ad->value.VsequenceDesc->value,
				   obj.VsequenceDesc->value))
			appendrearSEQIDLVALUE((*collects), ad->value);
		}
		foreachinSEQIDLVALUE(ad->value.VsequenceDesc->value, 
				     Sseqval,val)
		    if (typeof(val) == KnodeDesc)
			collect_objs(obj,val.VnodeDesc,collects);
		break;

	    case KnodeDesc:
		collect_objs(obj,ad->value.VnodeDesc,collects);
		break;

	    default:
		if (typeof(obj) == typeof(ad->value)) {
		    appendrearSEQIDLVALUE((*collects),ad->value);
		}
		break;
	}
    }
}

/***********************************************************************
*	untouch		unmark all nodes in given structure		*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

untouch(node)
nodeDesc	node;	/* structure to be ummarked */
{

    SEQattrDesc		Sad;
    attrDesc		ad;
    SEQIDLVALUE		Ssetval;
    SEQIDLVALUE		Sseqval;
    IDLVALUE		val;

    if (NodeTouched(node)) {
	UnmarkTouched(node);
	foreachinSEQattrDesc(node->attributes,Sad,ad)
	{
	    switch (typeof(ad->value)) {
		case KnodeDesc:
	            untouch(ad->value.VnodeDesc);
		    break;
		case KsetDesc:
		    foreachinSEQIDLVALUE(ad->value.VsetDesc->value, Ssetval,val)
			if (typeof(val) == KnodeDesc)
			    untouch(val.VnodeDesc);
		    break;
		case KsequenceDesc:
		    foreachinSEQIDLVALUE(ad->value.VsequenceDesc->value, 
					 Sseqval,val)
			if (typeof(val) == KnodeDesc)
			    untouch(val.VnodeDesc);
		    break;
		default:
		    break;
	    }
	}
    }
}
