/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlcheck/check/check2.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: Supporting routines for interpreter for assertion checker	*	
*									*
*									*
\* ******************************************************************* */

/*	static char rcsid = "$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/idlcheck/check/RCS/check2.c,v 4.0 89/04/12 02:43:13 cheung Exp Locker: cheung $"					*/

/***********************************************************************\
*	$Log:	check2.c,v $
 * Revision 4.0  89/04/12  02:43:13  cheung
 * check2.c  Ver 4.0
 * 
 * Revision 3.9  89/04/02  12:19:56  cheung
 * check2.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  13:31:17  cheung
 * check2.c  Ver 3.9
 * 
 * Revision 1.3  85/12/27  14:15:57  kickenso
 * added routines for noncyclic definitions
 * 
 * Revision 1.2  85/12/26  11:04:42  kickenso
 * Added bodies to routines
 * 
 * Revision 1.1  85/12/25  15:08:00  kickenso
 * Initial revision
 * 								*
*									*
\***********************************************************************/

#include <stdio.h>
#include "Check.h"
#include "macros.h"
#include "instructions.h"



/***********************************************************************
*	stack_obj	stack a runstack entry on the runstack and	*
*			place entry in given position in result array	*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

stack_obj(obj,stk,pos,indef)
runstackEntry	obj;		/* object to stack */
SEQrunstackEntry	*stk;	/* runstack	*/
int		pos;		/* position in result array to place object */
Boolean		indef;
{
    extern runstackEntry	runtime_result[];

#ifdef DEBUG
    DEBUG1("stack_obj: pos %d ", pos);
    print_runstackEntry(stderr, obj);
    DEBUG0("\n");
#endif
    appendfrontSEQrunstackEntry(*stk,obj);
    if (!indef)
	runtime_result[pos] = obj;
}

/***********************************************************************
*	pop	pop the runstack					*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

runstackEntry		pop(stk)
SEQrunstackEntry	*stk;	/* runstack */
{
    runstackEntry	retval;

    retrievefirstSEQrunstackEntry(*stk,retval);
    removefirstSEQrunstackEntry(*stk);
#ifdef DEBUG
    DEBUG0("pop: ");
    print_runstackEntry(stderr, retval);
    DEBUG0("\n");
#endif
    return(retval);
}


/********************************************************************** 
 * get_reachable_objects					      *
 *	get all reachable objects for type_value		      *
 *	check to see if this has already been done, if so use last    *
 *		result						      *
 **********************************************************************/
get_reachable_objects(type_value, strc, result)
AssertType 	type_value;
nodeDesc	strc;
runstackEntry	*result;
{

	SETTypeEntity 	SType;
	TypeEntity	AType;
	SEQIDLVALUE	Sobj;
	IDLVALUE	Aobj;
	SEQIDLVALUE	objects;

	TRACE("get_reachable_objects");

	/* result is a collection */
	result->Vcollect = Ncollect;


	/* get all types reachable from given type */
	reach(type_value);

	initializeSEQIDLVALUE(objects);
	foreachinSETTypeEntity(type_value.IDLclassCommon->reachable, 
					SType,AType) {

		/* convert string name of type to equivalent object */
		type_to_object(&Aobj, AType);

		/* collect objects in structure strc of same type as obj */
		collect_st_objs(Aobj, strc, &(objects));
	}

	/* make a new collection of objects */
	foreachinSEQIDLVALUE(objects, Sobj, Aobj) {
	    appendrearSEQIDLVALUE(result->Vcollect->objects, Aobj);
	}
#ifdef DEBUG
	DEBUG0("objects for type '");
	print_AssertType_name(stderr, type_value);
	DEBUG0("' are ");
	print_SEQIDLVALUE(stderr, result->Vcollect->objects);
	DEBUG0("\n");
#endif
}
/***********************************************************************
*	reach	place in the given set strings representing all types	*
*		reachable from the given type.  Used to expand class	*
*		types into their constituent node types.		*
*									*
*	Last revised:	June 7, 1986					*
************************************************************************/

reach(t)
AssertType	t;	/* type that does the reaching */
{

    SETTypeEntity 	St;
    TypeEntity		At;
    NamedType		component;
    TypeEntity		ctype;
    SETClass		SsubC;
    Class		subC;
    AssertType		AnAssertType;

    TRACE("reach");

    if (!emptySETTypeEntity(t.IDLclassCommon->reachable)) {
#ifdef DEBUG
	DEBUG0("already reached '");
	print_AssertType_name(stderr, t);
	DEBUG0("'\n");
#endif
	return;
    }

    switch (typeof(t)) {
	case KSetOf:
	case KSeqOf:
	    addSETTypeEntity(t.IDLclassCommon->reachable, t.VTypeEntity);
	    component = t.VSetOrSeq.IDLclassCommon->sem_component;
	    reach(component);
	    foreachinSETTypeEntity(component.IDLclassCommon->reachable, St, At){
		addSETTypeEntity(t.IDLclassCommon->reachable, At);
	    }
	    break;

 	case Ksingleton:
	    ctype = t.Vsingleton->sem_type.VTypeEntity;
	    reach(ctype);
	    foreachinSETTypeEntity(ctype.IDLclassCommon->reachable, St, At){
		addSETTypeEntity(t.IDLclassCommon->reachable, At);
	    }
	    break;

	case KAtomic:
	    addSETTypeEntity(t.VAtomic->reachable, t.VTypeEntity);
	    break;

	case KClass:
	    /* trace down descendants */
	    addSETTypeEntity(t.VClass->reachable, t.VTypeEntity);
	    foreachinSETClass(t.VClass->sem_subclasses,SsubC,subC) {
	      AnAssertType.VClass = subC;
	      reach(AnAssertType);
	      foreachinSETTypeEntity(subC->reachable, St, At){
		addSETTypeEntity(t.VClass->reachable, At);
	      }
	    }
	    break;
	
	default:
	    DEBUG1("Error in reach in check2.c type is %d\n", typeof(t));
	    fatal_error(1);
	    break;

    }
#ifdef DEBUG
    DEBUG0("Reachable types for '");
    print_AssertType_name(stderr, t);
    DEBUG0("are ");
    foreachinSETTypeEntity(t.IDLclassCommon->reachable, St, At)
	DEBUG1("%s ", At.IDLclassCommon->sem_name);
    DEBUG0("\n");
#endif
}


/***********************************************************************
*	findinstance	return the instance of the given definition	*
*			which matches the given arguments		*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

DefInstance	findinstance(def,args)
Definition	def;	/* definition */
SEQIDLVALUE	args;	/* arguments to match */
{
    DefInstance		retval;
    int			OK=FALSE;
    int			i;
    int 		len_args;
    DefInstance		in;
    SETDefInstance	Sin;
    Formal		f;
    runstackEntry	a;


    TRACE1("find_instance for def %s\n", def->sem_name);
    len_args = lengthSEQIDLVALUE(args);
    foreachinSETDefInstance(def->sem_overload,Sin,in) {
	if (len_args == lengthSEQFormal(in.IDLclassCommon->syn_list))
	{
	    OK = TRUE;
	    /* check that each argument matches the formal by type */
	    for (i=1;i<=len_args;i++)
	    {
		ithinSEQFormal(in.IDLclassCommon->syn_list,i,f);
		ithinSEQIDLVALUE(args,i,a);
		if (!type_match(a,f))
		    OK = FALSE;
	    }
	    if (OK == TRUE) {
		retval = in;
		break;
	    }
	}
    }

    if (!OK)  {
	DEBUG0("Error in find_instance in check2.c:\n");
	DEBUG1("\tInstance not found for definition '%s'\n",
	        def->sem_name); 
	DEBUG0("\tactual arguments = ");
        print_SEQIDLVALUE(stderr, args);
	DEBUG0("\n");
	fatal_error(1);
    }
    DEBUG1("found instance type %d\n", typeof(retval));
    return(retval);
}

/***********************************************************************
*	type_match	return TRUE if the type of the given argument	*
*			matches the type of the given formal		*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

type_match(arg,form)
IDLVALUE	arg;	/* argument */
Formal		form;	/* formal   */
{
    Boolean	retval;
    String	argtype;
    String	translate();	/* string equivalent of IDL type */
    SETString	incl;
    SETString	incl1,incl2;
    SEQIDLVALUE	So;
    IDLVALUE	o;
    TypeEntity  formtype;
    char buf[80];

    TRACE("type_match");

    /* empty collection matches any type */
    if (typeof(arg) == Kempty_collect)
	return(TRUE);


    initializeSETString(incl1);
    initializeSETString(incl2);
    initializeSETString(incl);
    retval = TRUE;
    argtype = translate(arg);


    /* types match if type of argument is included in the set of all
       types reachable by the formal type */

    formtype = form->syn_type.IDLclassCommon->sem_entity.VTypeEntity;
    TRACE1("type_match: %s", sprintf(buf, "arg type = %d formal type = %d\n",
	    typeof(arg), typeof(formtype)));

    switch (typeof(arg))	{
	case KsetDesc:
	    if (typeof(formtype) != KSetOf)
		retval = FALSE;
	    else /* component types must match */
	    {
		get_reachable_names(formtype, &incl1);
		foreachinSEQIDLVALUE(arg.VsetDesc->value,So,o)
		    addSETString(incl2,translate(o));
		if (!includes(incl1,incl2))
		    retval = FALSE;
	    }
	    break;
	case KsequenceDesc:
	    if (typeof(formtype) != KSeqOf)
		retval = FALSE;
	    else /* component types must match */
	    {
		get_reachable_names(formtype, &incl1);
		foreachinSEQIDLVALUE(arg.VsequenceDesc->value,So,o)
		    addSETString(incl2,translate(o));
		if (!includes(incl1,incl2))
		    retval = FALSE;
	    }
	    break;
	default:
	    get_reachable_names(formtype, &incl);
	    if (!inSETString(incl,argtype))
		retval = FALSE;
	    break;
    }
	    

    return(retval);
}

get_reachable_names(type, names)
AssertType type;
SETString  *names;
{
    SETTypeEntity SType;
    TypeEntity    AType;

    reach(type);
    foreachinSETTypeEntity(type.IDLclassCommon->reachable, SType, AType) {
	switch (typeof(AType)) {
	    case KSetOf:
		addSETString((*names), SET);
		break;
	    case KSeqOf:
		addSETString((*names), SEQ);
		break;
	    default:
		addSETString((*names), AType.IDLclassCommon->sem_name);
		break;
	}
    }
}

/***********************************************************************
*	includes	returns true if the first argument includes	*
*			all members of the second argument		*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

includes(s1,s2)
SETString	s1,s2;
{

	Boolean		retval;
	SETString	Ss;
	String		s;

	TRACE("includes");

#ifdef DEBUG
	DEBUG0("in includes: s1 =");
	foreachinSETString(s1,Ss,s) DEBUG1(" %s", s);
	DEBUG0("\n	s2 =");
	foreachinSETString(s2,Ss,s) DEBUG1(" %s", s);
	DEBUG0("\n");
#endif
	retval = TRUE;
	foreachinSETString(s2,Ss,s)
	    if (!inSETString(s1,s)) {
		retval = FALSE;
	    }

	return(retval);
}


/***********************************************************************
*	translate	returns the string equivalent of the IDL type	*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

String	translate(arg)
IDLVALUE	arg;	/* argument whose type we want translated */
{
    String	result = NULL;

    TRACE("translate");
    switch (typeof(arg))  {
	case KbooleanDesc:
	    result = NewString(BOOL);
	    break;
	case KintegerDesc:
	    result = NewString(INT);
	    break;
	case KstringDesc:
	    result = NewString(STR);
	    break;
	case KrationalDesc:
	    result = NewString(RAT);
	    break;
	case KsetDesc:
	    result = NewString(SET);
	    break;
	case KsequenceDesc:
	    result = NewString(SEQ);
	    break;
	case KnodeDesc:
	    result = arg.VnodeDesc->name;
	    break;
	default:
	    DEBUG1("Error in translate in check2.c: type is %d\n", typeof(arg));
	    fatal_error(1);
	    break;
	}
	return(result);
}


			
/***********************************************************************
*	get_object	returns the the object the given collection 	*
*			contains.  The collection must be a singleton	*
*			collection.					*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

runstackEntry	get_object(coll)
runstackEntry	coll;	/* collection to get object from	*/
{
	/* coll is known to be a singleton collection */

	IDLVALUE	temp;
	runstackEntry	result;

	TRACE("get_object");

	/* collection must be a singleton collection */
	if (lengthSEQIDLVALUE(coll.Vcollect->objects) == 0) {
	    DEBUG0("Argument to get_object must be singleton collection\n");
	    fatal_error(1);
	}

	else {

	    /* put object into temp */
	    retrievefirstSEQIDLVALUE(coll.Vcollect->objects,temp);

	    /* coerce collection into that object */
	    switch (typeof(temp))	{
		case KintegerDesc:
		    result.VintegerDesc = temp.VintegerDesc;
		    break;
		case KrationalDesc:
		    result.VrationalDesc = temp.VrationalDesc;
		    break;
		case KbooleanDesc:
		    result.VbooleanDesc  = temp.VbooleanDesc;
		    break;
		case KstringDesc:
		    result.VstringDesc = temp.VstringDesc;
		    break;
		case KsetDesc:
		    result.VsetDesc = temp.VsetDesc;
		    break;
		case KsequenceDesc:
		    result.VsequenceDesc = temp.VsequenceDesc;
		    break;
		case KnodeDesc:
		    result.VnodeDesc = temp.VnodeDesc;
		    break;
		default:
		    DEBUG1("Error in get_object in check2.c: type is %d\n",
			    typeof(temp));
		    fatal_error(1);
	    }
	}

	return(result);
}


/***********************************************************************
*	runstack_to_value	returns the runstack entry equivalent	*
*				to the given IDLVALUE			*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

IDLVALUE	runstack_to_value(obj)
runstackEntry	obj;	/* object to get runstack equivalent of */
{

	IDLVALUE	retval;
	char		buf[80];

	switch (typeof(obj))	{
	    case KintegerDesc:
		retval.VintegerDesc = obj.VintegerDesc;
		break;
	    case KrationalDesc:
		retval.VrationalDesc = obj.VrationalDesc;
		break;
	    case KbooleanDesc:
		retval.VbooleanDesc = obj.VbooleanDesc;
		break;
	    case KstringDesc:
		retval.VstringDesc = obj.VstringDesc;
		break;
	    case KsetDesc:
		retval.VsetDesc = obj.VsetDesc;
		break;
	    case KsequenceDesc:
		retval.VsequenceDesc = obj.VsequenceDesc;
		break;
	    case KnodeDesc:
		retval.VnodeDesc = obj.VnodeDesc;
		break;
	    case KTVALUE:
		retval.VbooleanDesc = NbooleanDesc;
		retval.VbooleanDesc->value = TRUE;
		break;
	    case KFVALUE:
		retval.VbooleanDesc = NbooleanDesc;
		retval.VbooleanDesc->value = FALSE;
		break;
	    default:	/* collections cannot be function arguments */
		DEBUG1("Error in runstack_to_value in check2.c typeis %d\n",
			typeof(obj));
		fatal_error(1);
		break;
	}
	TRACE(sprintf(buf, "runstack_to_value type %d -> type %d",
			typeof(obj), typeof(retval)));

	return(retval);

}


/***********************************************************************
*	value_to_runstack	returns the IDLVALUE equivalent of the	*
*				given runstack entry			*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

runstackEntry	value_to_runstack(val)
IDLVALUE	val;
{

	runstackEntry	retval;
	char 		buf[80];

	switch (typeof(val))	{
	    case KintegerDesc:
		retval.VintegerDesc = val.VintegerDesc;
		break;
	    case KrationalDesc:
		retval.VrationalDesc = val.VrationalDesc;
		break;
	    case KbooleanDesc:
		retval.VbooleanDesc = val.VbooleanDesc;
		break;
	    case KstringDesc:
		retval.VstringDesc = val.VstringDesc;
		break;
	    case KsetDesc:
		retval.VsetDesc = val.VsetDesc;
		break;
	    case KsequenceDesc:
		retval.VsequenceDesc = val.VsequenceDesc;
		break;
	    case KnodeDesc:
		retval.VnodeDesc = val.VnodeDesc;
		break;
	    default:
		DEBUG1("Error in value_to_runstack in check2.c type is %d\n",
			typeof(val));
		fatal_error(1);
	}
	TRACE(sprintf(buf, "value_to_runstack type %d -> type %d",
			typeof(val), typeof(retval)));

	return(retval);

}

/***********************************************************************
*	set_subset	returns TRUE if the first argument is a subset	*
*			of the second					*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

set_subset(set1,set2)
SEQIDLVALUE	set1,set2;
{
	Boolean		result;
	SEQIDLVALUE	Sval;
	IDLVALUE	val;
	SETString	Sname;
	String		name;
	SETString	incl1 = NULL;
	SETString	incl2 = NULL;
	String		translate();


	TRACE("set_subset");
	result = TRUE;

	foreachinSEQIDLVALUE(set1,Sval,val)
	    addSETString(incl1,translate(val));
	foreachinSEQIDLVALUE(set2,Sval,val)
	    addSETString(incl2,translate(val));

	foreachinSETString(incl1,Sname,name)
	    if (!inSETString(incl2,name))
		result = FALSE;

	return(result);
}

/***********************************************************************
*	seq_subset	returns TRUE if the first argument is a subset	*
*			of the second					*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/
seq_subset(seq1,seq2)
SEQIDLVALUE	seq1,seq2;
{
	Boolean		result;
	SEQIDLVALUE	Sval;
	IDLVALUE	val;
	SETString	Sname;
	String		name;
	SETString	incl1 = NULL;
	SETString	incl2 = NULL;
	String		translate();
 

	TRACE("seq_subset");
	result = TRUE;

	foreachinSEQIDLVALUE(seq1,Sval,val)
	{
	    name = translate(val);
	    addSETString(incl1,name);
	}

	foreachinSEQIDLVALUE(seq2,Sval,val)
	{
	    name = translate(val);
	    addSETString(incl2,name);
	}

	foreachinSETString(incl1,Sname,name)
	    if (!inSETString(incl2,name))
		result = FALSE;
	return(result);
}




/***********************************************************************
*	type_to_object	passes back the IDLVALUE object 		*
*				equivalent to the type 			*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/
	    
type_to_object(obj,tval)
IDLVALUE	*obj;	/* object passed back through here */
TypeEntity	tval;	/* actual type - needed for set/sequence types */
{

	IDLVALUE	val;
	SETTypeEntity	St;
	TypeEntity	t;

	switch (typeof(tval)) {
	    case KAtomic:
		if (IsBoolean(tval.VAtomic))
		     (*obj).VbooleanDesc = NbooleanDesc;
		else if (IsInteger(tval.VAtomic))
		     (*obj).VintegerDesc = NintegerDesc;
		else if (IsRational(tval.VAtomic))
		     (*obj).VrationalDesc = NrationalDesc;
		else if (IsString(tval.VAtomic))
		     (*obj).VstringDesc = NstringDesc;
		else {
		     (*obj).VnodeDesc = NnodeDesc;
		     (*obj).VnodeDesc->name = tval.VAtomic->sem_name;
		}
		break;
	    case KSetOf:
		(*obj).VsetDesc = NsetDesc;
		reach(tval);
		foreachinSETTypeEntity(tval.VSetOf->reachable,St,t) {
		     type_to_object(&val,t);
/*		     addSEQIDLVALUE((*obj).VsetDesc->value,val); */
		     appendrearSEQIDLVALUE((*obj).VsetDesc->value,val);
		}
		break;
	    case KSeqOf:
		(*obj).VsequenceDesc = NsequenceDesc;
		reach(tval);
		foreachinSETTypeEntity(tval.VSeqOf->reachable,St,t)
		{
		     type_to_object(&val,t);
		     appendrearSEQIDLVALUE((*obj).VsequenceDesc->value,val);
		}
		break;
	    case KClass:
		(*obj).VnodeDesc = NnodeDesc;
		(*obj).VnodeDesc->name = tval.VClass->sem_name;
		break;
	    default:
		DEBUG0("Invalid type in type_to_object\n");
		fatal_error(1);
		break;
	}
}

/***********************************************************************
*	get_structure	pass back the structure at the position given	* 
*			by the index.  Structure is found in	 	*
*			the given list of structures.			*
*									*
*	Last revised:	April 17,1986					*
************************************************************************/

get_structure(stc,allstrucs,index)
nodeDesc	*stc;	/* structure to pass back */
struc		allstrucs[];	/* list of all structure instances */
int		index;	/* index of structure in allstrucs */
{
	TRACE1("get_structure '%s'", allstrucs[index].st->name);
	if (index == -1) {
	    DEBUG0("get_structure index out of range (= -1)\n");
	    fatal_error(1);
	}
	*stc = allstrucs[index].st;
}



/***********************************************************************
*	get_structure_port	pass back the structure associated	*
*				with the given port.  Structure is	*
*				found in the given list of structures	*
*									*
*	Last revised:	April 17, 1986					*
************************************************************************/

get_structure_port(stc,name,allstrucs,num)
nodeDesc	*stc;	/* structure to pass back */
String		name;	/* name of port */
struc		allstrucs[];	/* list of all structure instances */
int		num;	/* number of structures in allstrucs	*/
{

	int	i;

	TRACE("get_structure_port");
	for (i=0;i<=num;i++)
	    if (streq(allstrucs[i].portname,name))
		*stc = allstrucs[i].st;

}

