/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlcheck/check/check.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: interpreter for assertion checker				*	
*									*
*									*
\* ******************************************************************* */

/* 	static char rcsid = "$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/idlcheck/check/RCS/check.c,v 4.0 89/04/12 02:42:34 cheung Exp Locker: cheung $"					*/

/***********************************************************************\
* Revision Log:								*
*	$Log:	check.c,v $
 * Revision 4.0  89/04/12  02:42:34  cheung
 * check.c  Ver 4.0
 * 
 * Revision 3.9  89/04/02  12:19:48  cheung
 * check.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  13:31:07  cheung
 * check.c  Ver 3.9
 * 
 * Revision 1.8  86/04/09  08:37:43  kickenso
 * modifying for integer byte codes
 * 
 * Revision 1.7  86/01/12  22:24:34  kickenso
 * rewrote code to handle Type function
 * 
 * Revision 1.6  85/12/27  14:15:11  kickenso
 * added code to handle noncyclic definitions
 * 
 * Revision 1.5  85/12/25  15:07:08  kickenso
 * Added code to handle all operators except formal args & applications
 * 
 * Revision 1.4  85/12/24  17:07:31  kickenso
 * Added supplied functions
 * modified code to make all literals standard ...Desc as in idlData
 * 
 * Revision 1.3  85/12/24  12:50:44  kickenso
 * Added more operators
 * 
 * Revision 1.2  85/12/23  16:37:35  kickenso
 * added code to handle binary operators
 * 
 * Revision 1.1  85/12/23  12:05:25  kickenso
 * Initial revision
 * 								*
*									*
\***********************************************************************/


#include <stdio.h>
#include "Check.h"
#include "macros.h"
#include "instructions.h"

typedef int		OPERATION;
typedef char		BYTE;
typedef SEQint		SEQOPERATION;

#define stack(x,y)	stack_obj(x,y,code_pos-1,isDef)
#define MAXSTRUCS	10	/* maximum number of structures that can
				   be read in for one process	*/

runstackEntry IDLrunstackEntry;
#define TVALUETorunstackEntry(tvalue) (IDLrunstackEntry.VTVALUE=tvalue,IDLrunstackEntry)

runstackEntry	runtime_result[1000];  /* array which saves results of all
					 intermediate expressions.  Used by
					 routine that generates error log */
FILE	*errorfile;

/***********************************************************************
*	interpret	interpret assertion code in given code array.	*
*			Return result.  Interpretation of an assertion	*
*			code array always results in a boolean value.	*
*			Interpretation of a definition instance code	*
*			array may result in any runstack entry type.	*
*			If an assertion returns false, an error 	*
*			log describing the failed assertion is 		*
*			generated.  The error log generation involves	*
*			a walk of the expression tree.			*
*									*
*	Last revised:	June 7, 1986					*
************************************************************************/


runstackEntry	interpret(body,name,SP,forms,allstrucs, numstruc,
			  stindex,tree,suppress, isDef)
SEQint		body;		/* code array to be interpreted */
String    	name;		/* assertion name, if any	*/
StructureOrProcess SP;		/* structure/process assertion is in */
IDLVALUE forms[]; 		/* list of definition arguments - used
			    	   when interpreting definition instance body */
struc		allstrucs[]; 	/* array of structure instances */
int		numstruc;   	/* number of structures in allstrucs */
int		stindex;	/* index of structure in allstrucs	*/
expression	tree;		/* expression tree for assertion - used in
			  	   generating error log */
Boolean		suppress; 	/* TRUE if error log should be suppressed */
Boolean		isDef;		/* TRUE if interpreting definition body */
{

    runstackEntry	run_application();	/* run a definition */
    runstackEntry	pop();			/* pop the runtime stack */
    runstackEntry	get_object();		/* returns object in a 
						   singleton collection */
    SEQrunstackEntry	runstack = NULL;	/* run time stack	*/
    int			code_pos = 1;		/* code array position	*/
    int			code_pos2;
    OPERATION		entry;			/* current entry in code */
    IDLVALUE		controlArray[50];	/* holds values controls
						   will take on		*/
    SEQint		controlReturn = NULL;	/* return points in control
						   array after applications */
    int			offset  = 0;		/* offset in controlArray */
    int			numcontrol = 0;		/* number of objects in control 
					   	   array		*/
    int			level;			/* level of control reference */
    int			nestlevel = 0;		/* nesting level of quantifier*/
    int			numargs = 0;		/* number of arguments in
						   formalArray		*/
    int			pos;			/* position of formal in
						   formal array		*/

    runstackEntry	op1;			/* operand	*/
    runstackEntry	op2;			/* operand	*/
    runstackEntry	result;			/* result */

    SEQcollect		quantsets = NULL;	/* stores quantifier sets */
    collect		qs;

    SEQIDLVALUE		Sobj;			/*  iterators ... */
    IDLVALUE		obj;
    SEQattrDesc		Sad;
    attrDesc		ad;
    SETTypeEntity	SType;
    TypeEntity		AType;

    int			index;		/* index into reference array	*/
    IDLVALUE		hed;		/* holds value of head of a sequence */

    IDLVALUE		arg;		/* a single argument		*/
    IDLVALUE		runstack_to_value();
					/* translates runstack entry to
					   equivalent IDLVALUE		*/
    runstackEntry	value_to_runstack();
					/* translates IDLVALUE to equivalent
					   runstack entry		*/

    nodeDesc		strc;		/* structure instance		*/
    IDLVALUE		tempIDLVALUE;	/* used for widening   */

    SEQString		string_refs;	/* string references	*/
    SEQint		integer_refs;	/* integer references	*/
    SEQfloat		rational_refs;	/* rational references	*/
    SEQTypeEntity	type_refs;	/* type references	*/
    SEQDefinition	define_refs;	/* definition references */
    int			int_value;	/* integer value	*/
    float		rat_value;	/* rational value	*/
    String		str_value;	/* string value		*/
    TypeEntity		type_value;	/* type value		*/
    Definition		def_value;	/* definition value	*/

    char		buf[80];	/* for debugging statements */
    char		*instr_type();
    extern int          assertioncounter;

	/* initialize control and formal return arrays */
	appendfrontSEQint(controlReturn,0);

	/* de-reference reference arrays */
	string_refs = SP.IDLclassCommon->string_refs;
	integer_refs = SP.IDLclassCommon->integer_refs;
	rational_refs = SP.IDLclassCommon->rational_refs;
	type_refs = SP.IDLclassCommon->type_refs;
	define_refs = SP.IDLclassCommon->define_refs;

        assertioncounter++;

#ifdef DEBUG
	print_op_stack(body);
#endif
	/* get first code operator */
	entry = get_op(body, code_pos++);

	/* ENDASSERTION ends an assertion interpretation.
	 * RETURN ends a definition instance interpretation. 
	 */

	while (entry != ENDASSERTION && entry != RETURN)
	{
#ifdef DEBUG
		print_op(entry);
#endif
		switch (entry)  {

		case Zero_op:
			result.VintegerDesc = NintegerDesc;
			result.VintegerDesc->value = 0;
			stack(result,&runstack);
			break;

		case One_op:
			result.VintegerDesc = NintegerDesc;
			result.VintegerDesc->value = 1;
			stack(result,&runstack);
			break;

			/* binary operators */
		case union_op:
		case intersect_op:
		case subset_op:
		case propSubset_op:
			op2 = pop(&runstack);
			op1 = pop(&runstack);
			collection_op(op1, op2, entry, &result);
			stack(result,&runstack);
			break;

		case plus_op:
		case minus_op:
		case times_op:
		case divide_op:
		case num_less_op:
		case num_lessEq_op:
		case num_greater_op:
		case num_grtrEq_op:
		case num_equal_op:
		case num_notEqual_op:
			op2 = pop(&runstack);
			op1 = pop(&runstack);
			number_op(op1, op2, entry, &result);
			stack(result,&runstack);
			break;

		case and_op:
		case or_op:
		case bool_equal_op:
		case bool_notEqual_op:
			op2 = pop(&runstack);
			op1 = pop(&runstack);
			boolean_op(op1, op2, entry, &result);
			stack(result,&runstack);
			break;

		case str_less_op:
		case str_lessEq_op:
		case str_greater_op:
		case str_grtrEq_op:
		case str_equal_op:
		case str_notEqual_op:
			op2 = pop(&runstack);
			op1 = pop(&runstack);
			string_op(op1, op2, entry, &result);
			stack(result,&runstack);
			break;

		case set_equal_op:
		case set_notEqual_op:
			op2 = pop(&runstack);
			op1 = pop(&runstack);
			set_op(op1, op2, entry, &result);
			stack(result,&runstack);
			break;

		case seq_equal_op:
		case seq_notEqual_op:
			op2 = pop(&runstack);
			op1 = pop(&runstack);
			seq_op(op1, op2, entry, &result);
			stack(result,&runstack);
			break;

		case node_equal_op:
		case node_notEqual_op:
			op2 = pop(&runstack);
			op1 = pop(&runstack);
			node_op(op1, op2, entry, &result);
			stack(result,&runstack);
			break;

		case is_op:
			op2 = pop(&runstack);
			op1 = pop(&runstack);

			/* singleton collection */
			if (typeof(op1) == Kcollect)
				op1 = get_object(op1);

			if (typeof(op2) != Kcollect && 
			    typeof(op1) != typeof(op2)) {
				;
			}
			else switch (typeof(op1)) {
			    case KnodeDesc:
				if (typeof(op2) == Kcollect) {
				    foreachinSEQIDLVALUE(op2.Vcollect->objects,
							 Sobj, obj) {
					node_op(op1, obj, entry, &result);
					if (typeof(result) == KTVALUE)
					    break;
				    }
				}
				else
				    node_op(op1, op2, entry, &result);
				break;
			    case KsetDesc:
				if (typeof(op2) == Kcollect)
					op2 = get_object(op1);
				set_op(op1, op2, entry, &result);
				break;
			    case KsequenceDesc:
				if (typeof(op2) == Kcollect)
					op2 = get_object(op1);
				seq_op(op1, op2, entry, &result);
				break;
			    default:
				invalid_arg(entry, 2, op1, op2);
				break;
			}
			stack(result,&runstack);
			break;

		case same_op:
			op2 = pop(&runstack);
			op1 = pop(&runstack);
			collection_op(op1, op2, entry, &result);
			stack(result,&runstack);
			break;

		case inSet_op:

			op2 = pop(&runstack);
			op1 = pop(&runstack);

			/* singleton collections */
			if (typeof(op1) == Kcollect)
				op1 = get_object(op1);
			if (typeof(op2) == Kcollect)
				op2 = get_object(op2);

			if (typeof(op2) != KsetDesc) {
				invalid_arg(entry, 2, op1, op2);
			}

			if (inSEQIDLVALUE(op2.VsetDesc->value, op1.VIDLVALUE))
				result.VTVALUE = NTVALUE;
			else 
				result.VFVALUE = NFVALUE;
			stack(result,&runstack);
			break;

		case inSeq_op:

			op2 = pop(&runstack);
			op1 = pop(&runstack);

			/* singleton collections */
			if (typeof(op1) == Kcollect)
				op1 = get_object(op1);
			if (typeof(op2) == Kcollect)
				op2 = get_object(op2);

			if (typeof(op2) != KsequenceDesc) {
				invalid_arg(entry, 2, op1, op2);
			}

			if (inSEQIDLVALUE(op2.VsequenceDesc->value, op1.VIDLVALUE))
				result.VTVALUE = NTVALUE;
			else 
				result.VFVALUE = NFVALUE;

			stack(result,&runstack);
			break;

		case inCollection_op:

			op2 = pop(&runstack);
			op1 = pop(&runstack);

			/* singleton collections */
			if (typeof(op1) == Kcollect)
				op1 = get_object(op1);

			/* op2 should be a collect */
			if (typeof(op2) != Kcollect) {
				invalid_arg(entry, 2, op1, op2);
			}

			if (inSEQIDLVALUE(op2.Vcollect->objects, op1.VIDLVALUE))
				result.VTVALUE = NTVALUE;
			else 
				result.VFVALUE = NFVALUE;

			stack(result,&runstack);
			break;

			/* Unary operators	*/
		case unaryMinus_op:
			op1 = pop(&runstack);

			/* singleton collection */
			if (typeof(op1) == Kcollect)
				op1 = get_object(op1);

			if (typeof(op1) == KrationalDesc)
			{
				result.VrationalDesc = NrationalDesc;
				result.VrationalDesc->value = -1*
						(op1.VrationalDesc->value);
			}
			else if (typeof(op1) == KintegerDesc)
			{
				result.VintegerDesc = NintegerDesc;
				result.VintegerDesc->value = 
						-1 * (op1.VintegerDesc->value);
			}
			else {
				invalid_arg(entry, 1, op1, TVALUETorunstackEntry(NTVALUE));
			}

			stack(result,&runstack);
			break;

		case not_op:

			op1 = pop(&runstack);

			/* singleton collection */
			if (typeof(op1) == Kcollect)
				op1 = get_object(op1);

			if (typeof(op1) != KTVALUE && typeof(op1) != KFVALUE) {
				invalid_arg(entry, 1, op1, TVALUETorunstackEntry(NTVALUE));
			}
			if (typeof(op1) == KTVALUE)
				result.VFVALUE = NFVALUE;
			else
				result.VTVALUE = NTVALUE;
			stack(result,&runstack);
			break;

			/* Jump operations	*/
		case jump:
			entry = get_op(body, code_pos);
			code_pos = entry;
			break;

		case jtrue:
			entry = get_op(body, code_pos++);
			op1 = pop(&runstack);
			if (typeof(op1) == KTVALUE)
				code_pos = entry;
			break;

		case jfalse:
			entry = get_op(body, code_pos++);
			op1 = pop(&runstack);
			if (typeof(op1) == KFVALUE)
				code_pos = entry;
			break;


			/* Literal entries	*/
		case intToken:
			/* get index into integer array */
			index = get_index(body, &code_pos);

			/* retrieve value */
			retrieve_int(integer_refs,index,&int_value);	
			result.VintegerDesc = NintegerDesc;
			result.VintegerDesc->value = int_value;

			code_pos--; /* decrement for accurate runtime_result entry */
			stack(result,&runstack);
			code_pos = code_pos + 2; 	/* adjust to next operator */
			break;

		case ratToken:
			/* get index into rational array */
			index = get_index(body, &code_pos);

			/* retrieve value */
			retrieve_rat(rational_refs,index,&rat_value);	
			result.VrationalDesc = NrationalDesc;
			result.VrationalDesc->value = rat_value;

			code_pos--; /* decrement for accurate runtime_result entry */
			stack(result,&runstack);
			code_pos = code_pos+2;	/* adjust to next operator */
			break;

		case strToken:
			/* get index into string array */
			index = get_index(body, &code_pos);

			/* retrieve value */
			retrieve_string(string_refs,index,&str_value);	
			result.VstringDesc = NstringDesc;
			result.VstringDesc->value = str_value;

			code_pos--; /* decrement for accurate runtime_result entry */
			stack(result,&runstack);
			code_pos = code_pos+2;	/* adjust to next operator */
			break;


		case true_op:
			result.VTVALUE = NTVALUE;
			stack(result,&runstack);
			break;

		case false_op:
			result.VFVALUE = NFVALUE;
			stack(result,&runstack);
			break;

		case empty_op:
			result.Vcollect = Ncollect;
			result.Vcollect->objects = NULL;
			stack(result,&runstack);
			break;

		case Root_op:
			result.Vcollect = Ncollect;
			get_structure(&strc,allstrucs,stindex);
			tempIDLVALUE.VnodeDesc = strc;
			appendrearSEQIDLVALUE(result.Vcollect->objects,tempIDLVALUE);
			stack(result,&runstack);
			break;

		case portRoot_op:
			result.Vcollect = Ncollect;

			/* get index into string array */
			index = get_index(body, &code_pos);

			/* retrieve value */
			retrieve_string(string_refs,index,&str_value);	

			get_structure_port(&strc,str_value,allstrucs,numstruc);
			tempIDLVALUE.VnodeDesc = strc;
			appendrearSEQIDLVALUE(result.Vcollect->objects,tempIDLVALUE);

			code_pos--;
			stack(result,&runstack);
			code_pos = code_pos + 2;
			break;


			/* Supplied Functions	*/
		case members_op:

			op1 = pop(&runstack);
			if (typeof(op1) == Kcollect)
				op1 = get_object(op1);
			if (typeof(op1) != KsequenceDesc && 
			    typeof(op1) != KsetDesc) {
				invalid_arg(entry, 1, op1, TVALUETorunstackEntry(NTVALUE));
			}

			result.Vcollect = Ncollect;
			if (typeof(op1) == KsetDesc)  {
				foreachinSEQIDLVALUE(op1.VsetDesc->value,Sobj,obj)
					appendrearSEQIDLVALUE(result.Vcollect->objects,obj);
			}
			else /* sequence argument */ {
				foreachinSEQIDLVALUE(op1.VsequenceDesc->value,Sobj,obj)
				    appendrearSEQIDLVALUE(result.Vcollect->objects,obj);
			}

			stack(result,&runstack);
			break;

		case head_op:

			result.Vcollect = Ncollect;
			op1 = pop(&runstack);

			/* singleton collect */
			if (typeof(op1) == Kcollect)
				op1 = get_object(op1);
			if (typeof(op1) != KsequenceDesc) {
				invalid_arg(entry, 1, op1, TVALUETorunstackEntry(NTVALUE));
			}
			retrievefirstSEQIDLVALUE(op1.VsequenceDesc->value,hed);
			appendrearSEQIDLVALUE(result.Vcollect->objects,hed);

			stack(result,&runstack);
			break;

		case tail_op:

			op1 = pop(&runstack);

			/* singleton collect */
			if (typeof(op1) == Kcollect)
				op1 = get_object(op1);
			if (typeof(op1) != KsequenceDesc) {
				invalid_arg(entry, 1, op1, TVALUETorunstackEntry(NTVALUE));
			}
			result.VsequenceDesc = NsequenceDesc;
			result.VsequenceDesc->value = 
			    tailSEQIDLVALUE(op1.VsequenceDesc->value);

			stack(result,&runstack);
			break;

		case str_size_op:

			op1 = pop(&runstack);

			/* singleton collect */
			if (typeof(op1) == Kcollect)
				op1 = get_object(op1);
			if (typeof(op1) != KstringDesc) {
				invalid_arg(entry, 1, op1, TVALUETorunstackEntry(NTVALUE));
			}
			result.VintegerDesc = NintegerDesc;
			result.VintegerDesc->value = strlen(op1.VstringDesc->value);

			stack(result,&runstack);
			break;

		case setseq_size_op:

			op1 = pop(&runstack);

			/* singleton collect with set or sequence object */
			if (typeof(op1) == Kcollect) {
				if (lengthSEQIDLVALUE(op1.Vcollect->objects)==1)
				{
					retrievefirstSEQIDLVALUE(op1.Vcollect->
								 objects,obj);
					if (typeof(obj) == KsetDesc || 
					    typeof(obj) == KsequenceDesc)
						op1 = get_object(op1);
				}
			}

			result.VintegerDesc = NintegerDesc;

			if (typeof(op1) == KsetDesc)
				result.VintegerDesc->value = 
/*				    sizeSEQIDLVALUE(op1.VsetDesc->value); */
				    lengthSEQIDLVALUE(op1.VsetDesc->value);

			else if (typeof(op1) == KsequenceDesc)
				result.VintegerDesc->value = 
				    lengthSEQIDLVALUE(op1.VsequenceDesc->value);

			else if (typeof(op1) == Kcollect)
				result.VintegerDesc->value =
				    lengthSEQIDLVALUE(op1.Vcollect->objects);
			else {
				invalid_arg(entry, 1, op1, TVALUETorunstackEntry(NTVALUE));
			}

			stack(result,&runstack);
			break;

		case type_op:
			op1 = pop(&runstack);
			if (typeof(op1) != Kcollect) {
				invalid_arg(entry, 1, op1, TVALUETorunstackEntry(NTVALUE));
			}

			/* if Type is in process, then typename is meant since
					 a collection doesn't make sense */
			if (typeof(SP) == KProcessEntity)
			{
				result.Vcollect = Ncollect;
				retrievefirstSEQIDLVALUE(op1.Vcollect->objects,
							 obj);
				appendrearSEQIDLVALUE(result.Vcollect->objects,
							 obj);
			}
			else
			{
				result.Vcollect = Ncollect;
				get_structure(&strc,allstrucs,stindex);
				foreachinSEQIDLVALUE(op1.Vcollect->objects,
							Sobj,obj) {
					/* collect puts objects in structure 
					   struc that are of same type as obj */
					collect_st_objs(obj,strc,
						&(result.Vcollect->objects));
				}
			}

			stack(result,&runstack);
			break;

		case dot_op:

			op1 = pop(&runstack);
			if (typeof(op1) != Kcollect) {
				invalid_arg(entry, 1, op1, TVALUETorunstackEntry(NTVALUE));
			}

			/* get index into string array */
			index = get_index(body, &code_pos);

			/* retrieve value */
			retrieve_string(string_refs,index,&str_value);	

			result.Vcollect = Ncollect;
			foreachinSEQIDLVALUE(op1.Vcollect->objects,Sobj,obj)
			{
				/* get all attributes with same name as dot 
				 * name */
				if (typeof(obj) != KnodeDesc) {
					invalid_arg(entry, 1, obj, TVALUETorunstackEntry(NTVALUE));
				}
				foreachinSEQattrDesc(obj.VnodeDesc->attributes,
							Sad,ad) {
					if (streq(str_value,ad->name))
					{
						appendrearSEQIDLVALUE(result.
						   Vcollect->objects,ad->value);
					}
				}
			}
			/* decrement for accurate runtime_result entry */
			code_pos--; 
			stack(result,&runstack);
			code_pos = code_pos + 2;/* adjust to next operator */
			break;

		case typeExpression_op:
			/* get index into type array */
			index = get_index(body, &code_pos);

			/* retrieve value */
			retrieve_type(type_refs,index,&type_value);	

			/* if in process, then typename is meant since
					 a collection doesn't make sense */
			if (typeof(SP) == KProcessEntity)
			{
			    result.Vcollect = Ncollect;
			    reach(type_value);
			    foreachinSETTypeEntity(type_value.IDLclassCommon->
						   reachable, SType, AType) {
				type_to_object(&obj, AType);
				appendrearSEQIDLVALUE(result.Vcollect->objects,
							obj);
			    }
			}
			else
			{
			    /* get structure */
			    get_structure(&strc,allstrucs,stindex);

			    /* get all objects reachable from given type */
			    get_reachable_objects(type_value, strc, &result);
			}
			
			code_pos--; /* decrement for accurate runtime_result 
							     entry */
			stack(result,&runstack);
			code_pos = code_pos + 2; /* adjust to next operator */
			break;

		case portExpression_op:

			/* get index into type array */	
			index = get_index(body, &code_pos);
			++code_pos;

			/* retrieve type value */
			retrieve_type(type_refs,index,&type_value);	

			/* get index into string array */
			index = get_index(body, &code_pos);

			/* retrieve port name value */
			/* get associated structure */
			retrieve_string(string_refs,index,&str_value);
			get_structure_port(&strc,str_value,allstrucs,numstruc);

			get_reachable_objects(type_value, strc, &result);

			code_pos = code_pos - 3; /* decrement for accurate 
						    runtime_result entry */
			stack(result,&runstack);
			code_pos = code_pos + 4; /* adjust to next operator */
			break;

		case casename_op:
			op1 = pop(&runstack);
			if (typeof(op1) == Kcollect)
			    op1 = get_object(op1);
			controlArray[nestlevel++] = op1.VIDLVALUE;
			numcontrol++;
			break;

		case forall_op:
			op1 = pop(&runstack);
			if (typeof(op1) != Kcollect) {
				invalid_arg(entry, 1, op1, TVALUETorunstackEntry(NTVALUE));
			}

			/* store iterator collect in new object so that
			   original won't get clobbered */
			op2.Vcollect = Ncollect;
			foreachinSEQIDLVALUE(op1.Vcollect->objects,Sobj,obj)
			    appendfrontSEQIDLVALUE(op2.Vcollect->objects,obj);

			/* place collection set on quantifier 
						collections list */
			appendrearSEQcollect(quantsets,op2.Vcollect);

			/* stack true since forall is assumed true */
			/*  until proven false 		           */
			/* set nest level and go to endForAll to   */
			/*  get first object to iterate with       */
			result.VTVALUE = NTVALUE;
			stack(result,&runstack);
			nestlevel++;
			numcontrol++;
			code_pos2 = code_pos;
			while (1) {
			    while ( get_op(body, code_pos) != endForAll)
				++code_pos;
			    /* check for correct endForAll */
			    if (get_op(body, code_pos+1) == code_pos2)
				break;
			    else
				++code_pos;
			}

			break;

		case exists_op:

			op1 = pop(&runstack);

			/* store iterator collect in new object so that
						original won't get clobbered */
			op2.Vcollect = Ncollect;
			foreachinSEQIDLVALUE(op1.Vcollect->objects,Sobj,obj)
			    appendfrontSEQIDLVALUE(op2.Vcollect->objects,obj);
			appendrearSEQcollect(quantsets,op2.Vcollect);

			/* stack false since exists is assumed false */
			/*  until proven true 		             */
			/* set nest level and go to endExists to     */
			/*  get first object to iterate with         */
			result.VFVALUE = NFVALUE;
			stack(result,&runstack);
			nestlevel++;
			numcontrol++;
			    
			code_pos2 = code_pos;
			while (1) {
			    while ( get_op(body, code_pos) != endExists)
				++code_pos;
			    /* check for correct endExists */
			    if (get_op(body, code_pos+1) == code_pos2)
				break;
			    else
				++code_pos;
			}


			break;

		case endForAll:
			/* get return point */
			entry = get_op(body, code_pos);

			op1 = pop(&runstack);
			if (typeof(op1) == Kcollect) {
			  retrievefirstSEQIDLVALUE(op1.Vcollect->objects, op1);
			}
			else if (typeof(op1) == KbooleanDesc) {
			    if (op1.VbooleanDesc->value)
			      op1.VTVALUE = NTVALUE;
			    else op1.VFVALUE = NFVALUE;
			  }
			if (typeof(op1) == KFVALUE) /* body is false! */
			{
				removelastSEQcollect(quantsets);
				result.VFVALUE = NFVALUE;
				stack(result,&runstack);

				/* place object that caused failure in result array */
				runtime_result[code_pos] = 
				    value_to_runstack(controlArray[nestlevel-1]);
				nestlevel--;
				numcontrol--;
				code_pos++;
			}
			else /* body is true */
			{
				retrievelastSEQcollect(quantsets,qs);
				/* if not more to check, quantifier is true */
				if (emptySEQIDLVALUE(qs->objects))  /* set is empty */
				{
					removelastSEQcollect(quantsets);
					result.VTVALUE = NTVALUE;
					stack(result,&runstack);
					nestlevel--;
					numcontrol--;
					code_pos++;
				}
				else /* go get next in set */
				{
					retrievefirstSEQIDLVALUE(qs->objects,obj);
					removefirstSEQIDLVALUE(qs->objects);
					controlArray[nestlevel-1] = obj;

					code_pos = entry;
				}
			}
			break;

		case endExists:

			entry = get_op(body, code_pos);
			op1 = pop(&runstack);
			if (typeof(op1) == Kcollect) {
			  retrievefirstSEQIDLVALUE(op1.Vcollect->objects, op1);
			}
			if (typeof(op1) == KbooleanDesc) {
			  if (op1.VbooleanDesc->value)
			    op1.VTVALUE = NTVALUE;
			  else op1.VFVALUE = NFVALUE;
			}
			if (typeof(op1) == KTVALUE) /* body is true! */
			{
				removelastSEQcollect(quantsets);
				result.VTVALUE = NTVALUE;
				stack(result,&runstack);
				/* place object that satisfied Exists in result array */
				runtime_result[code_pos] = 
				    value_to_runstack(controlArray[nestlevel-1]);
				nestlevel--;
				numcontrol--;
				code_pos++;
			}
			else /* body is false */
			{
				retrievelastSEQcollect(quantsets,qs);
				/* if not more to check, quantifier is false */
				if (emptySEQIDLVALUE(qs->objects))  /* set is empty */
				{
					removelastSEQcollect(quantsets);
					result.VFVALUE = NFVALUE;
					stack(result,&runstack);
					nestlevel--;
					numcontrol--;
					code_pos++;
				}
				else /* go back to get next in set */
				{
					retrievefirstSEQIDLVALUE(qs->objects,obj);
					removefirstSEQIDLVALUE(qs->objects);
					controlArray[nestlevel-1] = obj;

					code_pos = entry;

				}
			}
			break;

		case control_op:
			result.Vcollect = Ncollect;
			/* get level */
			level = get_op(body, code_pos);

			/* get offset into control array */
			retrievefirstSEQint(controlReturn,offset);

#ifdef DEBUG
			print_controlArray(controlArray, numcontrol);
			DEBUG1("\tretrieving index %d\n", level+offset-1);
#endif
			/* retrieve object */
			if (level+offset <= numcontrol) {
				obj = controlArray[level+offset-1];
				appendrearSEQIDLVALUE(result.Vcollect->objects,obj);
			}
			else {
				DEBUG2("Error in control_op: index = %d number in arry = %d \n",
				level+offset-1, numcontrol);
				fatal_error(1);
			}

			stack(result,&runstack);
			code_pos++;
			break;

		case formArg_op:

			result.Vcollect = Ncollect;
			/* get position of actual argument */
			pos = get_op(body, code_pos++);

			/* retrieve actual argument */
			arg = forms[pos-1];
			TRACE(sprintf(buf, "type of arg is %d\n", typeof(arg)));
			appendrearSEQIDLVALUE(result.Vcollect->objects,arg);

			stack(result,&runstack);
			break;


		case cyclic_appl_op:
		case application_op:

			/* get index into definition array */
			index = get_index(body, &code_pos);
			++code_pos;

			/* retrieve value */
			retrieve_def(define_refs,index,&def_value);

			/* get number of arguments */
			numargs = get_op(body, code_pos++);

			result = run_application(def_value, numargs, &runstack,
					name, SP, allstrucs, numstruc, 
					stindex, tree, suppress);

			code_pos = code_pos - 3;
			stack(result,&runstack);
			code_pos = code_pos + 3;
			break;


		} /* end of switch */

		/* get next code operator */
		entry = get_op(body, code_pos++);
	}  /* end of while loop */

	result = pop(&runstack);
	if (entry == RETURN)  	/* just interpreted a definition body - 
						   return result */
	{
		return(result);
	}
	else /* interpreted an assertion body */
	{
		(void) fprintf(stderr, "idlcheck:          Assertion completed\n");
		/* Find out whether assertion is true and report */
		if (typeof(result) == KFVALUE) {
			(void) fprintf(stderr,"idlcheck:          Assertion %s in %s is false.\n",
			name, SP.IDLclassCommon->lex_name);
			if (!suppress) {
#ifdef DEBUG
				print_runtime_result(runtime_result,code_pos);
#endif
				print(tree,0,FALSE,0); /* generate error log */
			}
		}
		else {
			(void) fprintf(stderr,"idlcheck:          Assertion %s in %s is true.\n",
			name,
			SP.IDLclassCommon->lex_name);
		}
		return(result);
	}
}
