/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlcheck/check/application.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Check.h"
#include "macros.h"
#include <stdio.h>
#define MAXARGS 100

runstackEntry run_application(def_value, numargs, runstack,
			      name, SP, allstrucs, numstruc, stindex, 
			      tree, suppress)
Definition 	 def_value;
int 		 numargs;
SEQrunstackEntry *runstack;
String    	name;		/* assertion name, if any	*/
StructureOrProcess SP;		/* structure/process assertion is in */
struc		allstrucs[]; 	/* array of structure instances */
int		numstruc;   	/* number of structures in allstrucs */
int		stindex;	/* index of structure in allstrucs	*/
expression	tree;		/* expression tree for assertion - used in
			  	   generating error log */
Boolean		suppress; 	/* TRUE if error log should be suppressed */
{
	SEQIDLVALUE 	args;
	IDLVALUE	formalArray[MAXARGS];
	value_result	val_result;
	DefInstance	instance;
	runstackEntry 	result;
	runstackEntry 	tmp_result;
	SEQIDLVALUE	Sobj;
	IDLVALUE	obj;
	int		len;
	runstackEntry	stack_args[MAXARGS];
	int		num_calls;
	register int	i;
	Boolean		arb_collection=FALSE;

	DefInstance	findinstance();		/* functions called */
	Boolean		has_called();
	runstackEntry	pop();
	runstackEntry	interpret();
        void            exit();

	TRACE1("run_application '%s'", def_value->sem_name);

	/* get arguments */
	num_calls = 1;
	for (i=numargs-1; i>=0; i--) {
		stack_args[i] = pop(runstack);   
		if (typeof(stack_args[i]) == Kcollect) {
		    len = lengthSEQIDLVALUE(stack_args[i].Vcollect->objects);
		    if (len == 0) {
			num_calls = 0; /* empty_collection */
		    }
		    else if (len > 1) {
			num_calls *= len; /* arbitrary collection */
			arb_collection = TRUE;
		    }
		}
	}
	/* if empty collection result is an empty collection*/
	if (num_calls == 0) {
		/* result is empty collection */
		result.Vcollect = Ncollect; 
		initializeSEQIDLVALUE(result.Vcollect->objects);
	}
	/* else if arbitrary collection, result is a collection */
	else if (num_calls > 1) {
		result.Vcollect = Ncollect; 
	}

	DEBUG2("%s: Number of calls = %d\n", def_value->sem_name,num_calls);

	/* call application */
	while (num_calls--) {
	    get_arguments(stack_args, numargs, formalArray, &args);

	    /* must find instance */
	    instance = findinstance(def_value,args);

	    if (has_called(instance, args, &val_result)) {
		tmp_result = val_result->result;
		DEBUG1("already interpreted application '%s' for this argument\n", 
		    def_value->sem_name);
		if (typeof(instance) != Kcyclicdef) {
		    (void) fprintf(stderr, "idlcheck: noncyclic instance for def %s is actually cyclic\n", def_value->sem_name);
		}
	    }
	    else {
		tmp_result = interpret(instance.IDLclassCommon->postfixDefn,
				    name,SP,formalArray,
				    allstrucs,numstruc,stindex,tree,
				    suppress,TRUE);
		val_result->result = tmp_result;
	    }
	    if (arb_collection) { /* add to existing result */
		if (typeof(tmp_result) == Kcollect) {
		    foreachinSEQIDLVALUE(tmp_result.Vcollect->objects,Sobj,obj)
			appendrearSEQIDLVALUE(result.Vcollect->objects, obj);
		}
		else if ((typeof(tmp_result) == KTVALUE)
			 || (typeof(tmp_result) == KFVALUE))
		  exit(-1);
		else {
		    appendrearSEQIDLVALUE(result.Vcollect->objects, tmp_result.VIDLVALUE);
		}
	    }
	    else result = tmp_result;
	}
#ifdef DEBUG
	DEBUG1("Result of application '%s' is ", def_value->sem_name);
	print_runstackEntry(stderr, result);
	DEBUG0("\n");
#endif

	return(result);
}

Boolean has_called(instance, args, val_result)
IDLDefInstance instance;
SEQIDLVALUE    args;
value_result  *val_result;
{
    SEQvalue_result Svr;
    value_result    vr;
    IDLVALUE        iv1, iv2;
    int		    len_args;
    int		    i;
    Boolean 	    match=FALSE;
    extern int      assertioncounter;

    match = FALSE;
    len_args = lengthSEQIDLVALUE(args);

    if (instance.IDLclassCommon->epoch != assertioncounter) {
      initializeSEQvalue_result(instance.IDLclassCommon->actual_args);
      instance.IDLclassCommon->epoch = assertioncounter;
    }
    else foreachinSEQvalue_result(instance.IDLclassCommon->actual_args, Svr, vr) {
      if (lengthSEQIDLVALUE(vr->value) == len_args) {
	match=TRUE;
	for (i=1; i<=len_args && match; i++) {
	  ithinSEQIDLVALUE(args, i, iv1);
	  ithinSEQIDLVALUE(vr->value, i, iv2);
	  if (iv1.IDLclassCommon != iv2.IDLclassCommon) {
	    match = FALSE;
	  }
	}
	if (match) {
	  *val_result = vr;
	  break;
	}
      }
    }
    /* add to sequence if not already there */
    if (!match) {
	*val_result = Nvalue_result;
	(*val_result)->value = args;
	(*val_result)->result.Vcollect = Ncollect;	/* empty collection */
	appendrearSEQvalue_result(instance.IDLclassCommon->actual_args, 
				  (*val_result));
    }
    return(match);
}

/* remove one object from one arbitrary collection */
get_arguments(stack_args, num_args, formalArray, args)
runstackEntry	stack_args[MAXARGS];
int 		num_args;
IDLVALUE	formalArray[MAXARGS];
SEQIDLVALUE 	*args;
{
    register int 	i;
    runstackEntry 	arg;
    collect		collect_arg;
    IDLVALUE		val;
    Boolean		arb_collection=FALSE;
    runstackEntry	get_object();
    IDLVALUE		runstack_to_value();

    initializeSEQIDLVALUE((*args));

    TRACE("get_arguments");

    for (i=0; i<num_args; i++) {
	arg = stack_args[i];
	if (typeof(arg) == Kcollect) {
	    collect_arg = arg.Vcollect;
	    arg = get_object(arg);
	    if (!arb_collection && lengthSEQIDLVALUE(collect_arg->objects)>1) {
		removefirstSEQIDLVALUE(collect_arg->objects);
		arb_collection = TRUE;
	    }
	}
	val = runstack_to_value(arg);
	appendrearSEQIDLVALUE((*args), val);
	formalArray[i] = val;
    }
}
