/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlcheck/assertcodegen/gencode.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: main driver for code generation for assertion checker	*	
*									*
*									*
\* ******************************************************************* */

/*	$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/idlcheck/assertcodegen/RCS/gencode.c,v 4.0 89/04/12 02:30:57 cheung Exp Locker: cheung $						       */

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	gencode.c,v $
 * Revision 4.0  89/04/12  02:30:57  cheung
 * gencode.c  Ver 4.0
 * 
 * Revision 3.9  89/04/02  12:14:11  cheung
 * gencode.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  13:30:43  cheung
 * gencode.c  Ver 3.9
 * 
 * Revision 1.7  85/12/19  12:47:15  kickenso
 * This version works!  Exhaustive testing will follow.
 * 
 * Revision 1.6  85/12/17  12:18:03  kickenso
 * handles all expressions - compiles
 * next: runtime checking
 * 
 * Revision 1.5  85/12/15  13:19:30  kickenso
 * idlc version - still must add quantifiers & conditionals
 * 
 * Revision 1.4  85/12/08  21:44:21  kickenso
 * pointer to postfix array now passed to gencode procedure
 * 
 * Revision 1.3  85/12/08  15:21:04  kickenso
 * this version compiles!
 * 
 * Revision 1.2  85/12/08  15:07:07  kickenso
 * created main driver

 * Revision 1.1  85/12/08  14:27:02  kickenso
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     December 8, 1985 (kickenson).					*
*									*
\* ******************************************************************* */


#include <stdio.h>
#include "GeneratePostfix.h"
#include "instructions.h"

#define gencode(BOD,PF)	generatecode(BOD,PF,in,ADecl)
#define streq(s1,s2)	strcmp(s1,s2) == 0

#define ISSTRING(t)	(!strcmp(t.IDLclassCommon->sem_name, "String"))
#define ISBOOLEAN(t)	(!strcmp(t.IDLclassCommon->sem_name, "Boolean"))
#define ISINTEGER(t)	(!strcmp(t.IDLclassCommon->sem_name, "Integer"))
#define ISRATIONAL(t)	(!strcmp(t.IDLclassCommon->sem_name, "Rational"))
#define ISSET(t)	(typeof(t) == KSetOf)
#define ISSEQ(t)	(typeof(t) == KSeqOf)
#define ISNODE(t)	(typeof(t) == KClass)
#define ISMEMBERS(d)	(!strcmp(d->sem_name, "Members"))
#define ISHEAD(d)	(!strcmp(d->sem_name, "Head"))
#define ISTYPE(d)	(!strcmp(d->sem_name, "Type"))
#define ISSTRSIZE(d, as)	(!strcmp(d->sem_name, "Size") && ArgTypeIsString(as))
#define ISSETSEQSIZE(d, as)	(!strcmp(d->sem_name, "Size") && !ArgTypeIsString(as))
#define ISTAIL(d)	(!strcmp(d->sem_name, "Tail")) 


typedef char		BYTE;


int		level = 0;		/* level of a nested quantifier	*/
SEQint		loc_stack = NULL;	/* stack of code array locations, 
					   used by conditionals		*/
int		currentpos = 0;		/* current position in code array */

void            exit();
Boolean 	ArgTypeIsString();

main()
{
    compilationUnit		compUnit;	/* input Candle */
    SEQDeclaration		SDecl;
    Declaration			ADecl;
    SETAssertion		Sas;
    Assertion			as;
    SETDefinition		Sdef;
    Definition			def;
    SETDefInstance		Sin;
    DefInstance			in;
    IDLDefInstance		IdlDef;
    StructureOrProcess		StorPr;
    SEQDeclaration		StPrs;



    /* read in Candle	*/
    compUnit = INCandle(stdin);
    if (compUnit == NULL) {
	(void) fprintf(stderr, "read error in code generator\n");
	exit(1);
    }

    /* collect all structures and processes */
    collect_stprs(compUnit, &StPrs);

    /* generate code for all assertions and definition instance bodies	*/
    foreachinSEQDeclaration(StPrs,SDecl,ADecl) {

	    StorPr = ADecl.VStructureOrProcess;

	    foreachinSETAssertion(StorPr.IDLclassCommon->sem_assertions,Sas,as){
		    currentpos = 0;
		    gencode(as->syn_body, &(as->postfixBody));
		    addtocode(ENDASSERTION,&(as->postfixBody));
	    }

	    foreachinSETDefinition(StorPr.IDLclassCommon->sem_definitions,
						Sdef,def) {
		    foreachinSETDefInstance(def->sem_overload,Sin,in) {
			if (typeof(in)==Kcyclicdef || typeof(in)==Knoncyclicdef)
			{
			    currentpos = 0;
			    IdlDef = in.VIDLDefInstance;
			    gencode(IdlDef.IDLclassCommon->syn_body,
			            &(IdlDef.IDLclassCommon->postfixDefn));
			    addtocode(RETURN,&(IdlDef.IDLclassCommon->postfixDefn));
			}
		    }
	    }
    }


    /* write out table with generated code included	*/
    PostfixCode(stdout,compUnit,TWOPASS);

    return 0;

} /* end of main */


/************************************************************************
*	generatecode 	generates postfix code equivalent to the given	*
*			expression tree.  Method uses a recursive tree  *
*			traversal.  Resulting code is an array of one	*
*			byte integers (C char).  Maximum size of array  *
*			1000.						*
*									*	
*									*
*	Last revised:	June 7, 1986					*
************************************************************************/
				
generatecode(body,code_array,in,ADecl)
expression	body;			/* expression tree	*/
SEQint		*code_array;		/* generated code passed back up */
DefInstance	in;			/* definition instance 	*/
Declaration	ADecl;			/* structure/process 	*/
{

    int			op;	/* appropriate operator */
    BYTE		hi;	/* high byte of reference index	*/
    BYTE		lo;	/* low byte of reference index	*/
    int			index;	/* index into string, rational, etc. array */

    SEQexpression	Sarg; 	/*  iterators ...	*/
    expression		arg;
    SEQcase_select	Scs;
    case_select		Acs;

    double		atof();

    int			startpos;	/* start position in code array
					   of quantifier		*/
    int			loc;		/* location to be saved		*/
    int			i;		/*  iterators ...		*/
    SEQexpressionPair	Sep;
    expressionPair	ep;

    int			loc_count = 0;	/* saves locations for OrIf
					    conditionals		*/
    TypeEntity		tipe, ThisTypeEntity;
    Expname		entity;
    Definition		def;
    int 		ivalue;
    Boolean		has_cyclic();


    /* generate code for different types of expressions  */
    switch (typeof(body))    {

	case KcaseExp:

	    level++;
	    body.VcaseExp->nest_level = level;

	    gencode(body.VcaseExp->syn_exp, code_array);
	    addtocode(type_op, code_array);
	    addtocode(casename_op, code_array);

	    body.VcaseExp->valuepos = currentpos;
	    foreachinSEQcase_select(body.VcaseExp->syn_select, Scs, Acs) {

		addtocode(control_op, code_array);
		addtocode(level,code_array);

		addtocode(typeExpression_op, code_array);
		tipe = Acs->syn_type.IDLclassCommon->sem_entity.VTypeEntity;
		/* calculate index into type reference array */
		index = add_type(ADecl, tipe);
		hi = (char) (index >> 8);
		lo = (char) index;
		addtocode(lo,code_array);
		addtocode(hi,code_array);

		addtocode(is_op, code_array);

		op = jfalse;
		addtocode(op,code_array);
		/* save current location to back insert later	*/
		loc = currentpos;
		addtocode(loc,code_array);
		gencode(Acs->syn_exp,code_array);

		op = jump;
		addtocode(op,code_array);

		/* stack location of jump to backinsert exit position at
		   end of case				*/
		appendrearSEQint(loc_stack,currentpos);

		loc_count++;	/* increment count of how many positions 
				       to backinsert into later	*/

		addtocode(currentpos,code_array);

		backinsert(currentpos,loc,code_array);	
	    }
	    if (typeof(body.VcaseExp->syn_otherwise) != KVoid) {
		gencode(body.Vconditional->syn_else,code_array);
	    }

	    /* backinsert exit location to all saved jump operator locations */
	    for(i=1;i<=loc_count;i++)
		backinsert(currentpos,pop(&loc_stack),code_array);

	    level--;
	    break;

        case Kunary:

	    gencode(body.Vunary->syn_body,code_array);

	    /* determine operator type */
	    if(typeof(body.Vunary->syn_op) == KUnaryPlus);
		/* no action need be taken */
	    if(typeof(body.Vunary->syn_op) == KUnaryMinus)
		op = unaryMinus_op;
	    if(typeof(body.Vunary->syn_op) == KnotOp)
		op = not_op;

	    if(typeof(body.Vunary->syn_op) != KUnaryPlus)
	    {
		body.Vunary->valuepos = currentpos; 
	        addtocode(op,code_array);
	    }

	    break;

	case Kbinary:

	    gencode(body.Vbinary->syn_left,code_array);
	    gencode(body.Vbinary->syn_right,code_array);

	    if (typeof(body.Vbinary->syn_right.IDLclassCommon->sem_type) 
	           == Ksingleton) {
	           tipe = body.Vbinary->syn_right.IDLclassCommon
	       		->sem_type.Vsingleton->sem_type.VTypeEntity;
	    }
	    else
	       tipe = body.Vbinary->syn_right.IDLclassCommon->sem_type.VTypeEntity;



	    /* determine operator type  */
	    switch (typeof(body.Vbinary->syn_op)) {
		
		case KisOp:
		    op = is_op;
		    break;

		case KandOp:
		    op = and_op;
		    break;

		case KorOp:
		    op = or_op;
		    break;

		case KunionOp:
		    op = union_op;
		    break;

		case KintersectOp:
		    op = intersect_op;
		    break;

		case Kplus:
		    op = plus_op;
		    break;

		case Kminus:
		    op = minus_op;
		    break;

		case Ktimes:
		    op = times_op;
		    break;

		case Kdivide:
		    op = divide_op;
		    break;

		case Kless:
		    /* determine which type of < opeator */
		    if (ISSTRING(tipe))
			op = str_less_op;
		    else
			op = num_less_op;
		    break;

		case KlessEq:
		    /* determine which type of <= operator */
		    if (ISSTRING(tipe))
			op = str_lessEq_op;
		    else
			op = num_lessEq_op;
		    break;

		case Kgreater:
		    /* determine which type of > operator */
		    if (ISSTRING(tipe))
			op = str_greater_op;
		    else
			op = num_greater_op;
		    break;

		case KgrtrEq:
		    /* determine which type of >= operator */
		    if (ISSTRING(tipe))
			op = str_grtrEq_op;
		    else
			op = num_grtrEq_op;
		    break;

		case Kequal:
		    /* determine which type of equal operator */
		    if (ISSTRING(tipe))
			    op = str_equal_op;
		    else if (ISBOOLEAN(tipe))
			    op = bool_equal_op;
		    else if (ISINTEGER(tipe))
			    op = num_equal_op;
		    else if (ISRATIONAL(tipe))
			    op = num_equal_op;
		    else if (ISSET(tipe))
			    op = set_equal_op;
		    else if (ISSEQ(tipe))
			    op = seq_equal_op;
		    else if (ISNODE(tipe))
			    op = node_equal_op;
		    else op = -1;
		    break;

		case KnotEqual:
		    /* determine which type of ~= operator */
		    if (ISSTRING(tipe))
			    op = str_notEqual_op;
		    else if (ISBOOLEAN(tipe))
			    op = bool_notEqual_op;
		    else if (ISINTEGER(tipe))
			    op = num_notEqual_op;
		    else if (ISRATIONAL(tipe))
			    op = num_notEqual_op;
		    else if (ISSET(tipe))
			    op = set_notEqual_op;
		    else if (ISSEQ(tipe))
			    op = seq_notEqual_op;
		    else if (ISNODE(tipe))
			    op = node_notEqual_op;
		    else op = -1;
		    break;

		case KsameOp:
		    op = same_op;
		    break;

		case KinSet:
		    /* determine which kind of In operator */
		    if (ISSET(tipe))
		    	    op = inSet_op;
		    else if (ISSEQ(tipe))
			    op = inSeq_op;
		    else
			    op = inCollection_op;
		    break;

		case Ksubset:
		    op = subset_op;
		    break;

		case KpropSubset:
		    op = propSubset_op;
		    break;

	    }
	    body.Vbinary->valuepos = currentpos;
	    addtocode(op,code_array);
	    break;
	    
	case Kdotted:

	    gencode(body.Vdotted->syn_left,code_array);

	    op = dot_op;
	    body.Vdotted->valuepos = currentpos;
	    addtocode(op,code_array);

	    /* calculate index into string reference array */
	    index = add_String(ADecl,body.Vdotted->syn_right->lex_name);
	    hi = (char) (index >> 8);
	    lo = (char) index;
	    addtocode(lo,code_array);
	    addtocode(hi,code_array);
	    break;

	case KportExpression:

	    op = portExpression_op;
	    body.VportExpression->valuepos = currentpos;
	    addtocode(op,code_array); 

	    /* calculate index into type reference array */
	    index = add_type(ADecl,body.VportExpression->syn_type.
			     IDLclassCommon->sem_entity.VTypeEntity);
	    hi = (char) (index >> 8);
	    lo = (char) index;
	    addtocode(lo,code_array);
	    addtocode(hi,code_array);

	    /* calculate reference into string reference array */
	    index = add_String(ADecl,body.VportExpression
				->syn_portName->lex_name);
	    hi = (char) (index >> 8);
	    lo = (char) index;
	    addtocode(lo,code_array);
	    addtocode(hi,code_array);
	    break;

	case Kapplication:
	    /* generate code for all arguments of the application */
	    foreachinSEQexpression(body.Vapplication->syn_arguments,Sarg,arg)
		gencode(arg,code_array);

	    if(typeof(body.Vapplication->syn_instance->sem_entity)==KDefinition)
		def = body.Vapplication->syn_instance->sem_entity.VDefinition;
	    else 
		def = body.Vapplication->syn_instance->sem_entity.
			VIDLDefInstance.IDLclassCommon->syn_def->sem_entity.
			VDefinition;
	    if (ISMEMBERS(def))
		op = members_op;
	    else if (ISHEAD(def))
		op = head_op;
	    else if (ISTYPE(def))
		op = type_op;
	    else if (ISSTRSIZE(def, body.Vapplication->syn_arguments))
		op = str_size_op;
	    else if (ISSETSEQSIZE(def, body.Vapplication->syn_arguments))
		op = setseq_size_op;
	    else if (ISTAIL(def))
		op = tail_op;
	    else if (has_cyclic(def))
		op = cyclic_appl_op;
	    else op = application_op;
	    body.Vapplication->valuepos = currentpos;
	    addtocode(op,code_array);

	    if (op == application_op || op == cyclic_appl_op) {
		/* calculate index into definition reference array */
		index = add_definition(ADecl,def);
		hi = (char) (index >> 8);
		lo = (char) index;
		addtocode(lo,code_array);
		addtocode(hi,code_array);

		/* enter number of arguments into code array */
		op = lengthSEQexpression(body.Vapplication->syn_arguments);
		addtocode(op,code_array);
	    }
	    break;

	case KExpSetRef:
	case KExpSeqRef:
	    op = typeExpression_op;
	    body.IDLclassCommon->valuepos = currentpos;
	    addtocode(op,code_array);

	    /* calculate index into type reference array */
	    if (typeof(body)==KExpSetRef) {
	      ThisTypeEntity.VSetOf = body.VExpSetRef->sem_entity.VSetOf;
	      index = add_type(ADecl, ThisTypeEntity);
	    }
	    else {
	      ThisTypeEntity.VSeqOf = body.VExpSeqRef->sem_entity.VSeqOf;
	      index = add_type(ADecl, ThisTypeEntity);
	    }
	    hi = (char) (index >> 8);
	    lo = (char) index;
	    addtocode(lo,code_array);
	    addtocode(hi,code_array);
	    break;

	case KExpNameRef:

	    entity = body.VExpNameRef->sem_entity.VExpname;
	    switch (typeof(entity)) {
	        case KDefinition:
		case Kcyclicdef:
		case Knoncyclicdef:
		case KPrivateDefInstance:
		    op = application_op;
		    body.IDLclassCommon->valuepos = currentpos;
		    addtocode(op,code_array);

		    /* calculate index into definition reference array */
		    if (typeof(entity)==KDefinition)
			def = entity.VDefinition;
		    else def = entity.VDefInstance.IDLclassCommon->syn_def->
			sem_entity.VDefinition;

		    index = add_definition(ADecl, def);
		    hi = (char) (index >> 8);
		    lo = (char) index;
		    addtocode(lo,code_array);
		    addtocode(hi,code_array);

		    /* enter number of arguments into code array */
		    op = 0;
		    addtocode(op,code_array);
		    break;

		case KClass:
		case KAtomic:
		    op = typeExpression_op;
		    body.IDLclassCommon->valuepos = currentpos;
		    addtocode(op,code_array);

		    /* calculate index into type reference array */
		    index = add_type(ADecl, entity.VNamedType);
		    hi = (char) (index >> 8);
		    lo = (char) index;
		    addtocode(lo,code_array);
		    addtocode(hi,code_array);
		    break;

		case KFormal:
		    op = formArg_op;
		    body.IDLclassCommon->valuepos = currentpos;
		    addtocode(op,code_array);

		    /* insert position of formal arg in list of declared args */
		    op = position(entity.VFormal, in.IDLclassCommon->syn_list);
		    addtocode(op,code_array);
		    break;

		case KControl:
		    op = control_op;
		    body.IDLclassCommon->valuepos = currentpos;
		    addtocode(op,code_array);

		    /* insert level of control operator */
		    op = entity.VControl->sem_owner.IDLclassCommon->nest_level;
		    addtocode(op,code_array);
		    break;

		case KCaseName:
		    op = control_op;
		    body.IDLclassCommon->valuepos = currentpos;
		    addtocode(op,code_array);

		    /* insert level of control operator */
		    op = entity.VCaseName->sem_owner->nest_level;
		    addtocode(op,code_array);
		    break;
	    }
	    break;


	case KintegerToken:

	    ivalue = atoi(body.VintegerToken->lex_externalform);
	    if (ivalue == 0)
	    {
		op = Zero_op;
		body.VintegerToken->valuepos = currentpos;
		addtocode(op,code_array);
	    }
	    else 
	    if (ivalue == 1)
	    {
		op = One_op;
		body.VintegerToken->valuepos = currentpos;
		addtocode(op,code_array);
	    }
	    else
	    {
		    op = intToken;
		    body.VintegerToken->valuepos = currentpos;
		    addtocode(op,code_array);

		    /* calculate index into integer reference array */
		    index = add_Integer(ADecl,ivalue);
		    hi = (char) (index >> 8);
		    lo = (char) index;
		    addtocode(lo,code_array);
		    addtocode(hi,code_array);
	    }
	    break;

	case KrationalToken:

	    op = ratToken;
	    body.VrationalToken->valuepos = currentpos;
	    addtocode(op,code_array);

	    /* calculate index into rational reference array */
	    index = add_Rational(ADecl,atof(body.VrationalToken->lex_externalform));
	    hi = (char) (index >> 8);
	    lo = (char) index;
	    addtocode(lo,code_array);
	    addtocode(hi,code_array);
	    break;

	case KstringToken:
	    
	    op = strToken;
	    body.VstringToken->valuepos = currentpos;
	    addtocode(op,code_array);

	    /* calculate index into string reference array */ 
	    index = add_String(ADecl,body.VstringToken->lex_externalform);
	    hi = (char) (index >> 8);
	    lo = (char) index;
	    addtocode(lo,code_array);
	    addtocode(hi,code_array);
	    break;

	case KrootExp:

	    if(typeof(body.VrootExp->syn_portName) == KVoid)
	    {
		op = Root_op;
		body.VrootExp->valuepos = currentpos;
		addtocode(op,code_array);
	    }
	    else	/* port name is present */
	    {
	        op = portRoot_op;
		body.VrootExp->valuepos = currentpos;
		addtocode(op,code_array);

		/* calculate index into string reference array */
	        index = add_String(ADecl,body.VrootExp->syn_portName.VPortRef->lex_name);
	        hi = (char) (index >> 8);
	        lo = (char) index;
	        addtocode(lo,code_array);
	        addtocode(hi,code_array);
	    }

	    break;

	case KemptyExp:

	    op = empty_op;
	    body.VemptyExp->valuepos = currentpos;
	    addtocode(op,code_array);
	    break;

	case KtrueExp:

	    op = true_op;
	    body.VtrueExp->valuepos = currentpos;
	    addtocode(op,code_array);
	    break;

	case KfalseExp:

	    op = false_op;
	    body.VfalseExp->valuepos = currentpos;
	    addtocode(op,code_array);
	    break;

	case Kforallq:
	case Kexistsq:

	    level++;		/* increment nesting level	*/
	    body.Vquantifier.IDLclassCommon->nest_level = level;

	    /* generate code for collection quantifier will iterate over */
	    gencode(body.Vquantifier.IDLclassCommon->syn_set,code_array);

	    if (typeof(body.Vquantifier) == Kforallq)
		op = forall_op;
	    else
		op = exists_op;

	    addtocode(op,code_array);

	    /* save start position for "return" statement that will be
	       inserted at endquantifier operator */
	    startpos = currentpos;

	    /* generate code for body of quantifier */
	    gencode(body.Vquantifier.IDLclassCommon->syn_body,code_array);

	    body.Vquantifier.IDLclassCommon->valuepos = currentpos;

	    /* End operator will return to start position if there are
	       more objects in the quantifier set			*/
	    if(op == forall_op)
	    {
		op = endForAll;
		addtocode(op,code_array);
		op = startpos + 1;
		addtocode(op,code_array);
	    }
	    else
	    {
		op = endExists;
		addtocode(op,code_array);
		op = startpos + 1;
		addtocode(op,code_array);
	    }

	    level--;		/* decrement nesting level	*/

	    break;


	case Kconditional:

	    body.Vconditional->valuepos = currentpos;
	    gencode(body.Vconditional->syn_test,code_array);

	    op = jfalse;
	    addtocode(op,code_array);
	    /* save current location to back insert later	*/
	    loc = currentpos;
	    addtocode(loc,code_array);

	    gencode(body.Vconditional->syn_then,code_array);

	    op = jump;
	    addtocode(op,code_array);

	    /* stack location of jump to backinsert exit position at
	       end of conditional				*/
	    appendrearSEQint(loc_stack,currentpos);

	    loc_count++;	/* increment count of how many positions 
				   to backinsert into later	*/

	    addtocode(currentpos,code_array);

	    backinsert(currentpos,loc,code_array);	

	    /* handle OrIf pairs */
	    foreachinSEQexpressionPair(body.Vconditional->syn_orif,Sep,ep)
	    {
		gencode(ep->syn_test,code_array);
		op = jfalse;
		addtocode(op,code_array);
		loc = currentpos;
		addtocode(loc,code_array);
		gencode(ep->syn_then,code_array);
		op = jump;
		addtocode(op,code_array);
		appendrearSEQint(loc_stack,currentpos);
		loc_count++;
		addtocode(currentpos,code_array);
		backinsert(currentpos,loc,code_array);
	    }

	    gencode(body.Vconditional->syn_else,code_array);

	    /* backinsert exit location to all saved jump operator locations */
	    for(i=1;i<=loc_count;i++)
		backinsert(currentpos,pop(&loc_stack),code_array);

	    break;
	}


}	/* end of generatecode */




/***********************************************************************
*	addtocode  	adds operator to code array			*
*									*
*	Last revised: 	April 14,1986					*
************************************************************************/

addtocode(entry,code)
int		entry;		/* operator to add */
SEQint		*code;		/* code array  	   */
{
    	appendrearSEQint(*code,entry);
	currentpos++;		/* increment current position in code array */
}

/***********************************************************************
*	backinsert	insert location into a former location 		*
*			used to avoid backtracking			*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/


backinsert(l1,l2,code)
int		l1;	/* location to insert */
int		l2;	/* location where to insert */
SEQint		*code; 	/* code array */
{
/*    int		i; 
    SEQint	SInt;
    int		AInt;

    i=0;
    foreachinSEQint((*code), SInt, AInt) {
	if (i++ == l2) {
            SInt->value = l1 + 1;
	    break;
	}
    }
*/

    modifyithinSEQint((*code),l2+1,l1+1);
}


/***********************************************************************
*	pop	pop a stack of integers					*
*									*
*	Last revised: April 14, 1986					*
************************************************************************/

pop(stack)
SEQint		*stack;		/* stack to be popped */
{
    int		result;

    retrievelastSEQint(*stack,result);
    removelastSEQint(*stack);
    return(result);
}


/***********************************************************************
*	position	returns the position of a formal argument in a	*
*			list of declared formal arguments		*
*									*
*	Last revised: 	April 14, 1986					*
************************************************************************/

position(form,declared_args)
Formal		form;		/* formal to find position of */
SEQFormal	declared_args;  /* list of formal arguments  */
{
	SEQFormal	Sf;
	Formal		f;
	int		result;
	int		i;

	i = 1;
	result = 0;

	foreachinSEQFormal(declared_args,Sf,f)
	{
	    if(f == form) result = i;
	    i++;
	}

	return(result);

}


/***********************************************************************
*	add_String	add a string to string_refs array and return	*
*			its position					*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

add_String(StPr,str)
StructureOrProcess StPr;/* structure or process containing string_refs array */
String		str;	/* string to add */
{
	appendrearSEQString(StPr.IDLclassCommon->string_refs,str);
	return(lengthSEQString(StPr.IDLclassCommon->string_refs));
}


/***********************************************************************
*	add_Integer	add an integer to integer_refs array and return	*
*			its position					*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

add_Integer(StPr,num)
StructureOrProcess StPr;/* structure or process containing integer_refs array */
int		num; 	/* integer to add */
{
	appendrearSEQint(StPr.IDLclassCommon->integer_refs,num);
	return(lengthSEQint(StPr.IDLclassCommon->integer_refs));
}

/***********************************************************************
*	add_Rational 	add a rational to rational_refs array and 	*
*			return its position				*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

add_Rational(StPr,num)
StructureOrProcess StPr;/* structure or process containing rational_refs array */
float		num;	/* rational to add */
{
	appendrearSEQfloat(StPr.IDLclassCommon->rational_refs,num);
	return(lengthSEQfloat(StPr.IDLclassCommon->rational_refs));
}

/***********************************************************************
*	add_type	add a type to type_refs array and	 	*
*			return its position				*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

add_type(StPr,t)
StructureOrProcess StPr; /* structure or process containing type_refs array */
TypeEntity	t;	/* type to add */
{
	appendrearSEQTypeEntity(StPr.IDLclassCommon->type_refs,t);
	return(lengthSEQTypeEntity(StPr.IDLclassCommon->type_refs));
}

/***********************************************************************
*	add_definition	add a definition to define_refs array and 	*
*			return its position				*
*									*
*	Last revised:	April 14, 1986					*
************************************************************************/

add_definition(StPr,d)
StructureOrProcess StPr;/* structure or process containing define_refs array */
Definition	d;	/* definition to add */
{
	appendrearSEQDefinition(StPr.IDLclassCommon->define_refs,d);
	return(lengthSEQDefinition(StPr.IDLclassCommon->define_refs));
}

/***************************************************************************\
 *  collect all structures and processes in compilationUnit		   *
 ***************************************************************************/
collect_stprs(compUnit, stprs)
compilationUnit compUnit;
SEQDeclaration *stprs;
{
    	SEQDeclaration SDecl;
	Declaration Decl,Adecl;
	SEQStructureOrProcessRef SStPrRef;
	StructureOrProcessRef AStPrRef;
	StructureOrProcess StorPr;

	initializeSEQDeclaration(*stprs);
	foreachinSEQDeclaration(compUnit->syn_body, SDecl, Decl) {
	    if (typeof(Decl)==KStructureEntity || typeof(Decl)==KProcessEntity){
		if (!inSEQDeclaration(*stprs, Decl)) {
		    appendfrontSEQDeclaration(*stprs, Decl);
		    collect_stprs2(Decl, stprs);
		}
	    }
	    else { /* import */
		foreachinSEQStructureOrProcessRef(Decl.VImportDecl->syn_specs,
						    SStPrRef, AStPrRef) {
		    if (typeof(AStPrRef->sem_entity)!= Kerror) {
			StorPr = AStPrRef->sem_entity.VStructureOrProcess;
			Adecl.VStructureOrProcess = StorPr;
			if (!inSEQDeclaration(*stprs, Adecl)) {
			    appendfrontSEQDeclaration(*stprs, Adecl);
			    collect_stprs2(StorPr, stprs);
			}
		    }
		}
	    }
	}
}

collect_stprs2(StOrPr, stprs)
StructureOrProcess StOrPr;
SEQDeclaration *stprs;
{
    StructureEntity st, st2;
    ProcessEntity pr, pr2;
    StructureOrProcess StOrPr2;
    SEQStructureRef SStRef;
    StructureRef StRef;
    SETPort SPort;
    Port APort;
    Declaration Adecl;

    if (typeof(StOrPr)==KStructureEntity) {
	st = StOrPr.VStructureEntity;
	if (typeof(st->syn_refines)==KStructureRef &&
	    typeof(st->syn_refines.VStructureRef->sem_entity)==KStructureEntity)
	{
	    st2 = st->syn_refines.VStructureRef->sem_entity.VStructureEntity;
	    Adecl.VStructureEntity = st2;
	    if (!inSEQDeclaration(*stprs,  Adecl)) {
		appendfrontSEQDeclaration(*stprs, Adecl);
		StOrPr2.VStructureEntity = st2;
		collect_stprs2(StOrPr2, stprs);
	    }
	}
	foreachinSEQStructureRef(st->syn_from, SStRef, StRef) {
	    if (typeof(StRef->sem_entity)==KStructureEntity) {
		st2 = StRef->sem_entity.VStructureEntity;
		Adecl.VStructureEntity = st2;
		if (!inSEQDeclaration(*stprs, Adecl)) {
		    appendfrontSEQDeclaration(*stprs, Adecl);
		    StOrPr2.VStructureEntity = st2;
		    collect_stprs2(StOrPr2, stprs);
		}
	    }
	}
    }
    else { /* process */
	pr = StOrPr.VProcessEntity;
	if (typeof(pr->syn_refines)==KProcessRef &&
	    typeof(pr->syn_refines.VProcessRef->sem_entity)==KProcessEntity) {
	    pr2 = pr->syn_refines.VProcessRef->sem_entity.VProcessEntity;
	    Adecl.VProcessEntity = pr2;
	    if (!inSEQDeclaration(*stprs,  Adecl)) {
		appendfrontSEQDeclaration(*stprs, Adecl);
		StOrPr2.VProcessEntity = pr2;
		collect_stprs2(StOrPr2, stprs);
	    }
	}
	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    if (typeof(APort->syn_data->sem_entity) != KStructureEntity)
		continue;
	    st2 = APort->syn_data->sem_entity.VStructureEntity;
	    Adecl.VStructureEntity = st2;
	    if (!inSEQDeclaration(*stprs,  Adecl)) {
		appendfrontSEQDeclaration(*stprs, Adecl);
		StOrPr2.VStructureEntity = st2;
		collect_stprs2(StOrPr2, stprs);
	    }
	}
    }
}
/* test if the argument type is one string */
Boolean ArgTypeIsString(args)
SEQexpression args;
{
    expression first;
    if (lengthSEQexpression(args) != 1)
	return(FALSE);
    retrievefirstSEQexpression(args, first);
    if (typeof(first.IDLclassCommon->sem_type)==KAtomic &&
	first.IDLclassCommon->sem_type.VAtomic->sem_name == NewString("String"))
	    return(TRUE);
    else return(FALSE);
}

Boolean has_cyclic(def)
Definition def;
{
	SETDefInstance SDefInst;
	DefInstance    ADefInst;

	foreachinSETDefInstance(def->sem_overload, SDefInst, ADefInst) {
		if (typeof(ADefInst)==Kcyclicdef)
			return(TRUE);
	}
	return(FALSE);
}
