/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semassert/types.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "SemAssert.h"
#include "macros.h"

SETDefinition preludedefs;
SEQPreludeType preludetypes;

Atomic GetAtomicType(SP, name)
StructureOrProcess SP;
char *name;
{
	SETTypeEntity SType;
	TypeEntity AType;
	StructureEntity st;
	String aname;
	Atomic atom;
	Atomic GetPreludeType();
	Boolean found = FALSE;

	Assume((IsStructureOrProcess(SP)&&(name !=NULL)), "GetAtomicType");
	if (typeof(SP)==KProcessEntity) {
	    st = SP.VProcessEntity->sem_invariant;
	}
	else st = SP.VStructureEntity;
	aname = NewString(name);
	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    if (typeof(AType)==KAtomic) {
		if (AType.VAtomic->sem_name == aname) {
		    found = TRUE;
		    atom = AType.VAtomic;
		}
	    }
	}
	if (!found) 
	    atom = GetPreludeType(aname);

	Assume1((IsAtomic(atom)), "GetAtomicType %s", name);
	return(atom);
}


Atomic GetPreludeType(name)
String name;
{
	Boolean found = FALSE;
	SEQPreludeType SType;
	PreludeType AType;
	Atomic atom;

	foreachinSEQPreludeType(preludetypes, SType, AType) {
	    if (typeof(AType)==KAtomic) {
		if (AType.VAtomic->sem_name == name) {
		    found = TRUE;
		    atom = AType.VAtomic;
		}
	    }
	}
	Assume1((found), "GetPreludeType %s", name);
	return(atom);
}
Boolean IsPreludeDef(def)
Definition def;
{
	SETDefinition SDef;
	Definition ADef;

	foreachinSETDefinition(preludedefs, SDef, ADef) {
	    if (def == ADef) {
		return(TRUE);
	    }
	}
	return(FALSE);
}

AssertTypeOrError GetPreludeDefType(pdef, inst, actualargs)
Definition pdef;
DefInstance inst;
SEQexpression actualargs;
{
	SEQFormal formalargs;
	AssertType deftype;
	AssertTypeOrError resulttype;
	AssertTypeOrError tmptype;
	TypeEntity collectiontype;
	NamedType component;
	AssertTypeOrError GetUniversalArgType();

	Assume((IsDefinition(pdef)&&IsDefInstance(inst)), "GetPreludeDefType");


	deftype = pdef->sem_resulttype.VAssertType;
	formalargs = inst.IDLclassCommon->syn_list;
	switch (typeof(deftype)) {
	    case KAtomic:
		if (IsUniversalType(deftype)) {
		    resulttype =
			GetUniversalArgType(formalargs, actualargs, KAtomic);
		}
		else resulttype.VAssertType = deftype;
		break;
	    case KSeqOf:
		component = deftype.VSeqOf->sem_component;
		if (IsUniversalType(component)) {
		    resulttype =
			GetUniversalArgType(formalargs, actualargs, KSeqOf);
		}
		else resulttype.VAssertType = deftype;
		break;
	    case KSetOf:
		component = deftype.VSetOf->sem_component;
		if (IsUniversalType(component)) {
		    resulttype =
			GetUniversalArgType(formalargs, actualargs, KSetOf);
		}
		else resulttype.VAssertType = deftype;
		break;
	    case Ksingleton:
	    case Karbitrary:
		collectiontype = deftype.Vcollection.IDLclassCommon->sem_type.VTypeEntity;
		if (IsUniversalType(collectiontype)) {
		    if (typeof(deftype)==Ksingleton)
			resulttype.Vsingleton = Nsingleton;
		    else resulttype.Varbitrary = Narbitrary;
		    tmptype = GetUniversalArgType(formalargs, actualargs,
					typeof(collectiontype));
		    if (IsError(tmptype))
			resulttype.Vcollection.IDLclassCommon->sem_type.Verror = 
				tmptype.Verror;
		    else
			resulttype.Vcollection.IDLclassCommon->sem_type.VTypeEntity = 
				tmptype.VTypeEntity;
		}
		else resulttype.VAssertType = deftype;
		break;
	}
	return(resulttype);
}

AssertTypeOrError GetUniversalArgType(formalargs, actualargs, matchtype)
SEQFormal formalargs;
SEQexpression actualargs;
int matchtype;		/* type to match form of */
{
	int len;
	int i;
	Formal form;
	expression act;
	AssertType exptype;
	TypeEntity formtype;
	TypeEntity acttype;
	NamedType component;
	AssertTypeOrError returntype;
	TypeEntity tmptype;
	Boolean found = FALSE;
        Boolean ErrorInAssertType();

	len = lengthSEQFormal(formalargs);
	for (i=1; i<=len; i++) {
	    ithinSEQFormal(formalargs, i, form);
	    ithinSEQexpression(actualargs, i, act);
	    formtype = GetTypeEntity(form->syn_type);
	    if (ErrorInAssertType(act.IDLclassCommon->sem_type))
		continue;
	    exptype = act.IDLclassCommon->sem_type.VAssertType;
	    if ((typeof(exptype)==Ksingleton)||(typeof(exptype)==Karbitrary))
		acttype = exptype.Vcollection.IDLclassCommon->sem_type.VTypeEntity;
	    else acttype = exptype.VTypeEntity;
	    switch (typeof(formtype)) {
		case KAtomic:
		    if (IsUniversalType(formtype)) {
			returntype.VTypeEntity = acttype;
			found = TRUE;
		    }
		    break;
		case KSetOf:
		case KSeqOf:
		    component =formtype.VSetOrSeq.IDLclassCommon->sem_component;
		    if (IsUniversalType(component)) {
			returntype.VTypeEntity = acttype;
			found = TRUE;
		    }
		    break;
	    }
	    if (found)
		break;
	}
	if (found) { /* check that type matches 'matchtype' */
	    switch (matchtype) {
		case KAtomic:  /* `Universal' matches atomic or class */
		    if ((typeof(returntype)==KSetOf)||
			(typeof(returntype)==KSeqOf)) {
			returntype.VNamedType = 
			     returntype.VSetOrSeq.IDLclassCommon->sem_component;
		    }
		    break;
		case KSetOf:  /* `Set Of Universal' matches any set */
		    if (typeof(returntype)==KSeqOf) {
			tmptype.VSetOf = NSetOf;
			tmptype.VSetOf->sem_component = 
					returntype.VSeqOf->sem_component;
			returntype.VTypeEntity = tmptype;
		    }
		    else if ((typeof(returntype)==KClass)||
			     (typeof(returntype)==KAtomic)) {
			tmptype.VSetOf = NSetOf;
			tmptype.VSetOf->sem_component = 
					returntype.VNamedType;
			returntype.VTypeEntity = tmptype;
		    }
		    break;
		case KSeqOf:  /* `Seq Of Universal' matches any seq */
		    if (typeof(returntype)==KSetOf) {
			tmptype.VSeqOf = NSeqOf;
			tmptype.VSeqOf->sem_component = 
					returntype.VSetOf->sem_component;
			returntype.VTypeEntity = tmptype;
		    }
		    else if ((typeof(returntype)==KClass)||
			     (typeof(returntype)==KAtomic)) {
			tmptype.VSeqOf = NSeqOf;
			tmptype.VSeqOf->sem_component = 
					returntype.VNamedType;
			returntype.VTypeEntity = tmptype;
		    }
		    break;
	    }
	}
	else returntype.Verror = Nerror;
#ifdef DEBUG
	(void) fprintf(stderr, "GetUniversalArgType: \n\t"); 
        print_type(returntype);
	(void) fprintf(stderr, "\n");
#endif

	Assume((IsTypeEntity(returntype)||IsError(returntype)), "GetUniversalArgType");
	return(returntype);
}
/* check if 2 types are the same, */
/* if one type is error return TRUE so that there is not a 
/*    cascade of errors */
Boolean IsSameType(type1, type2)
AssertType type1, type2;
{
    Boolean same = FALSE;
    Boolean contains();

    if ((typeof(type1)==Kerror) ||
	(typeof(type2)==Kerror)) {
	same = TRUE;
    }
    else if (IsUniversalType(type1) || IsUniversalType(type2)) {
	same = TRUE;
    }
    else if (typeof(type1) == typeof(type2)) {
	switch (typeof(type1)) {
	    case KAtomic:
		if (type1.VAtomic->sem_name == type2.VAtomic->sem_name)
		    same = TRUE;
		else if ((IsNumeric(type1))&&(IsNumeric(type2)))
		    same = TRUE; /* rational and integer are == */
		break;
	    case KClass:
		/* if they have the same name they are equal */
		if (type1.VClass->sem_name == type2.VClass->sem_name)
		    same = TRUE;
		/* if one is a subclass of the other then they are = */
		else same = (contains(type1, type2) || contains(type2, type1));
		break;
	    case KSetOf:
		if (type1.VSetOf->sem_name == type2.VSetOf->sem_name)
		    same = TRUE;
		/* if the components are the same they are = */
		else same = IsSameType(type1.VSetOf->sem_component,
		                       type2.VSetOf->sem_component);
		break;
	    case KSeqOf:
		if (type1.VSeqOf->sem_name == type2.VSeqOf->sem_name)
		    same = TRUE;
		/* if the components are the same they are = */
		else same = IsSameType(type1.VSeqOf->sem_component,
		                       type2.VSeqOf->sem_component);
		break;
	    case Ksingleton:
	    case Karbitrary:
		same = IsSameType(type1.Vcollection.IDLclassCommon->sem_type,
		                  type2.Vcollection.IDLclassCommon->sem_type);
	}
    }
    else if (typeof(type1)==Ksingleton) {
	same = IsSameType(type1.Vsingleton->sem_type, type2);
    }
    else if (typeof(type2)==Ksingleton) {
	same = IsSameType(type1, type2.Vsingleton->sem_type);
    }
    else {
	same = FALSE;
    }
    return(same);
}
/* returns TRUE if type1 contains type2 */
Boolean contains(type1, type2)
AssertType type1, type2;
{

	TypeEntityOrError ctype1, ctype2;	/* collection types */
	NamedType ntype1, ntype2;		/* set/seq types */
	Boolean does_contain = FALSE;

	if (typeof(type1) == typeof(type2)) {
	    switch (typeof(type1)) {
		case Karbitrary:
		case Ksingleton:
			ctype1 = type1.Vcollection.IDLclassCommon->sem_type;
			ctype2 = type2.Vcollection.IDLclassCommon->sem_type;
			does_contain = contains(ctype1, ctype2);
			break;
		case KAtomic:
			if (type1.VAtomic->sem_name == type2.VAtomic->sem_name)
			    does_contain = TRUE;
			else if (IsRationalType(type1) && IsIntegerType(type2))
			    does_contain = TRUE;
			else if (IsUniversalType(type2))
			    does_contain = TRUE;
			break;
		case KSetOf:
		case KSeqOf:
			ntype1 = type1.VSetOrSeq.IDLclassCommon->sem_component;
			ntype2 = type2.VSetOrSeq.IDLclassCommon->sem_component;
			does_contain = contains(ntype1, ntype2);
			break;
		case KClass: /* checks descendants */
			if (type1.VClass->sem_name == type2.VClass->sem_name)
			    does_contain = TRUE;
			else if (inSETTypeEntity(type1.VClass->expand, type2.VTypeEntity))
			    does_contain = TRUE;
			break;
	    }
	}
	else switch (typeof(type1)) {
	    case Karbitrary: /* contains singleton and non-collection */
		ctype1 = type1.Varbitrary->sem_type;
		if (typeof(type2) == Ksingleton) {
		    does_contain = contains(ctype1, type2.Vsingleton->sem_type);
		}
		else does_contain = contains(ctype1, type2);
		break;
	    case Ksingleton: /* contains non-collection of compatible type */
		ctype1 = type1.Vsingleton->sem_type;
		if (typeof(type2) == Karbitrary)
		    does_contain = FALSE;
		else does_contain = contains(ctype1, type2);
		break;
	    case KClass:
	    case KAtomic:
		if (IsUniversalType(type2))
		    does_contain = TRUE;
		break;
	}
	return(does_contain);
}

	/* if union take more general class type */
	/* if intersect take more less class type */
AssertTypeOrError get_type_union_intersect(type1, type2, op)
AssertTypeOrError type1, type2;
int op; /* union or intersect */
{
	AssertTypeOrError ret_type;
	AssertTypeOrError select_type;

	if (typeof(type1)==Kerror || typeof(type2)==Kerror)
	    ret_type.Verror = Nerror;
	else {
	    if (contains(type1, type2)) {
		if (op == KunionOp)
		    select_type = type1;
		else /* intersect */
		    select_type = type2;
	    }
	    else {
		if (op == KunionOp)
		    select_type = type2;
		else /* intersect */
		    select_type = type1;
	    }
	    ret_type.Varbitrary = Narbitrary;
	    if (typeof(select_type) == Ksingleton)
		ret_type.Varbitrary->sem_type = 
			select_type.Vsingleton->sem_type;
	    else if (typeof(select_type) == Karbitrary)
		ret_type.Varbitrary->sem_type = 
			select_type.Varbitrary->sem_type;
	    else
		ret_type.Verror = Nerror;
	}
	return(ret_type);
}
