/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semassert/symbol4.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: 								*
*									*
*               	x_type						*
*									*
\* ******************************************************************* */

#include "SemAssert.h"
#include <stdio.h>
#include "macros.h"

Atomic GetAtomicType(); /* needed for macro expansions -GetBooleanType, etc */
Boolean IsSameType();

/************************************************************************
*	x_type								*
* Function which types expressions.					*
*  Recursively calls itself as it types subexpressions			*
*  Returns a typed expression that is the semantic meaning of the	*
*  given expression.							*
*									*
*	Last Revised:	June 10, 1986					*
************************************************************************/

checkExp(exp, haserror)
expression 	exp;	  	/* expression to check */
Boolean 	*haserror; 	/* if expression has error */
{
	AssertTypeOrError	left_type;	/* type binary left subexp  */
	AssertTypeOrError	right_type;	/* type binary right subexp */
	int			boper;		/* binary operator	    */
	int			uoper;		/* unary operator	     */
	AssertTypeOrError	obj_type1;	/* type of objects in 
							collection */
	AssertTypeOrError	obj_type2;	/* type of objects in 
							collection */
	AssertTypeOrError	arg_type;
	Boolean			OK;		/* is type OK?		*/
	SEQexpression		Sexp;		/*  iterators ...	    */
	expression		a;
	SEQexpressionPair	Sorif;
	expressionPair		ep;
	SEQcase_select		Scs;
	case_select		Acs;
	SETTypeEntity		SType;
	TypeEntity		AType;
	TypeEntity		tmptype, tmptype2;
	expression		tmpexp;		/* temporary expression */
	expression		tmpexp2;	/* temporary expression */
	AssertType		lasttype;
	Boolean 		lefttest;
	Boolean			righttest;
	Boolean			haserror2;
	Boolean			first;
	Boolean			found;
	Boolean			errorincase;
	Boolean			ErrorInAssertType();

	if (typeof(exp.IDLclassCommon->sem_type)==Kerror)
	    *haserror = TRUE;
	else *haserror = FALSE;
	haserror2 = FALSE;

	/* check each kind of expression			*/
	switch (typeof(exp)) {

	    case KcaseExp:
		tmpexp = exp.VcaseExp->syn_exp;
		checkExp(tmpexp, &haserror2);
		*haserror  = *haserror || haserror2;
		first = TRUE;
		foreachinSEQcase_select(exp.VcaseExp->syn_select, Scs, Acs) {
		    checkExp(Acs->syn_exp, &haserror2);
		    *haserror  = *haserror || haserror2;

		    /* case subexp must all have same type */
		    if (!first) {
			if (!IsSameType(lasttype,
				    Acs->syn_exp.IDLclassCommon->sem_type)) {
			   Warning0(758,Acs->syn_exp.IDLclassCommon->lex_expos);
			}
			/* otherwise must have same type as case subexp */
			if (typeof(exp.VcaseExp->syn_otherwise) != KVoid ) {
			    tmpexp = exp.VcaseExp->syn_otherwise.Vexpression;
			    checkExp(tmpexp, &haserror2);
			    *haserror  = *haserror || haserror2;

			    if (!IsSameType(lasttype, 
					    tmpexp.IDLclassCommon->sem_type)){
			       Warning0(758,tmpexp.IDLclassCommon->lex_expos);
			    }
			}
		    }
		    if (!IsError(Acs->syn_exp.IDLclassCommon->sem_type)) {
			lasttype = Acs->syn_exp.IDLclassCommon->sem_type.VAssertType;
			first = FALSE;
		    }
		}

		/* types in case must cover expression type if no otherwise */
		tmpexp = exp.VcaseExp->syn_exp;
		errorincase =ErrorInAssertType(tmpexp.IDLclassCommon->sem_type);
		if ((typeof(exp.VcaseExp->syn_otherwise) == KVoid) &&
		    !errorincase)
		{
		    if (Iscollection(tmpexp.IDLclassCommon->sem_type)) {
			tmptype = tmpexp.IDLclassCommon->sem_type.
			       Vcollection.IDLclassCommon->sem_type.VTypeEntity;
		    }
		    else tmptype = tmpexp.IDLclassCommon->sem_type.VTypeEntity;
		    foreachinSETTypeEntity(tmptype.IDLclassCommon->expand, 
								SType, AType) {
			found = FALSE;
			foreachinSEQcase_select(exp.VcaseExp->syn_select, Scs, 
							Acs) {
			    tmpexp = Acs->syn_exp;
			    if (ErrorInAssertType(tmpexp.IDLclassCommon->sem_type))
				continue;

			    if (Iscollection(tmpexp.IDLclassCommon->sem_type))
				tmptype2 = tmpexp.IDLclassCommon->sem_type.
				   Vcollection.IDLclassCommon->sem_type.VTypeEntity;
			    else tmptype2 = tmpexp.IDLclassCommon->sem_type.
						VTypeEntity;
			    if (inSETTypeEntity(tmptype2.IDLclassCommon->expand,
						AType)) {
				found = TRUE;
				break;
			    }
			}
			if (!found) {
			    Warning0(759, exp.VcaseExp->lex_expos);
			    break;
			}
		    }
		}

		break;

	    case Kconditional:

		/* type subexpressions of the conditional... 	*/
		tmpexp = exp.Vconditional->syn_test;
		checkExp(tmpexp, &haserror2);
		*haserror = *haserror || haserror2;

		if (!IsBooleanType(tmpexp.IDLclassCommon->sem_type)) {
			Warning0(701,tmpexp.IDLclassCommon->lex_expos);
		}

		checkExp(exp.Vconditional->syn_then, &haserror2);
		*haserror = *haserror || haserror2;
		checkExp(exp.Vconditional->syn_else, &haserror2);
		*haserror = *haserror || haserror2;

		/* check all OrIf expressions		*/
		foreachinSEQexpressionPair(exp.Vconditional->syn_orif,Sorif,ep) 
		{
		    checkExp(ep->syn_test, &haserror2);
		    *haserror = *haserror || haserror2;
		    checkExp(ep->syn_then, &haserror2);
		    *haserror = *haserror || haserror2;

		    /* test subexp must be boolean	*/
		    if (!IsBooleanType(ep->syn_test.IDLclassCommon->sem_type)) {
			Warning0(701, ep->syn_test.IDLclassCommon->lex_expos);
		    }

		    /* OrIf-then subexp must have same type as then subexp */
		    tmpexp = exp.Vconditional->syn_then;
		    tmpexp2 = ep->syn_then;
		    if (!IsSameType(tmpexp2.IDLclassCommon->sem_type,
				    tmpexp.IDLclassCommon->sem_type)) {
			 Warning0(702,ep->lex_thenpos);
		    }
	        }

		tmpexp = exp.Vconditional->syn_then;
		tmpexp2 = exp.Vconditional->syn_else;

		/* type of then subexp must be same as else subexp	*/
		if (!IsSameType(tmpexp2.IDLclassCommon->sem_type,
				tmpexp.IDLclassCommon->sem_type)) {
		    Warning0(702,exp.Vconditional->lex_elsepos);
		}
		break;

	    case Kforallq:	/* quantifiers */
	    case Kexistsq:

		/* check set subexp and body			*/
		tmpexp = exp.Vquantifier.IDLclassCommon->syn_set;
		checkExp(tmpexp, &haserror2);
		*haserror = *haserror || haserror2;


		/* set subexp must be a collection		*/
		if (typeof(tmpexp.IDLclassCommon->sem_type) != Ksingleton && 
		    typeof(tmpexp.IDLclassCommon->sem_type) != Karbitrary)
			Warning0(703,tmpexp.IDLclassCommon->lex_expos);


		tmpexp2 = exp.Vquantifier.IDLclassCommon->syn_body;
		checkExp(tmpexp2, &haserror2);
		*haserror = *haserror || haserror2;

		/* body of quantifier must be type boolean	*/
		arg_type = tmpexp2.IDLclassCommon->sem_type;
		if (typeof(arg_type)==Ksingleton) {
		    if (typeof(arg_type.Vsingleton->sem_type)!=Kerror){
			arg_type.VTypeEntity = arg_type.Vsingleton->sem_type.VTypeEntity;
			if (!IsBooleanType(arg_type))
			   Warning0(704,tmpexp2.IDLclassCommon->lex_expos);
		    }
		}
		else {
		    if (!IsBooleanType(arg_type))
		       Warning0(704,tmpexp2.IDLclassCommon->lex_expos);
		}
		break;

	    case Kbinary:
		boper = typeof(exp.Vbinary->syn_op);

		/* check left and right subexps			*/
		checkExp(exp.Vbinary->syn_left, &haserror2);
		*haserror = *haserror || haserror2;
		checkExp(exp.Vbinary->syn_right, &haserror2);
		*haserror = *haserror || haserror2;

		left_type = exp.Vbinary->syn_left.IDLclassCommon->sem_type;
		right_type = exp.Vbinary->syn_right.IDLclassCommon->sem_type;

		/* singleton collection may be operands of value operators,
		   in which case type is type of object in collection	*/

		if (!(boper == KsameOp || boper == Ksubset || 
			boper == KpropSubset || boper == KunionOp || 
			boper == KintersectOp)) {
		    if (typeof(left_type) == Ksingleton) {
			if (IsError(left_type.Vsingleton->sem_type))
			    left_type.Verror = left_type.Vsingleton->sem_type.Verror;
			else
			    left_type.VTypeEntity = left_type.Vsingleton->sem_type.VTypeEntity;
		    }
		    if (typeof(right_type) == Ksingleton) {
			if (IsError(right_type.Vsingleton->sem_type))
			    right_type.Verror= right_type.Vsingleton->sem_type.Verror;
			else
			    right_type.VTypeEntity= right_type.Vsingleton->sem_type.VTypeEntity;
		    }
		}

	/*  Handle errors in types of operands for various operators... */

		switch (boper) {
		case KandOp:
		case KorOp:
		    if ((!IsBooleanType(left_type) &&
			typeof(left_type) != Kerror) || 
		       (!IsBooleanType(right_type) &&
			typeof(right_type) != Kerror))
			    Warning0(705,exp.Vbinary->lex_expos);
		    break;

		case Kless:
		case KlessEq:
		case Kgreater:
		case KgrtrEq:
		    OK = TRUE;
		    lefttest = (!IsIntegerType(left_type) &&
			    !IsRationalType(left_type) &&
			    !IsStringType(left_type) &&
			    typeof(left_type) != Kerror);
		    righttest = (!IsIntegerType(right_type) &&
			    !IsRationalType(right_type) &&
			    !IsStringType(right_type) &&
			    typeof(right_type) != Kerror);
		    if (lefttest || righttest)
			OK = FALSE;

		    if (!OK) {
			Warning0(706,exp.Vbinary->lex_expos);
#ifdef DEBUG
			(void) fprintf(stderr, "Error:binary ");
			print_2types(left_type, right_type);
			(void) fprintf(stderr, "\n");
#endif
		    }
		    else {
			if (IsStringType(left_type))
			    if (!(IsStringType(right_type)))
				Warning0(707,exp.Vbinary->lex_expos);
		    }
		    break;

		case Kequal:
		case KnotEqual:
		    if (typeof(left_type) == Karbitrary && 
		       typeof(right_type) == Karbitrary)
			Warning0(708,exp.Vbinary->lex_expos);

		    else if (!IsSameType(left_type, right_type)) {
		       Warning0(709,exp.Vbinary->lex_expos);
#ifdef DEBUG
			(void) fprintf(stderr, "Error 709:\n\t"); 
			print_2types(left_type, right_type);
#endif
		    }
		    break;

		case KsameOp:
		case Ksubset:
		case KpropSubset:
		    if ((typeof(left_type) != Ksingleton 
			    && typeof(left_type) != Karbitrary
			    && typeof(left_type) != Kerror) ||
		       (typeof(right_type) != Ksingleton
			    && typeof(right_type) != Karbitrary
			    && typeof(right_type) != Kerror))
		    Warning0(710,exp.Vbinary->lex_expos);
		    break;

		case KunionOp:
		case KintersectOp:
		    OK = TRUE;
		    if ((typeof(left_type) != Ksingleton 
			    && typeof(left_type) != Karbitrary
			    && typeof(left_type) != Kerror) ||
		       (typeof(right_type) != Ksingleton
			    && typeof(right_type) != Karbitrary
			    && typeof(right_type) != Kerror))
			    OK = FALSE;			    

		    if (!OK)
			 Warning0(710,exp.Vbinary->lex_expos);
		    else
		    {
			if (typeof(left_type) == Kerror) {
			    obj_type1.Verror = left_type.Verror;
			}
			else {
			    obj_type1.VTypeEntity = left_type.Vcollection.
				IDLclassCommon->sem_type.VTypeEntity;
			}
			if (typeof(right_type) == Kerror) {
			    obj_type2.Verror = right_type.Verror;
			}
			else {
			    obj_type2.VTypeEntity = right_type.Vcollection.
				IDLclassCommon->sem_type.VTypeEntity;
			}

			if (typeof(obj_type1) != Kerror && 
			    typeof(obj_type2) != Kerror)
			        if (!IsSameType(obj_type1, obj_type2))
				    Warning0(711,exp.Vbinary->lex_expos);
		    }			   
		    break;

		case KinSet:
		    OK = TRUE;
		    if (typeof(right_type) != KSetOf && 
		       typeof(right_type) != KSeqOf &&
		       typeof(right_type) != Karbitrary &&
		       typeof(right_type) != Kerror)
		    {
			OK == FALSE;
			Warning0(712,exp.Vbinary->lex_expos);
		    }
		    if (OK && typeof(right_type) == KSetOf) {
			if (typeof(left_type) != 
			   	typeof(right_type.VSetOf->sem_component) &&
			   typeof(left_type) != Kerror)
			     Warning0(713,exp.Vbinary->lex_expos);
		    }
		    else if (OK && typeof(right_type) == KSeqOf) {
			if (typeof(left_type) != 
			   	typeof(right_type.VSeqOf->sem_component) &&
			   typeof(left_type) != Kerror)
			     Warning0(714,exp.Vbinary->lex_expos);
		    }
		    break;

		case Kplus:
		case Kminus:
		case Ktimes:
		case Kdivide:
		    if (!ErrorInAssertType(left_type) && 
			!ErrorInAssertType(right_type)) {

			if ((typeof(left_type)==Karbitrary)||
			    (typeof(left_type)==Ksingleton))
			    left_type.VTypeEntity = 
				left_type.Vcollection.IDLclassCommon->sem_type.
				VTypeEntity;
			if ((typeof(right_type)==Karbitrary)||
			    (typeof(right_type)==Ksingleton))
			    right_type.VTypeEntity = 
				right_type.Vcollection.IDLclassCommon->sem_type.
				VTypeEntity;
			if (!IsNumeric(left_type) || !IsNumeric(right_type)){
				Warning0(715,exp.Vbinary->lex_expos);
			}
		    }
		    break;
		} /* end switch (boper) */

		break;

	    case Kunary:
		uoper = typeof(exp.Vunary->syn_op);

		/* check body of unary exp		*/
		checkExp(exp.Vunary->syn_body, &haserror2);
		*haserror = *haserror || haserror2;
		arg_type = exp.Vunary->syn_body.IDLclassCommon->sem_type;

		/* singleton collection may be argument of value operator,
		   in which case type is type of object in collection	*/

		if (typeof(arg_type) == Ksingleton) {
		    if (IsError(arg_type.Vsingleton->sem_type))
			arg_type.Verror = arg_type.Vsingleton->sem_type.Verror;
		    else
			arg_type.VTypeEntity = arg_type.Vsingleton->sem_type.
					    VTypeEntity;
		}

		/* Check for error in operand type			*/
		if (uoper == KUnaryPlus || uoper == KUnaryMinus) 
		{
			if (!IsNumeric(arg_type) &&
			    typeof(arg_type) != Kerror)
			     Warning0(716,exp.Vunary->lex_expos);
		}
		else if (!IsBooleanType(arg_type) && typeof(arg_type) != Kerror)
			 Warning0(717,exp.Vunary->lex_expos);

		break;

	    case Kapplication:

		/* check arguments */
		foreachinSEQexpression(exp.Vapplication->syn_arguments,Sexp,a)
		{
		    checkExp(a, &haserror2);
		    *haserror = *haserror || haserror2;
		}
		break;

	    case Kdotted:
		checkExp(exp.Vdotted->syn_left, &haserror2);
		*haserror = *haserror || haserror2;
		break;


	    case KportExpression:
	    case KExpSetRef:
	    case KExpSeqRef:
	    case KExpNameRef:
	    case KrootExp:
	    case KemptyExp:
	    case KtrueExp:
	    case KfalseExp:
	    case KintegerToken:
	    case KrationalToken:
	    case KstringToken:
		break;

	    default:
		Assume((FALSE), "Default case in checkExp");
		break;
	} /* end of switch */

} /* End of checkExp */


Boolean ErrorInAssertType(atype)
AssertTypeOrError atype;
{
	if (Iscollection(atype) && 
	    IsError(atype.Vcollection.IDLclassCommon->sem_type))
	    return(TRUE);
	else if (IsError(atype))
	    return(TRUE);
	else
	    return(FALSE);
}
