/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semassert/symbol3.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: routines to handle definitions				*
*									*
*									*
\* ******************************************************************* */


/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	symbol3.c,v $
 * Revision 1.1  89/07/05  16:33:22  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  06:18:52  cheung
 * symbol3.c  Ver 4.0
 * 
 * Revision 3.9  89/03/30  13:18:54  cheung
 * symbol3.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  15:28:55  cheung
 * symbol3.c  Ver 3.9
 * 
 * Revision 1.1  87/04/18  12:12:51  shannon
 * Initial revision
 * 
 * Revision 1.1  86/03/24  22:11:19  kickenso
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     	May 25 1985 (kickenson)						*
*									*
\* ******************************************************************* */

#include <stdio.h>
#include "SemAssert.h"
#include "macros.h"

	
	
/***********************************************************************
*	check_defInstances							*
*  check that such instances in a definition can be distinguished by 	*
*  formal argument types						*
*									*
*	Last revised:	May 25 1986					*
************************************************************************/

check_defInstances(SP)
StructureOrProcess	SP;	/* structure or process */
{
	SETDefinition Sdef;
	Definition		def;
	SETDefInstance		Sin, Sin2;
	DefInstance		in, in2;
	SETDefInstance		notdistinct;
	SETDefInstance		checked_instances;

	Assume((IsStructureOrProcess(SP)), "check_defInstances");


	   /*  check for distinguishable formal types */
	foreachinSETDefinition(SP.IDLclassCommon->sem_definitions,Sdef,def) {
#ifdef DEBUG2
	   (void) fprintf(stderr, "checking instances for def %s\n", 
               def->sem_name);
#endif
	   initializeSETDefInstance(notdistinct);
	   initializeSETDefInstance(checked_instances);
	   foreachinSETDefInstance(def->sem_overload,Sin,in) {
	       foreachinSETDefInstance(checked_instances,Sin2,in2) {
		   if (!distinct_formal(in.IDLclassCommon->syn_list,
				in2.IDLclassCommon->syn_list)){
			addSETDefInstance(notdistinct, in);
			addSETDefInstance(notdistinct, in2);
		    }
		}
		addSETDefInstance(checked_instances, in);
	   }
	   foreachinSETDefInstance(notdistinct,Sin,in) {
		Warning0(755,in.IDLclassCommon->lex_stmtpos);
	   }
	}
}



/***********************************************************************
*	check_instance_types	checks that all instances of the same	*
*				definition return the same type		*
*									*
*	Last revised:	May 25, 1986					*
************************************************************************/

check_instance_types(SP)
StructureOrProcess	SP;	/* structure or process */
{
    SETDefinition	Sdefn;
    Definition		defn;
    SETDefInstance	Sin;
    DefInstance		in;
    IDLDefInstance	IDLdefin;
    AssertType		intype;		/* type of instance */
    Boolean		IsSameType();
    Boolean             contains();


    Assume((IsStructureOrProcess(SP)), "check_instance_types");

    foreachinSETDefinition(SP.IDLclassCommon->sem_definitions,Sdefn,defn)
    {
	foreachinSETDefInstance(defn->sem_overload,Sin,in) {
	    if (typeof(in) != KPrivateDefInstance) {
		IDLdefin = in.VIDLDefInstance;
		if (!IsError(IDLdefin.IDLclassCommon->syn_body.
				IDLclassCommon->sem_type)) {
		    intype = IDLdefin.IDLclassCommon->syn_body.
				IDLclassCommon->sem_type.VAssertType;
		    if (!contains(defn->sem_resulttype, intype)) 
			Warning0(756,IDLdefin.IDLclassCommon->lex_stmtpos);
		}
	    }
	    else /* private definition */ {
		intype.VTypeEntity = 
			GetTypeEntity(in.VPrivateDefInstance->syn_returnType);
		if (!contains(defn->sem_resulttype, intype)) {
		    Warning0(756, 
			GetTypePos(in.VPrivateDefInstance->syn_returnType));
		}
	    }
	}
    }
}

/**********************************************************************
*	findcalls	Store with each definition the definitions it	*
*			calls						*
*									*
*	Last revised:	June 10, 1986					*
************************************************************************/

findcalls(SP)
StructureOrProcess	SP;	/* structure or process */
{
    SETDefinition	Sd;
    Definition		d;
    SETDefInstance	Sin;
    DefInstance		in;
    SETDefinition 	defs;

    Assume((IsStructureOrProcess(SP)), "findcalls");

    defs = SP.IDLclassCommon->sem_definitions;
    foreachinSETDefinition(defs,Sd,d) {
	foreachinSETDefInstance(d->sem_overload,Sin,in) {
	    if (typeof(in) != KPrivateDefInstance)
	        trackcalls(d, in, in.VIDLDefInstance.IDLclassCommon->syn_body);
	}
    }
}


/***********************************************************************
*	trackcalls	track down all definition calls made in the 	*
*			given definition body.  			*
*									*
*	Last revised:	June 10, 1986					*
************************************************************************/

trackcalls(def, in, body)
Definition	def;		/* definition whose calls are to be recorded */
IDLDefInstance  in;		/* instance */
expression	body;		/* body to track through		*/	
{

    SEQexpressionPair	Sep;
    expressionPair	ep;
    SEQexpression	Sarg;
    expression		arg;
    SEQcase_select	Scs;
    case_select		Acs;
    Definition 		def_entity;


    Assume((IsDefinition(def)), "trackcalls");

    switch (typeof(body)) {

	case Kconditional:
	    trackcalls(def, in, body.Vconditional->syn_test);
	    trackcalls(def, in, body.Vconditional->syn_then);
	    trackcalls(def, in, body.Vconditional->syn_else);
	    foreachinSEQexpressionPair(body.Vconditional->syn_orif,Sep,ep)
	    {
	        trackcalls(def, in, ep->syn_test);
	        trackcalls(def, in, ep->syn_then);
	    }
	    break;

	case Kforallq:
	case Kexistsq:
	    trackcalls(def, in, body.Vquantifier.IDLclassCommon->syn_set);
	    trackcalls(def, in, body.Vquantifier.IDLclassCommon->syn_body);
	    break;

	case Kbinary:
	    trackcalls(def, in, body.Vbinary->syn_left);
	    trackcalls(def, in, body.Vbinary->syn_right);
	    break;

	case Kunary:
	    trackcalls(def, in, body.Vunary->syn_body);
	    break;

	case Kdotted:
	    trackcalls(def, in, body.Vdotted->syn_left);
	    break;

	case KExpNameRef:
	    /* check if a definition */
	    if (TypeOfEntity(body.VExpNameRef) == KDefinition) {
		def_entity = GetDefineEntity(body.VExpNameRef);
		if (def_entity == def)
		    in.IDLclassCommon->isrecursive = TRUE;
		addSETDefinition(def->calls, def_entity);
	    }
	    break;

	case Kapplication:
	    if (TypeOfEntity(body.Vapplication->syn_instance) == KDefinition) {
		def_entity = GetDefineEntity(body.Vapplication->syn_instance);
		if (def_entity == def)
		    in.IDLclassCommon->isrecursive = TRUE;
		addSETDefinition(def->calls, def_entity);
	    }
	    foreachinSEQexpression(body.Vapplication->syn_arguments,Sarg,arg)
		trackcalls(def, in, arg);
	    break;

	case KcaseExp:
	    trackcalls(def, in, body.VcaseExp->syn_exp);
	    foreachinSEQcase_select(body.VcaseExp->syn_select, Scs, Acs)
		trackcalls(def, in, Acs->syn_exp);
	    if (typeof(body.VcaseExp->syn_otherwise) != KVoid)
		trackcalls(def, in, body.VcaseExp->syn_otherwise.Vexpression);
	    break;

	default:
	    /* no other expressions can include a definition call */
	    break;

	}  /* end of switch */
}


/************************************************************************
*	findcycles	mark all definitions in the given structure or	*
*			process that are part of a cycle		*
*									*
*	Last revised:	June 12, 1985					*
*									*
************************************************************************/

findcycles(SP)
StructureOrProcess	SP;	
{

    SETDefinition	Sd, Sdf;
    Definition		d,df;

    Assume((IsStructureOrProcess(SP)), "findcycles");

    foreachinSETDefinition(SP.IDLclassCommon->sem_definitions, Sd, d) {
	Assume((IsDefinition(d)), "findcycles2");
	foreachinSETDefinition(d->calls, Sdf, df) {
	    Assume((IsDefinition(df)), "findcycles3");
	    if (inSETDefinition(df->calls, d)) {
		d->cycle = TRUE;
	    }
	}
    }
}


/***********************************************************************
*	markcyclic		marks a definitions as cyclic or not    *
*				depending on the instances it contains	*
*									*
*	Last revised:	June 10, 1986					*
************************************************************************/

markcyclic(SP)
StructureOrProcess SP;
{
    SETDefinition	Sd;
    Definition		d;
    SETDefInstance 	Sin;
    DefInstance		in;

    Assume((IsStructureOrProcess(SP)), "markcyclic");
    foreachinSETDefinition(SP.IDLclassCommon->sem_definitions,Sd,d) {
	foreachinSETDefInstance(d->sem_overload, Sin, in) {
	    if (typeof(in) == Kcyclicdef) {
		d->hascyclic = TRUE;
		break;
	    }
	}
    }
}

